/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.Collator;
import org.netbeans.modules.dbschema.DBElementProperties;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;

public abstract class DBElement
implements Comparable,
DBElementProperties {
    Impl impl;

    public DBElement() {
    }

    protected DBElement(Impl impl) {
        this.impl = impl;
        impl.attachToElement(this);
    }

    public final Impl getElementImpl() {
        return this.impl;
    }

    public void setElementImpl(Impl anImpl) {
        this.impl = anImpl;
        if (this.impl != null) {
            this.impl.attachToElement(this);
        }
    }

    public DBIdentifier getName() {
        DBIdentifier name = this.getElementImpl().getName();
        return name;
    }

    public final void setName(DBIdentifier name) throws DBException {
        this.getElementImpl().setName(name);
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.getElementImpl().addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.getElementImpl().removePropertyChangeListener(l);
    }

    public String toString() {
        return this.getName().toString();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            throw new ClassCastException();
        }
        if (obj == this) {
            return 0;
        }
        String thisName = this.getName().getFullName();
        String otherName = ((DBElement)obj).getName().getFullName();
        if (thisName == null) {
            return otherName == null ? 0 : -1;
        }
        if (otherName == null) {
            return 1;
        }
        int ret = Collator.getInstance().compare(thisName, otherName);
        if (ret == 0 && this.getClass() != obj.getClass()) {
            ret = this.getClass().getName().compareTo(obj.getClass().getName());
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.getClass() == obj.getClass() && this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return this.getName() != null && this.getName().getFullName() != null ? this.getName().getFullName().hashCode() : 0;
    }

    public static interface Impl {
        public static final int ADD = 1;
        public static final int REMOVE = -1;
        public static final int SET = 0;

        public void attachToElement(DBElement var1);

        public DBIdentifier getName();

        public void setName(DBIdentifier var1) throws DBException;

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    static abstract class Memory
    implements Impl {
        protected DBElement _element;
        private DBIdentifier _name;
        private PropertyChangeSupport support;

        public Memory() {
        }

        public Memory(DBElement el) {
            this._name = el.getName();
        }

        @Override
        public void attachToElement(DBElement element) {
            this._element = element;
        }

        @Override
        public final synchronized DBIdentifier getName() {
            if (this._name == null) {
                this._name = DBIdentifier.create("");
            }
            return this._name;
        }

        @Override
        public synchronized void setName(DBIdentifier name) {
            DBIdentifier old = this._name;
            this._name = name;
            this.firePropertyChange("name", old, name);
        }

        protected final void firePropertyChange(String name, Object o, Object n) {
            if (this.support != null) {
                this.support.firePropertyChange(name, o, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
            if (this.support == null) {
                Memory memory = this;
                synchronized (memory) {
                    if (this.support == null) {
                        this.support = new PropertyChangeSupport(this._element);
                    }
                }
            }
            this.support.addPropertyChangeListener(l);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
            if (this.support != null) {
                this.support.removePropertyChangeListener(l);
            }
        }
    }
}

