/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.preferences;

import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.css.prep.CssPreprocessorType;
import org.netbeans.modules.css.prep.util.CssPreprocessorUtils;
import org.openide.util.Pair;

abstract class BasePreferences {
    BasePreferences() {
    }

    protected boolean isConfigured(Project project, String propertyName) {
        return this.getPreferences(project).getBoolean(propertyName, false);
    }

    protected void setConfigured(Project project, String propertyName, boolean configured) {
        this.getPreferences(project).putBoolean(propertyName, configured);
    }

    protected boolean isEnabled(Project project, String propertyName) {
        String privateEnabled = this.getPrivatePreferences(project).get(propertyName, null);
        if (privateEnabled != null) {
            return Boolean.parseBoolean(privateEnabled);
        }
        return this.getPreferences(project).getBoolean(propertyName, false);
    }

    protected void setEnabled(Project project, String propertyName, boolean enabled) {
        this.getPrivatePreferences(project).remove(propertyName);
        this.getPreferences(project).putBoolean(propertyName, enabled);
    }

    @CheckForNull
    protected List<Pair<String, String>> getMappings(Project project, String propertyName, CssPreprocessorType type) {
        String mappings = this.getPreferences(project).get(propertyName, null);
        if (mappings == null) {
            return CssPreprocessorUtils.getDefaultMappings(type);
        }
        return CssPreprocessorUtils.decodeMappings(mappings);
    }

    protected void setMappings(Project project, String propertyName, List<Pair<String, String>> mappings) {
        this.getPreferences(project).put(propertyName, CssPreprocessorUtils.encodeMappings(mappings));
    }

    protected String getCompilerOptions(Project project, String propertyName) {
        return this.getPreferences(project).get(propertyName, "");
    }

    protected void setCompilerOptions(Project project, String propertyName, String compilerOptions) {
        this.getPreferences(project).put(propertyName, compilerOptions);
    }

    protected Preferences getPreferences(Project project) {
        assert (project != null);
        return ProjectUtils.getPreferences((Project)project, BasePreferences.class, (boolean)true);
    }

    protected Preferences getPrivatePreferences(Project project) {
        assert (project != null);
        return ProjectUtils.getPreferences((Project)project, BasePreferences.class, (boolean)false);
    }
}

