/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.ElementHandle;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.model.impl.ModelElement;

public class ElementHandleImpl
implements ElementHandle {
    private static char DELIMITER = (char)47;
    private static char INDEX_DELIMITER = (char)124;
    private String elementId;

    ElementHandleImpl(ModelElement element) {
        this.elementId = ElementHandleImpl.createPath(element);
    }

    @Override
    public Element resolve(Model model) {
        final AtomicReference elementRef = new AtomicReference();
        model.runReadTask(new Model.ModelTask(){

            @Override
            public void run(StyleSheet styleSheet) {
                StringTokenizer st = new StringTokenizer(ElementHandleImpl.this.elementId, "" + DELIMITER);
                StyleSheet base = styleSheet;
                assert (st.hasMoreTokens());
                String styleSheetId = st.nextToken();
                assert (styleSheetId.equals(ElementHandleImpl.getFQElementID((ModelElement)((Object)styleSheet))));
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    int indexDelim = token.indexOf(INDEX_DELIMITER);
                    String lightId = indexDelim >= 0 ? token.substring(0, indexDelim) : token;
                    String sindex = indexDelim >= 0 ? token.substring(indexDelim + 1) : "1";
                    int index = Integer.parseInt(sindex);
                    int count = 0;
                    ModelElement foundLocal = null;
                    Iterator<Element> childrenIterator = base.childrenIterator();
                    while (childrenIterator.hasNext()) {
                        ModelElement child = (ModelElement)childrenIterator.next();
                        if (!lightId.equals(ElementHandleImpl.getElementID(child)) || ++count != index) continue;
                        foundLocal = child;
                        break;
                    }
                    if (foundLocal == null) {
                        return;
                    }
                    base = foundLocal;
                    if (st.hasMoreTokens()) continue;
                    elementRef.set(base);
                    return;
                }
            }
        });
        return (Element)elementRef.get();
    }

    static String createPath(ModelElement element) {
        StringBuilder sb = new StringBuilder();
        ArrayList<ModelElement> elements = new ArrayList<ModelElement>();
        do {
            elements.add(0, element);
        } while ((element = (ModelElement)element.getParent()) != null);
        Iterator elementsItr = elements.iterator();
        while (elementsItr.hasNext()) {
            sb.append(ElementHandleImpl.getFQElementID((ModelElement)elementsItr.next()));
            if (!elementsItr.hasNext()) continue;
            sb.append(DELIMITER);
        }
        return sb.toString();
    }

    @NonNull
    static String getFQElementID(ModelElement element) {
        StringBuilder sb = new StringBuilder();
        sb.append(ElementHandleImpl.getElementID(element));
        int index = ElementHandleImpl.getIndexInSimilarNodes(element);
        if (index > 1) {
            sb.append(INDEX_DELIMITER);
            sb.append(index);
        }
        return sb.toString();
    }

    static String getElementID(ModelElement element) {
        String customElementId = element.getCustomElementID();
        return customElementId != null ? customElementId : element.getModelClass().getSimpleName();
    }

    static int getIndexInSimilarNodes(ModelElement element) {
        Element parent = element.getParent();
        if (parent == null) {
            return -1;
        }
        String elementLightID = ElementHandleImpl.getElementID(element);
        int index = 0;
        Iterator<Element> childrenIterator = parent.childrenIterator();
        while (childrenIterator.hasNext()) {
            ModelElement child = (ModelElement)childrenIterator.next();
            String childLightID = ElementHandleImpl.getElementID(child);
            if (childLightID.equals(elementLightID)) {
                ++index;
            }
            if (child != element) continue;
            break;
        }
        return index;
    }
}

