/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public class ExportDataDumper {
    public static final int BUFFER_SIZE = 32000;
    OutputStreamWriter osw;
    BufferedOutputStream bos;
    IOException caughtEx;
    int numExceptions = 0;

    public ExportDataDumper(FileOutputStream fw) {
        this.bos = new BufferedOutputStream(fw, 32000);
        this.osw = new OutputStreamWriter((OutputStream)this.bos, StandardCharsets.UTF_8);
    }

    public IOException getCaughtException() {
        return this.caughtEx;
    }

    public int getNumExceptions() {
        return this.numExceptions;
    }

    public void dumpByte(byte b) {
        if (this.caughtEx != null) {
            return;
        }
        try {
            this.bos.write(b);
        }
        catch (IOException ex) {
            this.caughtEx = ex;
            System.out.println(b);
            ++this.numExceptions;
            System.err.println(ex.getMessage());
        }
    }

    public void dumpData(CharSequence s) {
        if (this.caughtEx != null) {
            return;
        }
        try {
            if (s != null) {
                this.osw.append(s);
            }
        }
        catch (IOException ex) {
            this.caughtEx = ex;
            System.out.println(s);
            ++this.numExceptions;
            System.err.println(ex.getMessage());
        }
    }

    public void close() {
        try {
            this.osw.close();
            this.bos.close();
        }
        catch (IOException ex) {
            this.caughtEx = ex;
            System.err.println(ex.getMessage());
        }
    }

    public void dumpDataAndClose(StringBuffer s) {
        this.dumpData(s);
        this.close();
    }

    public BufferedOutputStream getOutputStream() {
        return this.bos;
    }
}

