/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.cct;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.RuntimeCCTNodeProcessor;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainerFree;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;

public class CCTFlattener
extends RuntimeCCTNodeProcessor.PluginAdapter {
    private static final Logger LOGGER = Logger.getLogger(CCTFlattener.class.getName());
    private final Object containerGuard = new Object();
    private FlatProfileContainer container;
    private ProfilerClient client;
    private Stack<TotalTime> parentStack;
    private Set methodsOnStack;
    private int[] invDiff;
    private int[] invPM;
    private int[] nCalleeInvocations;
    private long[] timePM0;
    private long[] timePM1;
    private long[] totalTimePM0;
    private long[] totalTimePM1;
    private int nMethods;
    private CCTResultsFilter currentFilter;
    private InstrumentationFilter instrFilter;
    private int cpuProfilingType;
    private boolean twoTimestamps;
    private TimingAdjusterOld timingAdjuster;

    public CCTFlattener(ProfilerClient client, CCTResultsFilter filter) {
        this.client = client;
        this.parentStack = new Stack();
        this.methodsOnStack = new HashSet();
        this.currentFilter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlatProfileContainer getFlatProfile() {
        Object object = this.containerGuard;
        synchronized (object) {
            return this.container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        ProfilingSessionStatus status = this.client.getStatus();
        ProfilerEngineSettings pes = this.client.getSettings();
        this.nMethods = this.getMaxMethodId();
        this.timePM0 = new long[this.nMethods];
        this.timePM1 = new long[status.collectingTwoTimeStamps() ? this.nMethods : 0];
        this.totalTimePM0 = new long[this.nMethods];
        this.totalTimePM1 = new long[status.collectingTwoTimeStamps() ? this.nMethods : 0];
        this.invPM = new int[this.nMethods];
        this.invDiff = new int[this.nMethods];
        this.nCalleeInvocations = new int[this.nMethods];
        this.parentStack.clear();
        this.methodsOnStack.clear();
        this.instrFilter = pes.getInstrumentationFilter();
        this.cpuProfilingType = pes.getCPUProfilingType();
        this.twoTimestamps = status.collectingTwoTimeStamps();
        this.timingAdjuster = TimingAdjusterOld.getInstance(status);
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        long wholeGraphTime0 = 0L;
        long wholeGraphTime1 = 0L;
        long totalNInv = 0L;
        for (int i = 0; i < this.nMethods; ++i) {
            double time = this.timingAdjuster.adjustTime(this.timePM0[i], this.invPM[i] + this.invDiff[i], this.nCalleeInvocations[i] + this.invDiff[i], false);
            if (time < 0.0) {
                time = 0.0;
            }
            this.timePM0[i] = (long)time;
            if (i > 0) {
                wholeGraphTime0 = (long)((double)wholeGraphTime0 + time);
            }
            if (this.twoTimestamps) {
                time = this.timingAdjuster.adjustTime(this.timePM1[i], this.invPM[i] + this.invDiff[i], this.nCalleeInvocations[i] + this.invDiff[i], true);
                if (time < 0.0) {
                    time = 0.0;
                }
                this.timePM1[i] = (long)time;
                if (i > 0) {
                    wholeGraphTime1 = (long)((double)wholeGraphTime1 + time);
                }
            }
            totalNInv += (long)this.invPM[i];
        }
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = this.createContainer(this.timePM0, this.timePM1, this.totalTimePM0, this.totalTimePM1, this.invPM, wholeGraphTime0, wholeGraphTime1);
        }
        this.timePM1 = null;
        this.timePM0 = null;
        this.totalTimePM1 = null;
        this.totalTimePM0 = null;
        this.nCalleeInvocations = null;
        this.invDiff = null;
        this.invPM = null;
        this.parentStack.clear();
        this.methodsOnStack.clear();
        this.instrFilter = null;
    }

    @Override
    public void onNode(MethodCPUCCTNode node) {
        int parentMethodId;
        String jvmClassName;
        boolean filteredOut;
        int nodeMethodId = node.getMethodId();
        int nodeFilerStatus = node.getFilteredStatus();
        MethodCPUCCTNode currentParent = this.parentStack.isEmpty() ? null : this.parentStack.peek().parent;
        boolean bl = filteredOut = nodeFilerStatus == 2;
        if (!(filteredOut || this.cpuProfilingType != 2 && nodeFilerStatus != 1 || this.instrFilter.passes(jvmClassName = this.getInstrMethodClass(nodeMethodId).replace('.', '/')))) {
            filteredOut = true;
        }
        if (!filteredOut && this.currentFilter != null) {
            filteredOut = !this.currentFilter.passesFilter();
        }
        int n = parentMethodId = currentParent != null ? currentParent.getMethodId() : -1;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Processing runtime node: {0}.{1}; filtered={2}, time={3}, CPU time={4}", new Object[]{this.getInstrMethodClass(nodeMethodId), this.getInstrMethodName(nodeMethodId), filteredOut, node.getNetTime0(), node.getNetTime1()});
            String parentInfo = currentParent != null ? this.getInstrMethodClass(parentMethodId) + "." + this.getInstrMethodName(parentMethodId) : "none";
            LOGGER.log(Level.FINEST, "Currently used parent: {0}", parentInfo);
        }
        if (filteredOut) {
            if (currentParent != null && !currentParent.isRoot()) {
                int n2 = parentMethodId;
                this.invDiff[n2] = this.invDiff[n2] + node.getNCalls();
                int n3 = parentMethodId;
                this.timePM0[n3] = this.timePM0[n3] + node.getNetTime0();
                if (this.twoTimestamps) {
                    int n4 = parentMethodId;
                    this.timePM1[n4] = this.timePM1[n4] + node.getNetTime1();
                }
            }
        } else {
            int n5 = nodeMethodId;
            this.timePM0[n5] = this.timePM0[n5] + node.getNetTime0();
            if (this.twoTimestamps) {
                int n6 = nodeMethodId;
                this.timePM1[n6] = this.timePM1[n6] + node.getNetTime1();
            }
            int n7 = nodeMethodId;
            this.invPM[n7] = this.invPM[n7] + node.getNCalls();
            if (currentParent != null && !currentParent.isRoot()) {
                int n8 = parentMethodId;
                this.nCalleeInvocations[n8] = this.nCalleeInvocations[n8] + node.getNCalls();
            }
        }
        MethodCPUCCTNode nextParent = filteredOut ? currentParent : node;
        TotalTime timeNode = new TotalTime(nextParent, this.methodsOnStack.contains(nodeMethodId));
        timeNode.totalTimePM0 += node.getNetTime0();
        if (this.twoTimestamps) {
            timeNode.totalTimePM1 += node.getNetTime1();
        }
        if (!timeNode.recursive) {
            this.methodsOnStack.add(nodeMethodId);
        }
        this.parentStack.push(timeNode);
    }

    @Override
    public void onBackout(MethodCPUCCTNode node) {
        TotalTime current = this.parentStack.pop();
        if (!current.recursive) {
            int nodeMethodId = node.getMethodId();
            this.methodsOnStack.remove(nodeMethodId);
            if (nodeMethodId != -1) {
                long time = (long)this.timingAdjuster.adjustTime(current.totalTimePM0, node.getNCalls() + current.outCalls, current.outCalls, false);
                if (time > 0L) {
                    int n = nodeMethodId;
                    this.totalTimePM0[n] = this.totalTimePM0[n] + time;
                }
                if (this.twoTimestamps && (time = (long)this.timingAdjuster.adjustTime(current.totalTimePM1, node.getNCalls() + current.outCalls, current.outCalls, true)) > 0L) {
                    int n = nodeMethodId;
                    this.totalTimePM1[n] = this.totalTimePM1[n] + time;
                }
            }
        }
        if (!this.parentStack.isEmpty()) {
            TotalTime parent = this.parentStack.peek();
            parent.add(current);
            parent.outCalls += node.getNCalls();
        }
    }

    protected int getMaxMethodId() {
        return this.client.getStatus().getNInstrMethods();
    }

    protected String getInstrMethodClass(int nodeMethodId) {
        return this.client.getStatus().getInstrMethodClasses()[nodeMethodId];
    }

    protected String getInstrMethodName(int nodeMethodId) {
        return this.client.getStatus().getInstrMethodNames()[nodeMethodId];
    }

    protected FlatProfileContainer createContainer(long[] timeInMcs0, long[] timeInMcs1, long[] totalTimeInMcs0, long[] totalTimeInMcs1, int[] nInvocations, double wholeGraphNetTime0, double wholeGraphNetTime1) {
        return new FlatProfileContainerFree(this.client.getStatus(), timeInMcs0, timeInMcs1, totalTimeInMcs0, totalTimeInMcs1, nInvocations, new char[0], wholeGraphNetTime0, wholeGraphNetTime1, nInvocations.length);
    }

    private static class TotalTime {
        private final MethodCPUCCTNode parent;
        private final boolean recursive;
        private int outCalls;
        private long totalTimePM0;
        private long totalTimePM1;

        TotalTime(MethodCPUCCTNode n, boolean r) {
            this.parent = n;
            this.recursive = r;
        }

        private void add(TotalTime current) {
            this.outCalls += current.outCalls;
            this.totalTimePM0 += current.totalTimePM0;
            this.totalTimePM1 += current.totalTimePM1;
        }
    }
}

