/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.HprofGCRoot;
import org.netbeans.lib.profiler.heap.HprofGCRoots;
import org.netbeans.lib.profiler.heap.StackFrame;
import org.netbeans.lib.profiler.heap.StackTrace;
import org.netbeans.lib.profiler.heap.ThreadObjectGCRoot;

class ThreadObjectHprofGCRoot
extends HprofGCRoot
implements ThreadObjectGCRoot {
    ThreadObjectHprofGCRoot(HprofGCRoots r, long offset) {
        super(r, offset);
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTrace stackTrace;
        int stackTraceSerialNumber = this.getStackTraceSerialNumber();
        if (stackTraceSerialNumber != 0 && (stackTrace = this.roots.heap.getStackTraceSegment().getStackTraceBySerialNumber(stackTraceSerialNumber)) != null) {
            StackFrame[] frames = stackTrace.getStackFrames();
            StackTraceElement[] stackElements = new StackTraceElement[frames.length];
            for (int i = 0; i < frames.length; ++i) {
                StackFrame f = frames[i];
                String className = f.getClassName();
                String method = f.getMethodName();
                String source = f.getSourceFile();
                int number = f.getLineNumber();
                if (number == -3) {
                    number = -2;
                } else if (number == 0 || number == -1) {
                    number = -1;
                }
                stackElements[i] = new StackTraceElement(className, method, source, number);
            }
            return stackElements;
        }
        return null;
    }

    int getThreadSerialNumber() {
        return this.getHprofBuffer().getInt(this.fileOffset + 1L + (long)this.getHprofBuffer().getIDSize());
    }

    private int getStackTraceSerialNumber() {
        return this.getHprofBuffer().getInt(this.fileOffset + 1L + (long)this.getHprofBuffer().getIDSize() + 4L);
    }
}

