/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.AppearanceController;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.lib.profiler.ui.threads.NameStateRenderer;
import org.netbeans.lib.profiler.ui.threads.ThreadStateIcon;
import org.netbeans.lib.profiler.ui.threads.ThreadTimeRelRenderer;
import org.netbeans.lib.profiler.ui.threads.TimelineHeaderRenderer;
import org.netbeans.lib.profiler.ui.threads.TimelineRenderer;
import org.netbeans.lib.profiler.ui.threads.ViewManager;

public class ThreadsPanel
extends DataView {
    private final ThreadsDataManager dataManager;
    private final ViewManager viewManager;
    private DataManagerListener listener;
    private ProfilerTable threadsTable;
    private ProfilerTableContainer threadsTableContainer;
    private JPanel bottomPanel;
    private JPanel legendPanel;
    private Filter filter = Filter.ALL;
    private final Set<Integer> selected = new HashSet<Integer>();
    private final Set<Integer> selectedApplied = new HashSet<Integer>();
    private Component zoomInAction;
    private Component zoomOutAction;
    private Component fitAction;
    private ThreadTimeRelRenderer timeRelRenderer;
    private long lastTimestamp;

    private static ResourceBundle BUNDLE() {
        return ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    }

    public ThreadsPanel(ThreadsDataManager dataManager, Action saveView) {
        this.dataManager = dataManager;
        this.lastTimestamp = dataManager.getEndTime();
        this.viewManager = new ViewManager(2, dataManager){

            @Override
            public void columnWidthChanged(int column, int oldW, int newW) {
                if (column == 2 && this.isFit()) {
                    ThreadsPanel.this.threadsTable.updateColumnPreferredWidth(2);
                }
                super.columnWidthChanged(column, oldW, newW);
            }

            @Override
            public void columnOffsetChanged(int column, int oldO, int newO) {
                super.columnOffsetChanged(column, oldO, newO);
                if (column == 2) {
                    ThreadsPanel.this.repaintTimeline();
                }
            }

            @Override
            public void zoomChanged(double oldZoom, double newZoom) {
                super.zoomChanged(oldZoom, newZoom);
                ThreadsPanel.this.repaintTimeline();
            }
        };
        this.initUI(saveView);
    }

    public void setFilter(Filter filter) {
        this.selectedApplied.clear();
        if (Filter.SELECTED == filter) {
            this.selectedApplied.addAll(this.selected);
        }
        this.filter = filter;
        this.threadsTable.addRowFilter(new ThreadsFilter());
        this.filterSelected(filter);
    }

    public Filter getFilter() {
        return this.filter;
    }

    protected void filterSelected(Filter filter) {
    }

    public boolean hasSelectedThreads() {
        return !this.selected.isEmpty();
    }

    public void showSelectedColumn() {
        this.threadsTable.setColumnVisibility(0, true);
    }

    public void cleanup() {
        this.dataManager.removeDataListener(this.listener);
    }

    private void initUI(Action saveView) {
        AppearanceController.getDefault().customizeThreadPanel(this);
        final AbstractTableModel threadsTableModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return ThreadsPanel.BUNDLE().getString("COL_Selected");
                }
                if (columnIndex == 1) {
                    return ThreadsPanel.BUNDLE().getString("COL_Name");
                }
                if (columnIndex == 2) {
                    return ThreadsPanel.BUNDLE().getString("COL_Timeline");
                }
                if (columnIndex == 3) {
                    return CommonConstants.THREAD_STATUS_RUNNING_STRING;
                }
                if (columnIndex == 4) {
                    return CommonConstants.THREAD_STATUS_SLEEPING_STRING;
                }
                if (columnIndex == 5) {
                    return CommonConstants.THREAD_STATUS_WAIT_STRING;
                }
                if (columnIndex == 6) {
                    return CommonConstants.THREAD_STATUS_PARK_STRING;
                }
                if (columnIndex == 7) {
                    return CommonConstants.THREAD_STATUS_MONITOR_STRING;
                }
                if (columnIndex == 8) {
                    return ThreadsPanel.BUNDLE().getString("COL_Total");
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Boolean.class;
                }
                if (columnIndex == 1) {
                    return ThreadData.class;
                }
                if (columnIndex == 2) {
                    return ViewManager.RowView.class;
                }
                return Long.class;
            }

            @Override
            public int getRowCount() {
                return ThreadsPanel.this.dataManager.getThreadsCount();
            }

            @Override
            public int getColumnCount() {
                return 9;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return ThreadsPanel.this.selected.contains(rowIndex);
                }
                if (columnIndex == 1) {
                    return this.getData(rowIndex);
                }
                if (columnIndex == 2) {
                    return ThreadsPanel.this.viewManager.getRowView(rowIndex);
                }
                if (columnIndex == 3) {
                    return this.getData(rowIndex).getRunningTime(ThreadsPanel.this.lastTimestamp);
                }
                if (columnIndex == 4) {
                    return this.getData(rowIndex).getSleepingTime(ThreadsPanel.this.lastTimestamp);
                }
                if (columnIndex == 5) {
                    return this.getData(rowIndex).getWaitTime(ThreadsPanel.this.lastTimestamp);
                }
                if (columnIndex == 6) {
                    return this.getData(rowIndex).getParkTime(ThreadsPanel.this.lastTimestamp);
                }
                if (columnIndex == 7) {
                    return this.getData(rowIndex).getMonitorTime(ThreadsPanel.this.lastTimestamp);
                }
                if (columnIndex == 8) {
                    return this.getData(rowIndex).getTotalTime(ThreadsPanel.this.lastTimestamp);
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    if (Boolean.FALSE.equals(aValue)) {
                        ThreadsPanel.this.selected.remove(rowIndex);
                    } else {
                        ThreadsPanel.this.selected.add(rowIndex);
                    }
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }

            private ThreadData getData(int rowIndex) {
                return ThreadsPanel.this.dataManager.getThreadData(rowIndex);
            }
        };
        this.threadsTable = new ProfilerTable(threadsTableModel, true, true, new int[]{2}){

            @Override
            protected int computeColumnPreferredWidth(int modelIndex, int viewIndex, int firstRow, int lastRow) {
                if (modelIndex != 2) {
                    return super.computeColumnPreferredWidth(modelIndex, viewIndex, firstRow, lastRow);
                }
                ThreadsPanel.this.viewManager.update();
                if (ThreadsPanel.this.viewManager.isFit()) {
                    return this.getTableHeader().getHeaderRect((int)viewIndex).width;
                }
                return ThreadsPanel.this.viewManager.getViewWidth();
            }

            @Override
            public Object getUserValueForRow(int row) {
                if (row == -1) {
                    return null;
                }
                if (row >= this.getModel().getRowCount()) {
                    return null;
                }
                return this.convertRowIndexToModel(row);
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                if (userValue != null) {
                    final int row = (Integer)userValue;
                    final boolean sel = ThreadsPanel.this.selected.contains(row);
                    popup.add(new JMenuItem(sel ? ThreadsPanel.BUNDLE().getString("ACT_UnselectThread") : ThreadsPanel.BUNDLE().getString("ACT_SelectThread")){

                        @Override
                        protected void fireActionPerformed(ActionEvent e) {
                            if (sel) {
                                ThreadsPanel.this.selected.remove(row);
                            } else {
                                ThreadsPanel.this.selected.add(row);
                            }
                            threadsTableModel.fireTableDataChanged();
                            if (!sel) {
                                ThreadsPanel.this.showSelectedColumn();
                            }
                        }
                    });
                    popup.addSeparator();
                }
                popup.add(this.createCopyMenuItem());
                popup.addSeparator();
                popup.add(new JMenuItem(FilterUtils.ACTION_FILTER){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        ThreadsPanel.this.activateFilter();
                    }
                });
                popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        ThreadsPanel.this.activateSearch();
                    }
                });
            }
        };
        this.threadsTable.setColumnVisibility(0, false);
        this.threadsTable.setMainColumn(1);
        this.threadsTable.setColumnToolTips(new String[]{ThreadsPanel.BUNDLE().getString("DESC_Selected"), ThreadsPanel.BUNDLE().getString("DESC_Name"), ThreadsPanel.BUNDLE().getString("DESC_Timeline"), ThreadsPanel.BUNDLE().getString("DESC_Running"), ThreadsPanel.BUNDLE().getString("DESC_Sleeping"), ThreadsPanel.BUNDLE().getString("DESC_Wait"), ThreadsPanel.BUNDLE().getString("DESC_Park"), ThreadsPanel.BUNDLE().getString("DESC_Monitor"), ThreadsPanel.BUNDLE().getString("DESC_Total")});
        this.threadsTable.setDefaultSortOrder(1, SortOrder.ASCENDING);
        this.threadsTable.setDefaultSortOrder(2, SortOrder.ASCENDING);
        this.threadsTable.setSecondarySortColumn(1);
        this.threadsTable.setSortColumn(2);
        this.threadsTable.setFitWidthColumn(2);
        NameStateRenderer nameStateRenderer = new NameStateRenderer();
        nameStateRenderer.setText("THREADnameTOsetupCOLUMNwidth");
        this.threadsTable.setColumnRenderer(0, new CheckBoxRenderer());
        this.threadsTable.setDefaultRenderer(ThreadData.class, nameStateRenderer);
        this.threadsTable.setDefaultRenderer(ViewManager.RowView.class, new TimelineRenderer(this.viewManager));
        int w = new JLabel((String)this.threadsTable.getColumnName((int)0)).getPreferredSize().width;
        this.threadsTable.setDefaultColumnWidth(0, w + 15);
        this.threadsTable.setDefaultColumnWidth(1, nameStateRenderer.getPreferredSize().width);
        JTableHeader header = this.threadsTable.getTableHeader();
        TableCellRenderer headerRenderer = header.getDefaultRenderer();
        header.setDefaultRenderer(new TimelineHeaderRenderer(headerRenderer, 2, this.viewManager));
        Long refTime = 1234567L;
        this.timeRelRenderer = new ThreadTimeRelRenderer(this.dataManager);
        this.timeRelRenderer.setMaxValue(refTime);
        this.threadsTable.setDefaultColumnWidth(this.timeRelRenderer.getNoBarWidth());
        this.threadsTable.setDefaultRenderer(Long.class, this.timeRelRenderer);
        NumberRenderer numberRenderer = new NumberRenderer(Formatters.millisecondsFormat());
        numberRenderer.setValue(refTime, -1);
        this.threadsTable.setDefaultColumnWidth(8, numberRenderer.getPreferredSize().width);
        this.threadsTable.setColumnRenderer(8, numberRenderer);
        this.threadsTable.setColumnVisibility(4, false);
        this.threadsTable.setColumnVisibility(5, false);
        this.threadsTable.setColumnVisibility(6, false);
        this.threadsTable.setColumnVisibility(7, false);
        this.threadsTable.providePopupMenu(true);
        this.threadsTableContainer = new ProfilerTableContainer(this.threadsTable, false, this.viewManager);
        this.legendPanel = new JPanel(new FlowLayout(4, 7, 8));
        this.legendPanel.setOpaque(false);
        ThreadStateIcon runningIcon = new ThreadStateIcon(1, 18, 9);
        JLabel runningLegend = new JLabel(CommonConstants.THREAD_STATUS_RUNNING_STRING, runningIcon, 10);
        runningLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(runningLegend);
        ThreadStateIcon sleepingIcon = new ThreadStateIcon(2, 18, 9);
        JLabel sleepingLegend = new JLabel(CommonConstants.THREAD_STATUS_SLEEPING_STRING, sleepingIcon, 10);
        sleepingLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(sleepingLegend);
        ThreadStateIcon waitIcon = new ThreadStateIcon(4, 18, 9);
        JLabel waitLegend = new JLabel(CommonConstants.THREAD_STATUS_WAIT_STRING, waitIcon, 10);
        waitLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(waitLegend);
        ThreadStateIcon parkIcon = new ThreadStateIcon(5, 18, 9);
        JLabel parkLegend = new JLabel(CommonConstants.THREAD_STATUS_PARK_STRING, parkIcon, 10);
        parkLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(parkLegend);
        ThreadStateIcon monitorIcon = new ThreadStateIcon(3, 18, 9);
        JLabel monitorLegend = new JLabel(CommonConstants.THREAD_STATUS_MONITOR_STRING, monitorIcon, 10);
        monitorLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(monitorLegend);
        final Action zoomIn = this.viewManager.zoomInAction();
        this.zoomInAction = new JButton(zoomIn){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                Object newOffset = zoomIn.getValue("newOffset");
                if (newOffset != null) {
                    int _newOffset = (Integer)newOffset;
                    ThreadsPanel.this.threadsTable.setColumnOffset(2, _newOffset);
                }
                threadsTableModel.fireTableDataChanged();
            }

            @Override
            public boolean isEnabled() {
                return ThreadsPanel.this.threadsTable.isShowing() && super.isEnabled();
            }
        };
        final Action zoomOut = this.viewManager.zoomOutAction();
        this.zoomOutAction = new JButton(zoomOut){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                Object newOffset = zoomOut.getValue("newOffset");
                if (newOffset != null) {
                    int _newOffset = (Integer)newOffset;
                    ThreadsPanel.this.threadsTable.setColumnOffset(2, _newOffset);
                }
                threadsTableModel.fireTableDataChanged();
            }

            @Override
            public boolean isEnabled() {
                return ThreadsPanel.this.threadsTable.isShowing() && super.isEnabled();
            }
        };
        this.fitAction = new JToggleButton(this.viewManager.fitAction()){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                threadsTableModel.fireTableDataChanged();
            }
        };
        this.fitAction.setEnabled(false);
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.setOpaque(false);
        this.bottomPanel.add((Component)this.legendPanel, "South");
        this.setOpaque(true);
        this.setBackground(UIUtils.getProfilerResultsBackground());
        this.setLayout(new BorderLayout());
        this.add((Component)this.threadsTableContainer, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.listener = new DataManagerListener(){
            private boolean firstChange = true;

            public void dataChanged() {
                ThreadsPanel.this.lastTimestamp = ThreadsPanel.this.dataManager.getEndTime();
                if (this.firstChange) {
                    this.firstChange = false;
                    ThreadsPanel.this.repaintTimeline();
                }
                threadsTableModel.fireTableDataChanged();
            }

            public void dataReset() {
                ThreadsPanel.this.viewManager.reset();
                this.firstChange = true;
                ThreadsPanel.this.timeRelRenderer.setMaxValue(0L);
                threadsTableModel.fireTableDataChanged();
            }
        };
        this.dataManager.addDataListener(this.listener);
        this.registerActions();
    }

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsPanel.this.activateFilter();
            }
        });
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsPanel.this.activateSearch();
            }
        });
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.threadsTable;
    }

    @Override
    protected boolean hasBottomFilterFindMargin() {
        return true;
    }

    @Override
    protected void addFilterFindPanel(JComponent comp) {
        this.bottomPanel.add((Component)comp, "North");
    }

    private void repaintTimeline() {
        JTableHeader header = this.threadsTable.getTableHeader();
        TableColumn draggedColumn = header.getDraggedColumn();
        if (draggedColumn != null && draggedColumn.getModelIndex() == 2) {
            header.repaint();
        } else {
            int _column = this.threadsTable.convertColumnIndexToView(2);
            header.repaint(header.getHeaderRect(_column));
        }
    }

    public Component getToolbar() {
        return null;
    }

    public Component getZoomIn() {
        return this.zoomInAction;
    }

    public Component getZoomOut() {
        return this.zoomOutAction;
    }

    public Component getFitWidth() {
        return this.fitAction;
    }

    public BufferedImage getCurrentViewScreenshot(boolean onlyVisibleArea) {
        return this.threadsTableContainer.createTableScreenshot(onlyVisibleArea);
    }

    public boolean fitsVisibleArea() {
        return !this.threadsTableContainer.tableNeedsScrolling();
    }

    public boolean hasView() {
        return this.threadsTableContainer.isShowing();
    }

    public void threadsMonitoringDisabled() {
        this.fitAction.setEnabled(false);
    }

    public void threadsMonitoringEnabled() {
        this.fitAction.setEnabled(true);
    }

    public void profilingSessionStarted() {
        this.selected.clear();
        if (!this.selectedApplied.isEmpty()) {
            this.setFilter(Filter.LIVE);
        }
    }

    public void profilingSessionFinished() {
    }

    public void addThreadsMonitoringActionListener(ActionListener listener) {
    }

    public static enum Filter {
        ALL,
        LIVE,
        FINISHED,
        SELECTED;

    }

    private final class ThreadsFilter
    extends RowFilter {
        private ThreadsFilter() {
        }

        public boolean include(RowFilter.Entry entry) {
            ThreadData data = (ThreadData)entry.getValue(1);
            switch (ThreadsPanel.this.filter) {
                case LIVE: {
                    return ThreadData.isAliveState((int)data.getLastState());
                }
                case FINISHED: {
                    return !ThreadData.isAliveState((int)data.getLastState());
                }
                case SELECTED: {
                    return ThreadsPanel.this.selectedApplied.contains(entry.getIdentifier());
                }
            }
            return true;
        }

        public boolean equals(Object o) {
            return o instanceof ThreadsFilter;
        }

        public int hashCode() {
            return 0x7FFFFFF4;
        }
    }
}

