/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.canvas;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import org.netbeans.lib.profiler.charts.canvas.BufferedCanvasComponent;

public abstract class TransformableCanvasComponent
extends BufferedCanvasComponent {
    private static final float SHIFT_ACCEL_LIMIT = 0.15f;
    private static final float DIAGONAL_SHIFT_ACCEL_LIMIT = 0.3f;
    private Insets viewInsets = new Insets(0, 0, 0, 0);
    private long dataOffsetX;
    private long pendingDataOffsetX;
    private long dataOffsetY;
    private long pendingDataOffsetY;
    private long dataWidth;
    private long pendingDataWidth;
    private long dataHeight;
    private long pendingDataHeight;
    private long contentsOffsetX;
    private long contentsOffsetY;
    private long contentsWidth;
    private long contentsHeight;
    private double scaleX = 1.0;
    private double lastScaleX;
    private double oldScaleX;
    private double scaleY = 1.0;
    private double lastScaleY;
    private double oldScaleY;
    private long offsetX;
    private long maxOffsetX;
    private long lastOffsetX;
    private long offsetY;
    private long maxOffsetY;
    private long lastOffsetY;
    private boolean rightBased;
    private boolean bottomBased;
    private boolean tracksDataOffsetX = true;
    private boolean tracksDataOffsetY;
    private boolean tracksDataWidth = true;
    private boolean tracksDataHeight;
    private boolean fitsWidth;
    private boolean fitsHeight;
    private long dx = 0L;
    private long dy = 0L;
    private int hOffsetAdjustingCounter = 0;
    private int vOffsetAdjustingCounter = 0;

    protected abstract void paintContents(Graphics var1, Rectangle var2);

    protected void contentsWillBeUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY) {
    }

    protected void contentsUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY, int shiftX, int shiftY) {
    }

    public final void setViewInsets(Insets insets) {
        this.viewInsets.set(insets.top, insets.left, insets.bottom, insets.right);
    }

    public final Insets getViewInsets() {
        return new Insets(this.viewInsets.top, this.viewInsets.left, this.viewInsets.bottom, this.viewInsets.right);
    }

    public final void setRightBased(boolean rightBased) {
        this.rightBased = rightBased;
    }

    public final boolean isRightBased() {
        return this.rightBased;
    }

    public final void setBottomBased(boolean bottomBased) {
        this.bottomBased = bottomBased;
    }

    public final boolean isBottomBased() {
        return this.bottomBased;
    }

    public final void setTracksDataOffsetX(boolean tracksDataOffsetX) {
        this.tracksDataOffsetX = tracksDataOffsetX;
    }

    public final boolean tracksDataOffsetX() {
        return this.tracksDataOffsetX;
    }

    public final void setTracksDataOffsetY(boolean tracksDataOffsetY) {
        this.tracksDataOffsetY = tracksDataOffsetY;
    }

    public final boolean tracksDataOffsetY() {
        return this.tracksDataOffsetY;
    }

    public final void setTracksDataWidth(boolean tracksDataWidth) {
        this.tracksDataWidth = tracksDataWidth;
    }

    public final boolean tracksDataWidth() {
        return this.tracksDataWidth;
    }

    public final boolean currentlyFollowingDataWidth() {
        return this.tracksDataWidth && !this.fitsWidth && this.offsetX == this.maxOffsetX;
    }

    public final void setTracksDataHeight(boolean tracksDataHeight) {
        this.tracksDataHeight = tracksDataHeight;
    }

    public final boolean tracksDataHeight() {
        return this.tracksDataHeight;
    }

    public final boolean currentlyFollowingDataHeight() {
        return this.tracksDataHeight && !this.fitsHeight && this.offsetY == this.maxOffsetY;
    }

    public final void setFitsWidth(boolean fitsWidth) {
        if (this.fitsWidth == fitsWidth) {
            return;
        }
        this.fitsWidth = fitsWidth;
        if (fitsWidth) {
            this.updateScale();
        } else {
            this.updateContentsWidths();
            this.updateMaxOffsets();
        }
    }

    public final boolean fitsWidth() {
        return this.fitsWidth;
    }

    public final void setFitsHeight(boolean fitsHeight) {
        if (this.fitsHeight == fitsHeight) {
            return;
        }
        this.fitsHeight = fitsHeight;
        if (fitsHeight) {
            this.updateScale();
        } else {
            this.updateContentsWidths();
            this.updateMaxOffsets();
        }
    }

    public final boolean fitsHeight() {
        return this.fitsHeight;
    }

    public final long getOffsetX() {
        return this.offsetX;
    }

    protected final long getMaxOffsetX() {
        return this.maxOffsetX;
    }

    public final long getOffsetY() {
        return this.offsetY;
    }

    protected final long getMaxOffsetY() {
        return this.maxOffsetY;
    }

    public final void setOffset(long offsetX, long offsetY) {
        offsetX = Math.max(Math.min(offsetX, this.maxOffsetX), 0L);
        offsetY = Math.max(Math.min(offsetY, this.maxOffsetY), 0L);
        if (this.offsetX == offsetX && this.offsetY == offsetY) {
            return;
        }
        long oldOffsetX = this.offsetX;
        long oldoffsetY = this.offsetY;
        this.dx += this.offsetX - offsetX;
        this.offsetX = offsetX;
        this.dy += this.offsetY - offsetY;
        this.offsetY = offsetY;
        this.offsetChanged(oldOffsetX, oldoffsetY, offsetX, offsetY);
    }

    protected void offsetChanged(long oldOffsetX, long oldOffsetY, long newOffsetX, long newOffsetY) {
    }

    public final double getScaleX() {
        return this.scaleX;
    }

    public final double getScaleY() {
        return this.scaleY;
    }

    public final void setScale(double scaleX, double scaleY) {
        if (this.scaleX == scaleX && this.scaleY == scaleY) {
            return;
        }
        double origScaleX = this.scaleX;
        double origScaleY = this.scaleY;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.updateContentsWidths();
        this.updateMaxOffsets();
        this.setOffset(this.offsetX, this.offsetY);
        this.scaleChanged(origScaleX, origScaleY, scaleX, scaleY);
        this.invalidateImage();
    }

    protected void scaleChanged(double oldScaleX, double oldScaleY, double newScaleX, double newScaleY) {
    }

    public final long getDataOffsetX() {
        return this.dataOffsetX;
    }

    public final long getDataOffsetY() {
        return this.dataOffsetY;
    }

    public final long getDataWidth() {
        return this.dataWidth;
    }

    public final long getDataHeight() {
        return this.dataHeight;
    }

    public final long getContentsWidth() {
        return this.contentsWidth;
    }

    public final long getContentsHeight() {
        return this.contentsHeight;
    }

    public final void setDataBounds(long dataOffsetX, long dataOffsetY, long dataWidth, long dataHeight) {
        if (this.dataOffsetX == dataOffsetX && this.dataOffsetY == dataOffsetY && this.dataWidth == dataWidth && this.dataHeight == dataHeight) {
            return;
        }
        if (this.isHOffsetAdjusting() && this.contentsWidth >= (long)this.getWidth() && this.dataWidth != dataWidth || this.isVOffsetAdjusting() && this.contentsHeight >= (long)this.getHeight() && this.dataHeight != dataHeight) {
            this.pendingDataOffsetX = dataOffsetX;
            this.pendingDataOffsetY = dataOffsetY;
            this.pendingDataWidth = dataWidth;
            this.pendingDataHeight = dataHeight;
        } else {
            long oldOffsetX = this.offsetX;
            long oldOffsetY = this.offsetY;
            long oldContentsOffsetX = this.contentsOffsetX;
            long oldContentsOffsetY = this.contentsOffsetY;
            long oldMaxOffsetX = this.maxOffsetX;
            long oldMaxOffsetY = this.maxOffsetY;
            long oldDataOffsetX = this.dataOffsetX;
            long oldDataOffsetY = this.dataOffsetY;
            long oldDataWidth = this.dataWidth;
            long oldDataHeight = this.dataHeight;
            this.dataOffsetX = dataOffsetX;
            this.dataOffsetY = dataOffsetY;
            this.dataWidth = dataWidth;
            this.dataHeight = dataHeight;
            this.contentsOffsetX = (long)Math.ceil(this.getViewWidth(dataOffsetX));
            this.contentsOffsetY = (long)Math.ceil(this.getViewHeight(dataOffsetY));
            this.updateScale();
            this.updateContentsWidths();
            this.updateMaxOffsets();
            long newOffsetX = this.offsetX;
            long newOffsetY = this.offsetY;
            if (!this.fitsWidth) {
                if (this.tracksDataWidth && this.offsetX == oldMaxOffsetX) {
                    newOffsetX = this.maxOffsetX;
                } else if (!(this.oldScaleX != this.scaleX || this.tracksDataOffsetX && this.offsetX == 0L)) {
                    newOffsetX = this.offsetX + oldContentsOffsetX - this.contentsOffsetX;
                }
            }
            if (!this.fitsHeight) {
                if (this.tracksDataHeight && this.offsetY == oldMaxOffsetY) {
                    newOffsetY = this.maxOffsetY;
                } else if (!(this.oldScaleY != this.scaleY || this.tracksDataOffsetY && this.offsetY == 0L)) {
                    newOffsetY = this.offsetY + oldContentsOffsetY - this.contentsOffsetY;
                }
            }
            long dxx = this.dx;
            long dyy = this.dy;
            this.setOffset(newOffsetX, newOffsetY);
            this.dataBoundsChanged(dataOffsetX, dataOffsetY, dataWidth, dataHeight, oldDataOffsetX, oldDataOffsetY, oldDataWidth, oldDataHeight);
            this.dx = this.fitsWidth ? 0L : dxx + (oldContentsOffsetX - this.contentsOffsetX) - (this.offsetX - oldOffsetX);
            this.dy = this.fitsHeight ? 0L : dyy + (oldContentsOffsetY - this.contentsOffsetY) - (this.offsetY - oldOffsetY);
            this.oldScaleX = this.scaleX;
            this.oldScaleY = this.scaleY;
            this.pendingDataOffsetX = -1L;
            this.pendingDataOffsetY = -1L;
            this.pendingDataWidth = -1L;
            this.pendingDataHeight = -1L;
        }
    }

    protected void dataBoundsChanged(long dataOffsetX, long dataOffsetY, long dataWidth, long dataHeight, long oldDataOffsetX, long oldDataOffsetY, long oldDataWidth, long oldDataHeight) {
    }

    protected final void offsetAdjustingStarted() {
        ++this.hOffsetAdjustingCounter;
        ++this.vOffsetAdjustingCounter;
        this.pendingDataOffsetX = -1L;
        this.pendingDataOffsetY = -1L;
        this.pendingDataWidth = -1L;
        this.pendingDataHeight = -1L;
    }

    protected final void offsetAdjustingFinished() {
        --this.hOffsetAdjustingCounter;
        --this.vOffsetAdjustingCounter;
        if (!(this.isOffsetAdjusting() || this.pendingDataWidth == -1L && this.pendingDataHeight == -1L)) {
            this.setDataBounds(this.pendingDataOffsetX, this.pendingDataOffsetY, this.pendingDataWidth, this.pendingDataHeight);
        }
    }

    protected final boolean isOffsetAdjusting() {
        return this.isHOffsetAdjusting() || this.isVOffsetAdjusting();
    }

    protected final void hOffsetAdjustingStarted() {
        ++this.hOffsetAdjustingCounter;
        this.pendingDataOffsetX = -1L;
        this.pendingDataOffsetY = -1L;
        this.pendingDataWidth = -1L;
        this.pendingDataHeight = -1L;
    }

    protected final void hOffsetAdjustingFinished() {
        --this.hOffsetAdjustingCounter;
        if (!this.isOffsetAdjusting() && this.pendingDataWidth != -1L) {
            this.setDataBounds(this.pendingDataOffsetX, this.pendingDataOffsetY, this.pendingDataWidth, this.pendingDataHeight);
        }
    }

    protected final boolean isHOffsetAdjusting() {
        return this.hOffsetAdjustingCounter > 0;
    }

    protected final void vOffsetAdjustingStarted() {
        ++this.vOffsetAdjustingCounter;
        this.pendingDataOffsetX = -1L;
        this.pendingDataOffsetY = -1L;
        this.pendingDataWidth = -1L;
        this.pendingDataHeight = -1L;
    }

    protected final void vOffsetAdjustingFinished() {
        --this.vOffsetAdjustingCounter;
        if (!this.isOffsetAdjusting() && this.pendingDataHeight != -1L) {
            this.setDataBounds(this.pendingDataOffsetX, this.pendingDataOffsetY, this.pendingDataWidth, this.pendingDataHeight);
        }
    }

    protected final boolean isVOffsetAdjusting() {
        return this.vOffsetAdjustingCounter > 0;
    }

    protected final double getViewX(double dataX) {
        return this.getViewX(dataX, false);
    }

    protected final double getReversedViewX(double dataX) {
        return this.getViewX(dataX, true);
    }

    private double getViewX(double dataX, boolean reverse) {
        if (this.rightBased && !reverse || !this.rightBased && reverse) {
            return ((double)this.dataOffsetX - dataX) * this.scaleX + (double)this.offsetX + (double)this.getWidth() - (double)this.viewInsets.right;
        }
        return (dataX - (double)this.dataOffsetX) * this.scaleX - (double)this.offsetX + (double)this.viewInsets.left;
    }

    protected final double getViewY(double dataY) {
        return this.getViewY(dataY, false);
    }

    protected final double getReversedViewY(double dataY) {
        return this.getViewY(dataY, true);
    }

    private double getViewY(double dataY, boolean reverse) {
        if (this.bottomBased && !reverse || !this.bottomBased && reverse) {
            return ((double)this.dataOffsetY - dataY) * this.scaleY + (double)this.offsetY + (double)this.getHeight() - (double)this.viewInsets.bottom;
        }
        return (dataY - (double)this.dataOffsetY) * this.scaleY - (double)this.offsetY + (double)this.viewInsets.top;
    }

    protected final double getViewWidth(double dataWidth) {
        return dataWidth * this.scaleX;
    }

    protected final double getViewHeight(double dataHeight) {
        return dataHeight * this.scaleY;
    }

    protected final double getDataX(double viewX) {
        return this.getDataX(viewX, false);
    }

    protected final double getReversedDataX(double viewX) {
        return this.getDataX(viewX, true);
    }

    private double getDataX(double viewX, boolean reverse) {
        if (this.rightBased && !reverse || !this.rightBased && reverse) {
            return (double)this.dataOffsetX - (viewX + (double)this.viewInsets.right - (double)this.offsetX - (double)this.getWidth()) / this.scaleX;
        }
        return (viewX + (double)this.offsetX - (double)this.viewInsets.left) / this.scaleX + (double)this.dataOffsetX;
    }

    protected final double getDataY(double viewY) {
        return this.getDataY(viewY, false);
    }

    protected final double getReversedDataY(double viewY) {
        return this.getDataY(viewY, true);
    }

    private double getDataY(double viewY, boolean reverse) {
        if (this.bottomBased && !reverse || !this.bottomBased && reverse) {
            return (double)this.dataOffsetY - (viewY + (double)this.viewInsets.bottom - (double)this.offsetY - (double)this.getHeight()) / this.scaleY;
        }
        return (viewY + (double)this.offsetY - (double)this.viewInsets.top) / this.scaleY + (double)this.dataOffsetY;
    }

    protected final double getDataWidth(double viewWidth) {
        return viewWidth / this.scaleX;
    }

    protected final double getDataHeight(double viewHeight) {
        return viewHeight / this.scaleY;
    }

    @Override
    boolean isDirty() {
        if (this.translationPending()) {
            return true;
        }
        return super.isDirty();
    }

    private boolean translationPending() {
        if (this.lastScaleX != this.scaleX || this.lastScaleY != this.scaleY) {
            return false;
        }
        return this.dx != 0L || this.dy != 0L;
    }

    @Override
    protected void reshaped(Rectangle oldBounds, Rectangle newBounds) {
        super.reshaped(oldBounds, newBounds);
        boolean followsWidth = this.currentlyFollowingDataWidth();
        boolean followsHeight = this.currentlyFollowingDataHeight();
        this.updateScale();
        this.updateContentsWidths();
        this.updateMaxOffsets();
        this.setOffset(followsWidth ? this.maxOffsetX : this.offsetX, followsHeight ? this.maxOffsetY : this.offsetY);
    }

    @Override
    protected final void paintComponent(Graphics g, Rectangle invalidArea) {
        int shiftX = 0;
        int shiftY = 0;
        this.contentsWillBeUpdated(this.offsetX, this.offsetY, this.scaleX, this.scaleY, this.lastOffsetX, this.lastOffsetY, this.lastScaleX, this.lastScaleY);
        if (!this.translationPending()) {
            this.paintContents(g, invalidArea);
        } else {
            int width = this.getWidth();
            int height = this.getHeight();
            if (Math.abs(this.dx) >= (long)width || Math.abs(this.dy) >= (long)height) {
                this.paintContents(g, new Rectangle(0, 0, width, height));
            } else {
                int idx = this.rightBased ? -((int)this.dx) : (int)this.dx;
                int idy = this.bottomBased ? -((int)this.dy) : (int)this.dy;
                int total = width * height;
                int shiftedSaved = (width - Math.abs(idx)) * (height - Math.abs(idy));
                if (idx != 0 && idy != 0 && (float)shiftedSaved < (float)total * 0.3f) {
                    this.paintContents(g, new Rectangle(0, 0, width, height));
                } else {
                    Rectangle viewport = new Rectangle(idx, idy, width, height);
                    Rectangle savedRect = viewport.intersection(new Rectangle(0, 0, width, height));
                    Rectangle invalidRect = invalidArea.intersection(savedRect);
                    int invalidAfterShift = invalidRect.isEmpty() ? 0 : invalidRect.width * invalidRect.height;
                    int savedTotal = shiftedSaved - invalidAfterShift;
                    if ((float)savedTotal < (float)total * 0.15f) {
                        this.paintContents(g, new Rectangle(0, 0, width, height));
                    } else {
                        this.shift(g, idx, idy, width, height);
                        if (invalidAfterShift != 0) {
                            this.paintContents(g, invalidRect);
                        }
                        shiftX = idx;
                        shiftY = idy;
                    }
                }
            }
        }
        this.contentsUpdated(this.offsetX, this.offsetY, this.scaleX, this.scaleY, this.lastOffsetX, this.lastOffsetY, this.lastScaleX, this.lastScaleY, shiftX, shiftY);
        this.dx = 0L;
        this.dy = 0L;
        this.lastOffsetX = this.offsetX;
        this.lastOffsetY = this.offsetY;
        this.lastScaleX = this.scaleX;
        this.lastScaleY = this.scaleY;
    }

    private void shift(Graphics g, int idx, int idy, int width, int height) {
        Rectangle areaToRepaint = new Rectangle();
        if (idx == 0) {
            if (idy > 0) {
                g.copyArea(0, 0, width, height - idy, 0, idy);
                areaToRepaint.setBounds(0, 0, width, idy);
            } else {
                g.copyArea(0, -idy, width, height + idy, 0, idy);
                areaToRepaint.setBounds(0, height + idy, width, -idy);
            }
        } else if (idy == 0) {
            if (idx > 0) {
                g.copyArea(0, 0, width - idx, height, idx, 0);
                areaToRepaint.setBounds(0, 0, idx, height);
            } else {
                g.copyArea(-idx, 0, width + idx, height, idx, 0);
                areaToRepaint.setBounds(width + idx, 0, -idx, height);
            }
        } else if (idx > 0) {
            if (idy > 0) {
                g.copyArea(0, 0, width - idx, height - idy, idx, idy);
                areaToRepaint.setBounds(0, 0, width, idy);
                this.paintContents(g, areaToRepaint);
                areaToRepaint.setBounds(0, idy, idx, height - idy);
            } else {
                g.copyArea(0, -idy, width - idx, height + idy, idx, idy);
                areaToRepaint.setBounds(0, height + idy, width, -idy);
                this.paintContents(g, areaToRepaint);
                areaToRepaint.setBounds(0, 0, idx, height + idy);
            }
        } else if (idy > 0) {
            g.copyArea(-idx, 0, width + idx, height - idy, idx, idy);
            areaToRepaint.setBounds(0, 0, width, idy);
            this.paintContents(g, areaToRepaint);
            areaToRepaint.setBounds(width + idx, idy, -idx, height - idy);
        } else {
            g.copyArea(-idx, -idy, width + idx, height + idy, idx, idy);
            areaToRepaint.setBounds(0, height + idy, width, -idy);
            this.paintContents(g, areaToRepaint);
            areaToRepaint.setBounds(width + idx, 0, -idx, height + idy);
        }
        this.paintContents(g, areaToRepaint);
    }

    private void updateScale() {
        if (!this.fitsWidth && !this.fitsHeight) {
            return;
        }
        double newScaleX = this.fitsWidth ? (double)(this.getWidth() - this.viewInsets.left - this.viewInsets.right) / (double)this.dataWidth : this.scaleX;
        double newScaleY = this.fitsHeight ? (double)(this.getHeight() - this.viewInsets.top - this.viewInsets.bottom) / (double)this.dataHeight : this.scaleY;
        this.setScale(newScaleX, newScaleY);
    }

    private void updateContentsWidths() {
        this.contentsWidth = this.fitsWidth ? (long)this.getWidth() : (long)Math.floor(this.getViewWidth(this.dataWidth)) + (long)this.viewInsets.left + (long)this.viewInsets.right;
        this.contentsHeight = this.fitsHeight ? (long)this.getHeight() : (long)Math.floor(this.getViewHeight(this.dataHeight)) + (long)this.viewInsets.top + (long)this.viewInsets.bottom;
    }

    private void updateMaxOffsets() {
        int width = this.getWidth();
        int height = this.getHeight();
        this.maxOffsetX = width == 0 ? 0L : Math.max(this.contentsWidth - (long)width, 0L);
        this.maxOffsetY = height == 0 ? 0L : Math.max(this.contentsHeight - (long)height, 0L);
    }
}

