/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.insane.model.ObjectSet;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class InsaneConverter {
    private File from;
    private File to;
    private Map<String, ClassInfo> classInfo = new LinkedHashMap<String, ClassInfo>();
    private Map<String, RefInfo> refInfo = new LinkedHashMap<String, RefInfo>();
    private ObjectSet instanceInfo = new ObjectSet();
    private int refsOffset;
    private int objsOffset;
    private int totalOffset;
    boolean prescan = true;
    MappedByteBuffer store;
    private static Object[] EMPTY = new Object[0];

    private InsaneConverter(File from, File to) {
        this.from = from;
        this.to = to;
    }

    ByteBuffer getByteBuffer(int offset) {
        if (offset < 12) {
            throw new IllegalArgumentException("bad offset " + offset);
        }
        return ((ByteBuffer)this.store.duplicate().position(offset)).slice();
    }

    private ClassInfo getClassInfo(String className) {
        ClassInfo ret = this.classInfo.get(className);
        if (ret == null) {
            ret = new ClassInfo(className);
            this.classInfo.put(className, ret);
        }
        return ret;
    }

    void createInstanceInfo(String strId, String type, int size, String val) {
        InstanceInfo template = new InstanceInfo(strId);
        InstanceInfo ii = (InstanceInfo)this.instanceInfo.get(template);
        if (ii == null) {
            if (!this.prescan) {
                throw new IllegalArgumentException("Unknown element during second pass:" + strId);
            }
            ii = template;
            this.instanceInfo.put(ii);
        }
        ClassInfo cls = this.getClassInfo(type);
        ii.process(this, cls, size);
        cls.register(ii);
    }

    InstanceInfo getInstance(String strId) {
        InstanceInfo template = new InstanceInfo(strId);
        return (InstanceInfo)this.instanceInfo.get(template);
    }

    void registerReference(String type, String fromId, String toId) {
        InstanceInfo from = fromId == null ? null : this.getInstance(fromId);
        InstanceInfo to = this.getInstance(toId);
        RefInfo ref = this.refInfo.get(type);
        if (ref == null) {
            ref = from == null ? new RefInfo(type, to) : new RefInfo(type, null);
            this.refInfo.put(type, ref);
        }
        if (from != null) {
            from.registerOutgoingReference(this, ref, to);
        }
        to.registerIncommingReference(this, ref, from);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws Exception {
        FileInputStream fis = new FileInputStream(this.from);
        try {
            this.parse(fis);
        }
        finally {
            fis.close();
        }
        this.compute();
        RandomAccessFile raf = new RandomAccessFile(this.to, "rw");
        this.store = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.totalOffset);
        raf.close();
        this.storeHeaders();
        this.prescan = false;
        fis = new FileInputStream(this.from);
        try {
            this.parse(fis);
        }
        finally {
            fis.close();
        }
        this.store.force();
    }

    private void compute() {
        int currentOffset = 12;
        for (ClassInfo classInfo : this.classInfo.values()) {
            currentOffset = classInfo.computeNextOffset(currentOffset);
        }
        this.refsOffset = currentOffset;
        for (RefInfo refInfo : this.refInfo.values()) {
            currentOffset = refInfo.computeNextOffset(currentOffset);
        }
        this.objsOffset = currentOffset;
        Iterator<Object> it = this.instanceInfo.iterator();
        while (it.hasNext()) {
            InstanceInfo instanceInfo = (InstanceInfo)it.next();
            currentOffset = instanceInfo.computeNextOffset(currentOffset);
        }
        this.totalOffset = currentOffset;
    }

    private void storeHeaders() throws IOException {
        this.store.put("SBIH".getBytes());
        this.store.putInt(this.refsOffset);
        this.store.putInt(this.objsOffset);
        for (ClassInfo classInfo : this.classInfo.values()) {
            classInfo.storeHeader();
        }
        for (RefInfo refInfo : this.refInfo.values()) {
            refInfo.storeHeader();
        }
    }

    private static void storeString(ByteBuffer buff, String str) {
        byte[] data = str.getBytes();
        buff.putInt(data.length);
        buff.put(data);
    }

    private static int computeStringSize(String str) {
        return 4 + str.getBytes().length;
    }

    private void parse(InputStream source) throws Exception {
        class Handler
        extends DefaultHandler {
            private int depth = 0;

            Handler() {
            }

            public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                if (this.depth == 0) {
                    if (!"insane".equals(qName)) {
                        throw new SAXException("format");
                    }
                } else {
                    if (this.depth != 1) {
                        throw new SAXException("format");
                    }
                    if ("object".equals(qName)) {
                        String id = atts.getValue("id");
                        String type = atts.getValue("type");
                        String size = atts.getValue("size");
                        String val = atts.getValue("value");
                        InsaneConverter.this.createInstanceInfo(id, type, Integer.parseInt(size), val);
                    } else if ("ref".equals(qName)) {
                        String from = atts.getValue("from");
                        String name = atts.getValue("name");
                        String to = atts.getValue("to");
                        InsaneConverter.this.registerReference(name, from, to);
                    } else {
                        throw new SAXException("format");
                    }
                }
                ++this.depth;
            }

            public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
                --this.depth;
            }
        }
        Handler h = new Handler();
        SAXParserFactory fact = SAXParserFactory.newInstance();
        SAXParser parser = fact.newSAXParser();
        parser.getXMLReader().setContentHandler(h);
        parser.getXMLReader().parse(new InputSource(source));
    }

    public static void convert(File from, File to) throws Exception {
        InsaneConverter conv = new InsaneConverter(from, to);
        conv.process();
    }

    private class RefInfo {
        int offset;
        String refName;
        InstanceInfo instance;

        RefInfo(String name, InstanceInfo inst) {
            this.refName = name;
            this.instance = inst;
        }

        int computeNextOffset(int currentOffset) {
            this.offset = currentOffset;
            return currentOffset + InsaneConverter.computeStringSize(this.refName) + 4;
        }

        void storeHeader() throws IOException {
            ByteBuffer buff = InsaneConverter.this.getByteBuffer(this.offset);
            InsaneConverter.storeString(buff, this.refName);
            if (this.instance == null) {
                buff.putInt(-1);
            } else {
                this.instance.storeOffset(buff);
            }
        }

        void storeOffset(ByteBuffer buff) {
            buff.putInt(this.offset);
        }
    }

    private static class InstanceInfo {
        private int id1;
        private int offset;
        private int incommingCountOrPtr;
        private int outgoingCountOrPtr;

        InstanceInfo(String str) {
            this.id1 = Integer.parseInt(str, 16);
        }

        void process(InsaneConverter converter, ClassInfo type, int size) {
            if (!converter.prescan) {
                ByteBuffer buff = converter.getByteBuffer(this.offset);
                type.storeOffset(buff);
                buff.putInt(size);
                buff.putInt(this.outgoingCountOrPtr);
                buff.putInt(this.incommingCountOrPtr);
                int outCount = this.outgoingCountOrPtr;
                this.outgoingCountOrPtr = this.offset + buff.position();
                this.incommingCountOrPtr = this.outgoingCountOrPtr + 8 * outCount;
            }
        }

        void registerIncommingReference(InsaneConverter converter, RefInfo ref, InstanceInfo inst) {
            this.incommingCountOrPtr = this.registerReference(converter, this.incommingCountOrPtr, ref, inst);
        }

        void registerOutgoingReference(InsaneConverter converter, RefInfo ref, InstanceInfo inst) {
            this.outgoingCountOrPtr = this.registerReference(converter, this.outgoingCountOrPtr, ref, inst);
        }

        private int registerReference(InsaneConverter converter, int ptr, RefInfo ref, InstanceInfo inst) {
            if (converter.prescan) {
                return ptr + 1;
            }
            ByteBuffer buff = converter.getByteBuffer(ptr);
            ref.storeOffset(buff);
            if (inst == null) {
                buff.putInt(0);
            } else {
                inst.storeOffset(buff);
            }
            return ptr + 8;
        }

        int computeNextOffset(int currentOffset) {
            this.offset = currentOffset;
            return currentOffset + 4 + 4 + 4 + 4 + 8 * this.outgoingCountOrPtr + 8 * this.incommingCountOrPtr;
        }

        void storeOffset(ByteBuffer buff) {
            buff.putInt(this.offset);
        }

        public boolean equals(Object o) {
            if (o instanceof InstanceInfo) {
                return this.id1 == ((InstanceInfo)o).id1;
            }
            return false;
        }

        public int hashCode() {
            return 61315 * this.id1;
        }
    }

    private class ClassInfo {
        String className;
        int offset;
        int countOrOffset;

        ClassInfo(String className) {
            this.className = className;
        }

        void register(InstanceInfo inst) {
            if (InsaneConverter.this.prescan) {
                ++this.countOrOffset;
            } else {
                ByteBuffer buff = InsaneConverter.this.getByteBuffer(this.countOrOffset);
                inst.storeOffset(buff);
                this.countOrOffset += 4;
            }
        }

        int computeNextOffset(int currentOffset) {
            this.offset = currentOffset;
            return currentOffset + InsaneConverter.computeStringSize(this.className) + 4 + 4 * this.countOrOffset;
        }

        void storeHeader() {
            ByteBuffer buff = InsaneConverter.this.getByteBuffer(this.offset);
            InsaneConverter.storeString(buff, this.className);
            buff.putInt(this.countOrOffset);
            this.countOrOffset = buff.position() + this.offset;
        }

        void storeOffset(ByteBuffer buff) {
            buff.putInt(this.offset);
        }
    }
}

