/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.impl;

import java.lang.reflect.Field;
import java.util.Arrays;

public abstract class Root {
    private Root() {
    }

    public abstract String describe();

    public abstract Object getObject();

    public static Root createNamed(String name, Object ref) {
        return new Named(name, ref);
    }

    public static Root createStatic(Field f, Object ref) {
        return new Static(f, ref);
    }

    private static class Static
    extends Root {
        private Class cls;
        private int i;

        Static(Field f, Object ref) {
            assert ((f.getModifiers() & 8) != 0);
            this.cls = f.getDeclaringClass();
            this.i = Arrays.asList(this.cls.getDeclaredFields()).indexOf(f);
            assert (this.i >= 0);
            assert (this.cls.getDeclaredFields()[this.i].equals(f));
        }

        public String describe() {
            return this.getField().toString();
        }

        public Object getObject() {
            try {
                return this.getField().get(null);
            }
            catch (Exception e) {
                return null;
            }
        }

        private Field getField() {
            return this.cls.getDeclaredFields()[this.i];
        }
    }

    private static class Named
    extends Root {
        private String name;
        private Object ref;

        Named(String name, Object ref) {
            if (ref == null) {
                new Exception().printStackTrace();
            }
            this.ref = ref;
            this.name = name;
        }

        public Object getObject() {
            return this.ref;
        }

        public String describe() {
            return this.name;
        }
    }
}

