/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.presenters.webkit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

final class UnJarResources {
    UnJarResources() {
    }

    static URL extract(URL url) throws IOException {
        if (!"jar".equals(url.getProtocol())) {
            return url;
        }
        JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
        JarFile jar = jarConnection.getJarFile();
        if (jar == null) {
            return url;
        }
        File dir = Files.createTempDirectory(jar.getName() + ".dir", new FileAttribute[0]).toFile();
        Enumeration<JarEntry> en = jar.entries();
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            String entryName = entry.getName();
            if (entryName.endsWith(".class") || entryName.endsWith("/")) continue;
            File file = new File(dir, entryName.replace('/', File.separatorChar));
            file.getParentFile().mkdirs();
            InputStream is = jar.getInputStream(entry);
            try {
                Files.copy(is, file.toPath(), new CopyOption[0]);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        File file = new File(dir, jarConnection.getEntryName().replace('/', File.separatorChar));
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return url;
    }
}

