/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.presenters.render;

import com.sun.jna.Callback;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.io.Closeable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.netbeans.html.boot.spi.Fn;
import org.netbeans.html.presenters.render.JSC;
import org.netbeans.html.presenters.render.Show;

final class Cocoa
extends Show
implements Callback {
    private final Fn.Presenter presenter;
    private final Runnable onPageLoad;
    private final Runnable onContext;
    private final JSC jsc;
    private static final Queue<Runnable> QUEUE = new ConcurrentLinkedQueue<Runnable>();
    private static Pointer NSApp;
    private static Pointer appDelPtr;
    private static Pointer doMainSelector;
    private static Thread dispatchThread;
    private AppDidStart appDidStart;
    private Ready ready;
    private ContextCreated contextCreated;
    private UIDelegate ui;
    private DialogHandler[] dialogs;
    private Pointer jsContext;
    private String page;
    private Pointer webView;
    private Pointer mainWindow;

    Cocoa() {
        this(null, null, null, false);
    }

    Cocoa(Fn.Presenter p, Runnable onPageLoad, Runnable onContext, boolean hl) {
        this.presenter = p;
        this.onPageLoad = onPageLoad;
        this.onContext = onContext;
        this.jsc = (JSC)Native.loadLibrary((String)"JavaScriptCore", JSC.class, Collections.singletonMap("allow-objects", true));
    }

    @Override
    public JSC jsc() {
        return this.jsc;
    }

    @Override
    public Pointer jsContext() {
        return this.jsContext;
    }

    @Override
    public void show(URI page) {
        this.page = page.toASCIIString();
        Cocoa.ensureHttpAccess(page);
        Native.loadLibrary((String)"WebKit", WebKit.class);
        this.appDidStart = new AppDidStart();
        this.contextCreated = new ContextCreated();
        this.ready = new Ready();
        this.ui = new UIDelegate();
        this.dialogs = new DialogHandler[3];
        this.dialogs[0] = new DialogHandler(0);
        this.dialogs[1] = new DialogHandler(1);
        this.dialogs[2] = new DialogHandler(2);
        if (appDelPtr == null) {
            ObjC objC = ObjC.INSTANCE;
            Pointer appDelClass = objC.objc_allocateClassPair(objC.objc_getClass("NSObject"), "AppDelegate", 0);
            objC.class_addMethod(appDelClass, objC.sel_getUid("applicationDidFinishLaunching:"), this.appDidStart, "i@:@");
            doMainSelector = objC.sel_getUid("doMain");
            Native.setCallbackThreadInitializer((Callback)this, (CallbackThreadInitializer)new CallbackThreadInitializer(false, false, "Cocoa Dispatch Thread"));
            objC.class_addMethod(appDelClass, doMainSelector, this, "i@");
            objC.class_addMethod(appDelClass, objC.sel_getUid("webView:didCreateJavaScriptContext:forFrame:"), this.contextCreated, "v@:@:@");
            objC.class_addMethod(appDelClass, objC.sel_getUid("webView:didFinishLoadForFrame:"), this.ready, "v@:@");
            objC.class_addMethod(appDelClass, objC.sel_getUid("webView:createWebViewWithRequest:"), this.ui, "v@:@");
            objC.class_addMethod(appDelClass, objC.sel_getUid("webView:runJavaScriptAlertPanelWithMessage:initiatedByFrame:"), this.dialogs[0], "v@:@:@");
            objC.class_addMethod(appDelClass, objC.sel_getUid("webView:runJavaScriptConfirmPanelWithMessage:initiatedByFrame:"), this.dialogs[1], "v@:@:@");
            objC.class_addMethod(appDelClass, objC.sel_getUid("webView:runJavaScriptTextInputPanelWithPrompt:defaultText:initiatedByFrame:"), this.dialogs[2], "v@:@:@");
            objC.objc_registerClassPair(appDelClass);
            long appDelObj = Cocoa.send(objC.objc_getClass("AppDelegate"), "alloc", new Object[0]);
            appDelPtr = new Pointer(appDelObj);
            Cocoa.send(appDelPtr, "init", new Object[0]);
            Cocoa.send(appDelPtr, "performSelectorOnMainThread:withObject:waitUntilDone:", doMainSelector, null, 1);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    Cocoa.this.appDidStart.callback(appDelPtr);
                }
            });
        }
    }

    @Override
    public void execute(Runnable command) {
        QUEUE.add(command);
        if (Thread.currentThread() == dispatchThread && Fn.activePresenter() == this.presenter) {
            try {
                this.process();
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Cannot process " + command, ex);
            }
        } else {
            Cocoa.send(appDelPtr, "performSelectorOnMainThread:withObject:waitUntilDone:", doMainSelector, null, 0);
        }
    }

    private void process() throws Exception {
        try (Closeable c = this.presenter == null ? null : Fn.activate((Fn.Presenter)this.presenter);){
            Runnable r;
            while ((r = QUEUE.poll()) != null) {
                r.run();
            }
        }
    }

    static long send(Pointer obj, String selector, Object ... args) {
        Pointer uid = ObjC.INSTANCE.sel_getUid(selector);
        return ObjC.INSTANCE.objc_msgSend(obj, uid, args);
    }

    public void callback(Pointer self) throws Exception {
        if (NSApp != null) {
            this.process();
            return;
        }
        ObjC objC = ObjC.INSTANCE;
        long res = Cocoa.send(objC.objc_getClass("NSApplication"), "sharedApplication", new Object[0]);
        if (res == 0L) {
            System.err.print("Failed to initialized NSApplication...  terminating...\n");
            System.exit(1);
        }
        dispatchThread = Thread.currentThread();
        NSApp = new Pointer(res);
        Cocoa.send(NSApp, "setActivationPolicy:", 0);
        Cocoa.send(NSApp, "setDelegate:", self);
        res = Cocoa.send(NSApp, "run", new Object[0]);
        System.err.println("end res: " + res);
    }

    static Pointer nsString(String bd) {
        ObjC objC = ObjC.INSTANCE;
        Pointer stringClass = objC.objc_getClass("NSString");
        Pointer browserDemo = new Pointer(Cocoa.send(stringClass, "stringWithCString:encoding:", bd, 4));
        return browserDemo;
    }

    private static void ensureHttpAccess(URI page) {
        if (!"http".equals(page.getScheme())) {
            return;
        }
        ObjC objC = ObjC.INSTANCE;
        Pointer nsBundle = objC.objc_getClass("NSBundle");
        Pointer nsNumber = objC.objc_getClass("NSNumber");
        Pointer nsDictionary = objC.objc_getClass("NSMutableDictionary");
        Pointer mainBundle = new Pointer(Cocoa.send(nsBundle, "mainBundle", new Object[0]));
        Pointer info = new Pointer(Cocoa.send(mainBundle, "infoDictionary", new Object[0]));
        Pointer nsAppTransportSecurity = Cocoa.nsString("NSAppTransportSecurity");
        Pointer nsAllowArbitraryLoads = Cocoa.nsString("NSAllowsArbitraryLoads");
        long nsTrue = Cocoa.send(nsNumber, "numberWithBool:", 1);
        long rawDict = Cocoa.send(info, "objectForKey:", nsAppTransportSecurity);
        if (rawDict == 0L) {
            Pointer dict = new Pointer(Cocoa.send(nsDictionary, "dictionaryWithCapacity:", 1));
            Cocoa.send(info, "setValue:forKey:", dict, nsAppTransportSecurity);
            Cocoa.send(dict, "setObject:forKey:", nsTrue, nsAllowArbitraryLoads);
        }
    }

    public final class AppDidStart
    implements Callback {
        AppDidStart() {
        }

        public long callback(Pointer self) {
            ObjC objC = ObjC.INSTANCE;
            Cocoa.this.mainWindow = new Pointer(Cocoa.send(objC.objc_getClass("NSWindow"), "alloc", new Object[0]));
            Pointer screen = new Pointer(Cocoa.send(objC.objc_getClass("NSScreen"), "mainScreen", new Object[0]));
            Pointer uid = ObjC.INSTANCE.sel_getUid("frame");
            Rct size = ObjC.INSTANCE.objc_msgSend_stret(screen, uid, new Object[0]);
            double height = size.height.doubleValue() * 0.9;
            double width = size.width.doubleValue() * 0.9;
            double x = size.width.doubleValue() * 0.05 + size.x.doubleValue();
            double y = size.height.doubleValue() * 0.05 + size.y.doubleValue();
            Rct r = new Rct(x, y, width, height);
            int mode = 15;
            int backingstoreBuffered = 2;
            Cocoa.send(Cocoa.this.mainWindow, "initWithContentRect:styleMask:backing:defer:", new Object[]{r, mode, backingstoreBuffered, false});
            Cocoa.send(Cocoa.this.mainWindow, "setTitle:", Cocoa.nsString("Browser demo"));
            Pointer webViewClass = objC.objc_getClass("WebView");
            long webViewId = Cocoa.send(webViewClass, "alloc", new Object[0]);
            Cocoa.this.webView = new Pointer(webViewId);
            Cocoa.send(Cocoa.this.webView, "init", new Object[0]);
            Cocoa.send(Cocoa.this.webView, "setFrameLoadDelegate:", self);
            Cocoa.send(Cocoa.this.webView, "setUIDelegate:", self);
            Pointer frame = new Pointer(Cocoa.send(Cocoa.this.webView, "mainFrame", new Object[0]));
            Pointer urlClass = objC.objc_getClass("NSURL");
            Pointer url = new Pointer(Cocoa.send(urlClass, "URLWithString:", Cocoa.nsString(Cocoa.this.page)));
            Pointer requestClass = objC.objc_getClass("NSURLRequest");
            Pointer request = new Pointer(Cocoa.send(requestClass, "alloc", new Object[0]));
            Cocoa.send(request, "initWithURL:", url);
            Cocoa.send(Cocoa.this.mainWindow, "setContentView:", Cocoa.this.webView);
            Cocoa.send(frame, "loadRequest:", request);
            Cocoa.send(Cocoa.this.mainWindow, "becomeFirstResponder", new Object[0]);
            Cocoa.send(Cocoa.this.mainWindow, "makeKeyAndOrderFront:", NSApp);
            return 1L;
        }
    }

    public static interface WebKit
    extends Library {
    }

    public final class ContextCreated
    implements Callback {
        ContextCreated() {
        }

        public void callback(Pointer webView, Pointer ctx, Pointer frame) {
            frame = new Pointer(Cocoa.send(frame, "mainFrame", new Object[0]));
            ctx = new Pointer(Cocoa.send(frame, "globalContext", new Object[0]));
            Cocoa.this.jsContext = ctx;
            if (Cocoa.this.onContext != null) {
                Cocoa.this.onContext.run();
            }
        }
    }

    public final class Ready
    implements Callback {
        Ready() {
        }

        public void callback(Pointer p1, Pointer frame) {
            Cocoa.send(Cocoa.this.webView, "stringByEvaluatingJavaScriptFromString:", Cocoa.nsString("1 + 1"));
            if (Cocoa.this.onPageLoad != null) {
                Cocoa.this.onPageLoad.run();
            }
        }
    }

    public final class UIDelegate
    implements Callback {
        UIDelegate() {
        }

        public Pointer callback(Pointer appDelegate) {
            ObjC objC = ObjC.INSTANCE;
            Pointer uid = ObjC.INSTANCE.sel_getUid("frame");
            Rct size = ObjC.INSTANCE.objc_msgSend_stret(Cocoa.this.mainWindow, uid, new Object[0]);
            double height = size.height.doubleValue() * 0.9;
            double width = size.width.doubleValue() * 0.9;
            double x = size.width.doubleValue() * 0.05 + size.x.doubleValue();
            double y = size.height.doubleValue() * 0.05 + size.y.doubleValue();
            Pointer window = new Pointer(Cocoa.send(objC.objc_getClass("NSWindow"), "alloc", new Object[0]));
            Rct r = new Rct(x, y, width, height);
            int mode = 15;
            int backingstoreBuffered = 2;
            Cocoa.send(window, "initWithContentRect:styleMask:backing:defer:", new Object[]{r, mode, backingstoreBuffered, false});
            Cocoa.send(window, "setTitle:", Cocoa.nsString("Browser demo"));
            Pointer webViewClass = objC.objc_getClass("WebView");
            long webViewId = Cocoa.send(webViewClass, "alloc", new Object[0]);
            Pointer webView = new Pointer(webViewId);
            Cocoa.send(webView, "init", new Object[0]);
            Cocoa.send(window, "setContentView:", webView);
            Cocoa.send(window, "makeKeyAndOrderFront:", new Object[]{null});
            return webView;
        }
    }

    public final class DialogHandler
    implements Callback {
        private final int type;

        public DialogHandler(int type) {
            this.type = type;
        }

        public boolean alertOrConfirm(Pointer appDelegate, Pointer selector, Pointer webView, Pointer msg, Pointer frame) {
            int res;
            ObjC objC = ObjC.INSTANCE;
            Pointer alert = new Pointer(Cocoa.send(objC.objc_getClass("NSAlert"), "alloc", new Object[0]));
            Cocoa.send(alert, "init", new Object[0]);
            Cocoa.send(alert, "setMessageText:", msg);
            Cocoa.send(alert, "addButtonWithTitle:", Cocoa.nsString("OK"));
            if (this.type == 1) {
                Cocoa.send(alert, "addButtonWithTitle:", Cocoa.nsString("Cancel"));
            }
            return (res = (int)Cocoa.send(alert, "runModal", new Object[0]) & 1) == 0;
        }
    }

    public static interface ObjC
    extends Library {
        public static final ObjC INSTANCE = (ObjC)Native.loadLibrary((String)"objc.A", ObjC.class);

        public boolean class_addMethod(Pointer var1, Pointer var2, Callback var3, String var4);

        public String class_getName(Pointer var1);

        public String object_getClassName(Pointer var1);

        public Pointer class_copyMethodList(Class var1, IntByReference var2);

        public Pointer objc_allocateClassPair(Pointer var1, String var2, int var3);

        public Pointer objc_getClass(String var1);

        public long objc_msgSend(Pointer var1, Pointer var2, Object ... var3);

        public Rct objc_msgSend_stret(Pointer var1, Pointer var2, Object ... var3);

        public void objc_registerClassPair(Pointer var1);

        public Pointer sel_getUid(String var1);
    }

    public static final class Flt
    extends Number
    implements NativeMapped {
        private static final boolean SMALL = Native.LONG_SIZE == 4;
        private final double number;

        public Flt() {
            this(0.0);
        }

        public Flt(double d) {
            this.number = d;
        }

        @Override
        public float floatValue() {
            return (float)this.number;
        }

        @Override
        public double doubleValue() {
            return this.number;
        }

        @Override
        public int intValue() {
            return (int)this.number;
        }

        @Override
        public long longValue() {
            return (long)this.number;
        }

        public Object fromNative(Object o, FromNativeContext fromNativeContext) {
            return new Flt(((Number)o).doubleValue());
        }

        public Object toNative() {
            return SMALL ? (double)this.floatValue() : this.number;
        }

        public Class<?> nativeType() {
            return SMALL ? Float.class : Double.class;
        }

        public String toString() {
            return Double.toString(this.number);
        }
    }

    public static final class Rct
    extends Structure
    implements Structure.ByValue {
        public Flt x;
        public Flt y;
        public Flt width;
        public Flt height;

        public Rct() {
        }

        public Rct(double x, double y, double width, double height) {
            this.x = new Flt(x);
            this.y = new Flt(y);
            this.width = new Flt(width);
            this.height = new Flt(height);
        }

        protected List getFieldOrder() {
            return Arrays.asList("x", "y", "width", "height");
        }
    }
}

