/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.util.List;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import net.java.html.json.tests.Mines;
import net.java.html.json.tests.Row;
import net.java.html.json.tests.Square;
import net.java.html.json.tests.Utils;
import org.netbeans.html.json.tck.KOTest;

public final class MinesTest {
    Mines m;
    private static int randIndex;
    private static int[] RANDOM;

    @KOTest
    public void paintTheGridOnClick() throws Throwable {
        int cnt;
        if (this.m == null) {
            BrwsrCtx ctx = Utils.newContext(MinesTest.class);
            Object exp = Utils.exposeHTML(MinesTest.class, "    <button id='init' data-bind='click: normalSize'></button>\n    <table>\n        <tbody id='table'>\n            <!-- ko foreach: rows -->\n            <tr>\n                <!-- ko foreach: columns -->\n                <td data-bind='css: style' >\n                    <div data-bind='text: html'></div>\n                </td>\n                <!-- /ko -->\n            </tr>\n            <!-- /ko -->\n        </tbody>\n    </table>\n");
            this.m = (Mines)Models.bind((Object)new Mines(), (BrwsrCtx)ctx);
            this.m.applyBindings();
            int cnt2 = Utils.countChildren(MinesTest.class, "table");
            Utils.assertEquals(cnt2, 0, "Table is empty: " + cnt2);
            Utils.scheduleClick(MinesTest.class, "init", 100);
        }
        if ((cnt = Utils.countChildren(MinesTest.class, "table")) == 0) {
            throw new InterruptedException();
        }
        Utils.assertEquals(cnt, 10, "There is ten rows in the table now: " + cnt);
        Utils.exposeHTML(MinesTest.class, "");
    }

    @KOTest
    public void countAround() throws Exception {
        Mines mines = new Mines();
        mines.init(5, 5, 0);
        mines.getRows().get(0).getColumns().get(0).setMine(true);
        mines.getRows().get(1).getColumns().get(0).setMine(true);
        mines.getRows().get(0).getColumns().get(1).setMine(true);
        int cnt = MinesTest.around(mines, 1, 1);
        Utils.assertEquals(cnt, 3, "There are three mines around. Was: " + cnt);
    }

    static boolean fieldShowing(GameState state) {
        return state != null;
    }

    static void normalSize(Mines m) {
        m.init(10, 10, 10);
    }

    private static int random() {
        return RANDOM[randIndex++ % RANDOM.length];
    }

    static void init(Mines model, int width, int height, int mines) {
        List rows = Models.asList((Object[])new Row[0]);
        for (int y = 0; y < height; ++y) {
            Square[] columns = new Square[width];
            for (int x = 0; x < width; ++x) {
                columns[x] = new Square(SquareType.UNKNOWN, false);
            }
            rows.add(new Row(columns));
        }
        while (mines > 0) {
            int x = MinesTest.random() % width;
            int y = MinesTest.random() % height;
            Square s = ((Row)rows.get(y)).getColumns().get(x);
            if (s.isMine()) continue;
            s.setMine(true);
            --mines;
        }
        model.setState(GameState.IN_PROGRESS);
        model.getRows().clear();
        model.getRows().addAll(rows);
    }

    static void computeMines(Mines model) {
        Square sq;
        int x;
        int y;
        List xBombs = Models.asList((Object[])new Integer[0]);
        List yBombs = Models.asList((Object[])new Integer[0]);
        List<Row> rows = model.getRows();
        boolean emptyHidden = false;
        SquareType[][] arr = new SquareType[rows.size()][];
        for (y = 0; y < rows.size(); ++y) {
            List<Square> columns = rows.get(y).getColumns();
            arr[y] = new SquareType[columns.size()];
            for (x = 0; x < columns.size(); ++x) {
                sq = columns.get(x);
                if (sq.isMine()) {
                    xBombs.add(x);
                    yBombs.add(y);
                }
                if (sq.getState().isVisible()) {
                    arr[y][x] = SquareType.N_0;
                    continue;
                }
                if (sq.isMine()) continue;
                emptyHidden = true;
            }
        }
        for (int i = 0; i < xBombs.size(); ++i) {
            int x2 = (Integer)xBombs.get(i);
            int y2 = (Integer)yBombs.get(i);
            MinesTest.incrementAround(arr, x2, y2);
        }
        for (y = 0; y < rows.size(); ++y) {
            List<Square> columns = rows.get(y).getColumns();
            for (x = 0; x < columns.size(); ++x) {
                sq = columns.get(x);
                SquareType newState = arr[y][x];
                if (newState == null || newState == sq.getState()) continue;
                sq.setState(newState);
            }
        }
        if (!emptyHidden) {
            model.setState(GameState.WON);
            MinesTest.showAllBombs(model, SquareType.DISCOVERED);
        }
    }

    private static void incrementAround(SquareType[][] arr, int x, int y) {
        MinesTest.incrementAt(arr, x - 1, y - 1);
        MinesTest.incrementAt(arr, x - 1, y);
        MinesTest.incrementAt(arr, x - 1, y + 1);
        MinesTest.incrementAt(arr, x + 1, y - 1);
        MinesTest.incrementAt(arr, x + 1, y);
        MinesTest.incrementAt(arr, x + 1, y + 1);
        MinesTest.incrementAt(arr, x, y - 1);
        MinesTest.incrementAt(arr, x, y + 1);
    }

    private static void incrementAt(SquareType[][] arr, int x, int y) {
        if (y >= 0 && y < arr.length) {
            SquareType sq;
            SquareType[] r = arr[y];
            if (x >= 0 && x < r.length && (sq = r[x]) != null) {
                r[x] = sq.moreBombsAround();
            }
        }
    }

    static void showAllBombs(Mines model, SquareType state) {
        for (Row row : model.getRows()) {
            for (Square square : row.getColumns()) {
                if (!square.isMine()) continue;
                square.setState(state);
            }
        }
    }

    private static void expandKnown(Mines model, Square data) {
        List<Row> rows = model.getRows();
        for (int y = 0; y < rows.size(); ++y) {
            List<Square> columns = rows.get(y).getColumns();
            for (int x = 0; x < columns.size(); ++x) {
                Square sq = columns.get(x);
                if (sq != data) continue;
                MinesTest.expandKnown(model, x, y);
                return;
            }
        }
    }

    private static void expandKnown(Mines model, int x, int y) {
        if (y < 0 || y >= model.getRows().size()) {
            return;
        }
        List<Square> columns = model.getRows().get(y).getColumns();
        if (x < 0 || x >= columns.size()) {
            return;
        }
        Square sq = columns.get(x);
        if (sq.getState() == SquareType.UNKNOWN) {
            int around = MinesTest.around(model, x, y);
            SquareType t = SquareType.valueOf("N_" + around);
            sq.setState(t);
            if (sq.getState() == SquareType.N_0) {
                MinesTest.expandKnown(model, x - 1, y - 1);
                MinesTest.expandKnown(model, x - 1, y);
                MinesTest.expandKnown(model, x - 1, y + 1);
                MinesTest.expandKnown(model, x, y - 1);
                MinesTest.expandKnown(model, x, y + 1);
                MinesTest.expandKnown(model, x + 1, y - 1);
                MinesTest.expandKnown(model, x + 1, y);
                MinesTest.expandKnown(model, x + 1, y + 1);
            }
        }
    }

    private static int around(Mines model, int x, int y) {
        return MinesTest.minesAt(model, x - 1, y - 1) + MinesTest.minesAt(model, x - 1, y) + MinesTest.minesAt(model, x - 1, y + 1) + MinesTest.minesAt(model, x, y - 1) + MinesTest.minesAt(model, x, y + 1) + MinesTest.minesAt(model, x + 1, y - 1) + MinesTest.minesAt(model, x + 1, y) + MinesTest.minesAt(model, x + 1, y + 1);
    }

    private static int minesAt(Mines model, int x, int y) {
        if (y < 0 || y >= model.getRows().size()) {
            return 0;
        }
        List<Square> columns = model.getRows().get(y).getColumns();
        if (x < 0 || x >= columns.size()) {
            return 0;
        }
        Square sq = columns.get(x);
        return sq.isMine() ? 1 : 0;
    }

    static {
        RANDOM = new int[]{4, 5, 8, 1, 3, 9, 2, 7, 7, 3, 8, 5, 4, 0, 2, 7, 5, 3, 2, 9, 8, 8, 5, 3, 5, 8, 1, 5};
    }

    static enum SquareType {
        N_0,
        N_1,
        N_2,
        N_3,
        N_4,
        N_5,
        N_6,
        N_7,
        N_8,
        UNKNOWN,
        EXPLOSION,
        DISCOVERED;


        final boolean isVisible() {
            return this.name().startsWith("N_");
        }

        final SquareType moreBombsAround() {
            switch (this) {
                case EXPLOSION: 
                case UNKNOWN: 
                case DISCOVERED: 
                case N_8: {
                    return this;
                }
            }
            return SquareType.values()[this.ordinal() + 1];
        }
    }

    static enum GameState {
        IN_PROGRESS,
        WON,
        LOST;

    }

    static class SquareModel {
        SquareModel() {
        }

        static String html(SquareType state) {
            if (state == null) {
                return "&nbsp;";
            }
            switch (state) {
                case EXPLOSION: {
                    return "&#x2717;";
                }
                case UNKNOWN: {
                    return "&nbsp;";
                }
                case DISCOVERED: {
                    return "&#x2714;";
                }
                case N_0: {
                    return "&nbsp;";
                }
            }
            return "&#x278" + (state.ordinal() - 1);
        }

        static String style(SquareType state) {
            return state == null ? null : state.toString();
        }
    }

    static class RowModel {
        RowModel() {
        }
    }
}

