/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Timer;
import java.util.TimerTask;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import org.netbeans.html.json.tck.KnockoutTCK;

public final class Utils {
    private static KnockoutTCK instantiatedTCK;

    static boolean skipIfNoFullJDK() {
        try {
            Class<?> thread = Class.forName("java.lang.Thread");
            Thread t = new Thread("Empty");
            t.setName("Different");
            t.setDaemon(false);
            t.interrupt();
            t.start();
        }
        catch (ClassNotFoundException ex) {
            return true;
        }
        catch (SecurityException ex) {
            return true;
        }
        return false;
    }

    static void scheduleLater(int delay, final Runnable r) {
        for (KnockoutTCK tck : Utils.tcks(r.getClass())) {
            if (!tck.scheduleLater(delay, r)) continue;
            return;
        }
        Timer t = new Timer("Running later");
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                r.run();
            }
        }, delay);
    }

    private Utils() {
    }

    public static void registerTCK(KnockoutTCK tck) {
        instantiatedTCK = tck;
    }

    static BrwsrCtx newContext(Class<?> clazz) {
        for (KnockoutTCK tck : Utils.tcks(clazz)) {
            BrwsrCtx c = tck.createContext();
            if (c == null) continue;
            return c;
        }
        throw new AssertionError((Object)"Can't find appropriate Context in ServiceLoader!");
    }

    static Object createObject(Map<String, Object> values, Class<?> clazz) {
        for (KnockoutTCK tck : Utils.tcks(clazz)) {
            Object o = tck.createJSON(values);
            if (o == null) continue;
            return o;
        }
        throw new AssertionError((Object)"Can't find appropriate Context in ServiceLoader!");
    }

    static Object executeScript(Class<?> clazz, String script, Object ... arguments) throws Exception {
        Iterator<KnockoutTCK> iterator = Utils.tcks(clazz).iterator();
        if (iterator.hasNext()) {
            KnockoutTCK tck = iterator.next();
            return tck.executeScript(script, arguments);
        }
        throw new AssertionError((Object)"Can't find appropriate Context in ServiceLoader!");
    }

    private static Iterable<KnockoutTCK> tcks(Class<?> clazz) {
        if (instantiatedTCK != null) {
            return Models.asList((Object[])new KnockoutTCK[]{instantiatedTCK});
        }
        return ServiceLoader.load(KnockoutTCK.class, Utils.cl(clazz));
    }

    static Object exposeHTML(Class<?> clazz, String html) throws Exception {
        String s = "var n = window.document.getElementById('ko.test.div'); \n if (!n) { \n  n = window.document.createElement('div'); \n   n.id = 'ko.test.div'; \n   var body = window.document.getElementsByTagName('body')[0];\n  body.appendChild(n);\n}\nn.innerHTML = arguments[0]; \n ";
        return Utils.executeScript(clazz, s, html);
    }

    static int countChildren(Class<?> caller, String id) throws Exception {
        return ((Number)Utils.executeScript(caller, "var e = window.document.getElementById(arguments[0]);\nif (typeof e === 'undefined') return -2;\n var list = e.childNodes;\nvar cnt = 0;\nfor (var i = 0; i < list.length; i++) {\n  if (list[i].nodeType == 1) cnt++;\n}\nreturn cnt;\n", id)).intValue();
    }

    static Object addChildren(Class<?> caller, String id, String field, Object value) throws Exception {
        return Utils.executeScript(caller, "var e = window.document.getElementById(arguments[0]);\nvar f = arguments[1];\nvar v = arguments[2];\nif (typeof e === 'undefined') return -2;\n var c = ko.contextFor(e);\nvar fn = c.$rawData[f];\nvar arr = c.$rawData[f]();\narr.push(v);\nfn(arr);\nreturn arr;\n", id, field, value);
    }

    static String prepareURL(Class<?> clazz, String content, String mimeType, String ... parameters) {
        for (KnockoutTCK tck : Utils.tcks(clazz)) {
            String o = tck.prepareWebResource(content, mimeType, parameters);
            if (o == null) continue;
            return o.toString();
        }
        throw new IllegalStateException();
    }

    static boolean canFailWebSockets(Class<?> clazz) {
        for (KnockoutTCK tck : Utils.tcks(clazz)) {
            if (!tck.canFailWebSocketTest()) continue;
            return true;
        }
        return false;
    }

    private static ClassLoader cl(Class<?> c) {
        try {
            return c.getClassLoader();
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    static void fail(String msg) {
        throw new AssertionError((Object)msg);
    }

    static void assertTrue(boolean c, String msg) {
        if (!c) {
            throw new AssertionError((Object)msg);
        }
    }

    static void assertFalse(boolean c, String msg) {
        if (c) {
            throw new AssertionError((Object)msg);
        }
    }

    static void assertNull(Object o, String msg) {
        if (o != null) {
            throw new AssertionError((Object)(msg + " but was: " + o));
        }
    }

    static void assertNotNull(Object o, String msg) {
        if (o == null) {
            throw new AssertionError((Object)msg);
        }
    }

    static void assertEquals(Object a, Object b, String msg) {
        if (a == b) {
            return;
        }
        if (a != null && a.equals(b)) {
            return;
        }
        throw new AssertionError((Object)(msg + " expecting: " + b + " actual: " + a));
    }
}

