/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import net.java.html.json.tests.ArchetypeData;
import net.java.html.json.tests.ConstantModel;
import net.java.html.json.tests.KnockoutModel;
import net.java.html.json.tests.Pair;
import net.java.html.json.tests.PairModel;
import net.java.html.json.tests.Person;
import net.java.html.json.tests.Sex;
import net.java.html.json.tests.Utils;
import org.netbeans.html.json.tck.KOTest;

public final class KnockoutTest {
    private KnockoutModel js;

    static List<Integer> resultLengths(List<String> results) {
        Integer[] arr = new Integer[results.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = results.get(i).length();
        }
        return Arrays.asList(arr);
    }

    @KOTest
    public void modifyValueAssertChangeInModelOnEnum() throws Throwable {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "Latitude: <input id='input' data-bind=\"value: choice\"></input>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setChoice(Choice.A);
            m.applyBindings();
            String v = KnockoutTest.getSetInput("input", null);
            Utils.assertEquals("A", v, "Value is really A: " + v);
            KnockoutTest.getSetInput("input", "B");
            KnockoutTest.triggerEvent("input", "change");
            Utils.assertEquals((Object)Choice.B, (Object)m.getChoice(), "Enum property updated: " + (Object)((Object)m.getChoice()));
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    @KOTest
    public void modifyRadioValueOnEnum() throws Throwable {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<input id='i1' type=\"radio\" name=\"choice\" value=\"A\" data-bind=\"checked: choice\"></input>Right\n<input id='input' type=\"radio\" name=\"choice\" value=\"B\" data-bind=\"checked: choice\"></input>Never\n\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setChoice(Choice.B);
            m.applyBindings();
            Utils.assertFalse(KnockoutTest.isChecked("i1"), "B should be checked now");
            Utils.assertTrue(KnockoutTest.isChecked("input"), "B should be checked now");
            KnockoutTest.triggerEvent("i1", "click");
            Utils.assertEquals((Object)Choice.A, (Object)m.getChoice(), "Switched to A");
            Utils.assertTrue(KnockoutTest.isChecked("i1"), "A should be checked now");
            Utils.assertFalse(KnockoutTest.isChecked("input"), "A should be checked now");
            KnockoutTest.triggerEvent("input", "click");
            Utils.assertEquals((Object)Choice.B, (Object)m.getChoice(), "Enum property updated: " + (Object)((Object)m.getChoice()));
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    @KOTest
    public void modifyValueAssertChangeInModelOnDouble() throws Throwable {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "Latitude: <input id='input' data-bind=\"value: latitude\"></input>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setLatitude(50.5);
            m.applyBindings();
            String v = KnockoutTest.getSetInput("input", null);
            Utils.assertEquals("50.5", v, "Value is really 50.5: " + v);
            KnockoutTest.getSetInput("input", "49.5");
            KnockoutTest.triggerEvent("input", "change");
            Utils.assertEquals(49.5, m.getLatitude(), "Double property updated: " + m.getLatitude());
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    @KOTest
    public void rawObject() throws Exception {
        if (this.js == null) {
            BrwsrCtx ctx = KnockoutTest.newContext();
            Person p1 = (Person)Models.bind((Object)new Person(), (BrwsrCtx)ctx);
            p1.setFirstName("Jarda");
            p1.setLastName("Tulach");
            Object raw = Models.toRaw((Object)p1);
            Person p2 = (Person)Models.fromRaw((BrwsrCtx)ctx, Person.class, (Object)raw);
            Utils.assertEquals(p2.getFirstName(), "Jarda", "First name");
            Utils.assertEquals(p2.getLastName(), "Tulach", "Last name");
            p2.setFirstName("Jirka");
            Utils.assertEquals(p2.getFirstName(), "Jirka", "First name updated");
            this.js = new KnockoutModel();
            this.js.getPeople().add(p1);
            this.js.getPeople().add(p2);
        }
        Person p1 = this.js.getPeople().get(0);
        Person p2 = this.js.getPeople().get(1);
        if (this.js.getPeople().size() == 2) {
            if (!"Jirka".equals(p1.getFirstName())) {
                throw new InterruptedException();
            }
            Utils.assertEquals(p1.getFirstName(), "Jirka", "First name updated in original object");
            p1.setFirstName("Ondra");
            Utils.assertEquals(p1.getFirstName(), "Ondra", "1st name updated in original object");
            this.js.getPeople().add(p1);
        }
        if (!"Ondra".equals(p2.getFirstName())) {
            throw new InterruptedException();
        }
        Utils.assertEquals(p2.getFirstName(), "Ondra", "1st name updated in copied object");
    }

    @KOTest
    public void modifyComputedProperty() throws Throwable {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "Full name: <div data-bind='with:firstPerson'>\n<input id='input' data-bind=\"value: fullName\"></input>\n</div>\n");
        try {
            KnockoutModel m = new KnockoutModel();
            m.getPeople().add(new Person());
            m = (KnockoutModel)Models.bind((Object)m, (BrwsrCtx)KnockoutTest.newContext());
            m.getFirstPerson().setFirstName("Jarda");
            m.getFirstPerson().setLastName("Tulach");
            m.applyBindings();
            String v = KnockoutTest.getSetInput("input", null);
            Utils.assertEquals("Jarda Tulach", v, "Value: " + v);
            KnockoutTest.getSetInput("input", "Mickey Mouse");
            KnockoutTest.triggerEvent("input", "change");
            Utils.assertEquals("Mickey", m.getFirstPerson().getFirstName(), "First name updated");
            Utils.assertEquals("Mouse", m.getFirstPerson().getLastName(), "Last name updated");
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    @KOTest
    public void modifyValueAssertChangeInModelOnBoolean() throws Throwable {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "Latitude: <input id='input' data-bind=\"value: enabled\"></input>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setEnabled(true);
            m.applyBindings();
            String v = KnockoutTest.getSetInput("input", null);
            Utils.assertEquals("true", v, "Value is really true: " + v);
            KnockoutTest.getSetInput("input", "false");
            KnockoutTest.triggerEvent("input", "change");
            Utils.assertFalse(m.isEnabled(), "Boolean property updated: " + m.isEnabled());
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void modifyValueAssertChangeInModel() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<h1 data-bind=\"text: helloMessage\">Loading Bck2Brwsr's Hello World...</h1>\nYour name: <input id='input' data-bind=\"value: name\"></input>\n<button id=\"hello\">Say Hello!</button>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setName("Kukuc");
            m.applyBindings();
            String v = KnockoutTest.getSetInput("input", null);
            Utils.assertEquals("Kukuc", v, "Value is really kukuc: " + v);
            KnockoutTest.getSetInput("input", "Jardo");
            KnockoutTest.triggerEvent("input", "change");
            Utils.assertEquals("Jardo", m.getName(), "Name property updated: " + m.getName());
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    private static String getSetSelected(int index, Object value) throws Exception {
        String s = "var index = arguments[0];\nvar value = arguments[1];\nvar n = window.document.getElementById('input'); \n if (value != null) {\n  n.options[index].value = 'me'; \n  n.value = 'me'; \n  ko.dataFor(n.options[index]).archetype(value); // haven't found better way to trigger ko change yet \n} \n var op = n.options[n.selectedIndex]; \nreturn op ? op.text : n.selectedIndex;\n";
        Object ret = Utils.executeScript(KnockoutTest.class, s, index, value);
        return ret == null ? null : ret.toString();
    }

    @KOTest
    public void selectWorksOnModels() throws Exception {
        if (this.js == null) {
            Utils.exposeHTML(KnockoutTest.class, "<select id='input' data-bind=\"options: archetypes,\n                       optionsText: 'name',\n                       value: archetype\">\n                  </select>\n");
            this.js = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            this.js.getArchetypes().add(new ArchetypeData("ko4j", "org.netbeans.html", "0.8.3", "ko4j", "ko4j", null));
            this.js.getArchetypes().add(new ArchetypeData("crud", "org.netbeans.html", "0.8.3", "crud", "crud", null));
            this.js.getArchetypes().add(new ArchetypeData("3rd", "org.netbeans.html", "0.8.3", "3rd", "3rd", null));
            this.js.setArchetype(this.js.getArchetypes().get(1));
            this.js.applyBindings();
            String v = KnockoutTest.getSetSelected(0, null);
            Utils.assertEquals("crud", v, "Second index (e.g. crud) is selected: " + v);
            String sel = KnockoutTest.getSetSelected(2, Models.toRaw((Object)this.js.getArchetypes().get(2)));
            Utils.assertEquals("3rd", sel, "3rd is selected now: " + sel);
        }
        if (this.js.getArchetype() != this.js.getArchetypes().get(2)) {
            throw new InterruptedException();
        }
        Utils.exposeHTML(KnockoutTest.class, "");
    }

    @KOTest
    public void nestedObjectEqualsChange() throws Exception {
        this.nestedObjectEqualsChange(true);
    }

    @KOTest
    public void nestedObjectChange() throws Exception {
        this.nestedObjectEqualsChange(false);
    }

    private void nestedObjectEqualsChange(boolean preApply) throws Exception {
        Utils.exposeHTML(KnockoutTest.class, "            <div data-bind='with: archetype'>\n                <input id='input' data-bind='value: groupId'></input>\n            </div>\n");
        this.js = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
        if (preApply) {
            this.js.applyBindings();
        }
        this.js.setArchetype(new ArchetypeData());
        this.js.getArchetype().setGroupId("org.netbeans.html");
        this.js.applyBindings();
        String v = KnockoutTest.getSetInput("input", null);
        Utils.assertEquals("org.netbeans.html", v, "groupId has been changed");
        Utils.exposeHTML(KnockoutTest.class, "");
    }

    @KOTest
    public void modifyValueAssertAsyncChangeInModel() throws Exception {
        String v;
        if (this.js == null) {
            Utils.exposeHTML(KnockoutTest.class, "<h1 data-bind=\"text: helloMessage\">Loading Bck2Brwsr's Hello World...</h1>\nYour name: <input id='input' data-bind=\"value: name\"></input>\n<button id=\"hello\">Say Hello!</button>\n");
            this.js = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            this.js.setName("Kukuc");
            this.js.applyBindings();
            v = KnockoutTest.getSetInput("input", null);
            Utils.assertEquals("Kukuc", v, "Value is really kukuc: " + v);
            Timer t = new Timer("Set to Jardo");
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    KnockoutTest.this.js.setName("Jardo");
                }
            }, 1L);
        }
        if (!"Jardo".equals(v = KnockoutTest.getSetInput("input", null))) {
            throw new InterruptedException();
        }
        Utils.exposeHTML(KnockoutTest.class, "");
    }

    @KOTest
    public void nonMutableDouble() throws Exception {
        Utils.exposeHTML(KnockoutTest.class, "Type: <input id='input' data-bind=\"value: typeof doubleValue\"></input>\n");
        ConstantModel model = (ConstantModel)Models.bind((Object)new ConstantModel(), (BrwsrCtx)KnockoutTest.newContext());
        model.assignStringValue("Hello").assignDoubleValue(10.0);
        model.applyBindings();
        String v = KnockoutTest.getSetInput("input", null);
        Utils.assertEquals(v, "number", "Right type found: " + v);
        Utils.exposeHTML(KnockoutTest.class, "");
    }

    @KOTest
    public void nonMutableString() throws Exception {
        Utils.exposeHTML(KnockoutTest.class, "Type: <input id='input' data-bind=\"value: typeof stringValue\"></input>\n");
        ConstantModel model = (ConstantModel)Models.bind((Object)new ConstantModel(), (BrwsrCtx)KnockoutTest.newContext());
        model.assignStringValue("Hello").assignDoubleValue(10.0);
        model.applyBindings();
        String v = KnockoutTest.getSetInput("input", null);
        Utils.assertEquals(v, "string", "Right type found: " + v);
        Utils.exposeHTML(KnockoutTest.class, "");
    }

    @KOTest
    public void nonMutableBoolean() throws Exception {
        Utils.exposeHTML(KnockoutTest.class, "Type: <input id='input' data-bind=\"value: typeof boolValue\"></input>\n");
        ConstantModel model = (ConstantModel)Models.bind((Object)new ConstantModel(), (BrwsrCtx)KnockoutTest.newContext());
        model.assignStringValue("Hello").assignBoolValue(true);
        model.applyBindings();
        String v = KnockoutTest.getSetInput("input", null);
        Utils.assertEquals(v, "boolean", "Right type found: " + v);
        Utils.exposeHTML(KnockoutTest.class, "");
    }

    @KOTest
    public void nonMutableIntArray() throws Exception {
        Utils.exposeHTML(KnockoutTest.class, "Type: <input id='input' data-bind=\"value: typeof intArray\"></input>\n");
        ConstantModel model = (ConstantModel)Models.bind((Object)new ConstantModel(), (BrwsrCtx)KnockoutTest.newContext());
        model.assignStringValue("Hello").assignDoubleValue(9.223372036854776E18).assignIntArray(1, 2, 3, 4);
        model.applyBindings();
        String v = KnockoutTest.getSetInput("input", null);
        Utils.assertEquals(v, "object", "Right type found: " + v);
        Utils.exposeHTML(KnockoutTest.class, "");
    }

    private static String getSetInput(String id, String value) throws Exception {
        String s = "var value = arguments[0];\nvar n = window.document.getElementById(arguments[1]); \n if (value != null) n['value'] = value; \n return n['value'];";
        Object ret = Utils.executeScript(KnockoutTest.class, s, value, id);
        return ret == null ? null : ret.toString();
    }

    private static boolean isChecked(String id) throws Exception {
        String s = "var n = window.document.getElementById(arguments[0]); \n return n['checked'];";
        Object ret = Utils.executeScript(KnockoutTest.class, s, id);
        return Boolean.TRUE.equals(ret);
    }

    public static void triggerEvent(String id, String ev) throws Exception {
        Utils.executeScript(KnockoutTest.class, "ko.utils.triggerEvent(window.document.getElementById(arguments[0]), arguments[1]);", id, ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void displayContentOfArray() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: results'>\n  <li data-bind='text: $data, click: $root.call'/>\n</ul>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getResults().add("Ahoj");
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "One child, but was " + cnt);
            m.getResults().add("Hi");
            cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
            KnockoutTest.triggerChildClick("ul", 1);
            Utils.assertEquals(1, m.getCallbackCount(), "One callback " + m.getCallbackCount());
            Utils.assertEquals("Hi", m.getName(), "We got callback from 2nd child " + m.getName());
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    @KOTest
    public void displayContentOfAsyncArray() throws Exception {
        int cnt;
        if (this.js == null) {
            Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: results'>\n  <li data-bind='text: $data, click: $root.call'/>\n</ul>\n");
            this.js = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            this.js.getResults().add("Ahoj");
            this.js.applyBindings();
            cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "One child, but was " + cnt);
            Timer t = new Timer("add to array");
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    KnockoutTest.this.js.getResults().add("Hi");
                }
            }, 1L);
        }
        if ((cnt = Utils.countChildren(KnockoutTest.class, "ul")) != 2) {
            throw new InterruptedException();
        }
        try {
            KnockoutTest.triggerChildClick("ul", 1);
            Utils.assertEquals(1, this.js.getCallbackCount(), "One callback " + this.js.getCallbackCount());
            Utils.assertEquals("Hi", this.js.getName(), "We got callback from 2nd child " + this.js.getName());
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void displayContentOfComputedArray() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: bothNames'>\n  <li data-bind='text: $data, click: $root.assignFirstName'/>\n</ul>\n");
        try {
            Pair m = (Pair)Models.bind((Object)new Pair("First", "Last", null), (BrwsrCtx)KnockoutTest.newContext());
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
            KnockoutTest.triggerChildClick("ul", 1);
            Utils.assertEquals("Last", m.getFirstName(), "We got callback from 2nd child " + m.getFirstName());
            m.setLastName("Verylast");
            cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
            KnockoutTest.triggerChildClick("ul", 1);
            Utils.assertEquals("Verylast", m.getFirstName(), "We got callback from 2nd child " + m.getFirstName());
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void displayContentOfComputedArrayOnASubpair() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<div data-bind='with: next'>\n<ul id='ul' data-bind='foreach: bothNames'>\n  <li data-bind='text: $data, click: $root.assignFirstName'/>\n</ul></div>\n");
        try {
            BrwsrCtx ctx = KnockoutTest.newContext();
            Pair m = (Pair)Models.bind((Object)new Pair(null, null, new Pair("First", "Last", null)), (BrwsrCtx)ctx);
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
            KnockoutTest.triggerChildClick("ul", 1);
            Utils.assertEquals(PairModel.ctx, ctx, "Context remains the same");
            Utils.assertEquals("Last", m.getFirstName(), "We got callback from 2nd child " + m.getFirstName());
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void displayContentOfComputedArrayOnComputedASubpair() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<div data-bind='with: nextOne'>\n<ul id='ul' data-bind='foreach: bothNames'>\n  <li data-bind='text: $data, click: $root.assignFirstName'/>\n</ul></div>\n");
        try {
            Pair m = (Pair)Models.bind((Object)new Pair(null, null, new Pair("First", "Last", null)), (BrwsrCtx)KnockoutTest.newContext());
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
            KnockoutTest.triggerChildClick("ul", 1);
            Utils.assertEquals("Last", m.getFirstName(), "We got callback from 2nd child " + m.getFirstName());
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    @KOTest
    public void checkBoxToBooleanBinding() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<input type='checkbox' id='b' data-bind='checked: enabled'></input>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.applyBindings();
            Utils.assertFalse(m.isEnabled(), "Is disabled");
            KnockoutTest.triggerClick("b");
            Utils.assertTrue(m.isEnabled(), "Now the model is enabled");
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void displayContentOfDerivedArray() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: cmpResults'>\n  <li><b data-bind='text: $data'></b></li>\n</ul>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getResults().add("Ahoj");
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "One child, but was " + cnt);
            m.getResults().add("hello");
            cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void displayContentOfArrayOfPeople() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: people'>\n  <li data-bind='text: $data.firstName, click: $root.removePerson'></li>\n</ul>\n");
        try {
            BrwsrCtx c = KnockoutTest.newContext();
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)c);
            Person first = (Person)Models.bind((Object)new Person(), (BrwsrCtx)c);
            first.setFirstName("first");
            m.getPeople().add(first);
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "One child, but was " + cnt);
            Person second = (Person)Models.bind((Object)new Person(), (BrwsrCtx)c);
            second.setFirstName("second");
            m.getPeople().add(second);
            cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
            KnockoutTest.triggerChildClick("ul", 1);
            Utils.assertEquals(1, m.getCallbackCount(), "One callback " + m.getCallbackCount());
            cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "Again one child, but was " + cnt);
            String txt = KnockoutTest.childText("ul", 0);
            Utils.assertEquals("first", txt, "Expecting 'first': " + txt);
            first.setFirstName("changed");
            txt = KnockoutTest.childText("ul", 0);
            Utils.assertEquals("changed", txt, "Expecting 'changed': " + txt);
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    static Person firstPerson(List<Person> people) {
        return people.isEmpty() ? null : people.get(0);
    }

    @KOTest
    public void accessFirstPersonWithOnFunction() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<p id='ul' data-bind='with: firstPerson'>\n  <span data-bind='text: firstName, click: changeSex'></span>\n</p>\n");
        try {
            this.trasfertToFemale();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    @KOTest
    public void onPersonFunction() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: people'>\n  <li data-bind='text: $data.firstName, click: changeSex'></li>\n</ul>\n");
        try {
            this.trasfertToFemale();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    private void trasfertToFemale() throws Exception {
        KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
        Person first = (Person)Models.bind((Object)new Person(), (BrwsrCtx)KnockoutTest.newContext());
        first.setFirstName("first");
        first.setSex(Sex.MALE);
        m.getPeople().add(first);
        m.applyBindings();
        int cnt = Utils.countChildren(KnockoutTest.class, "ul");
        Utils.assertEquals(cnt, 1, "One child, but was " + cnt);
        KnockoutTest.triggerChildClick("ul", 0);
        Utils.assertEquals((Object)first.getSex(), (Object)Sex.FEMALE, "Transverted to female: " + (Object)((Object)first.getSex()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void stringArrayModificationVisible() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<div>\n<ul id='ul' data-bind='foreach: results'>\n  <li data-bind='text: $data'></li>\n</ul>\n</div>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getResults().add("Ahoj");
            m.getResults().add("Hello");
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children " + cnt);
            Object arr = Utils.addChildren(KnockoutTest.class, "ul", "results", "Hi");
            Utils.assertTrue(arr instanceof Object[], "Got back an array: " + arr);
            int len = ((Object[])arr).length;
            Utils.assertEquals(len, 3, "Three elements in the array " + len);
            int newCnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(newCnt, 3, "Three children in the DOM: " + newCnt);
            Utils.assertEquals(m.getResults().size(), 3, "Three java strings: " + m.getResults());
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void intArrayModificationVisible() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<div>\n<ul id='ul' data-bind='foreach: numbers'>\n  <li data-bind='text: $data'></li>\n</ul>\n</div>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getNumbers().add(1);
            m.getNumbers().add(31);
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children " + cnt);
            Object arr = Utils.addChildren(KnockoutTest.class, "ul", "numbers", 42);
            Utils.assertTrue(arr instanceof Object[], "Got back an array: " + arr);
            int len = ((Object[])arr).length;
            Utils.assertEquals(len, 3, "Three elements in the array " + len);
            int newCnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(newCnt, 3, "Three children in the DOM: " + newCnt);
            Utils.assertEquals(m.getNumbers().size(), 3, "Three java ints: " + m.getNumbers());
            Utils.assertEquals(m.getNumbers().get(2), 42, "Meaning of world: " + m.getNumbers());
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void derivedIntArrayModificationVisible() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<div>\n<ul id='ul' data-bind='foreach: resultLengths'>\n  <li data-bind='text: $data'></li>\n</ul>\n</div>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getResults().add("Ahoj");
            m.getResults().add("Hello");
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children " + cnt);
            Object arr = Utils.addChildren(KnockoutTest.class, "ul", "results", "Hi");
            Utils.assertTrue(arr instanceof Object[], "Got back an array: " + arr);
            int len = ((Object[])arr).length;
            Utils.assertEquals(len, 3, "Three elements in the array " + len);
            int newCnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(newCnt, 3, "Three children in the DOM: " + newCnt);
            Utils.assertEquals(m.getResultLengths().size(), 3, "Three java ints: " + m.getResultLengths());
            Utils.assertEquals(m.getResultLengths().get(2), 2, "Size is two: " + m.getResultLengths());
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void archetypeArrayModificationVisible() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<div>\n<ul id='ul' data-bind='foreach: archetypes'>\n  <li data-bind='text: artifactId'></li>\n</ul>\n</div>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 0, "No children " + cnt);
            Object arr = Utils.addChildren(KnockoutTest.class, "ul", "archetypes", new ArchetypeData("aid", "gid", "v", "n", "d", "u"));
            Utils.assertTrue(arr instanceof Object[], "Got back an array: " + arr);
            int len = ((Object[])arr).length;
            Utils.assertEquals(len, 1, "One element in the array " + len);
            int newCnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(newCnt, 1, "One child in the DOM: " + newCnt);
            Utils.assertEquals(m.getArchetypes().size(), 1, "One archetype: " + m.getArchetypes());
            Utils.assertNotNull(m.getArchetypes().get(0), "Not null: " + m.getArchetypes());
            Utils.assertEquals(m.getArchetypes().get(0).getArtifactId(), "aid", "'aid' == " + m.getArchetypes());
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    static void call(KnockoutModel m, String data) {
        m.setName(data);
        m.setCallbackCount(m.getCallbackCount() + 1);
    }

    static void removePerson(KnockoutModel model, Person data) {
        model.setCallbackCount(model.getCallbackCount() + 1);
        model.getPeople().remove(data);
    }

    static String helloMessage(String name) {
        return "Hello " + name + "!";
    }

    static List<String> cmpResults(List<String> results) {
        return results;
    }

    private static void triggerClick(String id) throws Exception {
        String s = "var id = arguments[0];var e = window.document.getElementById(id);\n if (e.checked) throw 'It should not be checked yet: ' + e;\n var ev = window.document.createEvent('MouseEvents');\n ev.initMouseEvent('click', true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);\n e.dispatchEvent(ev);\n if (!e.checked) {\n  e.checked = true;\n   e.dispatchEvent(ev);\n }\n";
        Utils.executeScript(KnockoutTest.class, s, id);
    }

    private static void triggerChildClick(String id, int pos) throws Exception {
        String s = "var id = arguments[0]; var pos = arguments[1];\nvar e = window.document.getElementById(id);\n var ev = window.document.createEvent('MouseEvents');\n ev.initMouseEvent('click', true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);\n var list = e.childNodes;\nvar cnt = -1;\nfor (var i = 0; i < list.length; i++) {\n  if (list[i].nodeType == 1) cnt++;\n  if (cnt == pos) return list[i].dispatchEvent(ev);\n}\nreturn null;\n";
        Utils.executeScript(KnockoutTest.class, s, id, pos);
    }

    private static String childText(String id, int pos) throws Exception {
        String s = "var id = arguments[0]; var pos = arguments[1];var e = window.document.getElementById(id);\nvar list = e.childNodes;\nvar cnt = -1;\nfor (var i = 0; i < list.length; i++) {\n  if (list[i].nodeType == 1) cnt++;\n  if (cnt == pos) return list[i].innerHTML;\n}\nreturn null;\n";
        return (String)Utils.executeScript(KnockoutTest.class, s, id, pos);
    }

    private static BrwsrCtx newContext() {
        return Utils.newContext(KnockoutTest.class);
    }

    static class ConstantCntrl {
        ConstantCntrl() {
        }
    }

    static class ArchModel {
        ArchModel() {
        }
    }

    static enum Choice {
        A,
        B;

    }
}

