/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import net.java.html.json.tests.JSONik;
import net.java.html.json.tests.NameAndValue;
import net.java.html.json.tests.People;
import net.java.html.json.tests.Person;
import net.java.html.json.tests.Sex;
import net.java.html.json.tests.Utils;
import org.netbeans.html.json.tck.KOTest;

public final class JSONTest {
    private JSONik js;
    private Integer orig;
    private String url;
    private BrwsrCtx ctx;
    private static BrwsrCtx onCallback;

    static void assignFetched(JSONik m, Person p) {
        m.setFetched(p);
    }

    @KOTest
    public void toJSONInABrowser() throws Throwable {
        Object json;
        Person p = (Person)Models.bind((Object)new Person(), (BrwsrCtx)JSONTest.newContext());
        p.setSex(Sex.MALE);
        p.setFirstName("Jarda");
        p.setLastName("Tulach");
        try {
            json = JSONTest.parseJSON(p.toString());
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Can't parse " + p).initCause(ex);
        }
        Person p2 = (Person)Models.fromRaw((BrwsrCtx)JSONTest.newContext(), Person.class, (Object)json);
        assert (p2.getFirstName().equals(p.getFirstName())) : "Should be the same: " + p.getFirstName() + " != " + p2.getFirstName();
    }

    @KOTest
    public void toJSONWithEscapeCharactersInABrowser() throws Throwable {
        Object json;
        Person p = (Person)Models.bind((Object)new Person(), (BrwsrCtx)JSONTest.newContext());
        p.setSex(Sex.MALE);
        p.setFirstName("/*\n * Copyright (c) 2013");
        String txt = p.toString();
        try {
            json = JSONTest.parseJSON(txt);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Can't parse " + txt).initCause(ex);
        }
        Person p2 = (Person)Models.fromRaw((BrwsrCtx)JSONTest.newContext(), Person.class, (Object)json);
        assert (p2.getFirstName().equals(p.getFirstName())) : "Should be the same: " + p.getFirstName() + " != " + p2.getFirstName();
    }

    @KOTest
    public void toJSONWithDoubleSlashInABrowser() throws Throwable {
        Object json;
        Person p = (Person)Models.bind((Object)new Person(), (BrwsrCtx)JSONTest.newContext());
        p.setSex(Sex.MALE);
        p.setFirstName("/*\\n * Copyright (c) 2013");
        String txt = p.toString();
        try {
            json = JSONTest.parseJSON(txt);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Can't parse " + txt).initCause(ex);
        }
        Person p2 = (Person)Models.fromRaw((BrwsrCtx)JSONTest.newContext(), Person.class, (Object)json);
        assert (p2.getFirstName().equals(p.getFirstName())) : "Should be the same: " + p.getFirstName() + " != " + p2.getFirstName();
    }

    @KOTest
    public void toJSONWithApostrophInABrowser() throws Throwable {
        Object json;
        Person p = (Person)Models.bind((Object)new Person(), (BrwsrCtx)JSONTest.newContext());
        p.setSex(Sex.MALE);
        p.setFirstName("Jimmy 'Jim' Rambo");
        String txt = p.toString();
        try {
            json = JSONTest.parseJSON(txt);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Can't parse " + txt).initCause(ex);
        }
        Person p2 = (Person)Models.fromRaw((BrwsrCtx)JSONTest.newContext(), Person.class, (Object)json);
        assert (p2.getFirstName().equals(p.getFirstName())) : "Should be the same: " + p.getFirstName() + " != " + p2.getFirstName();
    }

    static void fetch(JSONik model, Person p) {
        model.setFetched(p);
        onCallback = BrwsrCtx.findDefault(model.getClass());
    }

    static void fetchArray(JSONik model, Person[] p) {
        model.setFetchedCount(p.length);
        model.setFetched(p[0]);
        onCallback = BrwsrCtx.findDefault(model.getClass());
    }

    static void setMessage(JSONik m, Exception t) {
        assert (t != null);
        m.setFetchedResponse("Exception");
    }

    static void fetchPeople(JSONik model, People p) {
        int size = p.getInfo().size();
        if (size > 0) {
            model.setFetched(p.getInfo().get(0));
        }
        model.setFetchedCount(size);
    }

    static void fetchPeopleAge(JSONik model, People p) {
        int sum = 0;
        for (int a : p.getAge()) {
            sum += a;
        }
        model.setFetchedCount(sum);
    }

    @KOTest
    public void loadAndParseJSON() throws InterruptedException {
        Person p;
        if (this.js == null) {
            this.url = Utils.prepareURL(JSONTest.class, "{'firstName': 'Sitar', 'sex': 'MALE'}", "application/json", new String[0]);
            this.ctx = JSONTest.newContext();
            this.js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)this.ctx);
            this.js.applyBindings();
            this.js.setFetched(null);
            this.js.fetch(this.url);
        }
        if ((p = this.js.getFetched()) == null) {
            throw new InterruptedException();
        }
        assert ("Sitar".equals(p.getFirstName())) : "Expecting Sitar: " + p.getFirstName();
        assert (Sex.MALE.equals((Object)p.getSex())) : "Expecting MALE: " + (Object)((Object)p.getSex());
        assert (this.ctx == onCallback);
    }

    static void fetchViaJSONP(JSONik model, Person p) {
        model.setFetched(p);
    }

    @KOTest
    public void loadAndParseJSONP() throws InterruptedException, Exception {
        Person p;
        if (this.js == null) {
            this.url = Utils.prepareURL(JSONTest.class, "$0({'firstName': 'Mitar', 'sex': 'MALE'})", "application/javascript", "callme");
            this.orig = JSONTest.scriptElements();
            assert (this.orig > 0) : "There should be some scripts on the page";
            this.js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            this.js.applyBindings();
            this.js.setFetched(null);
            this.js.fetchViaJSONP(this.url);
        }
        if ((p = this.js.getFetched()) == null) {
            throw new InterruptedException();
        }
        assert ("Mitar".equals(p.getFirstName())) : "Unexpected: " + p.getFirstName();
        assert (Sex.MALE.equals((Object)p.getSex())) : "Expecting MALE: " + (Object)((Object)p.getSex());
        int now = JSONTest.scriptElements();
        assert (this.orig == now) : "The set of elements is unchanged. Delta: " + (now - this.orig);
    }

    static void putPerson(JSONik model, String reply) {
        model.setFetchedCount(1);
        model.setFetchedResponse(reply);
    }

    @KOTest
    public void putPeopleUsesRightMethod() throws InterruptedException, Exception {
        String msg;
        int cnt;
        if (this.js == null) {
            this.url = Utils.prepareURL(JSONTest.class, "$0\n$1", "text/plain", "http.method", "http.requestBody");
            this.orig = JSONTest.scriptElements();
            assert (this.orig > 0) : "There should be some scripts on the page";
            this.js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            this.js.applyBindings();
            Person p = (Person)Models.bind((Object)new Person(), (BrwsrCtx)BrwsrCtx.EMPTY);
            p.setFirstName("Jarda");
            this.js.putPerson(this.url, p);
        }
        if ((cnt = this.js.getFetchedCount()) == 0) {
            throw new InterruptedException();
        }
        String res = this.js.getFetchedResponse();
        int line = res.indexOf(10);
        if (line >= 0) {
            msg = res.substring(line + 1);
            res = res.substring(0, line);
        } else {
            msg = res;
        }
        assert ("PUT".equals(res)) : "Server was queried with PUT method: " + this.js.getFetchedResponse();
        assert (msg.contains("Jarda")) : "Data transferred to the server: " + msg;
    }

    private static int scriptElements() throws Exception {
        return ((Number)Utils.executeScript(JSONTest.class, "return window.document.getElementsByTagName('script').length;", new Object[0])).intValue();
    }

    private static Object parseJSON(String s) throws Exception {
        return Utils.executeScript(JSONTest.class, "return window.JSON.parse(arguments[0]);", s);
    }

    @KOTest
    public void loadAndParseJSONSentToArray() throws InterruptedException {
        Person p;
        if (this.js == null) {
            this.url = Utils.prepareURL(JSONTest.class, "{'firstName': 'Sitar', 'sex': 'MALE'}", "application/json", new String[0]);
            this.js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            this.js.applyBindings();
            this.js.setFetched(null);
            this.js.fetchArray(this.url);
        }
        if ((p = this.js.getFetched()) == null) {
            throw new InterruptedException();
        }
        assert ("Sitar".equals(p.getFirstName())) : "Expecting Sitar: " + p.getFirstName();
        assert (Sex.MALE.equals((Object)p.getSex())) : "Expecting MALE: " + (Object)((Object)p.getSex());
    }

    @KOTest
    public void loadAndParseJSONArraySingle() throws InterruptedException {
        Person p;
        if (this.js == null) {
            this.url = Utils.prepareURL(JSONTest.class, "[{'firstName': 'Gitar', 'sex': 'FEMALE'}]", "application/json", new String[0]);
            this.js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            this.js.applyBindings();
            this.js.setFetched(null);
            this.js.fetch(this.url);
        }
        if ((p = this.js.getFetched()) == null) {
            throw new InterruptedException();
        }
        assert ("Gitar".equals(p.getFirstName())) : "Expecting Gitar: " + p.getFirstName();
        assert (Sex.FEMALE.equals((Object)p.getSex())) : "Expecting FEMALE: " + (Object)((Object)p.getSex());
    }

    @KOTest
    public void loadAndParseArrayInPeople() throws InterruptedException {
        if (this.js == null) {
            this.url = Utils.prepareURL(JSONTest.class, "{'info':[{'firstName': 'Gitar', 'sex': 'FEMALE'}]}", "application/json", new String[0]);
            this.js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            this.js.applyBindings();
            this.js.fetchPeople(this.url);
        }
        if (0 == this.js.getFetchedCount()) {
            throw new InterruptedException();
        }
        assert (this.js.getFetchedCount() == 1) : "One person loaded: " + this.js.getFetchedCount();
        Person p = this.js.getFetched();
        assert (p != null) : "We should get our person back: " + p;
        assert ("Gitar".equals(p.getFirstName())) : "Expecting Gitar: " + p.getFirstName();
        assert (Sex.FEMALE.equals((Object)p.getSex())) : "Expecting FEMALE: " + (Object)((Object)p.getSex());
    }

    @KOTest
    public void loadAndParseArrayOfIntegers() throws InterruptedException {
        if (this.js == null) {
            this.url = Utils.prepareURL(JSONTest.class, "{'age':[1, 2, 3]}", "application/json", new String[0]);
            this.js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            this.js.applyBindings();
            this.js.fetchPeopleAge(this.url);
        }
        if (0 == this.js.getFetchedCount()) {
            throw new InterruptedException();
        }
        assert (this.js.getFetchedCount() == 6) : "1 + 2 + 3 is " + this.js.getFetchedCount();
    }

    static void fetchPeopleSex(JSONik model, People p) {
        model.setFetchedCount(1);
        model.getFetchedSex().addAll(p.getSex());
    }

    @KOTest
    public void loadAndParseArrayOfEnums() throws InterruptedException {
        if (this.js == null) {
            this.url = Utils.prepareURL(JSONTest.class, "{'sex':['FEMALE', 'MALE', 'MALE']}", "application/json", new String[0]);
            this.js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            this.js.applyBindings();
            this.js.fetchPeopleSex(this.url);
        }
        if (0 == this.js.getFetchedCount()) {
            throw new InterruptedException();
        }
        assert (this.js.getFetchedCount() == 1) : "Loaded";
        assert (this.js.getFetchedSex().size() == 3) : "Three values " + this.js.getFetchedSex();
        assert (this.js.getFetchedSex().get(0) == Sex.FEMALE) : "Female first " + this.js.getFetchedSex();
        assert (this.js.getFetchedSex().get(1) == Sex.MALE) : "male 2nd " + this.js.getFetchedSex();
        assert (this.js.getFetchedSex().get(2) == Sex.MALE) : "male 3rd " + this.js.getFetchedSex();
    }

    @KOTest
    public void loadAndParseJSONArray() throws InterruptedException {
        Person p;
        if (this.js == null) {
            this.url = Utils.prepareURL(JSONTest.class, "[{'firstName': 'Gitar', 'sex': 'FEMALE'},{'firstName': 'Peter', 'sex': 'MALE'}]", "application/json", new String[0]);
            this.js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            this.js.applyBindings();
            this.js.setFetched(null);
            this.js.fetchArray(this.url);
        }
        if ((p = this.js.getFetched()) == null) {
            throw new InterruptedException();
        }
        assert (this.js.getFetchedCount() == 2) : "We got two values: " + this.js.getFetchedCount();
        assert ("Gitar".equals(p.getFirstName())) : "Expecting Gitar: " + p.getFirstName();
        assert (Sex.FEMALE.equals((Object)p.getSex())) : "Expecting FEMALE: " + (Object)((Object)p.getSex());
    }

    @KOTest
    public void loadError() throws InterruptedException {
        if (this.js == null) {
            this.js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            this.js.applyBindings();
            this.js.setFetched(null);
            this.js.fetchArray("http://127.0.0.1:54253/does/not/exist.txt");
        }
        if (this.js.getFetchedResponse() == null) {
            throw new InterruptedException();
        }
        assert ("Exception".equals(this.js.getFetchedResponse())) : this.js.getFetchedResponse();
    }

    @KOTest
    public void parseNullNumber() throws Exception {
        String txt = "{ \"name\":\"M\" }";
        ByteArrayInputStream is = new ByteArrayInputStream(txt.getBytes("UTF-8"));
        NameAndValue v = (NameAndValue)Models.parse((BrwsrCtx)JSONTest.newContext(), NameAndValue.class, (InputStream)is);
        assert ("M".equals(v.getName())) : "Name is 'M': " + v.getName();
        assert (0L == v.getValue()) : "Value is empty: " + v.getValue();
        assert (0 == v.getSmall()) : "Small value is empty: " + v.getSmall();
    }

    @KOTest
    public void deserializeWrongEnum() throws Exception {
        PrintStream prev = null;
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            prev = System.err;
            System.setErr(new PrintStream(err));
        }
        catch (SecurityException e) {
            err = null;
            prev = null;
        }
        catch (LinkageError e) {
            err = null;
            prev = null;
        }
        String str = "{ \"sex\" : \"unknown\" }";
        ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes("UTF-8"));
        Person p = (Person)Models.parse((BrwsrCtx)JSONTest.newContext(), Person.class, (InputStream)is);
        assert (p.getSex() == null) : "Wrong sex means null, but was: " + (Object)((Object)p.getSex());
        if (err != null) assert (err.toString().contains("unknown") && err.toString().contains("Sex")) : "Expecting error: " + err.toString();
        if (prev != null) {
            try {
                System.setErr(prev);
            }
            catch (LinkageError e) {
                // empty catch block
            }
        }
    }

    private static BrwsrCtx newContext() {
        return Utils.newContext(JSONTest.class);
    }

    static class NandV {
        NandV() {
        }
    }
}

