/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import net.java.html.json.tests.ArchetypeData;
import net.java.html.json.tests.KnockoutModel;
import net.java.html.json.tests.Pair;
import net.java.html.json.tests.PairModel;
import net.java.html.json.tests.Person;
import net.java.html.json.tests.Sex;
import net.java.html.json.tests.Utils;
import org.netbeans.html.json.tck.KOTest;

public final class KnockoutTest {
    private KnockoutModel js;

    static List<Integer> resultLengths(List<String> results) {
        Integer[] arr = new Integer[results.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = results.get(i).length();
        }
        return Arrays.asList(arr);
    }

    @KOTest
    public void modifyValueAssertChangeInModelOnEnum() throws Throwable {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "Latitude: <input id='input' data-bind=\"value: choice\"></input>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setChoice(Choice.A);
            m.applyBindings();
            String v = KnockoutTest.getSetInput(null);
            assert ("A".equals(v)) : "Value is really A: " + v;
            KnockoutTest.getSetInput("B");
            KnockoutTest.triggerEvent("input", "change");
            assert (Choice.B == m.getChoice()) : "Enum property updated: " + (Object)((Object)m.getChoice());
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    @KOTest
    public void modifyValueAssertChangeInModelOnDouble() throws Throwable {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "Latitude: <input id='input' data-bind=\"value: latitude\"></input>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setLatitude(50.5);
            m.applyBindings();
            String v = KnockoutTest.getSetInput(null);
            assert ("50.5".equals(v)) : "Value is really 50.5: " + v;
            KnockoutTest.getSetInput("49.5");
            KnockoutTest.triggerEvent("input", "change");
            assert (49.5 == m.getLatitude()) : "Double property updated: " + m.getLatitude();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    @KOTest
    public void modifyValueAssertChangeInModelOnBoolean() throws Throwable {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "Latitude: <input id='input' data-bind=\"value: enabled\"></input>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setEnabled(true);
            m.applyBindings();
            String v = KnockoutTest.getSetInput(null);
            assert ("true".equals(v)) : "Value is really true: " + v;
            KnockoutTest.getSetInput("false");
            KnockoutTest.triggerEvent("input", "change");
            assert (!m.isEnabled()) : "Boolean property updated: " + m.isEnabled();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void modifyValueAssertChangeInModel() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<h1 data-bind=\"text: helloMessage\">Loading Bck2Brwsr's Hello World...</h1>\nYour name: <input id='input' data-bind=\"value: name\"></input>\n<button id=\"hello\">Say Hello!</button>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setName("Kukuc");
            m.applyBindings();
            String v = KnockoutTest.getSetInput(null);
            assert ("Kukuc".equals(v)) : "Value is really kukuc: " + v;
            KnockoutTest.getSetInput("Jardo");
            KnockoutTest.triggerEvent("input", "change");
            assert ("Jardo".equals(m.getName())) : "Name property updated: " + m.getName();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    private static String getSetSelected(int index, Object value) throws Exception {
        String s = "var index = arguments[0];\nvar value = arguments[1];\nvar n = window.document.getElementById('input'); \n if (value != null) {\n  n.options[index].value = 'me'; \n  n.value = 'me'; \n  ko.dataFor(n.options[index]).archetype(value); // haven't found better way to trigger ko change yet \n} \n var op = n.options[n.selectedIndex]; \nreturn op ? op.text : n.selectedIndex;\n";
        Object ret = Utils.executeScript(KnockoutTest.class, s, index, value);
        return ret == null ? null : ret.toString();
    }

    @KOTest
    public void selectWorksOnModels() throws Exception {
        if (this.js == null) {
            Utils.exposeHTML(KnockoutTest.class, "<select id='input' data-bind=\"options: archetypes,\n                       optionsText: 'name',\n                       value: archetype\">\n                  </select>\n");
            this.js = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            this.js.getArchetypes().add(new ArchetypeData("ko4j", "org.netbeans.html", "0.8.3", "ko4j", "ko4j", null));
            this.js.getArchetypes().add(new ArchetypeData("crud", "org.netbeans.html", "0.8.3", "crud", "crud", null));
            this.js.getArchetypes().add(new ArchetypeData("3rd", "org.netbeans.html", "0.8.3", "3rd", "3rd", null));
            this.js.setArchetype(this.js.getArchetypes().get(1));
            this.js.applyBindings();
            String v = KnockoutTest.getSetSelected(0, null);
            assert ("crud".equals(v)) : "Second index (e.g. crud) is selected: " + v;
            String sel = KnockoutTest.getSetSelected(2, Models.toRaw((Object)this.js.getArchetypes().get(2)));
            assert ("3rd".equals(sel)) : "3rd is selected now: " + sel;
        }
        if (this.js.getArchetype() != this.js.getArchetypes().get(2)) {
            throw new InterruptedException();
        }
        Utils.exposeHTML(KnockoutTest.class, "");
    }

    @KOTest
    public void modifyValueAssertAsyncChangeInModel() throws Exception {
        String v;
        if (this.js == null) {
            Utils.exposeHTML(KnockoutTest.class, "<h1 data-bind=\"text: helloMessage\">Loading Bck2Brwsr's Hello World...</h1>\nYour name: <input id='input' data-bind=\"value: name\"></input>\n<button id=\"hello\">Say Hello!</button>\n");
            this.js = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            this.js.setName("Kukuc");
            this.js.applyBindings();
            v = KnockoutTest.getSetInput(null);
            assert ("Kukuc".equals(v)) : "Value is really kukuc: " + v;
            Timer t = new Timer("Set to Jardo");
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    KnockoutTest.this.js.setName("Jardo");
                }
            }, 1L);
        }
        if (!"Jardo".equals(v = KnockoutTest.getSetInput(null))) {
            throw new InterruptedException();
        }
        Utils.exposeHTML(KnockoutTest.class, "");
    }

    private static String getSetInput(String value) throws Exception {
        String s = "var value = arguments[0];\nvar n = window.document.getElementById('input'); \n if (value != null) n['value'] = value; \n return n['value'];";
        Object ret = Utils.executeScript(KnockoutTest.class, s, value);
        return ret == null ? null : ret.toString();
    }

    public static void triggerEvent(String id, String ev) throws Exception {
        Utils.executeScript(KnockoutTest.class, "ko.utils.triggerEvent(window.document.getElementById(arguments[0]), arguments[1]);", id, ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void displayContentOfArray() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: results'>\n  <li data-bind='text: $data, click: $root.call'/>\n</ul>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getResults().add("Ahoj");
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 1) : "One child, but was " + cnt;
            m.getResults().add("Hi");
            cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 2) : "Two children now, but was " + cnt;
            KnockoutTest.triggerChildClick("ul", 1);
            assert (1 == m.getCallbackCount()) : "One callback " + m.getCallbackCount();
            assert ("Hi".equals(m.getName())) : "We got callback from 2nd child " + m.getName();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    @KOTest
    public void displayContentOfAsyncArray() throws Exception {
        int cnt;
        if (this.js == null) {
            Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: results'>\n  <li data-bind='text: $data, click: $root.call'/>\n</ul>\n");
            this.js = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            this.js.getResults().add("Ahoj");
            this.js.applyBindings();
            cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 1) : "One child, but was " + cnt;
            Timer t = new Timer("add to array");
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    KnockoutTest.this.js.getResults().add("Hi");
                }
            }, 1L);
        }
        if ((cnt = Utils.countChildren(KnockoutTest.class, "ul")) != 2) {
            throw new InterruptedException();
        }
        try {
            KnockoutTest.triggerChildClick("ul", 1);
            assert (1 == this.js.getCallbackCount()) : "One callback " + this.js.getCallbackCount();
            assert ("Hi".equals(this.js.getName())) : "We got callback from 2nd child " + this.js.getName();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void displayContentOfComputedArray() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: bothNames'>\n  <li data-bind='text: $data, click: $root.assignFirstName'/>\n</ul>\n");
        try {
            Pair m = (Pair)Models.bind((Object)new Pair("First", "Last", null), (BrwsrCtx)KnockoutTest.newContext());
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 2) : "Two children now, but was " + cnt;
            KnockoutTest.triggerChildClick("ul", 1);
            assert ("Last".equals(m.getFirstName())) : "We got callback from 2nd child " + m.getFirstName();
            m.setLastName("Verylast");
            cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 2) : "Two children now, but was " + cnt;
            KnockoutTest.triggerChildClick("ul", 1);
            assert ("Verylast".equals(m.getFirstName())) : "We got callback from 2nd child " + m.getFirstName();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void displayContentOfComputedArrayOnASubpair() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<div data-bind='with: next'>\n<ul id='ul' data-bind='foreach: bothNames'>\n  <li data-bind='text: $data, click: $root.assignFirstName'/>\n</ul></div>\n");
        try {
            BrwsrCtx ctx = KnockoutTest.newContext();
            Pair m = (Pair)Models.bind((Object)new Pair(null, null, new Pair("First", "Last", null)), (BrwsrCtx)ctx);
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 2) : "Two children now, but was " + cnt;
            KnockoutTest.triggerChildClick("ul", 1);
            assert (PairModel.ctx == ctx) : "Context remains the same";
            assert ("Last".equals(m.getFirstName())) : "We got callback from 2nd child " + m.getFirstName();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void displayContentOfComputedArrayOnComputedASubpair() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<div data-bind='with: nextOne'>\n<ul id='ul' data-bind='foreach: bothNames'>\n  <li data-bind='text: $data, click: $root.assignFirstName'/>\n</ul></div>\n");
        try {
            Pair m = (Pair)Models.bind((Object)new Pair(null, null, new Pair("First", "Last", null)), (BrwsrCtx)KnockoutTest.newContext());
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 2) : "Two children now, but was " + cnt;
            KnockoutTest.triggerChildClick("ul", 1);
            assert ("Last".equals(m.getFirstName())) : "We got callback from 2nd child " + m.getFirstName();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    @KOTest
    public void checkBoxToBooleanBinding() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<input type='checkbox' id='b' data-bind='checked: enabled'></input>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.applyBindings();
            assert (!m.isEnabled()) : "Is disabled";
            KnockoutTest.triggerClick("b");
            assert (m.isEnabled()) : "Now the model is enabled";
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void displayContentOfDerivedArray() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: cmpResults'>\n  <li><b data-bind='text: $data'></b></li>\n</ul>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getResults().add("Ahoj");
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 1) : "One child, but was " + cnt;
            m.getResults().add("hello");
            cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 2) : "Two children now, but was " + cnt;
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void displayContentOfArrayOfPeople() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: people'>\n  <li data-bind='text: $data.firstName, click: $root.removePerson'></li>\n</ul>\n");
        try {
            BrwsrCtx c = KnockoutTest.newContext();
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)c);
            Person first = (Person)Models.bind((Object)new Person(), (BrwsrCtx)c);
            first.setFirstName("first");
            m.getPeople().add(first);
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 1) : "One child, but was " + cnt;
            Person second = (Person)Models.bind((Object)new Person(), (BrwsrCtx)c);
            second.setFirstName("second");
            m.getPeople().add(second);
            cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 2) : "Two children now, but was " + cnt;
            KnockoutTest.triggerChildClick("ul", 1);
            assert (1 == m.getCallbackCount()) : "One callback " + m.getCallbackCount();
            cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 1) : "Again one child, but was " + cnt;
            String txt = KnockoutTest.childText("ul", 0);
            assert ("first".equals(txt)) : "Expecting 'first': " + txt;
            first.setFirstName("changed");
            txt = KnockoutTest.childText("ul", 0);
            assert ("changed".equals(txt)) : "Expecting 'changed': " + txt;
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    static Person firstPerson(List<Person> people) {
        return people.isEmpty() ? null : people.get(0);
    }

    @KOTest
    public void accessFirstPersonWithOnFunction() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<p id='ul' data-bind='with: firstPerson'>\n  <span data-bind='text: firstName, click: changeSex'></span>\n</p>\n");
        try {
            this.trasfertToFemale();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    @KOTest
    public void onPersonFunction() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: people'>\n  <li data-bind='text: $data.firstName, click: changeSex'></li>\n</ul>\n");
        try {
            this.trasfertToFemale();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    private void trasfertToFemale() throws Exception {
        KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
        Person first = (Person)Models.bind((Object)new Person(), (BrwsrCtx)KnockoutTest.newContext());
        first.setFirstName("first");
        first.setSex(Sex.MALE);
        m.getPeople().add(first);
        m.applyBindings();
        int cnt = Utils.countChildren(KnockoutTest.class, "ul");
        assert (cnt == 1) : "One child, but was " + cnt;
        KnockoutTest.triggerChildClick("ul", 0);
        assert (first.getSex() == Sex.FEMALE) : "Transverted to female: " + (Object)((Object)first.getSex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void stringArrayModificationVisible() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<div>\n<ul id='ul' data-bind='foreach: results'>\n  <li data-bind='text: $data'></li>\n</ul>\n</div>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getResults().add("Ahoj");
            m.getResults().add("Hello");
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 2) : "Two children " + cnt;
            Object arr = Utils.addChildren(KnockoutTest.class, "ul", "results", "Hi");
            assert (arr instanceof Object[]) : "Got back an array: " + arr;
            int len = ((Object[])arr).length;
            assert (len == 3) : "Three elements in the array " + len;
            int newCnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (newCnt == 3) : "Three children in the DOM: " + newCnt;
            assert (m.getResults().size() == 3) : "Three java strings: " + m.getResults();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void intArrayModificationVisible() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<div>\n<ul id='ul' data-bind='foreach: numbers'>\n  <li data-bind='text: $data'></li>\n</ul>\n</div>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getNumbers().add(1);
            m.getNumbers().add(31);
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 2) : "Two children " + cnt;
            Object arr = Utils.addChildren(KnockoutTest.class, "ul", "numbers", 42);
            assert (arr instanceof Object[]) : "Got back an array: " + arr;
            int len = ((Object[])arr).length;
            assert (len == 3) : "Three elements in the array " + len;
            int newCnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (newCnt == 3) : "Three children in the DOM: " + newCnt;
            assert (m.getNumbers().size() == 3) : "Three java ints: " + m.getNumbers();
            assert (m.getNumbers().get(2) == 42) : "Meaning of world: " + m.getNumbers();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void derivedIntArrayModificationVisible() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<div>\n<ul id='ul' data-bind='foreach: resultLengths'>\n  <li data-bind='text: $data'></li>\n</ul>\n</div>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getResults().add("Ahoj");
            m.getResults().add("Hello");
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 2) : "Two children " + cnt;
            Object arr = Utils.addChildren(KnockoutTest.class, "ul", "results", "Hi");
            assert (arr instanceof Object[]) : "Got back an array: " + arr;
            int len = ((Object[])arr).length;
            assert (len == 3) : "Three elements in the array " + len;
            int newCnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (newCnt == 3) : "Three children in the DOM: " + newCnt;
            assert (m.getResultLengths().size() == 3) : "Three java ints: " + m.getResultLengths();
            assert (m.getResultLengths().get(2) == 2) : "Size is two: " + m.getResultLengths();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void archetypeArrayModificationVisible() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<div>\n<ul id='ul' data-bind='foreach: archetypes'>\n  <li data-bind='text: artifactId'></li>\n</ul>\n</div>\n");
        try {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (cnt == 0) : "No children " + cnt;
            Object arr = Utils.addChildren(KnockoutTest.class, "ul", "archetypes", new ArchetypeData("aid", "gid", "v", "n", "d", "u"));
            assert (arr instanceof Object[]) : "Got back an array: " + arr;
            int len = ((Object[])arr).length;
            assert (len == 1) : "One element in the array " + len;
            int newCnt = Utils.countChildren(KnockoutTest.class, "ul");
            assert (newCnt == 1) : "One child in the DOM: " + newCnt;
            assert (m.getArchetypes().size() == 1) : "One archetype: " + m.getArchetypes();
            assert (m.getArchetypes().get(0) != null) : "Not null: " + m.getArchetypes();
            assert (m.getArchetypes().get(0).getArtifactId().equals("aid")) : "'aid' == " + m.getArchetypes();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    static void call(KnockoutModel m, String data) {
        m.setName(data);
        m.setCallbackCount(m.getCallbackCount() + 1);
    }

    static void removePerson(KnockoutModel model, Person data) {
        model.setCallbackCount(model.getCallbackCount() + 1);
        model.getPeople().remove(data);
    }

    static String helloMessage(String name) {
        return "Hello " + name + "!";
    }

    static List<String> cmpResults(List<String> results) {
        return results;
    }

    private static void triggerClick(String id) throws Exception {
        String s = "var id = arguments[0];var e = window.document.getElementById(id);\n if (e.checked) throw 'It should not be checked yet: ' + e;\n var ev = window.document.createEvent('MouseEvents');\n ev.initMouseEvent('click', true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);\n e.dispatchEvent(ev);\n if (!e.checked) {\n  e.checked = true;\n   e.dispatchEvent(ev);\n }\n";
        Utils.executeScript(KnockoutTest.class, s, id);
    }

    private static void triggerChildClick(String id, int pos) throws Exception {
        String s = "var id = arguments[0]; var pos = arguments[1];\nvar e = window.document.getElementById(id);\n var ev = window.document.createEvent('MouseEvents');\n ev.initMouseEvent('click', true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);\n var list = e.childNodes;\nvar cnt = -1;\nfor (var i = 0; i < list.length; i++) {\n  if (list[i].nodeType == 1) cnt++;\n  if (cnt == pos) return list[i].dispatchEvent(ev);\n}\nreturn null;\n";
        Utils.executeScript(KnockoutTest.class, s, id, pos);
    }

    private static String childText(String id, int pos) throws Exception {
        String s = "var id = arguments[0]; var pos = arguments[1];var e = window.document.getElementById(id);\nvar list = e.childNodes;\nvar cnt = -1;\nfor (var i = 0; i < list.length; i++) {\n  if (list[i].nodeType == 1) cnt++;\n  if (cnt == pos) return list[i].innerHTML;\n}\nreturn null;\n";
        return (String)Utils.executeScript(KnockoutTest.class, s, id, pos);
    }

    private static BrwsrCtx newContext() {
        return Utils.newContext(KnockoutTest.class);
    }

    static class ArchModel {
        ArchModel() {
        }
    }

    static enum Choice {
        A,
        B;

    }
}

