/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.util.List;
import net.java.html.BrwsrCtx;
import net.java.html.json.tests.PairModel;
import org.apidesign.html.json.spi.Proto;

public final class Pair
implements Cloneable {
    private static final Html4JavaType TYPE = new Html4JavaType();
    private final Proto proto;
    private String prop_firstName;
    private String prop_lastName;
    private Pair prop_next;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getBothNames() {
        String arg1 = this.getFirstName();
        String arg2 = this.getLastName();
        try {
            this.proto.acquireLock();
            List<String> list = PairModel.bothNames(arg1, arg2);
            return list;
        }
        finally {
            this.proto.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair getNextOne() {
        Pair arg1 = this.getNext();
        try {
            this.proto.acquireLock();
            Pair pair = PairModel.nextOne(arg1);
            return pair;
        }
        finally {
            this.proto.releaseLock();
        }
    }

    public String getFirstName() {
        this.proto.verifyUnlocked();
        return this.prop_firstName;
    }

    public void setFirstName(String v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame(this.prop_firstName, v)) {
            return;
        }
        String o = this.prop_firstName;
        this.prop_firstName = v;
        this.proto.valueHasMutated("firstName", (Object)o, (Object)v);
        this.proto.valueHasMutated("bothNames", null, this.getBothNames());
    }

    public String getLastName() {
        this.proto.verifyUnlocked();
        return this.prop_lastName;
    }

    public void setLastName(String v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame(this.prop_lastName, v)) {
            return;
        }
        String o = this.prop_lastName;
        this.prop_lastName = v;
        this.proto.valueHasMutated("lastName", (Object)o, (Object)v);
        this.proto.valueHasMutated("bothNames", null, this.getBothNames());
    }

    public Pair getNext() {
        this.proto.verifyUnlocked();
        return this.prop_next;
    }

    public void setNext(Pair v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame(this.prop_next, v)) {
            return;
        }
        Pair o = this.prop_next;
        this.prop_next = v;
        this.proto.valueHasMutated("next", (Object)o, (Object)v);
        this.proto.valueHasMutated("nextOne", null, (Object)this.getNextOne());
    }

    private static Class<PairModel> modelFor() {
        return null;
    }

    private Pair(BrwsrCtx context) {
        this.proto = TYPE.createProto(this, context);
    }

    public Pair() {
        this(BrwsrCtx.findDefault(Pair.class));
        this.prop_next = new Pair();
    }

    public Pair(String firstName, String lastName, Pair next) {
        this(BrwsrCtx.findDefault(Pair.class));
        this.prop_firstName = firstName;
        this.prop_lastName = lastName;
        this.prop_next = next;
    }

    private Pair(BrwsrCtx c, Object json) {
        this(c);
        Object[] ret = new Object[3];
        this.proto.extract(json, new String[]{"firstName", "lastName", "next"}, ret);
        this.prop_firstName = (String)ret[0];
        this.prop_lastName = (String)ret[1];
        this.prop_next = (Pair)this.proto.read(Pair.class, ret[2]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append('\"').append("firstName").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_firstName));
        sb.append(',');
        sb.append('\"').append("lastName").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_lastName));
        sb.append(',');
        sb.append('\"').append("next").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_next));
        sb.append('}');
        return sb.toString();
    }

    public Pair clone() {
        return this.clone(this.proto.getContext());
    }

    private Pair clone(BrwsrCtx ctx) {
        Pair ret = new Pair(ctx);
        ret.prop_firstName = this.prop_firstName;
        ret.prop_lastName = this.prop_lastName;
        ret.prop_next = this.prop_next == null ? null : this.prop_next.clone();
        return ret;
    }

    public Pair applyBindings() {
        this.proto.applyBindings();
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair p = (Pair)o;
        if (!TYPE.isSame(this.prop_firstName, p.prop_firstName)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_lastName, p.prop_lastName)) {
            return false;
        }
        return TYPE.isSame(this.prop_next, p.prop_next);
    }

    public int hashCode() {
        int h = Pair.class.getName().hashCode();
        h = TYPE.hashPlus(this.prop_firstName, h);
        h = TYPE.hashPlus(this.prop_lastName, h);
        h = TYPE.hashPlus(this.prop_next, h);
        return h;
    }

    private static class Html4JavaType
    extends Proto.Type<Pair> {
        private Html4JavaType() {
            super(Pair.class, PairModel.class, 5, 1);
            this.registerProperty("bothNames", 0, true);
            this.registerProperty("nextOne", 1, true);
            this.registerProperty("firstName", 2, false);
            this.registerProperty("lastName", 3, false);
            this.registerProperty("next", 4, false);
            this.registerFunction("assignFirstName", 0);
        }

        public void setValue(Pair data, int type, Object value) {
            switch (type) {
                case 2: {
                    data.setFirstName((String)TYPE.extractValue(String.class, value));
                    return;
                }
                case 3: {
                    data.setLastName((String)TYPE.extractValue(String.class, value));
                    return;
                }
                case 4: {
                    data.setNext((Pair)TYPE.extractValue(Pair.class, value));
                    return;
                }
            }
        }

        public Object getValue(Pair data, int type) {
            switch (type) {
                case 0: {
                    return data.getBothNames();
                }
                case 1: {
                    return data.getNextOne();
                }
                case 2: {
                    return data.getFirstName();
                }
                case 3: {
                    return data.getLastName();
                }
                case 4: {
                    return data.getNext();
                }
            }
            throw new UnsupportedOperationException();
        }

        public void call(Pair model, int type, Object data, Object ev) throws Exception {
            switch (type) {
                case 0: {
                    PairModel.assignFirstName(model, model.proto.toString(data, null));
                    return;
                }
            }
            throw new UnsupportedOperationException();
        }

        public Proto protoFor(Object obj) {
            return ((Pair)obj).proto;
        }

        public void onChange(Pair model, int type) {
            throw new UnsupportedOperationException();
        }

        public void onMessage(Pair model, int index, int type, Object data) {
            throw new UnsupportedOperationException("index: " + index + " type: " + type);
        }

        public Pair read(BrwsrCtx c, Object json) {
            return new Pair(c, json);
        }

        public Pair cloneTo(Pair o, BrwsrCtx c) {
            return o.clone(c);
        }
    }
}

