/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.boot.spi;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.html.boot.impl.FnContext;

public abstract class Fn {
    private final Presenter presenter;
    private static final Map<String, Set<Presenter>> LOADED = new HashMap<String, Set<Presenter>>();

    @Deprecated
    protected Fn() {
        this(null);
    }

    protected Fn(Presenter presenter) {
        this.presenter = presenter;
    }

    public final boolean isValid() {
        return this.presenter != null && FnContext.currentPresenter(false) == this.presenter;
    }

    public static boolean isValid(Fn fnOrNull) {
        return fnOrNull != null && fnOrNull.isValid();
    }

    public static Fn define(Class<?> caller, String code, String ... names) {
        Presenter p = FnContext.currentPresenter(false);
        return p == null ? null : p.defineFn(code, names);
    }

    public static Fn preload(final Fn fn, final Class<?> caller, final String resource) {
        return new Fn(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object thiz, Object ... args) throws Exception {
                Presenter p = FnContext.currentPresenter(false);
                HashSet<Presenter> there = (HashSet<Presenter>)LOADED.get(resource);
                if (there == null) {
                    there = new HashSet<Presenter>();
                    LOADED.put(resource, there);
                }
                if (there.add(p)) {
                    InputStream is = caller.getClassLoader().getResourceAsStream(resource);
                    try {
                        InputStreamReader r = new InputStreamReader(is, "UTF-8");
                        p.loadScript(r);
                    }
                    finally {
                        is.close();
                    }
                }
                return fn.invoke(thiz, args);
            }
        };
    }

    public static Presenter activePresenter() {
        return FnContext.currentPresenter(false);
    }

    public static Closeable activate(Presenter p) {
        return FnContext.activate(p);
    }

    public abstract Object invoke(Object var1, Object ... var2) throws Exception;

    protected final Presenter presenter() {
        return this.presenter;
    }

    public static interface FromJavaScript {
        public Object toJava(Object var1);
    }

    public static interface ToJavaScript {
        public Object toJavaScript(Object var1);
    }

    public static interface Presenter {
        public Fn defineFn(String var1, String ... var2);

        public void displayPage(URL var1, Runnable var2);

        public void loadScript(Reader var1) throws Exception;
    }
}

