/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import org.apidesign.html.boot.spi.Fn;
import org.netbeans.html.boot.impl.FnUtils;
import org.netbeans.html.boot.impl.JsPkgCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JsClassLoader
extends ClassLoader {
    JsClassLoader(ClassLoader parent) {
        super(parent);
        this.setDefaultAssertionStatus(JsClassLoader.class.desiredAssertionStatus());
    }

    @Override
    protected abstract URL findResource(String var1);

    @Override
    protected abstract Enumeration<URL> findResources(String var1);

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("javafx")) {
            return Class.forName(name);
        }
        if (name.startsWith("netscape")) {
            return Class.forName(name);
        }
        if (name.startsWith("com.sun")) {
            return Class.forName(name);
        }
        if (name.equals(JsClassLoader.class.getName())) {
            return JsClassLoader.class;
        }
        if (name.equals(Fn.class.getName())) {
            return Fn.class;
        }
        if (name.equals(Fn.Presenter.class.getName())) {
            return Fn.Presenter.class;
        }
        if (name.equals(Fn.ToJavaScript.class.getName())) {
            return Fn.ToJavaScript.class;
        }
        if (name.equals(Fn.FromJavaScript.class.getName())) {
            return Fn.FromJavaScript.class;
        }
        if (name.equals(FnUtils.class.getName())) {
            return FnUtils.class;
        }
        if (name.equals("org.apidesign.html.boot.spi.Fn") || name.equals("org.netbeans.html.boot.impl.FnUtils") || name.equals("org.netbeans.html.boot.impl.FnContext")) {
            return Class.forName(name);
        }
        URL u = this.findResource(name.replace('.', '/') + ".class");
        if (u != null) {
            InputStream is = null;
            try {
                int read;
                is = u.openStream();
                byte[] arr = new byte[is.available()];
                for (int len = 0; len < arr.length; len += read) {
                    read = is.read(arr, len, arr.length - len);
                    if (read != -1) continue;
                    throw new IOException("Can't read " + u);
                }
                is.close();
                is = null;
                if (JsPkgCache.process(this, name)) {
                    arr = FnUtils.transform(arr, this);
                }
                Class<?> clazz = this.defineClass(name, arr, 0, arr.length);
                return clazz;
            }
            catch (IOException ex) {
                throw new ClassNotFoundException("Can't load " + name, ex);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException(null, ex);
                }
            }
        }
        return super.findClass(name);
    }

    protected abstract Fn defineFn(String var1, String ... var2);

    protected abstract void loadScript(Reader var1) throws Exception;
}

