/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.wstyrus;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.html.js.JavaScriptBody;
import org.apidesign.html.boot.spi.Fn;
import org.apidesign.html.json.spi.JSONCall;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

final class LoadJSON
implements Runnable {
    private static final Logger LOG = Logger.getLogger(LoadJSON.class.getName());
    private static final Executor REQ = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });
    private final JSONCall call;
    private final URL base;
    private static Fn $$fn$$getProperty_1;

    private LoadJSON(JSONCall call) {
        this.call = call;
        this.base = null;
    }

    public static void loadJSON(JSONCall call) {
        assert (!"WebSocket".equals(call.getMethod()));
        REQ.execute(new LoadJSON(call));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block24: {
            Object json;
            block23: {
                IOException error = null;
                json = null;
                String url = this.call.isJSONP() ? this.call.composeURL("dummy") : this.call.composeURL(null);
                try {
                    int ch;
                    URL u = new URL(this.base, url.replace(" ", "%20"));
                    URLConnection conn = u.openConnection();
                    if (this.call.isDoOutput()) {
                        conn.setDoOutput(true);
                    }
                    if (this.call.getMethod() != null && conn instanceof HttpURLConnection) {
                        ((HttpURLConnection)conn).setRequestMethod(this.call.getMethod());
                    }
                    if (this.call.isDoOutput()) {
                        OutputStream os = conn.getOutputStream();
                        this.call.writeData(os);
                        os.flush();
                    }
                    PushbackInputStream is = new PushbackInputStream(conn.getInputStream(), 1);
                    boolean array = false;
                    boolean string = false;
                    if (this.call.isJSONP()) {
                        while ((ch = is.read()) != -1) {
                            if (ch == 91) {
                                is.unread(ch);
                                array = true;
                            } else {
                                if (ch != 123) continue;
                                is.unread(ch);
                            }
                            break;
                        }
                    } else {
                        ch = is.read();
                        if (ch == -1) {
                            string = true;
                        } else {
                            array = ch == 91;
                            is.unread(ch);
                            if (!array && ch != 123) {
                                string = true;
                            }
                        }
                    }
                    try {
                        if (string) {
                            throw new JSONException("");
                        }
                        JSONTokener tok = LoadJSON.createTokener(is);
                        JSONArray obj = array ? new JSONArray(tok) : new JSONObject(tok);
                        json = LoadJSON.convertToArray(obj);
                    }
                    catch (JSONException ex) {
                        int ch2;
                        InputStreamReader r = new InputStreamReader((InputStream)is, "UTF-8");
                        StringBuilder sb = new StringBuilder();
                        while ((ch2 = ((Reader)r).read()) != -1) {
                            sb.append((char)ch2);
                        }
                        json = sb.toString();
                    }
                    if (error == null) break block23;
                }
                catch (IOException ex) {
                    error = ex;
                    break block24;
                }
                finally {
                    if (error != null) {
                        this.call.notifyError((Throwable)error);
                    } else {
                        this.call.notifySuccess(json);
                    }
                }
                this.call.notifyError((Throwable)error);
                break block24;
            }
            this.call.notifySuccess(json);
        }
    }

    private static JSONTokener createTokener(InputStream is) throws IOException {
        InputStreamReader r = new InputStreamReader(is, "UTF-8");
        try {
            return new JSONTokener((Reader)r);
        }
        catch (LinkageError ex) {
            int ch;
            StringBuilder sb = new StringBuilder();
            while ((ch = ((Reader)r).read()) != -1) {
                sb.append((char)ch);
            }
            return new JSONTokener(sb.toString());
        }
    }

    static Object convertToArray(Object o) throws JSONException {
        if (o instanceof JSONArray) {
            JSONArray ja = (JSONArray)o;
            Object[] arr = new Object[ja.length()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = LoadJSON.convertToArray(ja.get(i));
            }
            return arr;
        }
        if (o instanceof JSONObject) {
            JSONObject obj = (JSONObject)o;
            Iterator it = obj.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                obj.put(key, LoadJSON.convertToArray(obj.get(key)));
            }
            return obj;
        }
        return o;
    }

    public static void extractJSON(Object jsonObject, String[] props, Object[] values) {
        if (jsonObject instanceof JSONObject) {
            JSONObject obj = (JSONObject)jsonObject;
            for (int i = 0; i < props.length; ++i) {
                try {
                    values[i] = obj.has(props[i]) ? obj.get(props[i]) : null;
                    continue;
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, "Can't read " + props[i] + " from " + jsonObject, ex);
                }
            }
            return;
        }
        for (int i = 0; i < props.length; ++i) {
            values[i] = LoadJSON.getProperty(jsonObject, props[i]);
        }
    }

    @JavaScriptBody(args={"object", "property"}, javacall=false, body="if (property === null) return object;\nif (object === null) return null;\nvar p = object[property]; return p ? p : null;")
    private static Object getProperty(Object object, String string) {
        block3: {
            Fn fn;
            block2: {
                fn = $$fn$$getProperty_1;
                if (Fn.isValid((Fn)fn)) break block2;
                Fn fn2 = Fn.define(LoadJSON.class, (String)"if (property === null) return object;\nif (object === null) return null;\nvar p = object[property]; return p ? p : null;", (String[])new String[]{"object", "property"});
                if (fn2 == null) break block3;
                fn = $$fn$$getProperty_1 = fn2;
            }
            return fn.invoke(null, new Object[]{object, string});
        }
        return null;
    }

    public static Object parse(InputStream is) throws IOException {
        try {
            JSONTokener t = LoadJSON.createTokener(is);
            return new JSONObject(t);
        }
        catch (JSONException ex) {
            throw new IOException(ex);
        }
    }
}

