/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.mojo;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.objectweb.asm.ClassReader;

abstract class ProcessJsAnnotations {
    private Boolean addAsm;
    private final LinkedList<URL> cp = new LinkedList();
    private final List<File> roots = new LinkedList<File>();

    ProcessJsAnnotations() {
    }

    protected abstract void log(String var1);

    public void addClasspathEntry(File f) {
        try {
            this.cp.add(f.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setAddAsm(boolean add) {
        this.addAsm = add;
    }

    public void addRoot(File file) {
        this.roots.add(file);
    }

    public void process() throws IOException {
        MultiFile classes = new MultiFile(this.roots);
        for (File r : this.roots) {
            this.cp.add(r.toURI().toURL());
        }
        URLClassLoader l = new URLClassLoader(this.cp.toArray(new URL[this.cp.size()]));
        Boolean asm = this.addAsm;
        if (asm == null) {
            try {
                l.loadClass(ClassReader.class.getName());
                asm = false;
            }
            catch (ClassNotFoundException ex) {
                asm = true;
            }
        }
        if (asm.booleanValue()) {
            URL loc = ClassReader.class.getProtectionDomain().getCodeSource().getLocation();
            this.cp.addFirst(loc);
            l = new URLClassLoader(this.cp.toArray(new URL[this.cp.size()]));
        }
        MultiFile master = classes.child("META-INF", "net.java.html.js.classes");
        this.processClasses(l, master, classes);
    }

    private void processClasses(ClassLoader l, MultiFile master, MultiFile f) throws IOException {
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            boolean classes = f.child("net.java.html.js.classes").exists();
            MultiFile[] arr = f.listFiles();
            if (arr != null) {
                for (MultiFile file : arr) {
                    if (!classes && !file.isDirectory()) continue;
                    this.processClasses(l, master, file);
                }
            }
        }
        if (!f.isFile() || !f.getName().endsWith(".class")) {
            return;
        }
        byte[] arr = f.readFully();
        byte[] newArr = null;
        try {
            Class<?> fnUtils = l.loadClass("org.netbeans.html.boot.impl.FnUtils");
            Method transform = fnUtils.getMethod("transform", byte[].class, ClassLoader.class);
            newArr = (byte[])transform.invoke(null, arr, l);
            if (newArr == null || newArr == arr) {
                return;
            }
            ProcessJsAnnotations.filterClass(f.getParentFile().child("net.java.html.js.classes"), f.getName());
            ProcessJsAnnotations.filterClass(master, f.getName());
        }
        catch (Exception ex) {
            throw new IOException("Can't process " + f, ex);
        }
        this.log("Processing " + f);
        f.writeArr(newArr);
    }

    private static void filterClass(MultiFile f, String className) throws IOException {
        boolean modified;
        ArrayList<String> arr;
        if (!f.exists()) {
            return;
        }
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        try (BufferedReader r = new BufferedReader(f.reader());){
            String line;
            arr = new ArrayList<String>();
            modified = false;
            while ((line = r.readLine()) != null) {
                if (line.endsWith(className)) {
                    modified = true;
                    continue;
                }
                arr.add(line);
            }
        }
        if (modified) {
            if (arr.isEmpty()) {
                f.delete();
            } else {
                try (BufferedWriter w = new BufferedWriter(f.writer());){
                    for (String l : arr) {
                        w.write(l);
                        w.write("\n");
                    }
                }
            }
        }
    }

    private static final class MultiFile {
        private final List<File> roots;

        MultiFile(List<File> roots) {
            this.roots = roots;
        }

        MultiFile child(String ... names) {
            ArrayList<File> arr = new ArrayList<File>();
            for (File r : this.roots) {
                for (String n : names) {
                    r = new File(r, n);
                }
                arr.add(r);
            }
            return new MultiFile(arr);
        }

        boolean exists() {
            for (File r : this.roots) {
                if (!r.exists()) continue;
                return true;
            }
            return false;
        }

        boolean isDirectory() {
            for (File r : this.roots) {
                if (!r.isDirectory()) continue;
                return true;
            }
            return false;
        }

        String getName() {
            Iterator<File> iterator = this.roots.iterator();
            if (iterator.hasNext()) {
                File r = iterator.next();
                return r.getName();
            }
            return null;
        }

        MultiFile[] listFiles() {
            TreeSet<String> names = new TreeSet<String>();
            for (File r : this.roots) {
                String[] children = r.list();
                if (children == null) continue;
                names.addAll(Arrays.asList(children));
            }
            MultiFile[] arr = new MultiFile[names.size()];
            int at = 0;
            for (String name : names) {
                arr[at++] = this.child(name);
            }
            return arr;
        }

        boolean isFile() {
            for (File r : this.roots) {
                if (!r.isFile()) continue;
                return true;
            }
            return false;
        }

        private MultiFile getParentFile() {
            ArrayList<File> arr = new ArrayList<File>();
            for (File r : this.roots) {
                arr.add(r.getParentFile());
            }
            return new MultiFile(arr);
        }

        byte[] readFully() throws IOException {
            for (File f : this.roots) {
                byte[] arr;
                if (!f.isFile()) continue;
                try (FileInputStream is = new FileInputStream(f);){
                    int read;
                    arr = new byte[(int)f.length()];
                    for (int off = 0; off < arr.length; off += read) {
                        read = is.read(arr, off, arr.length - off);
                        if (read != -1) continue;
                        break;
                    }
                }
                return arr;
            }
            throw new FileNotFoundException();
        }

        private void writeArr(byte[] newArr) throws IOException, FileNotFoundException {
            for (File f : this.roots) {
                if (f.isDirectory()) continue;
                f.getParentFile().mkdirs();
                try (FileOutputStream os = new FileOutputStream(f);){
                    os.write(newArr);
                }
                return;
            }
            throw new FileNotFoundException();
        }

        private Reader reader() throws FileNotFoundException {
            for (File r : this.roots) {
                if (!r.isFile()) continue;
                return new FileReader(r);
            }
            throw new FileNotFoundException();
        }

        private void delete() {
            for (File r : this.roots) {
                r.delete();
            }
        }

        private FileWriter writer() throws IOException {
            for (File r : this.roots) {
                if (!r.isFile()) continue;
                return new FileWriter(r);
            }
            throw new FileNotFoundException();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (File r : this.roots) {
                sb.append(sep);
                sb.append(r.toString());
                sep = ", ";
            }
            return sb.toString();
        }
    }
}

