/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.equinox.agentclass;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.netbeans.html.equinox.agentclass.NbInstrumentation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;

public class AgentHook
implements HookConfigurator,
BundleWatcher,
ClassLoadingHook {
    private static final Logger LOG = Logger.getLogger(AgentHook.class.getName());
    private boolean all;

    public void addHooks(HookRegistry hookRegistry) {
        LOG.info("Agent hook for Equinox initialized!");
        hookRegistry.addWatcher((BundleWatcher)this);
        hookRegistry.addClassLoadingHook((ClassLoadingHook)this);
    }

    public void watchBundle(Bundle bundle, int type) {
        BundleContext c;
        if (!this.all && (c = bundle.getBundleContext()) != null) {
            Bundle[] arr;
            for (Bundle b : arr = bundle.getBundleContext().getBundles()) {
                this.agentBundle(b);
            }
            this.all = true;
        }
        if (type == 8) {
            this.agentBundle(bundle);
        }
    }

    private void agentBundle(Bundle bundle) {
        String agentClass = (String)bundle.getHeaders().get("Agent-Class");
        if (agentClass != null) {
            try {
                Class agent = bundle.loadClass(agentClass);
                NbInstrumentation.registerAgent(agent.getClassLoader(), agent.getName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public byte[] processClass(String name, byte[] bytes, ClasspathEntry ce, BundleEntry entry, ClasspathManager manager) {
        BaseData bd = ce.getBaseData();
        if (bd == null) {
            return bytes;
        }
        Bundle b = bd.getBundle();
        if (b == null) {
            return bytes;
        }
        BundleWiring w = (BundleWiring)b.adapt(BundleWiring.class);
        if (w == null) {
            return bytes;
        }
        ClassLoader loader = w.getClassLoader();
        try {
            return NbInstrumentation.patchByteCode(loader, name, ce.getDomain(), bytes);
        }
        catch (IllegalClassFormatException e) {
            return bytes;
        }
    }

    public boolean addClassPathEntry(ArrayList cpEntries, String cp, ClasspathManager hostmanager, BaseData sourcedata, ProtectionDomain sourcedomain) {
        return false;
    }

    public String findLibrary(BaseData data, String libName) {
        return null;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public BaseClassLoader createClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, BundleProtectionDomain domain, BaseData data, String[] bundleclasspath) {
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData data) {
    }
}

