/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.EnumSet;
import java.util.Enumeration;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import nu.validator.servlet.InboundGzipFilter;
import nu.validator.servlet.InboundSizeLimitFilter;
import nu.validator.servlet.MultipartFormDataFilter;
import nu.validator.servlet.VerifierServlet;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class Main {
    private static final String BIND_ADDRESS = System.getProperty("nu.validator.servlet.bind-address", "0.0.0.0");
    private static final long SIZE_LIMIT = Integer.parseInt(System.getProperty("nu.validator.servlet.max-file-size", "2097152"));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean isRunningInsideDockerContainer() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/proc/1/cgroup"), "UTF-8"));){
            String line;
            do {
                if ((line = reader.readLine()) == null) return false;
            } while (!line.contains("/docker/"));
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static final void emitStartupMessage(Logger log4j, String host, int port) {
        if (Main.isRunningInsideDockerContainer()) {
            log4j.debug((Object)"");
            log4j.debug((Object)"Checker service started.");
            return;
        }
        log4j.debug((Object)"");
        log4j.debug((Object)"WARNING: Future checker releases will bind by default to 127.0.0.1.");
        log4j.debug((Object)"Your checker deployment might become unreachable unless you use the");
        log4j.debug((Object)"nu.validator.servlet.bind-address system property or --bind-address");
        log4j.debug((Object)"script option to bind the checker to a different address:");
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    String ip = addr.getHostAddress();
                    if (!(addr instanceof Inet4Address)) continue;
                    log4j.debug((Object)"");
                    log4j.debug((Object)String.format("  python ./checker.py --bind-address %s run", ip));
                    log4j.debug((Object)String.format("  java -Dnu.validator.servlet.bind-address=%s -cp vnu.jar nu.validator.servlet.Main 8888", ip));
                    log4j.debug((Object)String.format("  vnu-runtime-image/bin/java -Dnu.validator.servlet.bind-address=%s nu.validator.servlet.Main 8888", ip));
                    log4j.debug((Object)String.format("  vnu-runtime-image\\bin\\java.exe -Dnu.validator.servlet.bind-address=%s nu.validator.servlet.Main 8888", ip));
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        log4j.debug((Object)"");
        log4j.debug((Object)String.format("Checker service started at http://%s:%s/", host, port));
    }

    public static void main(String[] args) throws Exception {
        block55: {
            if (!"1".equals(System.getProperty("nu.validator.servlet.read-local-log4j-properties"))) {
                PropertyConfigurator.configure((URL)Main.class.getClassLoader().getResource("nu/validator/localentities/files/log4j.properties"));
            } else {
                PropertyConfigurator.configure((String)System.getProperty("nu.validator.servlet.log4j-properties", "log4j.properties"));
            }
            Logger log4j = Logger.getLogger(Main.class);
            ConsoleAppender console = new ConsoleAppender();
            console.setLayout((Layout)new PatternLayout("%m%n"));
            console.activateOptions();
            log4j.setAdditivity(false);
            log4j.addAppender((Appender)console);
            ServletContextHandler contextHandler = new ServletContextHandler();
            contextHandler.setContextPath("/");
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setIncludedMethods(new String[]{"POST", "GET"});
            gzipHandler.setInflateBufferSize(2048);
            gzipHandler.setHandler((Handler)contextHandler);
            contextHandler.addFilter(new FilterHolder((Filter)new InboundSizeLimitFilter(SIZE_LIMIT)), "/*", EnumSet.of(DispatcherType.REQUEST));
            contextHandler.addFilter(new FilterHolder((Filter)new InboundGzipFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
            contextHandler.addFilter(new FilterHolder((Filter)new MultipartFormDataFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
            contextHandler.addServlet(new ServletHolder((Servlet)new VerifierServlet()), "/*");
            Server server = new Server((ThreadPool)new QueuedThreadPool(100));
            server.setHandler((Handler)contextHandler);
            server.setHandler((Handler)gzipHandler);
            ServerConnector serverConnector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(new HttpConfiguration()), new HTTP2CServerConnectionFactory(new HttpConfiguration())});
            int port = args.length > 0 ? Integer.parseInt(args[0]) : 8888;
            serverConnector.setPort(port);
            serverConnector.setHost(BIND_ADDRESS);
            server.setConnectors(new Connector[]{serverConnector});
            int stopPort = -1;
            if (args.length > 1) {
                stopPort = Integer.parseInt(args[1]);
            }
            if (stopPort != -1) {
                Throwable throwable;
                Throwable throwable2;
                try {
                    throwable2 = null;
                    try (Socket clientSocket = new Socket(InetAddress.getByName("127.0.0.1"), stopPort);){
                        throwable = null;
                        try (InputStream in = clientSocket.getInputStream();){
                            in.read();
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable in) {
                        throwable2 = in;
                        throw in;
                    }
                }
                catch (ConnectException clientSocket) {
                    // empty catch block
                }
                server.start();
                Main.emitStartupMessage(log4j, serverConnector.getHost(), port);
                throwable2 = null;
                try (ServerSocket serverSocket = new ServerSocket(stopPort, 0, InetAddress.getByName("127.0.0.1"));){
                    throwable = null;
                    try (Socket s = serverSocket.accept();){
                        server.stop();
                        s.getOutputStream().close();
                        break block55;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
            }
            server.start();
            Main.emitStartupMessage(log4j, serverConnector.getHost(), port);
        }
    }
}

