/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import nu.validator.datatype.AbstractDatatype;
import org.relaxng.datatype.DatatypeException;

public final class FloatingPointExponentPositive
extends AbstractDatatype {
    public static final FloatingPointExponentPositive THE_INSTANCE = new FloatingPointExponentPositive();

    private FloatingPointExponentPositive() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        State state = State.AT_START;
        boolean zero = true;
        block16: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (state) {
                case AT_START: {
                    if (c == '-') {
                        throw this.newDatatypeException(i, "A positive floating point number cannot start with the minus sign.");
                    }
                    if (c == '.') {
                        state = State.DOT_SEEN;
                        continue block16;
                    }
                    if (this.isAsciiDigit(c)) {
                        if (c != '0') {
                            zero = false;
                        }
                        state = State.IN_INTEGER_PART_DIGITS_SEEN;
                        continue block16;
                    }
                    throw this.newDatatypeException(i, "Expected a digit but saw ", c, " instead.");
                }
                case IN_INTEGER_PART_DIGITS_SEEN: {
                    if (c == '.') {
                        state = State.DOT_SEEN;
                        continue block16;
                    }
                    if (c == 'e' || c == 'E') {
                        state = State.E_SEEN;
                        continue block16;
                    }
                    if (this.isAsciiDigit(c)) {
                        if (c == '0') continue block16;
                        zero = false;
                        continue block16;
                    }
                    throw this.newDatatypeException(i, "Expected a decimal point, \u201ce\u201d, \u201cE\u201d or a digit but saw ", c, " instead.");
                }
                case DOT_SEEN: {
                    if (this.isAsciiDigit(c)) {
                        if (c != '0') {
                            zero = false;
                        }
                        state = State.IN_DECIMAL_PART_DIGITS_SEEN;
                        continue block16;
                    }
                    throw this.newDatatypeException(i, "Expected a digit after the decimal point but saw ", c, " instead.");
                }
                case IN_DECIMAL_PART_DIGITS_SEEN: {
                    if (this.isAsciiDigit(c)) {
                        if (c == '0') continue block16;
                        zero = false;
                        continue block16;
                    }
                    if (c == 'e' || c == 'E') {
                        state = State.E_SEEN;
                        continue block16;
                    }
                    throw this.newDatatypeException(i, "Expected \u201ce\u201d, \u201cE\u201d or a digit but saw ", c, " instead.");
                }
                case E_SEEN: {
                    if (c == '-' || c == '+') {
                        state = State.IN_EXPONENT_SIGN_SEEN;
                        continue block16;
                    }
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_EXPONENT_DIGITS_SEEN;
                        continue block16;
                    }
                    throw this.newDatatypeException(i, "Expected a minus sign, a plus sign or a digit but saw ", c, " instead.");
                }
                case IN_EXPONENT_SIGN_SEEN: {
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_EXPONENT_DIGITS_SEEN;
                        continue block16;
                    }
                    throw this.newDatatypeException(i, "Expected a digit but saw ", c, " instead.");
                }
                case IN_EXPONENT_DIGITS_SEEN: {
                    if (this.isAsciiDigit(c)) continue block16;
                    throw this.newDatatypeException(i, "Expected a digit but saw ", c, " instead.");
                }
            }
        }
        switch (state) {
            case IN_INTEGER_PART_DIGITS_SEEN: 
            case IN_DECIMAL_PART_DIGITS_SEEN: 
            case IN_EXPONENT_DIGITS_SEEN: {
                if (zero) {
                    throw this.newDatatypeException("Zero is not a valid positive floating point number.");
                }
                return;
            }
            case AT_START: {
                throw this.newDatatypeException("The empty string is not a valid positive floating point number.");
            }
            case DOT_SEEN: {
                throw this.newDatatypeException("A positive floating point number must not end with the decimal point.");
            }
            case E_SEEN: {
                throw this.newDatatypeException("A positive floating point number must not end with the exponent \u201ce\u201d.");
            }
            case IN_EXPONENT_SIGN_SEEN: {
                throw this.newDatatypeException("A positive floating point number must not end with only a sign in the exponent.");
            }
        }
    }

    @Override
    public String getName() {
        return "positive floating point number";
    }

    private static enum State {
        AT_START,
        IN_INTEGER_PART_DIGITS_SEEN,
        DOT_SEEN,
        E_SEEN,
        IN_DECIMAL_PART_DIGITS_SEEN,
        IN_EXPONENT_SIGN_SEEN,
        IN_EXPONENT_DIGITS_SEEN;

    }
}

