/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.tooling;

import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.metaclass.MultipleSetterProperty;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtensionsSchema;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.gradle.plugin.use.PluginId;
import org.gradle.util.GradleVersion;
import org.netbeans.modules.gradle.tooling.GradleInternalAdapter;
import org.netbeans.modules.gradle.tooling.NbProjectInfoModel;
import org.netbeans.modules.gradle.tooling.NeedOnlineModeException;
import org.netbeans.modules.gradle.tooling.TypeUtils;
import org.netbeans.modules.gradle.tooling.internal.NbProjectInfo;

class NbProjectInfoBuilder {
    private static final Logger LOG = Logging.getLogger(NbProjectInfoBuilder.class);
    private static final String DEFAULT_EXTENSION_NAME = "ext";
    private static final String NB_PREFIX = "netbeans.";
    private static final Set<String> CONFIG_EXCLUDES = new HashSet<String>(Arrays.asList("archives", "checkstyle", "classycle", "codenarc", "findbugs", "findbugsPlugins", "jacocoAgent", "jacocoAnt", "jdepend", "pmd", ".*DependenciesMetadata"));
    private static final Pattern CONFIG_EXCLUDES_PATTERN = Pattern.compile(CONFIG_EXCLUDES.stream().reduce("", (s1, s2) -> s1 + "|" + s2));
    private static final Set<String> RECOGNISED_PLUGINS = new HashSet<String>(Arrays.asList("antlr", "application", "base", "checkstyle", "com.android.application", "com.android.library", "com.github.lkishalmi.gatling", "distribution", "ear", "findbugs", "groovy", "groovy-base", "io.micronaut.application", "ivy-publish", "jacoco", "java", "java-base", "java-library-distribution", "java-platform", "maven", "maven-publish", "org.jetbrains.kotlin.js", "org.jetbrains.kotlin.jvm", "org.jetbrains.kotlin.android", "org.springframework.boot", "osgi", "play", "pmd", "scala", "scala-base", "war"));
    private static final GradleVersion GRADLE_VERSION = GradleVersion.current().getBaseVersion();
    final Project project;
    final GradleInternalAdapter adapter;
    private NbProjectInfoModel model = new NbProjectInfoModel();
    private static final Set<String> EXCLUDE_TASK_PROPERTIES = new HashSet<String>(Arrays.asList("dependsOn", "project", "actions", "taskDependencies", "dependsOn", "ant", "logger", "logging", "outputs", "destroyables", "mustRunAfter", "finalizedBy", "shouldRunAfter", "enabled", "description", "group"));
    private static final Set<String> IGNORED_SYSTEM_PROPERTIES = new HashSet<String>(Arrays.asList("asDynamicObject", "convention", "class", "conventionMapping", "extensions", "modelIdentityDisplayName", "project", "taskThatOwnsThisObject", "additionalMethods", "elementsAsDynamicObject", "collectionSchema", "didWork", "onlyIf"));
    private static final String[] IGNORED_SYSTEM_CLASSES_REGEXP = new String[]{"java\\..*", "org\\.gradle\\.api\\.file\\..*", "org\\.gradle\\.api\\.tasks\\..*", "org\\.gradle\\.api\\.reflect\\..*", "org\\.gradle\\.api\\.NamedDomainObject.*", "org\\.gradle\\.api\\.internal\\..*", "org.gradle.api.internal.tasks.DefaultTaskDependency", "org\\.gradle\\.api\\.specs\\..*"};
    public static final String COLLECTION_TYPE_MARKER = "#col";
    public static final String COLLECTION_TYPE_NAMED = "named";
    public static final String COLLECTION_TYPE_MAP = "map";
    public static final String COLLECTION_TYPE_LIST = "list";
    public static final String COLLECTION_ITEM_MARKER = "#itemType";
    public static final String COLLECTION_ITEM_PREFIX = "#itemType.";
    public static final String COLLECTION_CONTENT_PREFIX = "#content";
    public static final String COLLECTION_KEYS_MARKER = "#keys";
    private Pattern ignoreClassesPattern;
    Map<String, Map<String, String>> globalTypes = new HashMap<String, Map<String, String>>();
    Map<String, String> propertyTypes = new HashMap<String, String>();
    Map<String, Object> values = new HashMap<String, Object>();

    NbProjectInfoBuilder(Project project) {
        this.project = project;
        this.adapter = this.sinceGradleOrDefault("7.6", () -> new GradleInternalAdapter.Gradle76(project), () -> new GradleInternalAdapter(project));
    }

    public NbProjectInfo buildAll() {
        this.adapter.setModel(this.model);
        this.runAndRegisterPerf(this.model, "meta", this::detectProjectMetadata);
        this.detectProps(this.model);
        this.detectLicense(this.model);
        this.runAndRegisterPerf(this.model, "plugins", this::detectPlugins);
        this.runAndRegisterPerf(this.model, "sources", this::detectSources);
        this.detectTests(this.model);
        this.runAndRegisterPerf(this.model, "dependencies", this::detectDependencies);
        this.runAndRegisterPerf(this.model, "artifacts", this::detectArtifacts);
        this.detectDistributions(this.model);
        this.sinceGradle("7.0", () -> this.runAndRegisterPerf(this.model, "detectExtensions", this::detectExtensions));
        this.sinceGradle("7.0", () -> this.runAndRegisterPerf(this.model, "detectPlugins2", this::detectAdditionalPlugins));
        this.sinceGradle("7.0", () -> this.runAndRegisterPerf(this.model, "taskDependencies", this::detectTaskDependencies));
        this.runAndRegisterPerf(this.model, "taskProperties", this::detectTaskProperties);
        this.runAndRegisterPerf(this.model, "artifacts", this::detectConfigurationArtifacts);
        this.storeGlobalTypes(this.model);
        return this.model;
    }

    private void detectDistributions(NbProjectInfoModel model) {
        if (this.project.getPlugins().hasPlugin("distribution")) {
            DistributionContainer distributions = (DistributionContainer)this.project.getExtensions().findByType(DistributionContainer.class);
            model.getInfo().put("distributions", NbProjectInfoBuilder.storeSet(distributions.getNames()));
        }
    }

    private void detectLicense(NbProjectInfoModel model) {
        String license;
        String string = license = this.project.hasProperty("netbeans.license") ? this.project.property("netbeans.license").toString() : null;
        if (license == null) {
            license = this.project.hasProperty("license") ? this.project.property("license").toString() : null;
        }
        model.getInfo().put("license", license);
    }

    private void addTypes(Class c, Set<Class> types) {
        if (c == null || !types.add(c)) {
            return;
        }
        if (c.getSuperclass() != Object.class) {
            this.addTypes(c.getSuperclass(), types);
        }
        for (Class<?> i : c.getInterfaces()) {
            this.addTypes(i, types);
        }
    }

    private String getTaskInheritance(Task t) {
        Class nonDecorated = NbProjectInfoBuilder.findNonDecoratedClass(t.getClass());
        HashSet<Class> classes = new HashSet<Class>();
        this.addTypes(nonDecorated, classes);
        return classes.stream().map(Class::getName).sorted().collect(Collectors.joining(","));
    }

    private void detectTaskProperties(NbProjectInfoModel model) {
        HashMap<String, Object> taskProperties = new HashMap<String, Object>();
        HashMap<String, String> taskPropertyTypes = new HashMap<String, String>();
        for (Task task : new ArrayList(this.project.getTasks().getAsMap().values())) {
            Class<?> taskClass = task.getClass();
            Class nonDecorated = NbProjectInfoBuilder.findNonDecoratedClass(taskClass);
            taskPropertyTypes.put(task.getName(), nonDecorated.getName());
            this.inspectObjectAndValues(taskClass, task, task.getName() + ".", this.globalTypes, taskPropertyTypes, taskProperties, EXCLUDE_TASK_PROPERTIES, true);
        }
        model.getInfo().put("tasks.propertyValues", taskProperties);
        model.getInfo().put("tasks.propertyTypes", taskPropertyTypes);
    }

    private void detectTaskDependencies(NbProjectInfoModel model) {
        HashMap tasks = new HashMap();
        for (Task task : new ArrayList(this.project.getTasks().getAsMap().values())) {
            HashMap<String, String> taskInfo = new HashMap<String, String>();
            taskInfo.put("name", task.getPath());
            taskInfo.put("enabled", Boolean.toString(task.getEnabled()));
            taskInfo.put("mustRunAfter", this.dependenciesAsString(task, task.getMustRunAfter()));
            taskInfo.put("shouldRunAfter", this.dependenciesAsString(task, task.getShouldRunAfter()));
            taskInfo.put("taskDependencies", this.dependenciesAsString(task, task.getTaskDependencies()));
            Class<?> taskClass = task.getClass();
            Class nonDecorated = NbProjectInfoBuilder.findNonDecoratedClass(taskClass);
            taskInfo.put("type", nonDecorated.getName());
            taskInfo.put("inherits", this.getTaskInheritance(task));
            tasks.put(task.getName(), taskInfo);
        }
        model.getInfo().put("taskDetails", tasks);
    }

    private String dependenciesAsString(Task t, TaskDependency td) {
        try {
            Set deps = td.getDependencies(t);
            if (deps.isEmpty()) {
                return "";
            }
            return deps.stream().map(Task::getPath).collect(Collectors.joining(","));
        }
        catch (LinkageError | RuntimeException ex) {
            LOG.warn("Error getting dependencies for task {}: {}", new Object[]{t.getName(), ex.getLocalizedMessage(), ex});
            return "";
        }
    }

    private void detectConfigurationArtifacts(NbProjectInfoModel model) {
        List configs = this.project.getConfigurations().stream().filter(Configuration::isCanBeConsumed).filter(c -> !c.isCanBeResolved()).sorted(Comparator.comparing(Configuration::getName)).collect(Collectors.toList());
        HashMap data = new HashMap();
        for (Configuration c2 : configs) {
            PublishArtifactSet publishSet = c2.getAllArtifacts();
            if (publishSet.isEmpty()) continue;
            HashMap confData = new HashMap();
            LOG.lifecycle("Configuration {} artifacts:", new Object[]{c2.getName()});
            for (PublishArtifact a : publishSet) {
                HashMap<String, String> artData = new HashMap<String, String>();
                artData.put("name", a.getName());
                artData.put("classifier", a.getClassifier());
                artData.put("extension", a.getExtension());
                artData.put("type", a.getType());
                File f = a.getFile();
                LOG.info("\t{}: name: {}, type: {}, classifier: {}, extension: {}", new Object[]{f.getPath(), a.getName(), a.getType(), a.getClassifier(), a.getExtension()});
                Set tasks = a.getBuildDependencies().getDependencies(null);
                String taskList = tasks.stream().map(t -> t.getName()).collect(Collectors.joining(","));
                artData.put("buildDeps", taskList);
                LOG.info("\tbuilt by: {}", (Object)taskList);
                confData.put(f.getPath(), artData);
            }
            data.put(c2.getName(), confData);
        }
        model.getInfo().put("configurationArtifacts", data);
    }

    private void detectAdditionalPlugins(NbProjectInfoModel model) {
        if (!this.adapter.hasPluginManager()) {
            return;
        }
        LOG.lifecycle("Detecting additional plugins");
        LinkedHashSet plugins = new LinkedHashSet();
        this.project.getPlugins().matching(p -> {
            for (Class<?> c = p.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
                Optional<PluginId> id = this.adapter.findPluginId(c);
                if (!id.isPresent()) continue;
                LOG.info("Plugin: {} -> {}", (Object)id.get(), p);
                plugins.add(id.get().getId());
                break;
            }
            return false;
        }).toArray();
        ((Set)model.getInfo().get("plugins")).addAll(plugins);
    }

    private void runAndRegisterPerf(NbProjectInfoModel model, String s, Consumer<NbProjectInfoModel> r) {
        this.runAndRegisterPerf(model, s, () -> r.accept(model));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAndRegisterPerf(NbProjectInfoModel model, String s, Runnable r) {
        long time = System.currentTimeMillis();
        try {
            r.run();
        }
        finally {
            long span = System.currentTimeMillis() - time;
            model.registerPerf(s, span);
        }
    }

    private void storeGlobalTypes(NbProjectInfoModel model) {
        model.getInfo().put("extensions.globalTypes", this.globalTypes);
    }

    private void detectExtensions(NbProjectInfoModel model) {
        StringBuilder sb = new StringBuilder();
        for (String s : IGNORED_SYSTEM_CLASSES_REGEXP) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(s);
        }
        this.ignoreClassesPattern = Pattern.compile(sb.toString());
        this.inspectExtensions("", this.project.getExtensions());
        model.getInfo().put("extensions.propertyTypes", this.propertyTypes);
        model.getInfo().put("extensions.propertyValues", this.values);
    }

    private Class findIterableItemClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Map<TypeVariable<?>, Type> parameters = TypeUtils.getTypeArguments(clazz, Iterable.class);
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        for (Map.Entry<TypeVariable<?>, Type> e : parameters.entrySet()) {
            TypeVariable<?> tv = e.getKey();
            if (tv.getGenericDeclaration() != Iterable.class) continue;
            Type t = e.getValue();
            if (!(t instanceof Class) || t == Object.class) {
                return null;
            }
            return (Class)t;
        }
        return null;
    }

    private static boolean isPrimitiveOrString(Class c) {
        if (c == Object.class) {
            return false;
        }
        String n = c.getName();
        return c.isPrimitive() || n.startsWith("java.lang.");
    }

    private void inspectObjectAndValues(Class clazz, Object object, String prefix, Map<String, Map<String, String>> globalTypes, Map<String, String> propertyTypes, Map<String, Object> defaultValues) {
        this.inspectObjectAndValues(clazz, object, prefix, globalTypes, propertyTypes, defaultValues, null, true);
    }

    private void inspectObjectAndValues(Class clazz, Object object, String prefix, Map<String, Map<String, String>> globalTypes, Map<String, String> propertyTypes, Map<String, Object> defaultValues, Set<String> excludes, boolean type) {
        try {
            this.inspectObjectAndValues0(clazz, object, prefix, globalTypes, propertyTypes, defaultValues, excludes, type);
        }
        catch (RuntimeException ex) {
            LOG.warn("Error during inspection of {}, value {}, prefix {}", new Object[]{clazz, object, prefix});
        }
    }

    private boolean isMutableType(Object potentialValue) {
        return this.adapter.isMutableType(potentialValue);
    }

    private void addNestedKeys(String prefix, Map<String, String> propertyTypes, Collection<String> keys) {
        propertyTypes.merge(prefix + COLLECTION_KEYS_MARKER, String.join((CharSequence)";;", keys), (old, add) -> {
            ArrayList<String> oldList = new ArrayList<String>(Arrays.asList(old.split(";;")));
            List<String> newList = Arrays.asList(add.split(";;"));
            oldList.addAll(newList);
            return String.join((CharSequence)";;", oldList);
        });
    }

    private void inspectObjectAndValues0(Class clazz, Object object, String prefix, Map<String, Map<String, String>> globalTypes, Map<String, String> propertyTypes, Map<String, Object> defaultValues, Set<String> excludes, boolean type) {
        Class nonDecorated = NbProjectInfoBuilder.findNonDecoratedClass(clazz);
        String typeKey = prefix;
        typeKey = prefix.endsWith(".") ? prefix.substring(0, prefix.length() - 1) : prefix;
        if (type && propertyTypes.putIfAbsent(typeKey, nonDecorated.getName()) != null && object == null) {
            return;
        }
        if (clazz == null || clazz.isEnum()) {
            return;
        }
        if (clazz.isArray() || excludes == null && this.ignoreClassesPattern.matcher(clazz.getName()).matches()) {
            this.dumpValue(object, typeKey, propertyTypes, defaultValues, clazz, null);
            return;
        }
        MetaClass mclazz = GroovySystem.getMetaClassRegistry().getMetaClass(clazz);
        Map globTypes = globalTypes.computeIfAbsent(nonDecorated.getName(), cn -> new HashMap());
        List props = mclazz.getProperties();
        ArrayList<String> addedKeys = new ArrayList<String>();
        for (MetaProperty mp : props) {
            String newPrefix;
            Class propertyDeclaringClass = null;
            String getterName = null;
            String propName = mp.getName();
            if (excludes != null && excludes.contains(propName) || IGNORED_SYSTEM_PROPERTIES.contains(propName)) continue;
            LOG.info("Inspecting {}.{}", (Object)clazz.getName(), (Object)propName);
            Class t = mp.getType();
            if (t == Object.class && mp instanceof MultipleSetterProperty) {
                MultipleSetterProperty msp = (MultipleSetterProperty)mp;
                t = msp.getGetter().getReturnType();
            }
            if (mp instanceof MetaBeanProperty) {
                MetaBeanProperty mbp = (MetaBeanProperty)mp;
                if (mbp.getGetter() == null) continue;
                if (mbp.getSetter() == null) {
                    Object potentialValue;
                    if (object == null) continue;
                    try {
                        potentialValue = mclazz.getProperty(object, propName);
                    }
                    catch (RuntimeException ex) {
                        continue;
                    }
                    if (!this.isMutableType(potentialValue)) continue;
                }
                getterName = mbp.getGetter().getName();
                propertyDeclaringClass = mbp.getGetter().getDeclaringClass().getTheClass();
            }
            ArrayList<Type> typeParameters = null;
            if (propertyDeclaringClass != null && t.getTypeParameters().length > 0) {
                try {
                    Method m = propertyDeclaringClass.getDeclaredMethod(getterName, new Class[0]);
                    Type rt = m.getGenericReturnType();
                    if (rt instanceof ParameterizedType) {
                        typeParameters = new ArrayList<Type>(Arrays.asList(((ParameterizedType)rt).getActualTypeArguments()));
                    }
                }
                catch (ReflectiveOperationException m) {
                    // empty catch block
                }
            }
            Object value = null;
            if ((mp.getModifiers() & 1) == 0) continue;
            if (object != null) {
                try {
                    ValueAndType vt;
                    value = mclazz.getProperty(object, propName);
                    if (Provider.class.isAssignableFrom(t) && (vt = this.adapter.findPropertyValueInternal(propName, value)) != null) {
                        t = vt.type;
                        if (vt.value.isPresent()) {
                            value = vt.value.get();
                        }
                    }
                }
                catch (RuntimeException vt) {
                    // empty catch block
                }
            }
            if (value != null && !(value instanceof Provider)) {
                if (NbProjectInfoBuilder.isPrimitiveOrString(value.getClass())) {
                    defaultValues.put(prefix + propName, value);
                } else {
                    try {
                        defaultValues.put(prefix + propName, value.toString());
                    }
                    catch (RuntimeException ex) {
                        LOG.info("Could not get value of {}", (Object)propName, (Object)ex);
                    }
                }
            }
            addedKeys.add(propName);
            String cn2 = NbProjectInfoBuilder.findNonDecoratedClass(t).getName();
            globTypes.put(propName, cn2);
            propertyTypes.put(prefix + propName, cn2);
            boolean dumped = false;
            if (value == null) continue;
            Class itemClass = null;
            if (value instanceof NamedDomainObjectContainer && value instanceof HasPublicType) {
                TypeOf pubType = ((HasPublicType)value).getPublicType();
                itemClass = pubType != null && pubType.getComponentType() != null ? pubType.getComponentType().getConcreteClass() : this.findIterableItemClass(pubType.getConcreteClass());
                propertyTypes.put(prefix + propName + COLLECTION_TYPE_MARKER, COLLECTION_TYPE_NAMED);
                propertyTypes.put(prefix + propName, NbProjectInfoBuilder.findNonDecoratedClass(t).getName());
                if (itemClass != null) {
                    propertyTypes.put(prefix + propName + COLLECTION_ITEM_MARKER, itemClass.getName());
                    newPrefix = prefix + propName + COLLECTION_ITEM_PREFIX;
                    this.inspectObjectAndValues(itemClass, null, newPrefix, globalTypes, propertyTypes, defaultValues);
                }
                NamedDomainObjectContainer nc = (NamedDomainObjectContainer)value;
                HashMap m = new HashMap(nc.getAsMap());
                this.dumpContainerProperties(m, prefix + propName, defaultValues);
                dumped = true;
            } else {
                dumped = this.dumpValue(value, prefix + propName, propertyTypes, defaultValues, t, typeParameters);
            }
            if (dumped || NbProjectInfoBuilder.isPrimitiveOrString(t) || Provider.class.isAssignableFrom(t)) continue;
            newPrefix = prefix + propName + ".";
            this.inspectObjectAndValues(t, value, newPrefix, globalTypes, propertyTypes, defaultValues);
        }
        this.addNestedKeys(typeKey, propertyTypes, addedKeys);
    }

    private void dumpContainerProperties(Map<String, ?> m, String prefix, Map<String, Object> defaultValues) {
        this.addNestedKeys(prefix, this.propertyTypes, m.keySet());
        for (Map.Entry<String, ?> it : m.entrySet()) {
            String k = it.getKey();
            String newPrefix = prefix + "." + k + ".";
            Object v = it.getValue();
            if (v == null) {
                defaultValues.put(prefix + "." + k, null);
                continue;
            }
            defaultValues.put(prefix + "." + k, Objects.toString(v));
            this.inspectObjectAndValues(v.getClass(), v, newPrefix, this.globalTypes, this.propertyTypes, defaultValues, null, false);
        }
    }

    private boolean dumpValue(Object value, String prefix, Map<String, String> propertyTypes, Map<String, Object> defaultValues, Class t, List<Type> typeParameters) {
        Class itemClass = null;
        String cn = null;
        boolean dumped = false;
        if (value instanceof NamedDomainObjectContainer && value instanceof HasPublicType) {
            String newPrefix;
            TypeOf pubType = ((HasPublicType)value).getPublicType();
            itemClass = pubType != null && pubType.getComponentType() != null ? pubType.getComponentType().getConcreteClass() : this.findIterableItemClass(pubType.getConcreteClass());
            propertyTypes.put(prefix + COLLECTION_TYPE_MARKER, COLLECTION_TYPE_NAMED);
            if (itemClass != null) {
                propertyTypes.put(prefix + COLLECTION_ITEM_MARKER, itemClass.getName());
                newPrefix = prefix + COLLECTION_ITEM_PREFIX;
                this.inspectObjectAndValues(itemClass, null, newPrefix, this.globalTypes, propertyTypes, defaultValues);
            }
            NamedDomainObjectContainer nc = (NamedDomainObjectContainer)value;
            HashMap m = new HashMap(nc.getAsMap());
            ArrayList ss = new ArrayList(m.keySet());
            propertyTypes.put(prefix + COLLECTION_KEYS_MARKER, String.join((CharSequence)";;", ss));
            for (String k2 : m.keySet()) {
                newPrefix = prefix + "." + k2 + ".";
                Object v = m.get(k2);
                if (v == null) {
                    defaultValues.put(prefix + "." + k2, null);
                    continue;
                }
                defaultValues.put(prefix + "." + k2, Objects.toString(v));
                this.inspectObjectAndValues(v.getClass(), v, newPrefix, this.globalTypes, propertyTypes, defaultValues, null, false);
            }
            dumped = true;
        } else if (Iterable.class.isAssignableFrom(t)) {
            itemClass = this.findIterableItemClass(t);
            if (itemClass == null && typeParameters != null && !typeParameters.isEmpty() && typeParameters.get(0) instanceof Class) {
                itemClass = (Class)typeParameters.get(0);
            }
            propertyTypes.put(prefix + COLLECTION_TYPE_MARKER, COLLECTION_TYPE_LIST);
            if (itemClass != null) {
                cn = NbProjectInfoBuilder.findNonDecoratedClass(itemClass).getName();
                propertyTypes.put(prefix + COLLECTION_ITEM_MARKER, cn);
                String newPrefix = prefix + COLLECTION_ITEM_PREFIX;
                if (!cn.startsWith("java.lang.") && !Provider.class.isAssignableFrom(t)) {
                    this.inspectObjectAndValues(itemClass, null, newPrefix, this.globalTypes, propertyTypes, defaultValues);
                }
            }
            if (value instanceof Iterable) {
                int index = 0;
                try {
                    for (Object o : (Iterable)value) {
                        String newPrefix = prefix + "[" + index + "].";
                        if (o == null) {
                            defaultValues.put(prefix + "[" + index + "]", null);
                        } else {
                            defaultValues.put(prefix + "[" + index + "]", Objects.toString(o));
                            this.inspectObjectAndValues(o.getClass(), o, newPrefix, this.globalTypes, propertyTypes, defaultValues, null, false);
                        }
                        ++index;
                    }
                }
                catch (RuntimeException pubType) {
                    // empty catch block
                }
                dumped = true;
            }
        } else if (value instanceof Map) {
            Map mvalue = (Map)value;
            Set ks = mvalue.keySet();
            Class<String> keyClass = this.findIterableItemClass(ks.getClass());
            if (keyClass == null || keyClass == Object.class) {
                boolean ok = true;
                for (Object k3 : ks) {
                    if (k3 instanceof String) continue;
                    ok = false;
                }
                if (ok) {
                    keyClass = String.class;
                }
            }
            if (keyClass == String.class) {
                itemClass = this.findIterableItemClass(mvalue.values().getClass());
                String keys = ks.stream().map(k -> k.toString()).map(k -> k.replace(";", "\\;")).collect(Collectors.joining(";;"));
                propertyTypes.put(prefix + COLLECTION_KEYS_MARKER, keys);
                propertyTypes.put(prefix + COLLECTION_TYPE_MARKER, COLLECTION_TYPE_MAP);
                if (itemClass != null) {
                    cn = NbProjectInfoBuilder.findNonDecoratedClass(itemClass).getName();
                    propertyTypes.put(prefix + COLLECTION_ITEM_MARKER, cn);
                    String newPrefix = prefix + COLLECTION_ITEM_PREFIX;
                    if (!cn.startsWith("java.lang.") && !Provider.class.isAssignableFrom(t)) {
                        this.inspectObjectAndValues(itemClass, null, newPrefix, this.globalTypes, propertyTypes, defaultValues);
                    }
                }
                for (Object o : ks) {
                    String k4 = o.toString();
                    String newPrefix = prefix + "[" + k4 + "]";
                    Object v = mvalue.get(o);
                    if (v == null) {
                        defaultValues.put(newPrefix, null);
                        continue;
                    }
                    defaultValues.put(newPrefix, Objects.toString(v));
                    this.inspectObjectAndValues(v.getClass(), v, newPrefix + ".", this.globalTypes, propertyTypes, defaultValues, null, itemClass == null);
                }
                dumped = true;
            }
        }
        return dumped;
    }

    private static Class findNonDecoratedClass(Class clazz) {
        while (clazz != Object.class && (clazz.getModifiers() & 0x1000) > 0) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    private void inspectExtensions(String prefix, ExtensionContainer container) {
        for (ExtensionsSchema.ExtensionSchema es : container.getExtensionsSchema().getElements()) {
            Object ext;
            String extName = es.getName();
            LOG.info("Extension: {}{}", (Object)prefix, (Object)extName);
            try {
                ext = container.getByName(extName);
                if (ext == null) {
                }
            }
            catch (UnknownDomainObjectException ex) {}
            continue;
            if (DEFAULT_EXTENSION_NAME.equals(extName) && ext instanceof ExtraPropertiesExtension) {
                String p = prefix.endsWith(".") ? prefix.substring(0, prefix.length() - 1) : prefix;
                this.dumpContainerProperties(((ExtraPropertiesExtension)ext).getProperties(), p, this.values);
                continue;
            }
            Class c = NbProjectInfoBuilder.findNonDecoratedClass(ext.getClass());
            this.propertyTypes.put(prefix + extName, c.getName());
            this.inspectObjectAndValues(ext.getClass(), ext, prefix + extName + ".", this.globalTypes, this.propertyTypes, this.values);
            if (!(ext instanceof ExtensionAware)) continue;
            this.inspectExtensions(prefix + extName + ".", ((ExtensionAware)ext).getExtensions());
        }
        ArrayList<String> propNames = new ArrayList<String>(this.propertyTypes.keySet());
        Collections.sort(propNames);
        for (String p : propNames) {
            LOG.info("Extension property: {}: {} = {}", new Object[]{p, this.propertyTypes.get(p), this.values.get(p)});
        }
    }

    private void detectProjectMetadata(NbProjectInfoModel model) {
        model.getInfo().put("project_name", this.project.getName());
        model.getInfo().put("project_path", this.project.getPath());
        model.getInfo().put("project_status", this.project.getStatus());
        if (this.project.getParent() != null) {
            model.getInfo().put("project_parent_name", this.project.getParent().getName());
        }
        model.getInfo().put("project_description", this.project.getDescription());
        model.getInfo().put("project_group", this.project.getGroup().toString());
        model.getInfo().put("project_version", this.project.getVersion().toString());
        model.getInfo().put("project_buildDir", this.project.getBuildDir());
        model.getInfo().put("project_projectDir", this.project.getProjectDir());
        model.getInfo().put("project_rootDir", this.project.getRootDir());
        model.getInfo().put("gradle_user_home", this.project.getGradle().getGradleUserHomeDir());
        model.getInfo().put("gradle_home", this.project.getGradle().getGradleHomeDir());
        model.getInfo().put("gradle_version", this.project.getGradle().getGradleVersion());
        Set<Configuration> visibleConfigurations = this.configurationsToSave();
        model.getInfo().put("configurations", visibleConfigurations.stream().map(conf -> conf.getName()).collect(Collectors.toCollection(HashSet::new)));
        HashMap<String, File> sp = new HashMap<String, File>();
        for (Project p : this.project.getSubprojects()) {
            sp.put(p.getPath(), p.getProjectDir());
        }
        model.getInfo().put("project_subProjects", sp);
        HashMap ib = new HashMap();
        LOG.lifecycle("Gradle Version: {}", new Object[]{GradleVersion.current()});
        this.sinceGradle("3.1", () -> {
            for (IncludedBuild p : this.project.getGradle().getIncludedBuilds()) {
                LOG.lifecycle("Include Build: {}", new Object[]{p.getName()});
                ib.put(p.getName(), p.getProjectDir());
            }
        });
        model.getInfo().put("project_includedBuilds", ib);
        this.sinceGradle("3.3", () -> model.getInfo().put("project_display_name", this.project.getDisplayName()));
        try {
            model.getInfo().put("buildClassPath", NbProjectInfoBuilder.storeSet(this.project.getBuildscript().getConfigurations().getByName("classpath").getFiles()));
        }
        catch (RuntimeException e) {
            model.noteProblem(e);
        }
        HashSet<String[]> tasks = new HashSet<String[]>();
        for (Task t : this.project.getTasks()) {
            String[] arr = new String[]{t.getPath(), t.getGroup(), t.getName(), t.getDescription()};
            tasks.add(arr);
        }
        model.getInfo().put("tasks", tasks);
    }

    private void detectPlugins(NbProjectInfoModel model) {
        HashSet<String> plugins = new HashSet<String>();
        for (String plugin : RECOGNISED_PLUGINS) {
            if (!this.project.getPlugins().hasPlugin(plugin)) continue;
            plugins.add(plugin);
        }
        model.getInfo().put("plugins", plugins);
    }

    private void detectTests(NbProjectInfoModel model) {
        HashSet testClassesRoots = new HashSet();
        this.sinceGradle("4.0", () -> this.project.getTasks().withType(Test.class).stream().forEach(task -> task.getTestClassesDirs().forEach(dir -> testClassesRoots.add(dir))));
        this.beforeGradle("4.0", () -> this.project.getTasks().withType(Test.class).stream().forEach(task -> testClassesRoots.add((File)NbProjectInfoBuilder.getProperty(task, "testClassesDir"))));
        model.getInfo().put("test_classes_dirs", testClassesRoots);
        if (this.project.getPlugins().hasPlugin("jacoco")) {
            HashSet coverageData = new HashSet();
            this.project.getTasks().withType(Test.class).stream().forEach(task -> coverageData.add((File)NbProjectInfoBuilder.getProperty(task, "jacoco", "destinationFile")));
            model.getInfo().put("jacoco_coverage_files", coverageData);
        }
    }

    private void detectProps(NbProjectInfoModel model) {
        HashMap nbprops = new HashMap();
        this.project.getProperties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(NB_PREFIX)).forEach(e -> nbprops.put(((String)e.getKey()).substring(NB_PREFIX.length()), String.valueOf(e.getValue())));
        model.getInfo().put("nbprops", nbprops);
    }

    private Path longestPrefixPath(List<Path> files) {
        if (files.size() < 2) {
            return null;
        }
        Path first = files.get(0);
        Path result = null;
        Path root = first.getRoot();
        int count = first.getNameCount();
        for (int i = 1; i <= count; ++i) {
            Path match = root != null ? root.resolve(first.subpath(0, i)) : first.subpath(0, i);
            for (int pi = 1; pi < files.size(); ++pi) {
                Path p = files.get(pi);
                if (p.startsWith(match)) continue;
                return result;
            }
            result = match;
        }
        return null;
    }

    private void detectSources(NbProjectInfoModel model) {
        boolean hasJava = this.project.getPlugins().hasPlugin("java-base");
        boolean hasGroovy = this.project.getPlugins().hasPlugin("groovy-base");
        boolean hasScala = this.project.getPlugins().hasPlugin("scala-base");
        boolean hasKotlin = this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.android") || this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.js") || this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.jvm");
        HashMap<String, Boolean> available = new HashMap<String, Boolean>();
        available.put("java", hasJava);
        available.put("groovy", hasGroovy);
        available.put("kotlin", hasKotlin);
        if (hasJava) {
            SourceSetContainer sourceSets = (SourceSetContainer)NbProjectInfoBuilder.getProperty(this.project, "sourceSets");
            if (sourceSets != null) {
                model.getInfo().put("sourcesets", NbProjectInfoBuilder.storeSet(sourceSets.getNames()));
                for (SourceSet sourceSet : sourceSets) {
                    String propBase = "sourceset_" + sourceSet.getName() + "_";
                    LinkedHashSet outDirs = new LinkedHashSet();
                    this.sinceGradle("4.0", () -> {
                        for (File dir : (ConfigurableFileCollection)NbProjectInfoBuilder.getProperty(sourceSet, "output", "classesDirs")) {
                            outDirs.add(dir);
                        }
                    });
                    this.beforeGradle("4.0", () -> outDirs.add((File)NbProjectInfoBuilder.getProperty(sourceSet, "output", "classesDir")));
                    List<Path> outPaths = outDirs.stream().map(File::toPath).collect(Collectors.toList());
                    Path base = this.longestPrefixPath(outPaths);
                    for (String lang : new String[]{"JAVA", "GROOVY", "SCALA", "KOTLIN"}) {
                        String langId = lang.toLowerCase();
                        Task compileTask = (Task)this.project.getTasks().findByName(sourceSet.getCompileTaskName(langId));
                        if (compileTask != null) {
                            List compilerArgs;
                            Object o = null;
                            if ("KOTLIN".equals(lang)) {
                                o = NbProjectInfoBuilder.getProperty(compileTask, "kotlinOptions", "languageVersion");
                            }
                            if (o == null && compileTask.hasProperty("sourceCompatibility")) {
                                o = NbProjectInfoBuilder.getProperty(compileTask, "sourceCompatibility");
                            }
                            if (o != null) {
                                model.getInfo().put(propBase + lang + "_source_compatibility", o.toString());
                            }
                            o = null;
                            if ("KOTLIN".equals(lang)) {
                                o = NbProjectInfoBuilder.getProperty(compileTask, "kotlinOptions", "jvmTarget");
                            }
                            if (o == null && compileTask.hasProperty("targetCompatibility")) {
                                o = NbProjectInfoBuilder.getProperty(compileTask, "targetCompatibility");
                            }
                            if (o != null) {
                                model.getInfo().put(propBase + lang + "_target_compatibility", o.toString());
                            }
                            if ((compilerArgs = (List)NbProjectInfoBuilder.getProperty(compileTask, "options", "allCompilerArgs")) == null) {
                                compilerArgs = (List)NbProjectInfoBuilder.getProperty(compileTask, "options", "compilerArgs");
                            }
                            if (compilerArgs == null) {
                                compilerArgs = (List)NbProjectInfoBuilder.getProperty(compileTask, "kotlinOptions", "freeCompilerArgs");
                            }
                            model.getInfo().put(propBase + lang + "_compiler_args", new ArrayList(compilerArgs));
                        }
                        if (!Boolean.TRUE.equals(available.get(langId))) continue;
                        model.getInfo().put(propBase + lang, NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(sourceSet, langId, "srcDirs")));
                        this.asGradle("4.0", "6.1", () -> {
                            File outDir = (File)NbProjectInfoBuilder.getProperty(sourceSet, langId, "outputDir");
                            model.getInfo().put(propBase + lang + "_output_classes", outDir);
                        });
                        this.sinceGradle("6.1", () -> {
                            DirectoryProperty dirProp = (DirectoryProperty)NbProjectInfoBuilder.getProperty(sourceSet, langId, "classesDirectory");
                            if (dirProp != null) {
                                File outDir;
                                if (dirProp.isPresent()) {
                                    outDir = ((Directory)dirProp.get()).getAsFile();
                                } else {
                                    Path candidate = null;
                                    if (base != null) {
                                        Path prefix = base.resolve(langId);
                                        for (int i = 0; i < outPaths.size(); ++i) {
                                            Path p = (Path)outPaths.get(i);
                                            if (!p.startsWith(prefix)) continue;
                                            if (candidate != null) {
                                                candidate = null;
                                                break;
                                            }
                                            candidate = p;
                                        }
                                    }
                                    outDir = candidate != null ? candidate.toFile() : new File("");
                                }
                                model.getInfo().put(propBase + lang + "_output_classes", outDir);
                            }
                        });
                    }
                    model.getInfo().put(propBase + "JAVA", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(sourceSet, "java", "srcDirs")));
                    model.getInfo().put(propBase + "RESOURCES", NbProjectInfoBuilder.storeSet(sourceSet.getResources().getSrcDirs()));
                    if (hasGroovy) {
                        model.getInfo().put(propBase + "GROOVY", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(sourceSet, "groovy", "srcDirs")));
                    }
                    if (hasScala) {
                        model.getInfo().put(propBase + "SCALA", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(sourceSet, "scala", "srcDirs")));
                    }
                    if (hasKotlin) {
                        model.getInfo().put(propBase + "KOTLIN", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(NbProjectInfoBuilder.getProperty(sourceSet, "kotlin"), "srcDirs")));
                    }
                    model.getInfo().put(propBase + "output_classes", outDirs);
                    model.getInfo().put(propBase + "output_resources", sourceSet.getOutput().getResourcesDir());
                    this.sinceGradle("5.2", () -> model.getInfo().put(propBase + "GENERATED", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(sourceSet, "output", "generatedSourcesDirs", "files"))));
                    try {
                        model.getInfo().put(propBase + "classpath_compile", NbProjectInfoBuilder.storeSet(sourceSet.getCompileClasspath().getFiles()));
                        model.getInfo().put(propBase + "classpath_runtime", NbProjectInfoBuilder.storeSet(sourceSet.getRuntimeClasspath().getFiles()));
                    }
                    catch (Exception e) {
                        model.noteProblem(e);
                    }
                    this.sinceGradle("4.6", () -> {
                        try {
                            model.getInfo().put(propBase + "classpath_annotation", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(sourceSet, "annotationProcessorPath", "files")));
                        }
                        catch (Exception e) {
                            model.noteProblem(e);
                        }
                        model.getInfo().put(propBase + "configuration_annotation", NbProjectInfoBuilder.getProperty(sourceSet, "annotationProcessorConfigurationName"));
                    });
                    this.beforeGradle("5.0", () -> {
                        if (model.getInfo().get(propBase + "classpath_annotation") == null || ((Collection)model.getInfo().get(propBase + "classpath_annotation")).isEmpty()) {
                            model.getInfo().put(propBase + "classpath_annotation", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(sourceSet, "compileClasspath", "files")));
                        }
                    });
                    this.beforeGradle("7.0", () -> {
                        model.getInfo().put(propBase + "configuration_compile", NbProjectInfoBuilder.getProperty(sourceSet, "compileClasspathConfigurationName"));
                        model.getInfo().put(propBase + "configuration_runtime", NbProjectInfoBuilder.getProperty(sourceSet, "runtimeClasspathConfigurationName"));
                    });
                }
            } else {
                model.getInfo().put("sourcesets", Collections.emptySet());
                model.noteProblem("No sourceSets found on this project. This project mightbe a Model/Rule based one which is not supported at the moment.");
            }
        }
    }

    private void detectArtifacts(NbProjectInfoModel model) {
        if (this.project.getPlugins().hasPlugin("java")) {
            model.getInfo().put("main_jar", NbProjectInfoBuilder.getProperty(this.project, "jar", "archivePath"));
        }
        if (this.project.getPlugins().hasPlugin("war")) {
            model.getInfo().put("main_war", NbProjectInfoBuilder.getProperty(this.project, "war", "archivePath"));
            model.getInfo().put("webapp_dir", NbProjectInfoBuilder.getProperty(this.project, "webAppDir"));
            model.getInfo().put("webxml", NbProjectInfoBuilder.getProperty(this.project, "war", "webXml"));
            try {
                model.getInfo().put("exploded_war_dir", NbProjectInfoBuilder.getProperty(this.project, "explodedWar", "destinationDir"));
            }
            catch (Exception e) {
                model.noteProblem(e);
            }
            try {
                model.getInfo().put("web_classpath", NbProjectInfoBuilder.getProperty(this.project, "war", "classpath", "files"));
            }
            catch (Exception e) {
                model.noteProblem(e);
            }
        }
        HashMap archives = new HashMap();
        this.beforeGradle("5.2", () -> this.project.getTasks().withType(Jar.class).forEach(jar -> archives.put(jar.getClassifier(), jar.getArchivePath())));
        this.sinceGradle("5.2", () -> this.project.getTasks().withType(Jar.class).forEach(jar -> archives.put((String)jar.getArchiveClassifier().get(), ((RegularFile)jar.getDestinationDirectory().file((String)jar.getArchiveFileName().get()).get()).getAsFile())));
        model.getInfo().put("archives", archives);
    }

    private static boolean resolvable(Configuration conf) {
        try {
            return (Boolean)NbProjectInfoBuilder.getProperty(conf, "canBeResolved");
        }
        catch (MissingPropertyException ex) {
            return true;
        }
    }

    private static String nonNullString(Object s) {
        return s == null ? "" : s.toString();
    }

    private void detectDependencies(NbProjectInfoModel model) {
        HashSet ids = new HashSet();
        HashMap projects = new HashMap();
        HashMap unresolvedProblems = new HashMap();
        HashMap resolvedJvmArtifacts = new HashMap();
        Set<Configuration> visibleConfigurations = this.configurationsToSave();
        HashMap projectIds = new HashMap();
        boolean ignoreUnresolvable = this.project.getPlugins().hasPlugin("java-platform") && Boolean.TRUE.equals(NbProjectInfoBuilder.getProperty(this.project, "javaPlatform", "allowDependencies"));
        visibleConfigurations.forEach(it -> {
            String propBase = "configuration_" + it.getName() + "_";
            model.getInfo().put(propBase + "non_resolving", !NbProjectInfoBuilder.resolvable(it));
            model.getInfo().put(propBase + "transitive", it.isTransitive());
            model.getInfo().put(propBase + "canBeConsumed", it.isCanBeConsumed());
            model.getInfo().put(propBase + "extendsFrom", it.getExtendsFrom().stream().map(c -> c.getName()).collect(Collectors.toCollection(HashSet::new)));
            model.getInfo().put(propBase + "description", it.getDescription());
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            AttributeContainer attrs = it.getAttributes();
            for (Attribute attr : attrs.keySet()) {
                attributes.put(attr.getName(), String.valueOf(attrs.getAttribute(attr)));
            }
            model.getInfo().put(propBase + "attributes", attributes);
        });
        visibleConfigurations.forEach(it -> {
            HashMap<String, Set<String>> directDependencies = new HashMap<String, Set<String>>();
            HashSet componentIds = new HashSet();
            HashSet<String> unresolvedIds = new HashSet<String>();
            HashSet projectNames = new HashSet();
            HashMap<String, String> resolvedVersions = new HashMap<String, String>();
            long time_inspect_conf = System.currentTimeMillis();
            it.getDependencies().withType(ModuleDependency.class).forEach(it2 -> {
                String group = it2.getGroup() != null ? it2.getGroup() : "";
                String name = it2.getName();
                String version = it2.getVersion() != null ? it2.getVersion() : "";
                String id = group + ":" + name + ":" + version;
                componentIds.add(id);
            });
            String configPrefix = "configuration_" + it.getName() + "_";
            if (NbProjectInfoBuilder.resolvable(it)) {
                try {
                    it.getIncoming().getResolutionResult().getAllDependencies().forEach(it2 -> {
                        ResolvedDependencyResult rdr;
                        if (it2 instanceof ResolvedDependencyResult && (rdr = (ResolvedDependencyResult)it2).getRequested() instanceof ModuleComponentSelector) {
                            ids.add(rdr.getSelected().getId());
                            if (rdr.getResolvedVariant() == null) {
                                componentIds.add(rdr.getSelected().getId().toString());
                            } else {
                                this.sinceGradle("6.8", () -> {
                                    if (!rdr.getResolvedVariant().getExternalVariant().isPresent()) {
                                        componentIds.add(rdr.getSelected().getId().toString());
                                    }
                                });
                            }
                        }
                        if (it2 instanceof UnresolvedDependencyResult) {
                            UnresolvedDependencyResult udr = (UnresolvedDependencyResult)it2;
                            String id = udr.getRequested().getDisplayName();
                            if (componentIds.contains(id)) {
                                unresolvedIds.add(id);
                            }
                            if (!ignoreUnresolvable && (it.isVisible() || it.isCanBeConsumed())) {
                                Throwable failure = ((UnresolvedDependencyResult)it2).getFailure();
                                if (this.project.getGradle().getStartParameter().isOffline()) {
                                    Throwable prev = null;
                                    for (Throwable t = failure; t != prev && t != null; t = t.getCause()) {
                                        if (t.getMessage().contains("available for offline")) {
                                            throw new NeedOnlineModeException("Need online mode", failure);
                                        }
                                        prev = t;
                                    }
                                }
                                unresolvedProblems.put(id, ((UnresolvedDependencyResult)it2).getFailure().getMessage());
                            }
                        }
                    });
                    HashSet<String> componentIds2 = new HashSet<String>();
                    DependencyWalker walker = new DependencyWalker((Configuration)it, ignoreUnresolvable, unresolvedProblems, (Set<String>)componentIds2, ids, (Set<String>)unresolvedIds, (Map<String, Set<String>>)directDependencies, projectIds, (Map<String, String>)resolvedVersions);
                    walker.walkResolutionResult(it.getIncoming().getResolutionResult().getRoot());
                }
                catch (ResolveException ex) {
                    model.noteProblem(ex);
                }
            } else {
                unresolvedIds.addAll(componentIds);
                componentIds.clear();
            }
            HashSet directChildSpecs = new HashSet();
            it.getDependencies().forEach(d -> {
                String a;
                String g;
                StringBuilder sb = new StringBuilder();
                if (d instanceof ProjectDependency) {
                    sb.append("*project:");
                    Project other = ((ProjectDependency)d).getDependencyProject();
                    g = other.getGroup().toString();
                    a = other.getName();
                } else {
                    g = d.getGroup();
                    a = d.getName();
                }
                sb.append(g).append(':').append(a).append(":").append(NbProjectInfoBuilder.nonNullString(d.getVersion()));
                String id = sb.toString();
                String resolved = (String)resolvedVersions.get(id);
                directChildSpecs.add(resolved != null ? resolved : id);
            });
            model.getInfo().put(configPrefix + "directChildren", directChildSpecs);
            String depBase = "dependency_inspect_" + it.getName();
            String depPrefix = depBase + "_";
            long time_project_deps = System.currentTimeMillis();
            model.registerPerf(depPrefix + "module", time_project_deps - time_inspect_conf);
            it.getDependencies().withType(ProjectDependency.class).forEach(it2 -> {
                Project prj = it2.getDependencyProject();
                projects.put(prj.getPath(), prj.getProjectDir());
                projectNames.add(prj.getPath());
            });
            long time_file_deps = System.currentTimeMillis();
            model.registerPerf(depPrefix + "project", time_file_deps - time_project_deps);
            HashSet fileDeps = new HashSet();
            it.getDependencies().withType(FileCollectionDependency.class).forEach(it2 -> fileDeps.addAll(it2.resolve()));
            long time_collect = System.currentTimeMillis();
            model.registerPerf(depPrefix + "file", time_collect - time_file_deps);
            if (NbProjectInfoBuilder.resolvable(it)) {
                try {
                    Set arts = it.getResolvedConfiguration().getLenientConfiguration().getArtifacts();
                    arts.stream().forEach(a -> {
                        if (!(a.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier)) {
                            resolvedJvmArtifacts.putIfAbsent(a.getId().getComponentIdentifier().toString(), Collections.singleton(a.getFile()));
                        }
                    });
                    it.getResolvedConfiguration().getLenientConfiguration().getFirstLevelModuleDependencies(Specs.SATISFIES_ALL).forEach(rd -> NbProjectInfoBuilder.collectArtifacts(rd, resolvedJvmArtifacts));
                }
                catch (NullPointerException arts) {
                    // empty catch block
                }
            }
            long time_report = System.currentTimeMillis();
            model.registerPerf(depPrefix + "collect", time_report - time_collect);
            model.getInfo().put(configPrefix + "components", componentIds);
            model.getInfo().put(configPrefix + "projects", projectNames);
            model.getInfo().put(configPrefix + "files", fileDeps);
            model.getInfo().put(configPrefix + "unresolved", unresolvedIds);
            model.getInfo().put(configPrefix + "dependencies", directDependencies);
            model.registerPerf(depPrefix + "file", System.currentTimeMillis() - time_report);
            model.registerPerf(depBase, System.currentTimeMillis() - time_inspect_conf);
        });
        long time_exclude = System.currentTimeMillis();
        visibleConfigurations.stream().forEach(it -> {
            String propBase = "configuration_" + it.getName() + "_";
            HashSet exclude = new HashSet();
            this.collectModuleDependencies(model, it.getName(), false, exclude);
            ((Set)model.getInfo().get(propBase + "components")).removeAll(exclude);
            ((Set)model.getInfo().get(propBase + "unresolved")).removeAll(exclude);
            ((Set)model.getInfo().get(propBase + "files")).removeAll(exclude);
        });
        model.registerPerf("excludes", System.currentTimeMillis() - time_exclude);
        model.registerPerf("offline", this.project.getGradle().getStartParameter().isOffline());
        HashMap<String, Set<File>> resolvedSourcesArtifacts = new HashMap<String, Set<File>>();
        HashMap<String, Set<File>> resolvedJavadocArtifacts = new HashMap<String, Set<File>>();
        if (this.project.getGradle().getStartParameter().isOffline() || this.project.hasProperty("downloadSources") || this.project.hasProperty("downloadJavadoc")) {
            String filter;
            ArrayList<Class> artifactTypes;
            long filter_time = System.currentTimeMillis();
            Set<Object> filteredIds = ids;
            ArrayList<Class> arrayList = artifactTypes = this.project.getGradle().getStartParameter().isOffline() ? new ArrayList<Class>(Arrays.asList(SourcesArtifact.class, JavadocArtifact.class)) : new ArrayList();
            if (this.project.hasProperty("downloadSources")) {
                filter = (String)NbProjectInfoBuilder.getProperty(this.project, "downloadSources");
                if (!"ALL".equals(filter)) {
                    filteredIds = ids.stream().filter(id -> id.toString().equals(filter)).collect(Collectors.toSet());
                    model.setMiscOnly(true);
                }
                artifactTypes.add(SourcesArtifact.class);
            }
            if (this.project.hasProperty("downloadJavadoc")) {
                filter = (String)NbProjectInfoBuilder.getProperty(this.project, "downloadJavadoc");
                if (!"ALL".equals(filter)) {
                    filteredIds = ids.stream().filter(id -> id.toString().equals(filter)).collect(Collectors.toSet());
                    model.setMiscOnly(true);
                }
                artifactTypes.add(JavadocArtifact.class);
            }
            long query_time = System.currentTimeMillis();
            model.registerPerf("dependencies_filter", query_time - filter_time);
            ArtifactResolutionResult result = this.project.getDependencies().createArtifactResolutionQuery().forComponents(filteredIds).withArtifacts(JvmLibrary.class, artifactTypes).execute();
            long collect_time = System.currentTimeMillis();
            model.registerPerf("dependencies_query", collect_time - query_time);
            for (ComponentArtifactsResult component : result.getResolvedComponents()) {
                Set javadocs;
                Set sources = component.getArtifacts(SourcesArtifact.class);
                if (!sources.isEmpty()) {
                    resolvedSourcesArtifacts.put(component.getId().toString(), NbProjectInfoBuilder.collectResolvedArtifacts(sources));
                }
                if ((javadocs = component.getArtifacts(JavadocArtifact.class)).isEmpty()) continue;
                resolvedJavadocArtifacts.put(component.getId().toString(), NbProjectInfoBuilder.collectResolvedArtifacts(javadocs));
            }
            model.registerPerf("dependencies_collect", System.currentTimeMillis() - collect_time);
        }
        model.getInfo().put("project_ids", projectIds);
        model.getExt().put("resolved_jvm_artifacts", resolvedJvmArtifacts);
        model.getExt().put("resolved_sources_artifacts", resolvedSourcesArtifacts);
        model.getExt().put("resolved_javadoc_artifacts", resolvedJavadocArtifacts);
        model.getInfo().put("project_dependencies", projects);
        model.getInfo().put("unresolved_problems", unresolvedProblems);
    }

    private static Set<File> collectResolvedArtifacts(Set<ArtifactResult> res) {
        return res.stream().filter(it -> it instanceof ResolvedArtifactResult).map(rar -> ((ResolvedArtifactResult)rar).getFile()).collect(Collectors.toCollection(HashSet::new));
    }

    private static void collectArtifacts(ResolvedDependency dep, Map<String, Set<File>> resolvedArtifacts) {
        String key = dep.getModuleGroup() + ":" + dep.getModuleName() + ":" + dep.getModuleVersion();
        if (!resolvedArtifacts.containsKey(key)) {
            resolvedArtifacts.put(key, dep.getModuleArtifacts().stream().map(r -> r.getFile()).collect(Collectors.toCollection(HashSet::new)));
            dep.getChildren().forEach(rd -> NbProjectInfoBuilder.collectArtifacts(rd, resolvedArtifacts));
        }
    }

    private void collectModuleDependencies(NbProjectInfoModel model, String configurationName, boolean includeRoot, Set deps) {
        String propBase = "configuration_" + configurationName + "_";
        if (includeRoot) {
            deps.addAll((Collection)model.getInfo().get(propBase + "components"));
            deps.addAll((Collection)model.getInfo().get(propBase + "files"));
            if (!model.getInfo().containsKey(propBase + "non_resolving")) {
                deps.addAll((Collection)model.getInfo().get(propBase + "unresolved"));
            }
        }
        ((Collection)model.getInfo().get(propBase + "extendsFrom")).forEach(it -> this.collectModuleDependencies(model, (String)it, true, deps));
    }

    private static <T extends Serializable> Set storeSet(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Collection)) {
            throw new IllegalStateException("storeSet can only be used with Collections, but was: " + o.getClass().getName());
        }
        Collection c = (Collection)o;
        switch (c.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(c.iterator().next());
            }
        }
        return new LinkedHashSet(c);
    }

    private Set<Configuration> configurationsToSave() {
        return this.project.getConfigurations().matching(c -> !CONFIG_EXCLUDES_PATTERN.matcher(c.getName()).matches()).stream().flatMap(c -> c.getHierarchy().stream()).collect(Collectors.toSet());
    }

    private static <T extends Throwable> void sneakyThrow(Throwable exception) throws T {
        throw exception;
    }

    private <T, E extends Throwable> T sinceGradleOrDefault(String version, ExceptionCallable<T, E> c, Supplier<T> def) {
        if (GRADLE_VERSION.compareTo(GradleVersion.version((String)version)) >= 0) {
            try {
                return c.call();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                NbProjectInfoBuilder.sneakyThrow(t);
                return null;
            }
        }
        if (def != null) {
            return def.get();
        }
        return null;
    }

    private <T, E extends Throwable> T sinceGradle(String version, ExceptionCallable<T, E> c) {
        return this.sinceGradleOrDefault(version, c, null);
    }

    private void sinceGradle(String version, Runnable r) {
        if (GRADLE_VERSION.compareTo(GradleVersion.version((String)version)) >= 0) {
            r.run();
        }
    }

    private void beforeGradle(String version, Runnable r) {
        if (GRADLE_VERSION.compareTo(GradleVersion.version((String)version)) < 0) {
            r.run();
        }
    }

    private void asGradle(String fromVersion, String toVersion, Runnable r) {
        if (GRADLE_VERSION.compareTo(GradleVersion.version((String)fromVersion)) >= 0 && GRADLE_VERSION.compareTo(GradleVersion.version((String)toVersion)) < 0) {
            r.run();
        }
    }

    private static Object getProperty(Object obj, String ... propPath) {
        Object currentObject = obj;
        try {
            for (String prop : propPath) {
                currentObject = InvokerHelper.getPropertySafe((Object)currentObject, (String)prop);
            }
            return currentObject;
        }
        catch (MissingPropertyException ex) {
            return null;
        }
    }

    static interface ExceptionCallable<T, E extends Throwable> {
        public T call() throws E;
    }

    class DependencyWalker {
        final Configuration configuration;
        final boolean ignoreUnresolvable;
        final Map<String, String> unresolvedProblems;
        final Set<String> componentIds;
        final String configName;
        final Set<ComponentIdentifier> ids;
        final Set<String> unresolvedIds;
        final Map<String, Set<String>> directDependencies;
        final Map<String, String> projectIds;
        final Map<String, String> resolvedVersions;
        int depth;

        public DependencyWalker(Configuration configuration, boolean ignoreUnresolvable, Map<String, String> unresolvedProblems, Set<String> componentIds, Set<ComponentIdentifier> ids, Set<String> unresolvedIds, Map<String, Set<String>> directDependencies, Map<String, String> projectIds, Map<String, String> resolvedVersions) {
            this.configuration = configuration;
            this.ignoreUnresolvable = ignoreUnresolvable;
            this.unresolvedProblems = unresolvedProblems;
            this.componentIds = componentIds;
            this.ids = ids;
            this.unresolvedIds = unresolvedIds;
            this.directDependencies = directDependencies;
            this.projectIds = projectIds;
            this.resolvedVersions = resolvedVersions;
            this.configName = configuration.getName();
        }

        public void walkResolutionResult(ResolvedComponentResult node) {
            this.walkChildren(true, "", node.getDependencies(), new HashSet<String>());
        }

        String findNodeIdentifier(ComponentIdentifier cid) {
            if (!(cid instanceof ModuleComponentIdentifier)) {
                if (cid instanceof ProjectComponentIdentifier) {
                    ProjectComponentIdentifier pid = (ProjectComponentIdentifier)cid;
                    String absPath = NbProjectInfoBuilder.this.project.getRootProject().absoluteProjectPath(pid.getProjectPath());
                    String rootName = NbProjectInfoBuilder.this.project.getRootProject().getName();
                    Object g = NbProjectInfoBuilder.this.project.getGroup();
                    Object v = NbProjectInfoBuilder.this.project.getVersion();
                    String gid = g == null ? "" : g.toString();
                    String aid = NbProjectInfoBuilder.this.project != NbProjectInfoBuilder.this.project.getRootProject() ? rootName + "-" + NbProjectInfoBuilder.this.project.getName() : NbProjectInfoBuilder.this.project.getName();
                    String ver = v == null ? "" : v.toString();
                    this.projectIds.put(absPath, String.format("%s:%s:%s", gid, NbProjectInfoBuilder.nonNullString(aid), NbProjectInfoBuilder.nonNullString(v)));
                    return "*project:" + absPath;
                }
                return null;
            }
            ModuleComponentIdentifier mid = (ModuleComponentIdentifier)cid;
            String nodeIdString = String.format("%s:%s:%s", NbProjectInfoBuilder.nonNullString(mid.getGroup()), mid.getModule(), NbProjectInfoBuilder.nonNullString(mid.getVersion()));
            return nodeIdString;
        }

        public void walkResolutionResult(ResolvedDependencyResult node, Set<String> stack) {
            ++this.depth;
            ResolvedComponentResult rcr = node.getSelected();
            String id = this.findNodeIdentifier(rcr.getId());
            if (!stack.add(id)) {
                return;
            }
            this.walkChildren(false, id, rcr.getDependencies(), stack);
            stack.remove(id);
            --this.depth;
        }

        public void walkChildren(boolean root, String parentId, Collection<? extends DependencyResult> deps, Set<String> stack) {
            for (DependencyResult dependencyResult : deps) {
                String id;
                if (dependencyResult instanceof ResolvedDependencyResult) {
                    ResolvedDependencyResult rdr = (ResolvedDependencyResult)dependencyResult;
                    id = null;
                    if (rdr.getRequested() instanceof ModuleComponentSelector) {
                        this.ids.add(rdr.getSelected().getId());
                        id = rdr.getResolvedVariant() == null ? rdr.getSelected().getId() : (ComponentIdentifier)NbProjectInfoBuilder.this.sinceGradle("6.8", () -> {
                            if (!rdr.getResolvedVariant().getExternalVariant().isPresent()) {
                                return rdr.getSelected().getId();
                            }
                            return null;
                        });
                    }
                    if (id != null) {
                        this.componentIds.add(id.toString());
                        if (id instanceof ModuleComponentIdentifier) {
                            ModuleComponentIdentifier mci = (ModuleComponentIdentifier)id;
                            this.resolvedVersions.putIfAbsent(String.format("%s:%s", mci.getGroup(), NbProjectInfoBuilder.nonNullString(mci.getModuleIdentifier().getName())), String.format("%s:%s:%s", mci.getGroup(), NbProjectInfoBuilder.nonNullString(mci.getModuleIdentifier().getName()), NbProjectInfoBuilder.nonNullString(mci.getVersion())));
                        }
                    }
                    if (this.directDependencies.computeIfAbsent(parentId, f -> new HashSet()).add(this.findNodeIdentifier(rdr.getSelected().getId()))) {
                        this.walkResolutionResult(rdr, stack);
                    }
                }
                if (!(dependencyResult instanceof UnresolvedDependencyResult)) continue;
                UnresolvedDependencyResult udr = (UnresolvedDependencyResult)dependencyResult;
                id = udr.getRequested().getDisplayName();
                if (this.componentIds.contains(id)) {
                    this.unresolvedIds.add(id);
                }
                if (this.ignoreUnresolvable || !this.configuration.isVisible() && !this.configuration.isCanBeConsumed()) continue;
                Throwable failure = ((UnresolvedDependencyResult)dependencyResult).getFailure();
                if (NbProjectInfoBuilder.this.project.getGradle().getStartParameter().isOffline()) {
                    Throwable prev = null;
                    for (Throwable t = failure; t != prev && t != null; t = t.getCause()) {
                        if (t.getMessage().contains("available for offline")) {
                            throw new NeedOnlineModeException("Need online mode", failure);
                        }
                        prev = t;
                    }
                }
                this.unresolvedProblems.putIfAbsent(id, ((UnresolvedDependencyResult)dependencyResult).getFailure().getMessage());
            }
        }
    }

    public static final class ValueAndType {
        final Class type;
        final Optional<Object> value;

        public ValueAndType(Class type, Object value) {
            this.type = type;
            this.value = Optional.ofNullable(value);
        }

        public ValueAndType(Class type) {
            this.type = type;
            this.value = Optional.empty();
        }
    }
}

