/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.internal.impldep.javax.annotation.Nonnull;

public class Trie
implements Comparable<Trie> {
    private final char c;
    private final boolean terminal;
    private final Trie[] transitions;

    public static Trie from(String ... words) {
        return Trie.from(Arrays.asList(words));
    }

    public static Trie from(Iterable<String> words) {
        Builder builder = new Builder();
        for (String word : words) {
            builder.addWord(word);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private Trie(char c, boolean terminal, Trie[] transitions) {
        this.c = c;
        this.terminal = terminal;
        this.transitions = transitions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.c).append(this.terminal ? "(terminal)\n" : "\n");
        sb.append("Next: ");
        for (Trie transition : this.transitions) {
            sb.append(transition.c).append(" ");
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public int compareTo(@Nonnull Trie o) {
        return this.c - o.c;
    }

    public boolean find(CharSequence seq) {
        if (seq.length() == 0) {
            return false;
        }
        int idx = 0;
        Trie cur = this;
        while (idx < seq.length()) {
            char c = seq.charAt(idx);
            boolean found = false;
            for (Trie transition : cur.transitions) {
                if (transition.c == c) {
                    cur = transition;
                    found = true;
                    if (++idx != seq.length()) break;
                    return cur.terminal;
                }
                if (transition.c <= c) continue;
                return false;
            }
            if (found) continue;
            return cur.terminal;
        }
        return cur.terminal;
    }

    public void dump(boolean all, Action<? super String> onWord) {
        this.dump(new StringBuilder(), all, this, onWord);
    }

    private void dump(StringBuilder buffer, boolean all, Trie trie, Action<? super String> onWord) {
        for (Trie transition : trie.transitions) {
            buffer.append(transition.c);
            if (transition.terminal) {
                onWord.execute(buffer.toString());
                if (all) {
                    this.dump(buffer, true, transition, onWord);
                }
            } else {
                this.dump(buffer, all, transition, onWord);
            }
            buffer.setLength(buffer.length() - 1);
        }
    }

    public static class Builder {
        private final char c;
        private boolean terminal;
        private List<Builder> transitions = new ArrayList<Builder>();

        public Builder() {
            this.c = '\u0000';
        }

        private Builder(char c) {
            this.c = c;
        }

        private Builder addTransition(char c, boolean terminal) {
            Builder b = null;
            for (Builder transition : this.transitions) {
                if (transition.c != c) continue;
                b = transition;
                break;
            }
            if (b == null) {
                b = new Builder(c);
                this.transitions.add(b);
            }
            b.terminal |= terminal;
            return b;
        }

        public void addWord(String word) {
            Builder cur = this;
            char[] chars = word.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                cur = cur.addTransition(c, i == chars.length - 1);
            }
        }

        public Trie build() {
            Object[] transitions = new Trie[this.transitions.size()];
            for (int i = 0; i < this.transitions.size(); ++i) {
                Builder transition = this.transitions.get(i);
                transitions[i] = transition.build();
            }
            Arrays.sort(transitions);
            return new Trie(this.c, this.terminal, (Trie[])transitions);
        }
    }
}

