/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public class JsxElementNode
extends Expression {
    private final String name;
    private final List<Expression> attributes;
    private final List<Expression> children;

    public JsxElementNode(String string, List<Expression> list, List<Expression> list2, long l, int n) {
        super(l, n);
        this.name = string;
        this.attributes = list;
        this.children = list2;
    }

    private JsxElementNode(JsxElementNode jsxElementNode, String string, List<Expression> list, List<Expression> list2) {
        super(jsxElementNode);
        this.name = string;
        this.attributes = list;
        this.children = list2;
    }

    public String getName() {
        return this.name;
    }

    public List<Expression> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public JsxElementNode setAttributes(List<Expression> list) {
        if (this.attributes == list) {
            return this;
        }
        return new JsxElementNode(this, this.name, list, this.children);
    }

    public List<Expression> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public JsxElementNode setChildren(List<Expression> list) {
        if (this.children == list) {
            return this;
        }
        return new JsxElementNode(this, this.name, this.attributes, list);
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterJsxElementNode(this)) {
            return nodeVisitor.leaveJsxElementNode(this.setAttributes(Node.accept(nodeVisitor, this.attributes)).setChildren(Node.accept(nodeVisitor, this.children)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterJsxElementNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('<').append(this.name);
        for (Expression expression : this.attributes) {
            stringBuilder.append(' ');
            expression.toString(stringBuilder, bl);
        }
        if (this.children.isEmpty()) {
            stringBuilder.append("/>");
        } else {
            stringBuilder.append('>');
            for (Expression expression : this.children) {
                expression.toString(stringBuilder, bl);
            }
            stringBuilder.append("</").append(this.name).append('>');
        }
    }
}

