/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.Assignment;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public final class UnaryNode
extends Expression
implements Assignment<Expression> {
    private final Expression expression;

    public UnaryNode(long l, Expression expression) {
        this(l, Math.min(expression.getStart(), Token.descPosition(l)), Math.max(Token.descPosition(l) + Token.descLength(l), expression.getFinish()), expression);
    }

    public UnaryNode(long l, int n, int n2, Expression expression) {
        super(l, n, n2);
        this.expression = expression;
    }

    private UnaryNode(UnaryNode unaryNode, Expression expression) {
        super(unaryNode);
        this.expression = expression;
    }

    @Override
    public boolean isAssignment() {
        switch (this.tokenType()) {
            case DECPOSTFIX: 
            case DECPREFIX: 
            case INCPOSTFIX: 
            case INCPREFIX: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSelfModifying() {
        return this.isAssignment();
    }

    @Override
    public Expression getAssignmentDest() {
        return this.isAssignment() ? this.getExpression() : null;
    }

    @Override
    public Expression getAssignmentSource() {
        return this.getAssignmentDest();
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterUnaryNode(this)) {
            return nodeVisitor.leaveUnaryNode(this.setExpression((Expression)this.expression.accept(nodeVisitor)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterUnaryNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        boolean bl2;
        TokenType tokenType = this.tokenType();
        String string = tokenType.getName();
        boolean bl3 = bl2 = tokenType == TokenType.DECPOSTFIX || tokenType == TokenType.INCPOSTFIX;
        if (tokenType == TokenType.SPREAD_ARRAY || tokenType == TokenType.SPREAD_OBJECT) {
            stringBuilder.append("...");
            this.getExpression().toString(stringBuilder, bl);
            return;
        }
        if (tokenType == TokenType.AWAIT) {
            stringBuilder.append("await ");
            this.getExpression().toString(stringBuilder, bl);
            return;
        }
        boolean bl4 = tokenType.needsParens(this.getExpression().tokenType(), false);
        if (!bl2) {
            if (string == null) {
                stringBuilder.append(tokenType.name());
                bl4 = true;
            } else {
                stringBuilder.append(string);
                if (tokenType.ordinal() > TokenType.BIT_NOT.ordinal()) {
                    stringBuilder.append(' ');
                }
            }
        }
        if (bl4) {
            stringBuilder.append('(');
        }
        this.getExpression().toString(stringBuilder, bl);
        if (bl4) {
            stringBuilder.append(')');
        }
        if (bl2) {
            stringBuilder.append(tokenType == TokenType.DECPOSTFIX ? "--" : "++");
        }
    }

    public Expression getExpression() {
        return this.expression;
    }

    public UnaryNode setExpression(Expression expression) {
        if (this.expression == expression) {
            return this;
        }
        return new UnaryNode(this, expression);
    }
}

