/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.FileNameMatcher;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.project.spi.CompatibilityUtils;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.netbeans.spi.search.SearchInfoDefinitionFactory;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;
import org.openidex.search.Utils;

public class ProjectSearchingUtils
implements CompatibilityUtils {
    public org.netbeans.api.search.provider.SearchInfo getSearchInfoForNode(Node node) {
        return this.getSearchInfoForLookup(node.getLookup());
    }

    public org.netbeans.api.search.provider.SearchInfo getSearchInfoForLookup(Lookup lookup) {
        SearchInfo si = (SearchInfo)lookup.lookup(SearchInfo.class);
        if (si != null) {
            return ProjectSearchingUtils.wrap(si);
        }
        return null;
    }

    static SearchInfoDefinition searchInfoToSearchInfoDefinition(SearchInfo searchInfo) {
        return new WrappingSearchInfoDefinition(searchInfo);
    }

    static List<SearchFilterDefinition> fileObjectFiltersToSearchFilters(List<FileObjectFilter> filters) {
        LinkedList<SearchFilterDefinition> l = new LinkedList<SearchFilterDefinition>();
        for (FileObjectFilter fof : filters) {
            if (fof == SearchInfoFactory.SHARABILITY_FILTER) {
                l.add(SearchInfoDefinitionFactory.SHARABILITY_FILTER);
                continue;
            }
            if (fof == SearchInfoFactory.VISIBILITY_FILTER) {
                l.add(SearchInfoDefinitionFactory.VISIBILITY_FILTER);
                continue;
            }
            l.add(new WrappingSearchFilter(fof));
        }
        return l;
    }

    private static org.netbeans.api.search.provider.SearchInfo wrap(SearchInfo legacyInfo) {
        return SearchInfoUtils.createForDefinition((SearchInfoDefinition)new WrappingSearchInfoDefinition(legacyInfo));
    }

    private static class WrappingIterator
    implements Iterator<FileObject> {
        private FileNameMatcher fileNameMatcher;
        private Iterator<FileObject> originalIterator;
        private SearchListener listener;
        private boolean upToDate = false;
        private FileObject next = null;
        private AtomicBoolean terminated;
        private List<SearchFilterDefinition> filters;

        public WrappingIterator(SearchScopeOptions searchScopeOptions, Iterator<FileObject> originalIterator, SearchListener listener, AtomicBoolean terminated) {
            this.fileNameMatcher = FileNameMatcher.create((SearchScopeOptions)searchScopeOptions);
            this.originalIterator = originalIterator;
            this.listener = listener;
            this.terminated = terminated;
            this.filters = searchScopeOptions.getFilters();
        }

        private void update() {
            assert (!this.upToDate);
            block0: while (this.originalIterator.hasNext()) {
                FileObject fo = this.originalIterator.next();
                if (fo.isFolder() || !this.fileNameMatcher.pathMatches(fo)) continue;
                for (SearchFilterDefinition filter : this.filters) {
                    if (filter.searchFile(fo)) continue;
                    this.listener.fileSkipped(fo, filter, null);
                    continue block0;
                }
                this.next = fo;
                this.upToDate = true;
                return;
            }
            this.next = null;
            this.upToDate = true;
        }

        @Override
        public boolean hasNext() {
            if (!this.upToDate) {
                this.update();
            }
            return this.next != null && !this.terminated.get();
        }

        @Override
        public FileObject next() {
            if (!this.upToDate) {
                this.update();
            }
            if (this.next != null) {
                FileObject toReturn = this.next;
                this.upToDate = false;
                this.next = null;
                return toReturn;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class WrappingSearchInfoDefinition
    extends SearchInfoDefinition {
        private SearchInfo searchInfo;

        public WrappingSearchInfoDefinition(SearchInfo searchInfo) {
            this.searchInfo = searchInfo;
        }

        public boolean canSearch() {
            return this.searchInfo.canSearch();
        }

        public Iterator<FileObject> filesToSearch(SearchScopeOptions options, SearchListener listener, AtomicBoolean terminated) {
            return new WrappingIterator(options, Utils.getFileObjectsIterator(this.searchInfo), listener, terminated);
        }

        public List<SearchRoot> getSearchRoots() {
            return Collections.emptyList();
        }
    }

    private static class WrappingSearchFilter
    extends SearchFilterDefinition {
        private FileObjectFilter delegate;

        public WrappingSearchFilter(FileObjectFilter delegate) {
            this.delegate = delegate;
        }

        public boolean searchFile(FileObject file) throws IllegalArgumentException {
            return this.delegate.searchFile(file);
        }

        public SearchFilterDefinition.FolderResult traverseFolder(FileObject folder) throws IllegalArgumentException {
            switch (this.delegate.traverseFolder(folder)) {
                case 0: {
                    return SearchFilterDefinition.FolderResult.DO_NOT_TRAVERSE;
                }
                case 2: {
                    return SearchFilterDefinition.FolderResult.TRAVERSE_ALL_SUBFOLDERS;
                }
                case 1: {
                    return SearchFilterDefinition.FolderResult.TRAVERSE;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

