/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.Arrays;
import java.util.Comparator;

public final class CharSequences {
    private static final CompactCharSequence EMPTY = new Fixed_0_7(new byte[0], 0);
    private static final CharSequenceComparator Comparator = new CharSequenceComparator();

    public static CharSequence create(char[] buf, int start, int count) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (count < 0) {
            throw new StringIndexOutOfBoundsException(count);
        }
        if (start > buf.length - count) {
            throw new StringIndexOutOfBoundsException(start + count);
        }
        int n = count;
        if (n == 0) {
            return EMPTY;
        }
        byte[] b = new byte[n];
        boolean bytes = true;
        for (int i = 0; i < n; ++i) {
            char o = buf[start + i];
            if ((o & 0xFF) != o) {
                bytes = false;
                break;
            }
            b[i] = (byte)o;
        }
        if (bytes) {
            return CharSequences.createFromBytes(b, n);
        }
        char[] v = new char[count];
        System.arraycopy(buf, start, v, 0, count);
        return new CharBasedSequence(v);
    }

    public static CharSequence create(CharSequence s) {
        if (s == null) {
            return null;
        }
        if (s instanceof CompactCharSequence) {
            return s;
        }
        int n = s.length();
        if (n == 0) {
            return EMPTY;
        }
        byte[] b = new byte[n];
        boolean bytes = true;
        for (int i = 0; i < n; ++i) {
            char o = s.charAt(i);
            if ((o & 0xFF) != o) {
                bytes = false;
                break;
            }
            b[i] = (byte)o;
        }
        if (bytes) {
            return CharSequences.createFromBytes(b, n);
        }
        char[] v = new char[n];
        for (int i = 0; i < n; ++i) {
            v[i] = s.charAt(i);
        }
        return new CharBasedSequence(v);
    }

    public static Comparator<CharSequence> comparator() {
        return Comparator;
    }

    public static CharSequence empty() {
        return EMPTY;
    }

    public static boolean isCompact(CharSequence cs) {
        return cs instanceof CompactCharSequence;
    }

    public static int indexOf(CharSequence text, CharSequence seq) {
        return CharSequences.indexOf(text, seq, 0);
    }

    public static int indexOf(CharSequence text, CharSequence seq, int fromIndex) {
        int textLength = text.length();
        int seqLength = seq.length();
        if (fromIndex >= textLength) {
            return seqLength == 0 ? textLength : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (seqLength == 0) {
            return fromIndex;
        }
        char first = seq.charAt(0);
        int max = textLength - seqLength;
        for (int i = fromIndex; i <= max; ++i) {
            if (text.charAt(i) != first) {
                while (++i <= max && text.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + seqLength - 1;
            int k = 1;
            while (j < end && text.charAt(j) == seq.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    private static CompactCharSequence createFromBytes(byte[] b, int n) {
        if (n < 8) {
            return new Fixed_0_7(b, n);
        }
        if (n < 16) {
            return new Fixed_8_15(b, n);
        }
        if (n < 24) {
            return new Fixed_16_23(b, n);
        }
        return new ByteBasedSequence(b);
    }

    private CharSequences() {
    }

    private static interface CompactCharSequence
    extends CharSequence {
    }

    private static class CharSequenceComparator
    implements Comparator<CharSequence> {
        private CharSequenceComparator() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            if (o1 instanceof ByteBasedSequence) {
                return CharSequenceComparator.compareByteBasedWithOther((ByteBasedSequence)o1, o2);
            }
            if (o2 instanceof ByteBasedSequence) {
                return -CharSequenceComparator.compareByteBasedWithOther((ByteBasedSequence)o2, o1);
            }
            if (o1 instanceof CharBasedSequence) {
                return CharSequenceComparator.compareCharBasedWithOther((CharBasedSequence)o1, o2);
            }
            if (o2 instanceof CharBasedSequence) {
                return -CharSequenceComparator.compareCharBasedWithOther((CharBasedSequence)o2, o1);
            }
            int len1 = o1.length();
            int len2 = o2.length();
            int n = Math.min(len1, len2);
            for (int k = 0; k < n; ++k) {
                char c2;
                char c1 = o1.charAt(k);
                if (c1 == (c2 = o2.charAt(k))) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }

        private static int compareByteBased(ByteBasedSequence bbs1, ByteBasedSequence bbs2) {
            int len1 = bbs1.value.length;
            int len2 = bbs2.value.length;
            int n = Math.min(len1, len2);
            for (int k = 0; k < n; ++k) {
                if (bbs1.value[k] == bbs2.value[k]) continue;
                return (bbs1.value[k] & 0xFF) - (bbs2.value[k] & 0xFF);
            }
            return len1 - len2;
        }

        private static int compareCharBased(CharBasedSequence cbs1, CharBasedSequence cbs2) {
            int len1 = cbs1.value.length;
            int len2 = cbs2.value.length;
            int n = Math.min(len1, len2);
            for (int k = 0; k < n; ++k) {
                if (cbs1.value[k] == cbs2.value[k]) continue;
                return cbs1.value[k] - cbs2.value[k];
            }
            return len1 - len2;
        }

        private static int compareByteBasedWithCharBased(ByteBasedSequence bbs1, CharBasedSequence cbs2) {
            int len1 = bbs1.value.length;
            int len2 = cbs2.value.length;
            int n = Math.min(len1, len2);
            for (int k = 0; k < n; ++k) {
                char c2;
                int c1 = bbs1.value[k] & 0xFF;
                if (c1 == (c2 = cbs2.value[k])) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }

        private static int compareByteBasedWithOther(ByteBasedSequence bbs1, CharSequence o2) {
            if (o2 instanceof ByteBasedSequence) {
                return CharSequenceComparator.compareByteBased(bbs1, (ByteBasedSequence)o2);
            }
            if (o2 instanceof CharBasedSequence) {
                return CharSequenceComparator.compareByteBasedWithCharBased(bbs1, (CharBasedSequence)o2);
            }
            int len1 = bbs1.value.length;
            int len2 = o2.length();
            int n = Math.min(len1, len2);
            for (int k = 0; k < n; ++k) {
                char c2;
                int c1 = bbs1.value[k] & 0xFF;
                if (c1 == (c2 = o2.charAt(k))) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }

        private static int compareCharBasedWithOther(CharBasedSequence cbs1, CharSequence o2) {
            if (o2 instanceof CharBasedSequence) {
                return CharSequenceComparator.compareCharBased(cbs1, (CharBasedSequence)o2);
            }
            if (o2 instanceof ByteBasedSequence) {
                return -CharSequenceComparator.compareByteBasedWithCharBased((ByteBasedSequence)o2, cbs1);
            }
            int len1 = cbs1.value.length;
            int len2 = o2.length();
            int n = Math.min(len1, len2);
            for (int k = 0; k < n; ++k) {
                char c2;
                char c1 = cbs1.value[k];
                if (c1 == (c2 = o2.charAt(k))) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }
    }

    private static final class ByteBasedSequence
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final byte[] value;
        private int hash;

        private ByteBasedSequence(byte[] b) {
            this.value = b;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public char charAt(int index) {
            int r = this.value[index] & 0xFF;
            return (char)r;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ByteBasedSequence) {
                ByteBasedSequence otherString = (ByteBasedSequence)object;
                if (this.hash != 0 && otherString.hash != 0 && this.hash != otherString.hash) {
                    return false;
                }
                return Arrays.equals(this.value, otherString.value);
            }
            return false;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                int n = this.value.length;
                for (int i = 0; i < n; ++i) {
                    h = 31 * h + this.value[i];
                }
                this.hash = h;
            }
            return h;
        }

        @Override
        public CharSequence subSequence(int beginIndex, int endIndex) {
            return CharSequences.create(this.toChars(), beginIndex, endIndex - beginIndex);
        }

        @Override
        public String toString() {
            char[] r = this.toChars();
            return new String(r);
        }

        private char[] toChars() {
            int n = this.value.length;
            char[] r = new char[n];
            for (int i = 0; i < n; ++i) {
                int c = this.value[i] & 0xFF;
                r[i] = (char)c;
            }
            return r;
        }

        @Override
        public int compareTo(CharSequence o) {
            return CharSequenceComparator.compareByteBasedWithOther(this, o);
        }
    }

    private static final class CharBasedSequence
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final char[] value;
        private int hash;

        private CharBasedSequence(char[] v) {
            this.value = v;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public char charAt(int index) {
            return this.value[index];
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CharBasedSequence) {
                CharBasedSequence otherString = (CharBasedSequence)object;
                if (this.hash != 0 && otherString.hash != 0 && this.hash != otherString.hash) {
                    return false;
                }
                return Arrays.equals(this.value, otherString.value);
            }
            return false;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                int n = this.value.length;
                for (int i = 0; i < n; ++i) {
                    h = 31 * h + this.value[i];
                }
                this.hash = h;
            }
            return h;
        }

        @Override
        public CharSequence subSequence(int beginIndex, int endIndex) {
            return CharSequences.create(this.value, beginIndex, endIndex - beginIndex);
        }

        @Override
        public String toString() {
            return new String(this.value);
        }

        @Override
        public int compareTo(CharSequence o) {
            return CharSequenceComparator.compareCharBasedWithOther(this, o);
        }
    }

    private static final class Fixed_16_23
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final long i1;
        private final long i2;
        private final long i3;

        private Fixed_16_23(byte[] b, int n) {
            long a1 = 0L;
            long a2 = 0L;
            long a3 = 0L;
            switch (n) {
                case 23: {
                    a3 += ((long)b[22] & 0xFFL) << 24;
                }
                case 22: {
                    a3 += (long)((b[21] & 0xFF) << 16);
                }
                case 21: {
                    a3 += (long)((b[20] & 0xFF) << 8);
                }
                case 20: {
                    a3 += (long)(b[19] & 0xFF);
                    a3 <<= 32;
                }
                case 19: {
                    a3 += ((long)b[18] & 0xFFL) << 24;
                }
                case 18: {
                    a3 += (long)((b[17] & 0xFF) << 16);
                }
                case 17: {
                    a3 += (long)((b[16] & 0xFF) << 8);
                }
                case 16: {
                    a3 += (long)(b[15] & 0xFF);
                }
                case 15: {
                    a2 += ((long)b[14] & 0xFFL) << 24;
                }
                case 14: {
                    a2 += (long)((b[13] & 0xFF) << 16);
                }
                case 13: {
                    a2 += (long)((b[12] & 0xFF) << 8);
                }
                case 12: {
                    a2 += (long)(b[11] & 0xFF);
                    a2 <<= 32;
                }
                case 11: {
                    a2 += ((long)b[10] & 0xFFL) << 24;
                }
                case 10: {
                    a2 += (long)((b[9] & 0xFF) << 16);
                }
                case 9: {
                    a2 += (long)((b[8] & 0xFF) << 8);
                }
                case 8: {
                    a2 += (long)(b[7] & 0xFF);
                }
                case 7: {
                    a1 += ((long)b[6] & 0xFFL) << 24;
                }
                case 6: {
                    a1 += (long)((b[5] & 0xFF) << 16);
                }
                case 5: {
                    a1 += (long)((b[4] & 0xFF) << 8);
                }
                case 4: {
                    a1 += (long)(b[3] & 0xFF);
                    a1 <<= 32;
                }
                case 3: {
                    a1 += ((long)b[2] & 0xFFL) << 24;
                }
                case 2: {
                    a1 += (long)((b[1] & 0xFF) << 16);
                }
                case 1: {
                    a1 += (long)((b[0] & 0xFF) << 8);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = a1 += (long)n;
            this.i2 = a2;
            this.i3 = a3;
        }

        @Override
        public int length() {
            return (int)(this.i1 & 0xFFL);
        }

        @Override
        public char charAt(int index) {
            int r = 0;
            switch (index) {
                case 0: {
                    r = (int)(this.i1 >> 8 & 0xFFL);
                    break;
                }
                case 1: {
                    r = (int)(this.i1 >> 16 & 0xFFL);
                    break;
                }
                case 2: {
                    r = (int)(this.i1 >> 24 & 0xFFL);
                    break;
                }
                case 3: {
                    r = (int)(this.i1 >> 32 & 0xFFL);
                    break;
                }
                case 4: {
                    r = (int)(this.i1 >> 40 & 0xFFL);
                    break;
                }
                case 5: {
                    r = (int)(this.i1 >> 48 & 0xFFL);
                    break;
                }
                case 6: {
                    r = (int)(this.i1 >> 56 & 0xFFL);
                    break;
                }
                case 7: {
                    r = (int)(this.i2 & 0xFFL);
                    break;
                }
                case 8: {
                    r = (int)(this.i2 >> 8 & 0xFFL);
                    break;
                }
                case 9: {
                    r = (int)(this.i2 >> 16 & 0xFFL);
                    break;
                }
                case 10: {
                    r = (int)(this.i2 >> 24 & 0xFFL);
                    break;
                }
                case 11: {
                    r = (int)(this.i2 >> 32 & 0xFFL);
                    break;
                }
                case 12: {
                    r = (int)(this.i2 >> 40 & 0xFFL);
                    break;
                }
                case 13: {
                    r = (int)(this.i2 >> 48 & 0xFFL);
                    break;
                }
                case 14: {
                    r = (int)(this.i2 >> 56 & 0xFFL);
                    break;
                }
                case 15: {
                    r = (int)(this.i3 & 0xFFL);
                    break;
                }
                case 16: {
                    r = (int)(this.i3 >> 8 & 0xFFL);
                    break;
                }
                case 17: {
                    r = (int)(this.i3 >> 16 & 0xFFL);
                    break;
                }
                case 18: {
                    r = (int)(this.i3 >> 24 & 0xFFL);
                    break;
                }
                case 19: {
                    r = (int)(this.i3 >> 32 & 0xFFL);
                    break;
                }
                case 20: {
                    r = (int)(this.i3 >> 40 & 0xFFL);
                    break;
                }
                case 21: {
                    r = (int)(this.i3 >> 48 & 0xFFL);
                    break;
                }
                case 22: {
                    r = (int)(this.i3 >> 56 & 0xFFL);
                }
            }
            return (char)r;
        }

        @Override
        public String toString() {
            int n = this.length();
            char[] r = new char[n];
            for (int i = 0; i < n; ++i) {
                r[i] = this.charAt(i);
            }
            return new String(r);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed_16_23) {
                Fixed_16_23 otherString = (Fixed_16_23)object;
                return this.i1 == otherString.i1 && this.i2 == otherString.i2 && this.i3 == otherString.i3;
            }
            return false;
        }

        public int hashCode() {
            long res = this.i1 + 31L * (this.i2 + 31L * this.i3);
            res = res + (res >> 32) & 0xFFFFFFFFL;
            return (int)res;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return CharSequences.create(this.toString().substring(start, end));
        }

        @Override
        public int compareTo(CharSequence o) {
            return Comparator.compare(this, o);
        }
    }

    private static final class Fixed_8_15
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final int i1;
        private final int i2;
        private final int i3;
        private final int i4;

        private Fixed_8_15(byte[] b, int n) {
            int a1 = n;
            int a2 = 0;
            int a3 = 0;
            int a4 = 0;
            switch (n) {
                case 15: {
                    a4 += (b[14] & 0xFF) << 24;
                }
                case 14: {
                    a4 += (b[13] & 0xFF) << 16;
                }
                case 13: {
                    a4 += (b[12] & 0xFF) << 8;
                }
                case 12: {
                    a4 += b[11] & 0xFF;
                }
                case 11: {
                    a3 += (b[10] & 0xFF) << 24;
                }
                case 10: {
                    a3 += (b[9] & 0xFF) << 16;
                }
                case 9: {
                    a3 += (b[8] & 0xFF) << 8;
                }
                case 8: {
                    a3 += b[7] & 0xFF;
                }
                case 7: {
                    a2 += (b[6] & 0xFF) << 24;
                }
                case 6: {
                    a2 += (b[5] & 0xFF) << 16;
                }
                case 5: {
                    a2 += (b[4] & 0xFF) << 8;
                }
                case 4: {
                    a2 += b[3] & 0xFF;
                }
                case 3: {
                    a1 += (b[2] & 0xFF) << 24;
                }
                case 2: {
                    a1 += (b[1] & 0xFF) << 16;
                }
                case 1: {
                    a1 += (b[0] & 0xFF) << 8;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = a1;
            this.i2 = a2;
            this.i3 = a3;
            this.i4 = a4;
        }

        @Override
        public int length() {
            return this.i1 & 0xFF;
        }

        @Override
        public char charAt(int index) {
            int r = 0;
            switch (index) {
                case 0: {
                    r = (this.i1 & 0xFF00) >> 8;
                    break;
                }
                case 1: {
                    r = (this.i1 & 0xFF0000) >> 16;
                    break;
                }
                case 2: {
                    r = this.i1 >> 24 & 0xFF;
                    break;
                }
                case 3: {
                    r = this.i2 & 0xFF;
                    break;
                }
                case 4: {
                    r = (this.i2 & 0xFF00) >> 8;
                    break;
                }
                case 5: {
                    r = (this.i2 & 0xFF0000) >> 16;
                    break;
                }
                case 6: {
                    r = this.i2 >> 24 & 0xFF;
                    break;
                }
                case 7: {
                    r = this.i3 & 0xFF;
                    break;
                }
                case 8: {
                    r = (this.i3 & 0xFF00) >> 8;
                    break;
                }
                case 9: {
                    r = (this.i3 & 0xFF0000) >> 16;
                    break;
                }
                case 10: {
                    r = this.i3 >> 24 & 0xFF;
                    break;
                }
                case 11: {
                    r = this.i4 & 0xFF;
                    break;
                }
                case 12: {
                    r = (this.i4 & 0xFF00) >> 8;
                    break;
                }
                case 13: {
                    r = (this.i4 & 0xFF0000) >> 16;
                    break;
                }
                case 14: {
                    r = this.i4 >> 24 & 0xFF;
                }
            }
            return (char)r;
        }

        @Override
        public String toString() {
            int n = this.length();
            char[] r = new char[n];
            for (int i = 0; i < n; ++i) {
                r[i] = this.charAt(i);
            }
            return new String(r);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed_8_15) {
                Fixed_8_15 otherString = (Fixed_8_15)object;
                return this.i1 == otherString.i1 && this.i2 == otherString.i2 && this.i3 == otherString.i3 && this.i4 == otherString.i4;
            }
            return false;
        }

        public int hashCode() {
            return this.i1 + 31 * (this.i2 + 31 * (this.i3 + 31 * this.i4));
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return CharSequences.create(this.toString().substring(start, end));
        }

        @Override
        public int compareTo(CharSequence o) {
            return Comparator.compare(this, o);
        }
    }

    private static final class Fixed_0_7
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final int i1;
        private final int i2;

        private Fixed_0_7(byte[] b, int n) {
            int a1 = n;
            int a2 = 0;
            switch (n) {
                case 7: {
                    a2 += (b[6] & 0xFF) << 24;
                }
                case 6: {
                    a2 += (b[5] & 0xFF) << 16;
                }
                case 5: {
                    a2 += (b[4] & 0xFF) << 8;
                }
                case 4: {
                    a2 += b[3] & 0xFF;
                }
                case 3: {
                    a1 += (b[2] & 0xFF) << 24;
                }
                case 2: {
                    a1 += (b[1] & 0xFF) << 16;
                }
                case 1: {
                    a1 += (b[0] & 0xFF) << 8;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = a1;
            this.i2 = a2;
        }

        @Override
        public int length() {
            return this.i1 & 0xFF;
        }

        @Override
        public char charAt(int index) {
            int r = 0;
            switch (index) {
                case 0: {
                    r = (this.i1 & 0xFF00) >> 8;
                    break;
                }
                case 1: {
                    r = (this.i1 & 0xFF0000) >> 16;
                    break;
                }
                case 2: {
                    r = this.i1 >> 24 & 0xFF;
                    break;
                }
                case 3: {
                    r = this.i2 & 0xFF;
                    break;
                }
                case 4: {
                    r = (this.i2 & 0xFF00) >> 8;
                    break;
                }
                case 5: {
                    r = (this.i2 & 0xFF0000) >> 16;
                    break;
                }
                case 6: {
                    r = this.i2 >> 24 & 0xFF;
                }
            }
            return (char)r;
        }

        @Override
        public String toString() {
            int n = this.length();
            char[] r = new char[n];
            for (int i = 0; i < n; ++i) {
                r[i] = this.charAt(i);
            }
            return new String(r);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed_0_7) {
                Fixed_0_7 otherString = (Fixed_0_7)object;
                return this.i1 == otherString.i1 && this.i2 == otherString.i2;
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.length(); ++i) {
                hash = 31 * hash + this.charAt(i);
            }
            return hash;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return CharSequences.create(this.toString().substring(start, end));
        }

        @Override
        public int compareTo(CharSequence o) {
            return Comparator.compare(this, o);
        }
    }
}

