/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

final class ExcludingLookup
extends Lookup {
    private Lookup delegate;
    private Object classes;

    ExcludingLookup(Lookup delegate, Class[] classes) {
        this.delegate = delegate;
        for (Class c : classes) {
            if (c != null) continue;
            throw new NullPointerException();
        }
        this.classes = classes.length == 1 ? classes[0] : classes;
    }

    public String toString() {
        return "ExcludingLookup: " + this.delegate + " excludes: " + Arrays.asList(this.classes());
    }

    @Override
    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        if (template == null) {
            throw new NullPointerException();
        }
        if (this.areSubclassesOfThisClassAlwaysExcluded(template.getType())) {
            return Lookup.EMPTY.lookup(template);
        }
        return new R<T>(template.getType(), this.delegate.lookup(template));
    }

    @Override
    public <T> T lookup(Class<T> clazz) {
        if (this.areSubclassesOfThisClassAlwaysExcluded(clazz)) {
            return null;
        }
        T res = this.delegate.lookup(clazz);
        if (this.isObjectAccessible(clazz, res, 0)) {
            return res;
        }
        return null;
    }

    @Override
    public <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        if (this.areSubclassesOfThisClassAlwaysExcluded(template.getType())) {
            return null;
        }
        Lookup.Item<T> retValue = this.delegate.lookupItem(template);
        if (this.isObjectAccessible(template.getType(), retValue, 2)) {
            return retValue;
        }
        return null;
    }

    private boolean areSubclassesOfThisClassAlwaysExcluded(Class<?> c) {
        Class<?>[] arr = this.classes();
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }

    final Class<?>[] classes() {
        if (this.classes instanceof Class[]) {
            return (Class[])this.classes;
        }
        return new Class[]{(Class)this.classes};
    }

    private static boolean isAccessible(Class<?>[] barriers, Class<?> from, Class<?> to) {
        if (to == null || !from.isAssignableFrom(to)) {
            return false;
        }
        for (int i = 0; i < barriers.length; ++i) {
            if (to != barriers[i]) continue;
            return false;
        }
        if (from == to) {
            return true;
        }
        if (ExcludingLookup.isAccessible(barriers, from, to.getSuperclass())) {
            return true;
        }
        Class<?>[] interfaces = to.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!ExcludingLookup.isAccessible(barriers, from, interfaces[i])) continue;
            return true;
        }
        return false;
    }

    private final boolean isObjectAccessible(Class from, Object to, int type) {
        if (to == null) {
            return false;
        }
        return ExcludingLookup.isObjectAccessible(this.classes(), from, to, type);
    }

    static final boolean isObjectAccessible(Class[] barriers, Class from, Object to, int type) {
        if (to == null) {
            return false;
        }
        switch (type) {
            case 0: {
                return ExcludingLookup.isAccessible(barriers, from, to.getClass());
            }
            case 1: {
                return ExcludingLookup.isAccessible(barriers, from, (Class)to);
            }
            case 2: {
                Lookup.Item item = (Lookup.Item)to;
                return ExcludingLookup.isAccessible(barriers, from, item.getType());
            }
        }
        throw new IllegalStateException("Type: " + type);
    }

    final <E, T extends Collection<E>> T filter(Class<?>[] arr, Class<?> from, T c, int type, T prototype) {
        Collection ret = null;
        while (true) {
            for (E res : c) {
                if (!ExcludingLookup.isObjectAccessible(arr, from, res, type)) {
                    if (ret != null) continue;
                    ret = prototype;
                    continue;
                }
                if (ret == null) continue;
                ret.add(res);
            }
            break;
        }
        return (T)(ret != null ? ret : (Collection)c);
    }

    private final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        private Lookup.Result source;
        private Reference<R<T>> result;

        public WeakResult(R<T> r, Lookup.Result<T> s) {
            this.result = new WeakReference<R<R<T>>>(r);
            this.source = s;
        }

        @Override
        protected void beforeLookup(Lookup.Template t) {
            R<T> r = this.result.get();
            if (r != null) {
                r.beforeLookup(t);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            R<T> r = this.result.get();
            if (r != null) {
                r.collectFires(evAndListeners);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public void addLookupListener(LookupListener l) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener l) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        protected Collection<T> allInstances(boolean ignore) {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            R<T> r = this.result.get();
            if (r != null) {
                r.resultChanged(ev);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItems(boolean callBeforeLookup) {
            return this.allItems();
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }
    }

    private final class R<T>
    extends WaitableResult<T>
    implements LookupListener {
        private Lookup.Result<T> result;
        private WeakResult<T> weak;
        private Object listeners;
        private Class<?> from;

        R(Class<?> from, Lookup.Result<T> delegate) {
            this.from = from;
            this.result = delegate;
            this.weak = new WeakResult<T>(this, delegate);
        }

        @Override
        protected void beforeLookup(Lookup.Template t) {
            if (this.result instanceof WaitableResult) {
                ((WaitableResult)this.result).beforeLookup(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLookupListener(LookupListener l) {
            boolean add;
            R r = this;
            synchronized (r) {
                this.listeners = AbstractLookup.modifyListenerList(true, l, this.listeners);
                add = this.listeners != null;
            }
            if (add) {
                this.result.addLookupListener(this.weak);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeLookupListener(LookupListener l) {
            boolean remove;
            R r = this;
            synchronized (r) {
                this.listeners = AbstractLookup.modifyListenerList(false, l, this.listeners);
                remove = this.listeners == null;
            }
            if (remove) {
                this.result.removeLookupListener(this.weak);
            }
        }

        @Override
        public Collection<? extends T> allInstances() {
            return this.openCol(this.result.allInstances(), 0);
        }

        @Override
        protected Collection<? extends T> allInstances(boolean ignore) {
            return this.allInstances();
        }

        private <S> Collection<S> openCol(Collection<S> c, int type) {
            return ExcludingLookup.this.filter(ExcludingLookup.this.classes(), this.from, c, type, new ArrayList(c.size()));
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return ExcludingLookup.this.filter(ExcludingLookup.this.classes(), this.from, this.result.allClasses(), 1, new HashSet());
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.openCol(this.result.allItems(), 2);
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems(boolean ignore) {
            return this.allItems();
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            if (ev.getSource() == this.result) {
                this.collectFires(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            Object[] arr;
            R r = this;
            synchronized (r) {
                if (this.listeners == null) {
                    return;
                }
                if (this.listeners instanceof LookupListener) {
                    arr = new LookupListener[]{(LookupListener)this.listeners};
                } else {
                    ArrayList l = (ArrayList)this.listeners;
                    arr = l.toArray(new LookupListener[l.size()]);
                }
            }
            Object[] ll = arr;
            LookupEvent newev = new LookupEvent(this);
            AbstractLookup.notifyListeners(ll, newev, evAndListeners);
        }
    }
}

