/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderChildrenPair;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderOrder;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Task;
import org.openide.util.WeakListeners;

final class FolderChildren
extends Children.Keys<FolderChildrenPair>
implements PropertyChangeListener,
ChangeListener,
FileChangeListener {
    private FolderList folder;
    private final DataFilter filter;
    private PropertyChangeListener listener;
    private FileChangeListener fcListener;
    private ChangeListener changeListener;
    private final Logger err;
    private volatile Task refTask = Task.EMPTY;

    public FolderChildren(DataFolder f) {
        this(f, DataFilter.ALL);
    }

    public FolderChildren(DataFolder f, DataFilter filter) {
        super(true);
        String log = f.getPrimaryFile().isRoot() ? "org.openide.loaders.FolderChildren" : "org.openide.loaders.FolderChildren." + f.getPrimaryFile().getPath().replace('/', '.');
        this.err = Logger.getLogger(log);
        this.folder = FolderList.find(f.getPrimaryFile(), true);
        this.filter = filter;
        this.listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.folder);
        this.fcListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.folder.getPrimaryFile());
    }

    DataFilter getFilter() {
        return this.filter;
    }

    static void waitRefresh() {
        DataNode.RP.post((Runnable)Task.EMPTY, 0, 1).waitFinished();
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        this.err.log(Level.FINE, "Got a change {0}", ev.getPropertyName());
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshChildren(RefreshMode.DEEP);
    }

    private void refreshChildren(RefreshMode operation) {
        class R
        implements Runnable {
            RefreshMode op;

            R() {
            }

            @Override
            public void run() {
                if (this.op == RefreshMode.DEEP) {
                    this.op = RefreshMode.DEEP_LATER;
                    Children.MUTEX.postWriteRequest((Runnable)this);
                    return;
                }
                FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}", (Object)this.op);
                try {
                    if (this.op == RefreshMode.CLEAR) {
                        FolderChildren.this.setKeys(Collections.emptyList());
                        return;
                    }
                    FileObject[] arr = FolderChildren.this.folder.getPrimaryFile().getChildren();
                    FolderOrder order = FolderOrder.findFor(FolderChildren.this.folder.getPrimaryFile());
                    Arrays.sort(arr, order);
                    ArrayList<FolderChildrenPair> positioned = new ArrayList<FolderChildrenPair>(arr.length);
                    for (FileObject fo : FileUtil.getOrder(Arrays.asList(arr), (boolean)false)) {
                        DataFilter.FileBased f;
                        if (FolderChildren.this.filter instanceof DataFilter.FileBased && !(f = (DataFilter.FileBased)FolderChildren.this.filter).acceptFileObject(fo)) continue;
                        positioned.add(new FolderChildrenPair(fo));
                    }
                    if (this.op == RefreshMode.DEEP_LATER) {
                        FolderChildren.this.setKeys(Collections.emptyList());
                        FolderChildren.this.setKeys(positioned);
                        return;
                    }
                    if (this.op == RefreshMode.SHALLOW) {
                        FolderChildren.this.setKeys(positioned);
                        return;
                    }
                    throw new IllegalStateException("Unknown op: " + (Object)((Object)this.op));
                }
                finally {
                    FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}, done", (Object)this.op);
                }
            }
        }
        R run = new R();
        if (operation == RefreshMode.SHALLOW_IMMEDIATE) {
            this.refTask.waitFinished();
            run.op = RefreshMode.SHALLOW;
            run.run();
        } else {
            run.op = operation;
            this.refTask = DataNode.RP.post((Runnable)run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Node[] createNodes(FolderChildrenPair pair) {
        block9: {
            time = System.currentTimeMillis();
            ret = null;
            try {
                pf = pair.primaryFile;
                obj = DataObject.find(pf);
                if (!obj.isValid() || !pf.equals(obj.getPrimaryFile()) || this.filter != null && !this.filter.acceptDataObject(obj)) break block9;
                ret = obj.getClonedNodeDelegate(this.filter);
                if (obj.isValid()) break block9;
                ret = null;
            }
            catch (DataObjectNotFoundException e) {
                try {
                    Logger.getLogger(FolderChildren.class.getName()).log(Level.FINE, null, e);
                }
                catch (Throwable var8_9) {
                    took = System.currentTimeMillis() - time;
                    if (this.err.isLoggable(Level.FINE)) {
                        this.err.log(Level.FINE, "createNodes: {0} took: {1} ms", new Object[]{pair, took});
                        this.err.log(Level.FINE, "  returning: {0}", ret);
                    }
                    throw var8_9;
                }
                took = System.currentTimeMillis() - time;
                if (this.err.isLoggable(Level.FINE)) {
                    this.err.log(Level.FINE, "createNodes: {0} took: {1} ms", new Object[]{pair, took});
                    this.err.log(Level.FINE, "  returning: {0}", ret);
                } else {
                    ** GOTO lbl30
                }
            }
        }
        took = System.currentTimeMillis() - time;
        if (this.err.isLoggable(Level.FINE)) {
            this.err.log(Level.FINE, "createNodes: {0} took: {1} ms", new Object[]{pair, took});
            this.err.log(Level.FINE, "  returning: {0}", ret);
        }
        if (ret == null) {
            v0 = null;
        } else {
            v1 = new Node[1];
            v0 = v1;
            v1[0] = ret;
        }
        return v0;
    }

    public Node[] getNodes(boolean optimalResult) {
        if (optimalResult) {
            this.waitOptimalResult();
        }
        return this.getNodes();
    }

    public Node findChild(String name) {
        if (FolderChildren.checkChildrenMutex()) {
            this.getNodesCount(true);
        }
        return super.findChild(name);
    }

    private void waitOptimalResult() {
        if (FolderChildren.checkChildrenMutex()) {
            this.err.fine("waitOptimalResult");
            if (!this.isInitialized()) {
                this.refreshChildren(RefreshMode.SHALLOW);
            }
            this.folder.waitProcessingFinished();
            this.refTask.waitFinished();
            this.err.fine("waitOptimalResult: waitProcessingFinished");
        } else {
            Logger.getLogger(FolderChildren.class.getName()).log(Level.WARNING, null, new IllegalStateException("getNodes(true) called while holding the Children.MUTEX"));
        }
    }

    public int getNodesCount(boolean optimalResult) {
        if (optimalResult) {
            this.waitOptimalResult();
        }
        return this.getNodesCount();
    }

    static boolean checkChildrenMutex() {
        return !Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess();
    }

    protected void addNotify() {
        this.err.fine("addNotify begin");
        this.folder.addPropertyChangeListener(this.listener);
        this.folder.getPrimaryFile().addFileChangeListener(this.fcListener);
        if (this.filter instanceof ChangeableDataFilter) {
            ChangeableDataFilter chF = (ChangeableDataFilter)this.filter;
            this.changeListener = WeakListeners.change((ChangeListener)this, (Object)chF);
            chF.addChangeListener(this.changeListener);
        }
        this.refreshChildren(RefreshMode.SHALLOW);
        this.err.fine("addNotify end");
    }

    protected void removeNotify() {
        this.err.fine("removeNotify begin");
        this.folder.getPrimaryFile().removeFileChangeListener(this.fcListener);
        this.folder.removePropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        List emptyList = Collections.emptyList();
        this.setKeys(emptyList);
        this.err.fine("removeNotify end");
    }

    public String toString() {
        return this.folder != null ? this.folder.getPrimaryFile().toString() : super.toString();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        if ("NetBeansAttrAssignedLoader".equals(fe.getName())) {
            DataObjectPool.checkAttributeChanged(fe);
            this.refreshKey(new FolderChildrenPair(fe.getFile()));
            this.refreshChildren(RefreshMode.SHALLOW_IMMEDIATE);
        }
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    public void fileDeleted(FileEvent fe) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    public void fileFolderCreated(FileEvent fe) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    private static enum RefreshMode {
        SHALLOW,
        SHALLOW_IMMEDIATE,
        DEEP,
        DEEP_LATER,
        CLEAR;

    }
}

