/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.netbeans.api.templates.FileBuilder;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

public class FileEntry
extends MultiDataObject.Entry {
    static final long serialVersionUID = 5972727204237511983L;

    public FileEntry(MultiDataObject obj, FileObject fo) {
        MultiDataObject multiDataObject = obj;
        Objects.requireNonNull(multiDataObject);
        super(multiDataObject, fo);
    }

    @Override
    public FileObject copy(FileObject f, String suffix) throws IOException {
        FileObject fo = this.getFile();
        String newName = fo.getName() + suffix;
        return fo.copy(f, newName, fo.getExt());
    }

    @Override
    public FileObject copyRename(FileObject f, String name, String ext) throws IOException {
        FileObject fo = this.getFile();
        return fo.copy(f, name, ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject rename(String name) throws IOException {
        boolean locked = this.isLocked();
        FileLock lock = this.takeLock();
        try {
            this.getFile().rename(lock, name, this.getFile().getExt());
        }
        finally {
            if (!locked) {
                lock.releaseLock();
            }
        }
        return this.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject move(FileObject f, String suffix) throws IOException {
        boolean locked = this.isLocked();
        FileObject fo = this.getFile();
        FileLock lock = this.takeLock();
        try {
            String newName = fo.getName() + suffix;
            FileObject dest = fo.move(lock, f, newName, fo.getExt());
            if (dest == null) {
                throw new IOException(fo + "move(" + lock + ", " + f + ", " + newName + ", " + fo.getExt() + " yields null!");
            }
            FileObject fileObject = dest;
            return fileObject;
        }
        finally {
            if (!locked) {
                lock.releaseLock();
            }
        }
    }

    @Override
    public void delete() throws IOException {
        boolean locked = this.isLocked();
        FileLock lock = this.takeLock();
        try {
            this.getFile().delete(lock);
        }
        finally {
            if (!locked) {
                lock.releaseLock();
            }
        }
    }

    @Override
    public FileObject createFromTemplate(FileObject f, String name) throws IOException {
        FileObject fo = FileBuilder.createFromTemplate((FileObject)this.getFile(), (FileObject)f, (String)name, DataObject.CreateAction.getCallParameters(name), (FileBuilder.Mode)FileBuilder.Mode.COPY);
        DataObject.setTemplate(fo, false);
        return fo;
    }

    public static final class Folder
    extends MultiDataObject.Entry {
        public Folder(MultiDataObject obj, FileObject fo) {
            MultiDataObject multiDataObject = obj;
            Objects.requireNonNull(multiDataObject);
            super(multiDataObject, fo);
        }

        @Override
        public FileObject copy(FileObject f, String suffix) throws IOException {
            String add = suffix + (String)(this.getFile().getExt().length() > 0 ? "." + this.getFile().getExt() : "");
            FileObject fo = FileUtil.createFolder((FileObject)f, (String)(this.getFile().getName() + add));
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fo);
            return fo;
        }

        @Override
        public FileObject move(FileObject f, String suffix) throws IOException {
            return this.copy(f, suffix);
        }

        @Override
        public FileObject createFromTemplate(FileObject f, String name) throws IOException {
            if (name == null) {
                name = FileUtil.findFreeFileName((FileObject)f, (String)this.getFile().getName(), (String)this.getFile().getExt());
            }
            FileObject fo = FileUtil.createFolder((FileObject)f, (String)name);
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fo, (n, v) -> "template".equals(n) ? null : FileUtil.defaultAttributesTransformer().apply(n, v));
            return fo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileObject rename(String name) throws IOException {
            boolean locked = this.isLocked();
            FileLock lock = this.takeLock();
            try {
                this.getFile().rename(lock, name, null);
            }
            finally {
                if (!locked) {
                    lock.releaseLock();
                }
            }
            return this.getFile();
        }

        @Override
        public void delete() throws IOException {
            boolean locked = this.isLocked();
            FileLock lock = this.takeLock();
            try {
                this.getFile().delete(lock);
            }
            finally {
                if (!locked) {
                    lock.releaseLock();
                }
            }
        }
    }

    public static final class Numb
    extends MultiDataObject.Entry {
        static final long serialVersionUID = -6572157492885890612L;

        public Numb(MultiDataObject obj, FileObject fo) {
            MultiDataObject multiDataObject = obj;
            Objects.requireNonNull(multiDataObject);
            super(multiDataObject, fo);
        }

        @Override
        public boolean isImportant() {
            return false;
        }

        @Override
        public FileObject copy(FileObject f, String suffix) {
            return null;
        }

        @Override
        public FileObject rename(String name) throws IOException {
            this.stdBehaving();
            return null;
        }

        @Override
        public FileObject move(FileObject f, String suffix) throws IOException {
            this.stdBehaving();
            return null;
        }

        @Override
        public void delete() throws IOException {
            this.stdBehaving();
        }

        private void stdBehaving() throws IOException {
            if (this.getFile() == null) {
                return;
            }
            if (this.isLocked()) {
                throw new IOException(NbBundle.getBundle(FileEntry.class).getString("EXC_SharedAccess"));
            }
            FileLock lock = this.takeLock();
            try {
                this.getFile().delete(lock);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }

        @Override
        public FileObject createFromTemplate(FileObject f, String name) {
            return null;
        }
    }

    public static abstract class Format
    extends FileEntry {
        static final long serialVersionUID = 8896750589709521197L;

        public Format(MultiDataObject obj, FileObject fo) {
            super(obj, fo);
        }

        @Override
        public FileObject createFromTemplate(FileObject f, String name) throws IOException {
            String ext = this.getFile().getExt();
            if (name == null) {
                name = FileUtil.findFreeFileName((FileObject)f, (String)this.getFile().getName(), (String)ext);
            }
            java.text.Format frm = this.createFormat(f, name, ext);
            List fos = new FileBuilder(this.getFile(), f).name(name).withParameters(DataObject.CreateAction.getCallParameters(name)).useFormat(frm).build();
            FileObject fo = (FileObject)fos.get(0);
            DataObject.setTemplate(fo, false);
            return fo;
        }

        protected abstract java.text.Format createFormat(FileObject var1, String var2, String var3);
    }
}

