/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.debugger.ui.models.BreakpointGroup;
import org.netbeans.modules.debugger.ui.models.BreakpointsViewButtons;
import org.openide.util.NbBundle;

public class BreakpointNestedGroupsDialog
extends JPanel {
    private JButton addButton;
    private JLabel availableGroupsLabel;
    private JList availableGroupsList;
    private JPanel availableGroupsPanel;
    private JScrollPane availableGroupsScrollPane;
    private JPanel buttonPanel;
    private JLabel displayedGroupsLabel;
    private JList displayedGroupsList;
    private JPanel displayedGroupsPanel;
    private JScrollPane displayedGroupsScrollPane;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton removeButton;

    public BreakpointNestedGroupsDialog() {
        this.initComponents();
        this.setAvailableGroups();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BreakpointNestedGroupsDialog.this.availableGroupsList.setSelectedIndex(0);
                BreakpointNestedGroupsDialog.this.displayedGroupsList.setSelectedIndex(0);
            }
        });
    }

    private void initComponents() {
        this.availableGroupsPanel = new JPanel();
        this.availableGroupsLabel = new JLabel();
        this.availableGroupsScrollPane = new JScrollPane();
        this.availableGroupsList = new JList();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.displayedGroupsPanel = new JPanel();
        this.displayedGroupsLabel = new JLabel();
        this.displayedGroupsScrollPane = new JScrollPane();
        this.displayedGroupsList = new JList();
        this.setLayout(new GridBagLayout());
        this.availableGroupsPanel.setLayout(new GridBagLayout());
        this.availableGroupsLabel.setText(NbBundle.getMessage(BreakpointNestedGroupsDialog.class, (String)"BreakpointNestedGroupsDialog.availableGroupsLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.availableGroupsPanel.add((Component)this.availableGroupsLabel, gridBagConstraints);
        this.availableGroupsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                BreakpointNestedGroupsDialog.this.availableGroupsListValueChanged(evt);
            }
        });
        this.availableGroupsScrollPane.setViewportView(this.availableGroupsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.availableGroupsPanel.add((Component)this.availableGroupsScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.availableGroupsPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.addButton.setText(NbBundle.getMessage(BreakpointNestedGroupsDialog.class, (String)"BreakpointNestedGroupsDialog.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BreakpointNestedGroupsDialog.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText(NbBundle.getMessage(BreakpointNestedGroupsDialog.class, (String)"BreakpointNestedGroupsDialog.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BreakpointNestedGroupsDialog.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        this.moveUpButton.setText(NbBundle.getMessage(BreakpointNestedGroupsDialog.class, (String)"BreakpointNestedGroupsDialog.moveUpButton.text"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BreakpointNestedGroupsDialog.this.moveUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveDownButton.setText(NbBundle.getMessage(BreakpointNestedGroupsDialog.class, (String)"BreakpointNestedGroupsDialog.moveDownButton.text"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BreakpointNestedGroupsDialog.this.moveDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.moveDownButton, gridBagConstraints);
        this.add((Component)this.buttonPanel, new GridBagConstraints());
        this.displayedGroupsPanel.setLayout(new GridBagLayout());
        this.displayedGroupsLabel.setText(NbBundle.getMessage(BreakpointNestedGroupsDialog.class, (String)"BreakpointNestedGroupsDialog.displayedGroupsLabel.text"));
        this.displayedGroupsPanel.add((Component)this.displayedGroupsLabel, new GridBagConstraints());
        this.displayedGroupsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                BreakpointNestedGroupsDialog.this.displayedGroupsListValueChanged(evt);
            }
        });
        this.displayedGroupsScrollPane.setViewportView(this.displayedGroupsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.displayedGroupsPanel.add((Component)this.displayedGroupsScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.displayedGroupsPanel, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        int[] indexes = this.availableGroupsList.getSelectedIndices();
        DefaultListModel availableModel = (DefaultListModel)this.availableGroupsList.getModel();
        DefaultListModel displayedModel = (DefaultListModel)this.displayedGroupsList.getModel();
        int at = displayedModel.getSize();
        for (int i = indexes.length - 1; i >= 0; --i) {
            Object element = availableModel.remove(indexes[i]);
            displayedModel.add(at, element);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] indexes = this.displayedGroupsList.getSelectedIndices();
        DefaultListModel availableModel = (DefaultListModel)this.availableGroupsList.getModel();
        DefaultListModel displayedModel = (DefaultListModel)this.displayedGroupsList.getModel();
        int at = availableModel.getSize();
        for (int i = indexes.length - 1; i >= 0; --i) {
            Object element = displayedModel.remove(indexes[i]);
            availableModel.add(at, element);
        }
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        int[] indexes = this.displayedGroupsList.getSelectedIndices();
        DefaultListModel displayedModel = (DefaultListModel)this.displayedGroupsList.getModel();
        for (int index : indexes) {
            Object down = displayedModel.get(index - 1);
            Object up = displayedModel.get(index);
            displayedModel.set(index, down);
            displayedModel.set(index - 1, up);
        }
        int i = 0;
        while (i < indexes.length) {
            int n = i++;
            indexes[n] = indexes[n] - 1;
        }
        this.displayedGroupsList.setSelectedIndices(indexes);
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        int[] indexes = this.displayedGroupsList.getSelectedIndices();
        DefaultListModel displayedModel = (DefaultListModel)this.displayedGroupsList.getModel();
        for (int index : indexes) {
            Object down = displayedModel.get(index);
            Object up = displayedModel.get(index + 1);
            displayedModel.set(index + 1, down);
            displayedModel.set(index, up);
        }
        int i = 0;
        while (i < indexes.length) {
            int n = i++;
            indexes[n] = indexes[n] + 1;
        }
        this.displayedGroupsList.setSelectedIndices(indexes);
    }

    private void availableGroupsListValueChanged(ListSelectionEvent evt) {
        Object selected = this.availableGroupsList.getSelectedValue();
        this.addButton.setEnabled(selected != null);
    }

    private void displayedGroupsListValueChanged(ListSelectionEvent evt) {
        int[] selected = this.displayedGroupsList.getSelectedIndices();
        this.removeButton.setEnabled(selected.length > 0);
        this.moveUpButton.setEnabled(selected.length > 0 && selected[0] > 0);
        this.moveDownButton.setEnabled(selected.length > 0 && selected[selected.length - 1] < this.displayedGroupsList.getModel().getSize() - 1);
    }

    private void setAvailableGroups() {
        DefaultListModel<GroupElement> model = new DefaultListModel<GroupElement>();
        model.addElement(new GroupElement(BreakpointGroup.Group.CUSTOM));
        model.addElement(new GroupElement(BreakpointGroup.Group.LANGUAGE));
        model.addElement(new GroupElement(BreakpointGroup.Group.TYPE));
        model.addElement(new GroupElement(BreakpointGroup.Group.PROJECT));
        model.addElement(new GroupElement(BreakpointGroup.Group.FILE));
        model.addElement(new GroupElement(BreakpointGroup.Group.ENGINE));
        this.availableGroupsList.setModel(model);
    }

    void setDisplayedGroups(String[] groupNames) {
        DefaultListModel availableModel = (DefaultListModel)this.availableGroupsList.getModel();
        DefaultListModel<GroupElement> model = new DefaultListModel<GroupElement>();
        for (String groupName : groupNames) {
            BreakpointGroup.Group g;
            try {
                g = BreakpointGroup.Group.valueOf(groupName);
            }
            catch (IllegalArgumentException iaex) {
                continue;
            }
            GroupElement ge = new GroupElement(g);
            model.addElement(ge);
            availableModel.removeElement(ge);
        }
        this.displayedGroupsList.setModel(model);
    }

    String[] getDisplayedGroups() {
        ListModel model = this.displayedGroupsList.getModel();
        int n = model.getSize();
        String[] groupNames = new String[n];
        for (int i = 0; i < n; ++i) {
            GroupElement ge = (GroupElement)model.getElementAt(i);
            groupNames[i] = ge.getGroup().name();
        }
        return groupNames;
    }

    private static final class GroupElement {
        private BreakpointGroup.Group group;

        public GroupElement(BreakpointGroup.Group group) {
            this.group = group;
        }

        BreakpointGroup.Group getGroup() {
            return this.group;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GroupElement)) {
                return false;
            }
            return this.group.equals((Object)((GroupElement)obj).group);
        }

        public int hashCode() {
            return this.group.hashCode();
        }

        public String toString() {
            String name = "LBL_" + this.group.name() + "Group";
            name = NbBundle.getMessage(BreakpointsViewButtons.class, (String)name);
            return name;
        }
    }
}

