/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.xml.retriever.DocumentTypeParser;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.impl.DocumentTypeSchemaWsdlParser;

public class DocumentParserFactory {
    private static ArrayList<DocumentTypeParser> registereDocumentTypeParsers = new ArrayList();

    public static DocumentTypeParser getParser(Utilities.DocumentTypesEnum docType) {
        for (DocumentTypeParser dParser : registereDocumentTypeParsers) {
            if (!dParser.accept(docType.toString())) continue;
            return dParser;
        }
        return null;
    }

    public static List<DocumentTypeParser> getRegisteredParsers() {
        return registereDocumentTypeParsers;
    }

    public static boolean removeRegisteredParser(DocumentTypeParser oldDocumentTypeParser) {
        return registereDocumentTypeParsers.remove(oldDocumentTypeParser);
    }

    public static void addParser(DocumentTypeParser newDocumentTypeParser) {
        registereDocumentTypeParsers.add(newDocumentTypeParser);
    }

    static {
        registereDocumentTypeParsers.add(new DocumentTypeSchemaWsdlParser());
    }
}

