/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.util.Random;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.netbeans.modules.uihandler.Installer;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class MetricsHandler
extends Handler {
    private static Task lastRecord = Task.EMPTY;
    private static RequestProcessor FLUSH = new RequestProcessor("Flush Metrics Logs");
    private static boolean flushOnRecord;
    static final int MAX_LOGS = 400;
    static final int MAX_DAYS;
    static final long MAX_LOGS_SIZE = 0xA00000L;

    public MetricsHandler() {
        this.setLevel(Level.FINEST);
    }

    @Override
    public void publish(LogRecord record) {
        class WriteOut
        implements Runnable {
            public LogRecord r;

            WriteOut() {
            }

            @Override
            public void run() {
                Installer.writeOutMetrics(this.r);
                this.r = null;
            }
        }
        WriteOut wo = new WriteOut();
        wo.r = record;
        lastRecord = FLUSH.post((Runnable)wo);
        if (flushOnRecord) {
            MetricsHandler.waitFlushed();
        }
    }

    @Override
    public void flush() {
        MetricsHandler.waitFlushed();
    }

    static void flushImmediatelly() {
        flushOnRecord = true;
    }

    static void setFlushOnRecord(boolean flushOnRecord) {
        MetricsHandler.flushOnRecord = flushOnRecord;
    }

    static void waitFlushed() {
        try {
            lastRecord.waitFinished(1000L);
        }
        catch (InterruptedException ex) {
            Installer.LOG.log(Level.FINE, null, ex);
        }
    }

    @Override
    public void close() throws SecurityException {
    }

    static {
        MAX_DAYS = 33 + new Random(System.currentTimeMillis()).nextInt(14);
    }
}

