/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.netbeans.modules.uihandler.Installer;
import org.openide.awt.Mnemonics;

final class ButtonsHTMLParser {
    static final Logger logger = Logger.getLogger(ButtonsHTMLParser.class.getName());
    private final InputStream is;
    private FormHTMLParser formParser;
    private List<Object> options;
    private List<Object> additionalOptions;
    private boolean containsExitButton;

    public ButtonsHTMLParser(InputStream is) {
        this.is = is;
    }

    void parse() throws IOException {
        ParserDelegator pd = new ParserDelegator();
        InputStreamReader r = new InputStreamReader(this.is, "utf-8");
        this.formParser = new FormHTMLParser();
        pd.parse(r, this.formParser, true);
    }

    void createButtons() {
        if (this.formParser == null) {
            throw new IllegalStateException("parse() must be called before this.");
        }
        this.options = new ArrayList<Object>();
        this.additionalOptions = new ArrayList<Object>();
        List<MutableAttributeSet> inputs = this.formParser.getInputs();
        if (inputs.isEmpty()) {
            return;
        }
        String action = ButtonsHTMLParser.attrValue((AttributeSet)inputs.get(0), HTML.Attribute.ACTION);
        if (action == null || action.isEmpty()) {
            throw new IllegalStateException("Action should not be empty");
        }
        String url = action;
        for (int i = 1; i < inputs.size(); ++i) {
            List<Object> addTo;
            MutableAttributeSet node = inputs.get(i);
            String name = ButtonsHTMLParser.attrValue((AttributeSet)node, HTML.Attribute.NAME);
            String value = ButtonsHTMLParser.attrValue((AttributeSet)node, HTML.Attribute.VALUE);
            String align = ButtonsHTMLParser.attrValue((AttributeSet)node, HTML.Attribute.ALIGN);
            String alt = ButtonsHTMLParser.attrValue((AttributeSet)node, HTML.Attribute.ALT);
            boolean enabled = true;
            String disabledValue = ButtonsHTMLParser.attrValue((AttributeSet)node, "disabled");
            if ("true".equals(disabledValue)) {
                enabled = false;
            } else if ("disabled".equals(disabledValue)) {
                enabled = false;
            }
            List<Object> list = addTo = "left".equals(align) ? this.additionalOptions : this.options;
            if (Installer.Button.isSubmitTrigger(name)) {
                String submitValue = value;
                JButton b = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)b, (String)submitValue);
                b.setActionCommand(name);
                b.putClientProperty("url", url);
                b.setDefaultCapable(addTo.isEmpty() && addTo == this.options);
                b.putClientProperty("alt", alt);
                b.putClientProperty("now", submitValue);
                b.setEnabled(enabled);
                addTo.add(b);
                continue;
            }
            JButton b = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)b, (String)value);
            b.setActionCommand(name);
            b.setDefaultCapable(addTo.isEmpty() && addTo == this.options);
            b.putClientProperty("alt", alt);
            b.putClientProperty("now", value);
            b.setEnabled(enabled && Installer.Button.isKnown(name));
            addTo.add(b);
            if (Installer.Button.EXIT.isCommand(name)) {
                this.containsExitButton = true;
            }
            if (!Installer.Button.REDIRECT.isCommand(name)) continue;
            b.putClientProperty("url", url);
        }
    }

    private static String attrValue(AttributeSet attr, Object attrName) {
        Object valueObj = attr.getAttribute(attrName);
        if (valueObj == null) {
            return null;
        }
        if (!(valueObj instanceof String)) {
            throw new IllegalStateException("Attribute " + attrName + " has a wrong value: " + valueObj);
        }
        return (String)valueObj;
    }

    private static String attrValue(AttributeSet attr, String attrName) {
        Enumeration<?> en = attr.getAttributeNames();
        while (en.hasMoreElements()) {
            Object name = en.nextElement();
            if (!attrName.equalsIgnoreCase(name.toString())) continue;
            return ButtonsHTMLParser.attrValue(attr, name);
        }
        return null;
    }

    List<Object> getOptions() {
        return this.options;
    }

    List<Object> getAdditionalOptions() {
        return this.additionalOptions;
    }

    String getTitle() {
        return this.formParser.getTitle();
    }

    boolean containsExitButton() {
        return this.containsExitButton;
    }

    private static final class FormHTMLParser
    extends HTMLEditorKit.ParserCallback {
        private static final String TAG_TITLE = "title";
        private static final String TAG_FORM = "form";
        private static final String TAG_INPUT = "input";
        private boolean readingTitle = false;
        private String title;
        private boolean readingForm = false;
        private final List<MutableAttributeSet> inputs = new ArrayList<MutableAttributeSet>();

        private FormHTMLParser() {
        }

        public String getTitle() {
            return this.title;
        }

        public List<MutableAttributeSet> getInputs() {
            return this.inputs;
        }

        @Override
        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            String tag = t.toString();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "StartTag <{0}> with attributes: {1}", new Object[]{tag, Collections.list(a.getAttributeNames()).toString()});
            }
            if (TAG_TITLE.equalsIgnoreCase(tag)) {
                this.readingTitle = true;
                return;
            }
            this.readingTitle = false;
            if (TAG_FORM.equalsIgnoreCase(tag)) {
                this.readingForm = true;
                this.inputs.clear();
                this.inputs.add(new SimpleAttributeSet(a));
                return;
            }
            if (this.readingForm && TAG_INPUT.equalsIgnoreCase(tag)) {
                this.inputs.add(new SimpleAttributeSet(a));
            }
        }

        @Override
        public void handleEndTag(HTML.Tag t, int pos) {
            String tag = t.toString();
            logger.log(Level.FINE, "EndTag <{0}>", tag);
            if (TAG_TITLE.equalsIgnoreCase(tag)) {
                this.readingTitle = false;
            }
            if (TAG_FORM.equalsIgnoreCase(tag)) {
                this.readingForm = false;
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            String tag = t.toString();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "SimpleTag <{0}> with attributes: {1}", new Object[]{tag, Collections.list(a.getAttributeNames()).toString()});
            }
            if (this.readingForm && TAG_INPUT.equalsIgnoreCase(tag)) {
                this.inputs.add(new SimpleAttributeSet(a));
            }
        }

        @Override
        public void handleText(char[] data, int pos) {
            if (logger.isLoggable(Level.FINE)) {
                String text = new String(data);
                logger.log(Level.FINE, "Text: ''{0}''", new Object[]{text});
            }
            if (this.readingTitle) {
                this.title = new String(data);
            }
        }

        @Override
        public void handleError(String errorMsg, int pos) {
            logger.log(Level.FINE, "Error: ''{0}'' at {1}", new Object[]{errorMsg, pos});
        }
    }
}

