/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;

final class SubprojectProviderImpl
implements SubprojectProvider {
    private final ReferenceHelper helper;

    SubprojectProviderImpl(ReferenceHelper helper) {
        this.helper = helper;
    }

    public Set<? extends Project> getSubprojects() {
        return (Set)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Set<? extends Project>>(){

            public Set<? extends Project> run() {
                HashSet<String> foreignProjectNames = new HashSet<String>();
                for (ReferenceHelper.RawReference ref : SubprojectProviderImpl.this.helper.getRawReferences()) {
                    foreignProjectNames.add(ref.getForeignProjectName());
                }
                HashSet<Project> foreignProjects = new HashSet<Project>();
                for (String foreignProjectName : foreignProjectNames) {
                    FileObject foreignProjectDir;
                    String prop = "project." + foreignProjectName;
                    AntProjectHelper h = SubprojectProviderImpl.this.helper.getAntProjectHelper();
                    String foreignProjectDirS = ((SubprojectProviderImpl)SubprojectProviderImpl.this).helper.eval.getProperty(prop);
                    if (foreignProjectDirS == null || (foreignProjectDir = h.resolveFileObject(foreignProjectDirS)) == null) continue;
                    try {
                        Project p = ProjectManager.getDefault().findProject(foreignProjectDir);
                        if (p == null) continue;
                        foreignProjects.add(p);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
                return foreignProjects;
            }
        });
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }
}

