/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl;

import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.parsing.impl.EmbeddingProviderFactory;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class EmbeddingProviderRegistrationProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(EmbeddingProvider.Registration.class.getCanonicalName());
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        for (Element element : roundEnv.getElementsAnnotatedWith(EmbeddingProvider.Registration.class)) {
            String targetMimeType;
            if (!element.getKind().isClass()) {
                throw new LayerGenerationException("Annotated Element has to be a class.", element);
            }
            EmbeddingProvider.Registration reg = element.getAnnotation(EmbeddingProvider.Registration.class);
            String mimeType = reg.mimeType();
            if (mimeType == null) {
                throw new LayerGenerationException("Mime type has to be given.", element);
            }
            if (!mimeType.isEmpty()) {
                mimeType = '/' + mimeType;
            }
            if ((targetMimeType = reg.targetMimeType()) == null || targetMimeType.isEmpty()) {
                throw new LayerGenerationException("Target mime type has to be given.", element);
            }
            this.layer(new Element[]{element}).instanceFile("Editors" + mimeType, null, null).stringvalue("instanceOf", TaskFactory.class.getName()).methodvalue("instanceCreate", EmbeddingProviderFactory.class.getName(), "create").stringvalue("targetMimeType", targetMimeType).instanceAttribute("provider", EmbeddingProvider.class).write();
        }
        return true;
    }
}

