/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsCategory;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.util.NbBundle;

public class OptionsPanelControllerProcessor
extends LayerGeneratingProcessor {
    private Element originatingElement;

    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(OptionsPanelController.TopLevelRegistration.class.getCanonicalName(), OptionsPanelController.ContainerRegistration.class.getCanonicalName(), OptionsPanelController.SubRegistration.class.getCanonicalName(), OptionsPanelController.KeywordsRegistration.class.getCanonicalName(), OptionsPanelController.Keywords.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        LayerBuilder builder;
        Annotation r;
        if (roundEnv.processingOver()) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(OptionsPanelController.TopLevelRegistration.class)) {
            r = element.getAnnotation(OptionsPanelController.TopLevelRegistration.class);
            if (r == null) continue;
            builder = this.layer(new Element[]{element});
            LayerBuilder.File file = builder.instanceFile("OptionsDialog", r.id().length() > 0 ? r.id() : null, r, null).methodvalue("instanceCreate", OptionsCategory.class.getName(), "createCategory").instanceAttribute("controller", OptionsPanelController.class).bundlevalue("categoryName", r.categoryName()).position(r.position());
            this.iconBase(element, r.iconBase(), r, file, builder);
            this.keywords(element, r.keywords(), r.keywordsCategory(), r, file);
            file.write();
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(OptionsPanelController.SubRegistration.class)) {
            r = element.getAnnotation(OptionsPanelController.SubRegistration.class);
            if (r.position() != Integer.MAX_VALUE && r.location().equals("Advanced")) {
                throw new LayerGenerationException("position ignored for Advanced subpanels", element, this.processingEnv, r, "position");
            }
            LayerBuilder.File file = this.layer(new Element[]{element}).instanceFile("OptionsDialog/" + r.location(), r.id().length() > 0 ? r.id() : null, r, null).methodvalue("instanceCreate", AdvancedOption.class.getName(), "createSubCategory").instanceAttribute("controller", OptionsPanelController.class).bundlevalue("displayName", r.displayName()).position(r.position());
            this.keywords(element, r.keywords(), r.keywordsCategory(), r, file);
            file.write();
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(OptionsPanelController.Keywords.class)) {
            this.handleElement(element, element.getAnnotation(OptionsPanelController.Keywords.class), "");
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(OptionsPanelController.KeywordsRegistration.class)) {
            r = element.getAnnotation(OptionsPanelController.KeywordsRegistration.class);
            OptionsPanelController.Keywords[] panels = r.value();
            for (int i = 0; i < panels.length; ++i) {
                this.handleElement(element, panels[i], Integer.toString(-(i + 1)));
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(OptionsPanelController.ContainerRegistration.class)) {
            r = element.getAnnotation(OptionsPanelController.ContainerRegistration.class);
            builder = this.layer(new Element[]{element});
            LayerBuilder.File file = builder.file("OptionsDialog/" + r.id() + ".instance").methodvalue("instanceCreate", OptionsCategory.class.getName(), "createCategory").stringvalue("advancedOptionsFolder", "OptionsDialog/" + r.id()).bundlevalue("categoryName", r.categoryName()).position(r.position());
            this.iconBase(element, r.iconBase(), r, file, builder);
            this.keywords(element, r.keywords(), r.keywordsCategory(), r, file);
            file.write();
            this.layer(new Element[]{element}).folder("OptionsDialog/" + r.id()).position(0).write();
        }
        return true;
    }

    private void handleElement(Element e, OptionsPanelController.Keywords annotation, String name) throws LayerGenerationException {
        this.originatingElement = e;
        if (!annotation.location().equals("General") && !annotation.location().equals("Keymaps") && annotation.tabTitle().trim().isEmpty()) {
            throw new LayerGenerationException("Must specify tabTitle", e, this.processingEnv, (Annotation)annotation, "tabTitle");
        }
        LayerBuilder.File file = this.layer(new Element[]{e}).file("OptionsDialog/Keywords/".concat(e.asType().toString()).concat(name)).stringvalue("location", annotation.location()).bundlevalue("tabTitle", annotation.tabTitle(), (Annotation)annotation, "tabTitle");
        String[] keywords = annotation.keywords();
        for (int j = 0; j < keywords.length; ++j) {
            file = file.bundlevalue("keywords-".concat(Integer.toString(j + 1)), keywords[j], (Annotation)annotation, "keywords");
        }
        file.write();
    }

    private String getBundleValue(String label, Annotation annotation, String annotationMethod) throws LayerGenerationException {
        String javaIdentifier = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
        Matcher m = Pattern.compile("((?:" + javaIdentifier + "\\.)+[^\\s.#]+)?#(\\S*)").matcher(label);
        if (m.matches()) {
            Object bundle = m.group(1);
            String key = m.group(2);
            if (bundle == null) {
                Element referenceElement;
                for (referenceElement = this.originatingElement; referenceElement != null && referenceElement.getKind() != ElementKind.PACKAGE; referenceElement = referenceElement.getEnclosingElement()) {
                }
                if (referenceElement == null) {
                    throw new LayerGenerationException("No reference element to determine package in '" + label + "'", this.originatingElement);
                }
                bundle = ((PackageElement)referenceElement).getQualifiedName() + ".Bundle";
            }
            return this.verifyBundleValue((String)bundle, key, m.group(1) == null, annotation, annotationMethod);
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String verifyBundleValue(String bundle, String key, boolean samePackage, Annotation annotation, String annotationMethod) throws LayerGenerationException {
        String string;
        if (this.processingEnv == null) {
            return "";
        }
        if (samePackage) {
            for (Element e = this.originatingElement; e != null; e = e.getEnclosingElement()) {
                NbBundle.Messages m = e.getAnnotation(NbBundle.Messages.class);
                if (m == null) continue;
                for (String kv : m.value()) {
                    if (!kv.startsWith(key + "=")) continue;
                    return bundle.concat("#").concat(key);
                }
            }
        }
        InputStream is = this.layer(new Element[]{this.originatingElement}).validateResource(bundle.replace('.', '/') + ".properties", this.originatingElement, null, null, false).openInputStream();
        try {
            Properties p = new Properties();
            p.load(is);
            if (p.getProperty(key) == null) {
                throw new LayerGenerationException("No key '" + key + "' found in " + bundle, this.originatingElement, this.processingEnv, annotation, annotationMethod);
            }
            string = bundle.concat("#").concat(key);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException x) {
                throw new LayerGenerationException("Could not open " + bundle + ": " + x, this.originatingElement, this.processingEnv, annotation, annotationMethod);
            }
        }
        is.close();
        return string;
    }

    private void iconBase(Element e, String iconBase, Annotation r, LayerBuilder.File file, LayerBuilder builder) throws LayerGenerationException {
        builder.validateResource(iconBase, e, r, "iconBase", true);
        file.stringvalue("iconBase", iconBase);
    }

    private void keywords(Element e, String keywords, String keywordsCategory, Annotation r, LayerBuilder.File file) throws LayerGenerationException {
        if (keywords.length() > 0) {
            if (keywordsCategory.length() == 0) {
                throw new LayerGenerationException("Must specify both keywords and keywordsCategory", e, this.processingEnv, r, "keywordsCategory");
            }
            file.bundlevalue("keywords", keywords, r, "keywords").bundlevalue("keywordsCategory", keywordsCategory, r, "keywordsCategory");
        } else if (keywordsCategory.length() > 0) {
            throw new LayerGenerationException("Must specify both keywords and keywordsCategory", e, this.processingEnv, r, "keywords");
        }
    }
}

