/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netbinox;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.Manifest;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;

final class NetigsoBundleFile
extends BundleFile {
    private final BundleData data;

    NetigsoBundleFile(File base, BundleData data) {
        super(base);
        this.data = data;
    }

    public File getFile(String string, boolean bln) {
        return null;
    }

    public BundleEntry getEntry(String entry) {
        if ("META-INF/MANIFEST.MF".equals(entry)) {
            return new BundleEntry(){

                public InputStream getInputStream() throws IOException {
                    for (ModuleInfo mi : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
                        if (!NetigsoBundleFile.this.data.getLocation().endsWith(mi.getCodeNameBase())) continue;
                        return NetigsoBundleFile.fakeManifest(mi);
                    }
                    throw new IOException("Cannot find " + NetigsoBundleFile.this.data.getLocation());
                }

                public long getSize() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public String getName() {
                    return "META-INF/MANIFEST.MF";
                }

                public long getTime() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public URL getLocalURL() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public URL getFileURL() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
        return null;
    }

    public Enumeration getEntryPaths(String string) {
        return Collections.enumeration(Collections.emptyList());
    }

    public void close() throws IOException {
    }

    public void open() throws IOException {
    }

    public boolean containsDir(String string) {
        return false;
    }

    private static InputStream fakeManifest(ModuleInfo m) throws IOException {
        String exp = (String)m.getAttribute("OpenIDE-Module-Public-Packages");
        if ("-".equals(exp)) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Manifest man = new Manifest();
        man.getMainAttributes().putValue("Manifest-Version", "1.0");
        man.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
        man.getMainAttributes().putValue("Bundle-SymbolicName", m.getCodeNameBase());
        if (m.getSpecificationVersion() != null) {
            String spec = NetigsoBundleFile.threeDotsWithMajor(m.getSpecificationVersion().toString(), m.getCodeName());
            man.getMainAttributes().putValue("Bundle-Version", spec.toString());
        }
        if (exp != null) {
            man.getMainAttributes().putValue("Export-Package", exp.replaceAll("\\.\\*", ""));
        } else {
            man.getMainAttributes().putValue("Export-Package", m.getCodeNameBase());
        }
        man.write(os);
        return new ByteArrayInputStream(os.toByteArray());
    }

    private static String threeDotsWithMajor(String version, String withMajor) {
        int indx = withMajor.indexOf(47);
        int major = 0;
        if (indx > 0) {
            major = Integer.parseInt(withMajor.substring(indx + 1));
        }
        String[] segments = (version + ".0.0.0").split("\\.");
        assert (segments.length >= 3 && segments[0].length() > 0);
        return Integer.parseInt(segments[0]) + major * 100 + "." + segments[1] + "." + segments[2];
    }
}

