/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Tuple;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.Bundle;
import org.netbeans.modules.lsp.client.bindings.Icons;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.xml.XMLUtil;

public class CompletionProviderImpl
implements CompletionProvider {
    private static final Logger LOG = Logger.getLogger(CompletionProviderImpl.class.getName());
    static IndirectCompletionItemRenderer COMPLETION_ITEM_RENDERER = new IndirectCompletionItemRenderer(){

        @Override
        public void renderCompletionItem(ImageIcon icon, String leftLabel, String rightLabel, Graphics grphcs, Font font, Color color, int i, int i1, boolean bln) {
            CompletionUtilities.renderHtml((ImageIcon)icon, (String)leftLabel, (String)rightLabel, (Graphics)grphcs, (Font)font, (Color)color, (int)i, (int)i1, (boolean)bln);
        }
    };

    public CompletionTask createTask(int queryType, final JTextComponent component) {
        if ((queryType & 4) != 0) {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                    try {
                        FileObject file = NbEditorUtilities.getFileObject((Document)doc);
                        if (file == null) {
                            return;
                        }
                        StringBuilder signatures = new StringBuilder();
                        Utils.handleBindings(LSPBindings.getBindings(file), capa -> capa.getSignatureHelpProvider() != null, () -> new SignatureHelpParams(new TextDocumentIdentifier(Utils.toURI(file)), Utils.createPosition(doc, caretOffset)), (server, params) -> server.getTextDocumentService().signatureHelp(params), (server, result) -> CompletionProviderImpl.this.handleSignatureInfo((SignatureHelp)result, signatures));
                        if (signatures.isEmpty()) {
                            return;
                        }
                        signatures.insert(0, "<html>");
                        JToolTip tip = new JToolTip();
                        tip.setTipText(signatures.toString());
                        resultSet.setToolTip(tip);
                    }
                    finally {
                        resultSet.finish();
                    }
                }
            }, component);
        }
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                try {
                    FileObject file = NbEditorUtilities.getFileObject((Document)doc);
                    if (file == null) {
                        return;
                    }
                    Utils.handleBindings(LSPBindings.getBindings(file), capa -> capa.getCompletionProvider() != null, () -> new CompletionParams(new TextDocumentIdentifier(Utils.toURI(file)), Utils.createPosition(doc, caretOffset)), (server, params) -> server.getTextDocumentService().completion(params), (server, result) -> CompletionProviderImpl.this.handleCompletionResult(resultSet, component, doc, caretOffset, (LSPBindings)server, (Either<List<CompletionItem>, CompletionList>)result));
                }
                finally {
                    resultSet.finish();
                }
            }
        }, component);
    }

    private void handleSignatureInfo(SignatureHelp help, StringBuilder signatures) {
        if (help == null || help.getSignatures().isEmpty()) {
            return;
        }
        for (SignatureInformation info : help.getSignatures()) {
            if (info.getParameters() == null || info.getParameters().isEmpty()) {
                if (info.getLabel().isEmpty()) {
                    signatures.append(Bundle.DN_NoParameter());
                } else {
                    signatures.append(info.getLabel());
                }
                signatures.append("<br>");
                continue;
            }
            String sigSep = "";
            int idx = 0;
            for (ParameterInformation pi : info.getParameters()) {
                String label;
                signatures.append(sigSep);
                if (idx == help.getActiveParameter()) {
                    signatures.append("<b>");
                }
                if (pi.getLabel().isLeft()) {
                    label = (String)pi.getLabel().getLeft();
                } else {
                    Integer start = (Integer)((Tuple.Two)pi.getLabel().getRight()).getFirst();
                    Integer end = (Integer)((Tuple.Two)pi.getLabel().getRight()).getSecond();
                    label = info.getLabel().substring(start, end);
                }
                signatures.append(label);
                if (idx == help.getActiveParameter()) {
                    signatures.append("</b>");
                }
                sigSep = ", ";
                ++idx;
            }
            signatures.append("<br>");
        }
    }

    private void handleCompletionResult(CompletionResultSet resultSet, final JTextComponent component, final Document doc, final int caretOffset, final LSPBindings server, Either<List<CompletionItem>, CompletionList> completionResult) {
        List items;
        if (completionResult == null) {
            return;
        }
        final CompletionOptions completionOptions = server.getInitResult().getCapabilities().getCompletionProvider();
        if (completionResult.isLeft()) {
            items = (List)completionResult.getLeft();
            incomplete = true;
        } else {
            items = ((CompletionList)completionResult.getRight()).getItems();
            incomplete = ((CompletionList)completionResult.getRight()).isIncomplete();
        }
        for (final CompletionItem i : items) {
            String rightLabel;
            String leftLabel;
            String insert;
            String string = insert = i.getInsertText() != null ? i.getInsertText() : i.getLabel();
            if (i.getLabelDetails() != null) {
                leftLabel = this.encode(i.getLabel() + (i.getLabelDetails().getDetail() != null ? i.getLabelDetails().getDetail() : ""));
                rightLabel = i.getLabelDetails().getDescription() != null ? this.encode(i.getLabelDetails().getDescription()) : null;
            } else {
                leftLabel = this.encode(i.getLabel());
                rightLabel = i.getDetail() != null ? this.encode(i.getDetail()) : null;
            }
            final String sortText = i.getSortText() != null ? i.getSortText() : i.getLabel();
            CompletionItemKind kind = i.getKind();
            final ImageIcon icon = ImageUtilities.icon2ImageIcon((Icon)Icons.getCompletionIcon(kind));
            resultSet.addItem(new org.netbeans.spi.editor.completion.CompletionItem(){

                public void defaultAction(JTextComponent jtc) {
                    this.commit("");
                }

                private void commit(String appendText) {
                    CompletionItem resolved;
                    if (i.getTextEdit() == null && CompletionProviderImpl.this.hasCompletionResolve(completionOptions)) {
                        CompletionItem resolvedTemp = i;
                        try {
                            resolvedTemp = (CompletionItem)server.getTextDocumentService().resolveCompletionItem(resolvedTemp).get();
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            LOG.log(Level.FINE, null, ex);
                        }
                        resolved = resolvedTemp;
                    } else {
                        resolved = i;
                    }
                    Either edit = resolved.getTextEdit();
                    if (edit != null && edit.isRight()) {
                        Completion.get().hideDocumentation();
                        Completion.get().hideCompletion();
                        return;
                    }
                    NbDocument.runAtomic((StyledDocument)((StyledDocument)doc), () -> {
                        try {
                            TextEdit mainEdit;
                            CodeTemplate template = null;
                            if (edit != null) {
                                TextEdit providedMainEdit = (TextEdit)edit.getLeft();
                                if (resolved.getInsertTextFormat() == InsertTextFormat.Snippet) {
                                    template = CodeTemplateManager.get((Document)doc).createTemporary(CompletionProviderImpl.convertSnippet2CodeTemplate(providedMainEdit.getNewText()));
                                    mainEdit = new TextEdit(providedMainEdit.getRange(), "");
                                } else {
                                    mainEdit = providedMainEdit;
                                }
                            } else {
                                org.eclipse.lsp4j.Position end;
                                org.eclipse.lsp4j.Position start;
                                String toAdd;
                                if (resolved.getInsertTextFormat() == InsertTextFormat.Snippet) {
                                    template = CodeTemplateManager.get((Document)doc).createTemporary(CompletionProviderImpl.convertSnippet2CodeTemplate(resolved.getInsertText()));
                                    toAdd = "";
                                } else {
                                    toAdd = resolved.getInsertText();
                                    if (toAdd == null) {
                                        toAdd = resolved.getLabel();
                                    }
                                }
                                int[] identSpan = Utilities.getIdentifierBlock((BaseDocument)((BaseDocument)doc), (int)caretOffset);
                                if (identSpan != null) {
                                    start = Utils.createPosition(doc, identSpan[0]);
                                    end = Utils.createPosition(doc, identSpan[1]);
                                } else {
                                    end = start = Utils.createPosition(doc, caretOffset);
                                }
                                mainEdit = new TextEdit(new Range(start, end), toAdd);
                            }
                            ArrayList<TextEdit> allEdits = new ArrayList<TextEdit>();
                            allEdits.add(mainEdit);
                            if (resolved.getAdditionalTextEdits() != null) {
                                allEdits.addAll(resolved.getAdditionalTextEdits());
                            }
                            int insertPos = Utils.getOffset(doc, mainEdit.getRange().getStart());
                            LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class);
                            Position startPos = ld.createPosition(insertPos, Position.Bias.Backward);
                            Utils.applyEditsNoLock(doc, allEdits);
                            if (template != null) {
                                template.insert(component);
                            } else {
                                int endPos = startPos.hashCode() + mainEdit.getNewText().length();
                                doc.insertString(endPos, appendText, null);
                            }
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    });
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                }

                public void processKeyEvent(KeyEvent ke) {
                    if (ke.getID() == 400) {
                        String commitText = String.valueOf(ke.getKeyChar());
                        List commitCharacters = i.getCommitCharacters();
                        if (commitCharacters != null && commitCharacters.contains(commitText)) {
                            this.commit(commitText);
                            ke.consume();
                            if (CompletionProviderImpl.this.isTriggerCharacter(server, commitText)) {
                                Completion.get().showCompletion();
                            }
                        }
                    }
                }

                public int getPreferredWidth(Graphics grphcs, Font font) {
                    return CompletionUtilities.getPreferredWidth((String)leftLabel, (String)rightLabel, (Graphics)grphcs, (Font)font);
                }

                public void render(Graphics grphcs, Font font, Color color, Color color1, int i2, int i1, boolean bln) {
                    COMPLETION_ITEM_RENDERER.renderCompletionItem(icon, leftLabel, rightLabel, grphcs, font, color, i2, i1, bln);
                }

                public CompletionTask createDocumentationTask() {
                    return new AsyncCompletionTask(new AsyncCompletionQuery(){

                        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                            CompletionItem resolved;
                            if ((i.getDetail() == null || i.getDocumentation() == null) && CompletionProviderImpl.this.hasCompletionResolve(completionOptions)) {
                                CompletionItem temp;
                                try {
                                    temp = (CompletionItem)server.getTextDocumentService().resolveCompletionItem(i).get();
                                }
                                catch (InterruptedException | ExecutionException ex) {
                                    LOG.log(Level.INFO, "Failed to retrieve documentation data", ex);
                                    temp = i;
                                }
                                resolved = temp;
                            } else {
                                resolved = i;
                            }
                            if (resolved.getDocumentation() != null || resolved.getDetail() != null) {
                                resultSet.setDocumentation(new CompletionDocumentation(){

                                    public String getText() {
                                        StringBuilder documentation = new StringBuilder();
                                        documentation.append("<html>\n");
                                        if (resolved.getDetail() != null) {
                                            documentation.append("<b>").append(CompletionProviderImpl.escape(resolved.getDetail())).append("</b>");
                                            documentation.append("\n<p>");
                                        }
                                        if (resolved.getDocumentation() != null) {
                                            MarkupContent content;
                                            if (resolved.getDocumentation().isLeft()) {
                                                content = new MarkupContent();
                                                content.setKind("plaintext");
                                                content.setValue((String)resolved.getDocumentation().getLeft());
                                            } else {
                                                content = (MarkupContent)resolved.getDocumentation().getRight();
                                            }
                                            switch (content.getKind()) {
                                                default: {
                                                    documentation.append("<pre>\n").append(content.getValue()).append("\n</pre>");
                                                    break;
                                                }
                                                case "markdown": {
                                                    documentation.append(HtmlRenderer.builder().build().render((Node)Parser.builder().build().parse(content.getValue())));
                                                    break;
                                                }
                                                case "html": {
                                                    documentation.append(content.getValue());
                                                }
                                            }
                                        }
                                        return documentation.toString();
                                    }

                                    public URL getURL() {
                                        return null;
                                    }

                                    public CompletionDocumentation resolveLink(String link) {
                                        return null;
                                    }

                                    public Action getGotoSourceAction() {
                                        return null;
                                    }
                                });
                            }
                            resultSet.finish();
                        }
                    });
                }

                public CompletionTask createToolTipTask() {
                    return null;
                }

                public boolean instantSubstitution(JTextComponent jtc) {
                    return false;
                }

                public int getSortPriority() {
                    return 100;
                }

                public CharSequence getSortText() {
                    return sortText;
                }

                public CharSequence getInsertPrefix() {
                    return insert;
                }
            });
        }
    }

    private boolean hasCompletionResolve(CompletionOptions completionOptions) {
        Boolean resolveProvider = completionOptions.getResolveProvider();
        return resolveProvider != null && resolveProvider != false;
    }

    private static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    private String encode(String str) {
        return str.replace("&", "&amp;").replace("<", "&lt;");
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        FileObject file = NbEditorUtilities.getFileObject((Document)component.getDocument());
        if (file == null) {
            return 0;
        }
        List<LSPBindings> servers = LSPBindings.getBindings(file);
        if (servers.isEmpty()) {
            return 0;
        }
        return servers.stream().anyMatch(server -> this.isTriggerCharacter((LSPBindings)server, typedText)) ? 1 : 0;
    }

    private boolean isTriggerCharacter(LSPBindings server, String text) {
        InitializeResult init = server.getInitResult();
        if (init == null) {
            return false;
        }
        ServerCapabilities capabilities = init.getCapabilities();
        if (capabilities == null) {
            return false;
        }
        CompletionOptions completionOptions = capabilities.getCompletionProvider();
        if (completionOptions == null) {
            return false;
        }
        List triggerCharacters = completionOptions.getTriggerCharacters();
        if (triggerCharacters == null) {
            return false;
        }
        return triggerCharacters.stream().anyMatch(trigger -> text.endsWith((String)trigger));
    }

    static String convertSnippet2CodeTemplate(String snippet) {
        StringBuilder template = new StringBuilder();
        int placeholderIdx = 0;
        for (int i = 0; i < snippet.length(); ++i) {
            char c = snippet.charAt(i);
            if (c == '$') {
                c = snippet.charAt(++i);
                boolean hasBody = false;
                if (c == '{') {
                    hasBody = true;
                    c = snippet.charAt(++i);
                }
                if (Character.isLetter(c)) {
                    if (hasBody) {
                        while (c != '}') {
                            c = snippet.charAt(++i);
                        }
                    } else {
                        while (Character.isLetter(c)) {
                            c = snippet.charAt(++i);
                        }
                        --i;
                    }
                    template.append("${P").append(placeholderIdx).append("}");
                    continue;
                }
                int tabStopIndexStart = i;
                while (Character.isDigit(c) && ++i < snippet.length()) {
                    c = snippet.charAt(i);
                }
                String tabStopIndex = snippet.substring(tabStopIndexStart, i);
                String tabStopContent = "";
                if (hasBody) {
                    int pos = i;
                    while (c != '}') {
                        c = snippet.charAt(++i);
                    }
                    tabStopContent = snippet.substring(pos, i);
                } else {
                    --i;
                }
                if ("0".equals(tabStopIndex)) {
                    template.append("${cursor}");
                    continue;
                }
                template.append("${T");
                template.append(tabStopIndex);
                if (tabStopContent.startsWith(":")) {
                    template.append(" default=\"");
                    template.append(tabStopContent.substring(1));
                    template.append("\"");
                }
                template.append("}");
                continue;
            }
            template.append(c);
        }
        return template.toString();
    }

    static interface IndirectCompletionItemRenderer {
        public void renderCompletionItem(ImageIcon var1, String var2, String var3, Graphics var4, Font var5, Color var6, int var7, int var8, boolean var9);
    }
}

