/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.lsp.client.debugger.api.RegisterDAPBreakpoints;
import org.netbeans.modules.lsp.client.debugger.breakpoints.DAPLineBreakpoint;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public final class DAPBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private static final Set ACTIONS = Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    private static final Map<String, BreakpointInfo> mimeType2BreakpointInfo = new HashMap<String, BreakpointInfo>();
    private EditorContextDispatcher context = EditorContextDispatcher.getDefault();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasMimeTypeDAPBreakpoints(String mimeType) {
        Map<String, BreakpointInfo> map = mimeType2BreakpointInfo;
        synchronized (map) {
            return mimeType2BreakpointInfo.computeIfAbsent(mimeType, mt -> {
                Lookup.Result result = MimeLookup.getLookup((String)mimeType).lookupResult(RegisterDAPBreakpoints.class);
                result.addLookupListener(evt -> {
                    Map<String, BreakpointInfo> map = mimeType2BreakpointInfo;
                    synchronized (map) {
                        mimeType2BreakpointInfo.put(mimeType, new BreakpointInfo(!result.allInstances().isEmpty(), (Lookup.Result<RegisterDAPBreakpoints>)result));
                    }
                });
                return new BreakpointInfo(!result.allInstances().isEmpty(), (Lookup.Result<RegisterDAPBreakpoints>)result);
            }).dapBreakpointsAllowed();
        }
    }

    public DAPBreakpointActionProvider() {
        this.context.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.context));
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
    }

    public void doAction(Object action) {
        int i;
        Line line = DAPBreakpointActionProvider.getCurrentLine();
        if (line == null) {
            return;
        }
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        FileObject fo = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fo == null) {
            return;
        }
        int lineNumber = line.getLineNumber() + 1;
        int k = breakpoints.length;
        for (i = 0; i < k; ++i) {
            DAPLineBreakpoint lb;
            Breakpoint breakpoint = breakpoints[i];
            if (!(breakpoint instanceof DAPLineBreakpoint) || !fo.equals((lb = (DAPLineBreakpoint)breakpoint).getFileObject()) || lb.getLineNumber() != lineNumber) continue;
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)lb);
            break;
        }
        if (i == k) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)DAPLineBreakpoint.create(line));
        }
    }

    public Set<Object> getActions() {
        return ACTIONS;
    }

    private static Line getCurrentLine() {
        FileObject fo = EditorContextDispatcher.getDefault().getCurrentFile();
        if (!DAPBreakpointActionProvider.isRelevantFile(fo)) {
            return null;
        }
        return EditorContextDispatcher.getDefault().getCurrentLine();
    }

    private static boolean isRelevantFile(FileObject fo) {
        if (fo == null) {
            return false;
        }
        return DAPBreakpointActionProvider.hasMimeTypeDAPBreakpoints(FileUtil.getMIMEType((FileObject)fo));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean enabled = DAPBreakpointActionProvider.getCurrentLine() != null;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, enabled);
    }

    private record BreakpointInfo(boolean dapBreakpointsAllowed, Lookup.Result<RegisterDAPBreakpoints> registerLookup) {
    }
}

