/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class Utils {
    private static final Comparator<TextEdit> rangeReverseSort = (s1, s2) -> {
        int l1 = s1.getRange().getEnd().getLine();
        int l2 = s2.getRange().getEnd().getLine();
        int c1 = s1.getRange().getEnd().getCharacter();
        int c2 = s2.getRange().getEnd().getCharacter();
        if (l1 != l2) {
            return l2 - l1;
        }
        return c2 - c1;
    };

    public static String toURI(FileObject file) {
        return file.toURI().toString().replace("file:/", "file:///");
    }

    public static Position createPosition(Document doc, int offset) throws BadLocationException {
        return new Position(LineDocumentUtils.getLineIndex((LineDocument)((LineDocument)doc), (int)offset), offset - LineDocumentUtils.getLineStart((LineDocument)((LineDocument)doc), (int)offset));
    }

    public static int getOffset(Document doc, Position pos) {
        return LineDocumentUtils.getLineStartFromIndex((LineDocument)((LineDocument)doc), (int)pos.getLine()) + pos.getCharacter();
    }

    public static int getEndCharacter(Document doc, int line) {
        int start = LineDocumentUtils.getLineStartFromIndex((LineDocument)((LineDocument)doc), (int)line);
        try {
            return LineDocumentUtils.getLineEnd((LineDocument)((LineDocument)doc), (int)start) - start;
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return 0;
        }
    }

    public static void applyWorkspaceEdit(WorkspaceEdit edit) {
        if (edit.getDocumentChanges() != null) {
            for (Either change : edit.getDocumentChanges()) {
                if (change.isLeft()) {
                    Utils.applyEdits(((TextDocumentEdit)change.getLeft()).getTextDocument().getUri(), ((TextDocumentEdit)change.getLeft()).getEdits());
                    continue;
                }
                switch (((ResourceOperation)change.getRight()).getKind()) {
                    case "create": {
                        try {
                            FileUtil.createData((File)new File(new URI(((CreateFile)change.getRight()).getUri())));
                        }
                        catch (IOException | URISyntaxException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        break;
                    }
                    case "delete": {
                        try {
                            URLMapper.findFileObject((URL)new URI(((DeleteFile)change.getRight()).getUri()).toURL()).delete();
                        }
                        catch (IOException | URISyntaxException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        break;
                    }
                    case "rename": {
                        try {
                            File target = new File(new URI(((RenameFile)change.getRight()).getNewUri()));
                            FileObject targetFolder = FileUtil.createFolder((File)target.getParentFile());
                            FileObject source = URLMapper.findFileObject((URL)new URI(((RenameFile)change.getRight()).getOldUri()).toURL());
                            DataObject od = DataObject.find((FileObject)source);
                            od.move(DataFolder.findFolder((FileObject)targetFolder));
                            od.rename(target.getName());
                            break;
                        }
                        catch (IOException | URISyntaxException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        } else {
            for (Map.Entry e : edit.getChanges().entrySet()) {
                Utils.applyEdits((String)e.getKey(), (List)e.getValue());
            }
        }
    }

    private static void applyEdits(String uri, List<TextEdit> edits) {
        try {
            StyledDocument doc;
            FileObject file = URLMapper.findFileObject((URL)new URI(uri).toURL());
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument styledDocument = doc = ec != null ? ec.openDocument() : null;
            if (doc == null) {
                return;
            }
            NbDocument.runAtomic((StyledDocument)doc, () -> Utils.applyEditsNoLock(doc, edits));
        }
        catch (IOException | URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void applyEditsNoLock(Document doc, List<? extends TextEdit> edits) {
        Utils.applyEditsNoLock(doc, edits, null, null);
    }

    public static void applyEditsNoLock(Document doc, List<? extends TextEdit> edits, Integer startLimit, Integer endLimit) {
        edits.stream().sorted(rangeReverseSort).forEach(te -> {
            try {
                int start = Utils.getOffset(doc, te.getRange().getStart());
                int end = Utils.getOffset(doc, te.getRange().getEnd());
                if (!(startLimit != null && start < startLimit || endLimit != null && end >= endLimit)) {
                    doc.remove(start, end - start);
                    doc.insertString(start, te.getNewText(), null);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    public static void applyCodeAction(LSPBindings server, Either<Command, CodeAction> cmd) {
        try {
            Command command;
            if (cmd.isLeft()) {
                command = (Command)cmd.getLeft();
            } else {
                Utils.applyWorkspaceEdit(((CodeAction)cmd.getRight()).getEdit());
                command = ((CodeAction)cmd.getRight()).getCommand();
            }
            if (command != null) {
                server.getWorkspaceService().executeCommand(new ExecuteCommandParams(command.getCommand(), command.getArguments())).get();
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static Position computeEndPositionForRemovedText(Position startPos, String removedText) {
        int endLine = startPos.getLine();
        int endChar = startPos.getCharacter();
        for (char c : removedText.toCharArray()) {
            if (c == '\n') {
                ++endLine;
                endChar = 0;
                continue;
            }
            ++endChar;
        }
        return new Position(endLine, endChar);
    }

    public static List<TextEdit> computeDefaultOnTypeIndent(Document doc, int changeStart, Position startPos, String newText) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        try {
            int indentLevel = IndentUtils.indentLevelSize((Document)doc);
            int lineStart = IndentUtils.lineStartOffset((Document)doc, (int)changeStart);
            int indent = IndentUtils.lineIndent((Document)doc, (int)lineStart);
            if (newText.equals("}") && indent == changeStart - lineStart) {
                int idx;
                CharSequence cs = DocumentUtilities.getText((Document)doc);
                int balance = 1;
                block6: for (idx = changeStart - 1; idx >= 0 && balance > 0; --idx) {
                    switch (cs.charAt(idx)) {
                        case '{': {
                            --balance;
                            continue block6;
                        }
                        case '}': {
                            ++balance;
                        }
                    }
                }
                int newIndent = balance == 0 ? IndentUtils.lineIndent((Document)doc, (int)IndentUtils.lineStartOffset((Document)doc, (int)idx)) : 0;
                edits.add(new TextEdit(new Range(new Position(startPos.getLine(), 0), new Position(startPos.getLine(), indent)), IndentUtils.createIndentString((Document)doc, (int)newIndent)));
            } else if (newText.equals("\n")) {
                Position insertPos = new Position(startPos.getLine() + 1, 0);
                int newIndent = indent;
                if (changeStart > 0 && DocumentUtilities.getText((Document)doc, (int)(changeStart - 1), (int)1).charAt(0) == '{') {
                    newIndent += indentLevel;
                }
                edits.add(new TextEdit(new Range(insertPos, insertPos), IndentUtils.createIndentString((Document)doc, (int)newIndent)));
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return edits;
    }

    public static FileObject fromURI(String targetUri) {
        try {
            URI target = URI.create(targetUri);
            return URLMapper.findFileObject((URL)target.toURL());
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static void open(String targetUri, Range targetRange) {
        FileObject targetFile = Utils.fromURI(targetUri);
        if (targetFile != null) {
            LineCookie lc = (LineCookie)targetFile.getLookup().lookup(LineCookie.class);
            Line line = lc.getLineSet().getCurrent(targetRange.getStart().getLine());
            SwingUtilities.invokeLater(() -> line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, targetRange.getStart().getCharacter()));
        }
    }

    public static boolean isTrue(Boolean b) {
        return b != null && b != false;
    }

    public static boolean isEnabled(Either<Boolean, ?> settings) {
        return settings != null && (settings.isLeft() ? Utils.isTrue((Boolean)settings.getLeft()) : settings.getRight() != null);
    }
}

