/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenHierarchyUpdate;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.JoinToken;
import org.netbeans.spi.lexer.EmbeddingPresence;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;

public final class EmbeddingContainer<T extends TokenId>
implements TokenOrEmbedding<T> {
    private static final Logger LOG = Logger.getLogger(EmbeddingContainer.class.getName());
    private AbstractToken<T> branchToken;
    private final TokenList<?> rootTokenList;
    private int cachedModCount;
    private int branchTokenStartOffset;
    private EmbeddedTokenList<?> firstEmbeddedTokenList;
    private EmbeddedTokenList<?> defaultEmbeddedTokenList;
    private static boolean checkStatusUpdatedThrowingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> EmbeddedTokenList<ET> embeddedTokenList(TokenList<T> tokenList, int index, Set<Language<?>> embeddedLanguages, boolean initTokensInNew) {
        TokenList<?> rootTokenList;
        TokenList<?> tokenList2 = rootTokenList = tokenList.rootTokenList();
        synchronized (tokenList2) {
            EmbeddedTokenList<?> prevEtl;
            EmbeddingPresence ep;
            TokenOrEmbedding<T> tokenOrEmbedding = tokenList.tokenOrEmbedding(index);
            EmbeddingContainer<T> ec = tokenOrEmbedding.embedding();
            AbstractToken<T> token = tokenOrEmbedding.token();
            if (token.getClass() == JoinToken.class) {
                return null;
            }
            if (ec != null) {
                ep = null;
            } else {
                ep = LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).embeddingPresence(token.id());
                if (ep == EmbeddingPresence.NONE) {
                    return null;
                }
            }
            if (ec != null) {
                ec.updateStatusUnsync();
                prevEtl = null;
                for (EmbeddedTokenList<?> etl = ec.firstEmbeddedTokenList(); etl != null; etl = etl.nextEmbeddedTokenList()) {
                    if (embeddedLanguages == null || embeddedLanguages.contains(etl.languagePath().innerLanguage())) {
                        EmbeddedTokenList<?> etlUC = etl;
                        return etlUC;
                    }
                    prevEtl = etl;
                }
                if (ec.defaultEmbeddedTokenList() != null) {
                    return null;
                }
            } else {
                prevEtl = null;
            }
            if (tokenList.isRemoved()) {
                return null;
            }
            LanguagePath languagePath = tokenList.languagePath();
            LanguageHierarchy languageHierarchy = LexerUtilsConstants.innerLanguageHierarchy(languagePath);
            LanguageEmbedding<?> embedding = LexerUtilsConstants.findEmbedding(languageHierarchy, token, languagePath, tokenList.inputAttributes());
            if (ep == null) {
                ep = LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).embeddingPresence(token.id());
            }
            if (embedding != null) {
                if (ep == EmbeddingPresence.CACHED_FIRST_QUERY) {
                    LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).setEmbeddingPresence(token.id(), EmbeddingPresence.ALWAYS_QUERY);
                }
                if (embeddedLanguages != null && !embeddedLanguages.contains(embedding.language()) || token.isRemoved() || embedding.startSkipLength() + embedding.endSkipLength() > token.length()) {
                    return null;
                }
                if (ec == null) {
                    ec = new EmbeddingContainer<T>(token, rootTokenList);
                    tokenList.wrapToken(index, ec);
                }
                LanguagePath embeddedLanguagePath = LanguagePath.get(languagePath, embedding.language());
                EmbeddedTokenList etl = new EmbeddedTokenList(ec, embeddedLanguagePath, embedding);
                ec.addEmbeddedTokenList(prevEtl, etl, true);
                if (LOG.isLoggable(Level.FINE)) {
                    StringBuilder sb = new StringBuilder(200);
                    sb.append("@@@@@@@@@@ NATURAL-EMBEDDING-CREATED EC-");
                    LexerUtilsConstants.appendIdentityHashCode(sb, ec);
                    sb.append(" ROOT-");
                    LexerUtilsConstants.appendIdentityHashCode(sb, rootTokenList);
                    sb.append(" for ").append(embeddedLanguagePath.mimePath()).append(", ").append(embedding).append(": ").append((CharSequence)etl.dumpInfo(null)).append(", initTokensInNew=").append(initTokensInNew).append('\n');
                    LOG.fine(sb.toString());
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.log(Level.INFO, "Natural embedding created by:", new Exception());
                    }
                }
                if (initTokensInNew) {
                    TokenHierarchyOperation<?, ?> operation = rootTokenList.tokenHierarchyOperation();
                    if (embedding.joinSections()) {
                        operation.tokenListList(embeddedLanguagePath);
                    } else {
                        assert (operation.existingTokenListList(embeddedLanguagePath) == null);
                        etl.initAllTokens();
                    }
                }
                return etl;
            }
            if (ep == EmbeddingPresence.CACHED_FIRST_QUERY) {
                LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).setEmbeddingPresence(token.id(), EmbeddingPresence.NONE);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> boolean createEmbedding(TokenList<T> tokenList, int index, Language<ET> embeddedLanguage, int startSkipLength, int endSkipLength, boolean joinSections) {
        TokenHierarchyEventInfo eventInfo;
        int tokenStartOffset;
        EmbeddedTokenList<ET> etl;
        LanguageEmbedding<ET> embedding;
        TokenHierarchyOperation<?, ?> tokenHierarchyOperation;
        TokenList<?> rootTokenList;
        TokenList<?> tokenList2 = rootTokenList = tokenList.rootTokenList();
        synchronized (tokenList2) {
            if (tokenList.isRemoved()) {
                return false;
            }
            tokenHierarchyOperation = tokenList.tokenHierarchyOperation();
            tokenHierarchyOperation.ensureWriteLocked();
            TokenOrEmbedding<T> tokenOrEmbedding = tokenList.tokenOrEmbedding(index);
            EmbeddingContainer<T> ec = tokenOrEmbedding.embedding();
            AbstractToken<T> token = tokenOrEmbedding.token();
            if (ec != null) {
                for (EmbeddedTokenList<?> etl2 = ec.firstEmbeddedTokenList(); etl2 != null; etl2 = etl2.nextEmbeddedTokenList()) {
                    if (embeddedLanguage != etl2.languagePath().innerLanguage()) continue;
                    return false;
                }
            } else {
                if (token.isFlyweight()) {
                    return false;
                }
                ec = new EmbeddingContainer<T>(token, rootTokenList);
                tokenList.wrapToken(index, ec);
            }
            if (startSkipLength + endSkipLength > token.length()) {
                return false;
            }
            LanguagePath languagePath = tokenList.languagePath();
            LanguagePath embeddedLanguagePath = LanguagePath.get(languagePath, embeddedLanguage);
            TokenListList tll = tokenHierarchyOperation.existingTokenListList(embeddedLanguagePath);
            if (tll != null && tll.joinSections()) {
                joinSections = true;
            }
            embedding = LanguageEmbedding.create(embeddedLanguage, startSkipLength, endSkipLength, joinSections);
            tokenHierarchyOperation.addLanguagePath(embeddedLanguagePath);
            etl = new EmbeddedTokenList<ET>(ec, embeddedLanguagePath, embedding);
            ec.addEmbeddedTokenList(null, etl, false);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("@@@@@@@@@@ EXPLICIT-EMBEDDING-CREATED for " + embeddedLanguagePath.mimePath() + ", " + embedding + ": " + etl.dumpInfo(null) + '\n');
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.INFO, "Explicit embedding created by:", new Exception());
                }
            }
            tokenStartOffset = ec.branchTokenStartOffset();
            eventInfo = new TokenHierarchyEventInfo(tokenHierarchyOperation, TokenHierarchyEventType.EMBEDDING_CREATED, tokenStartOffset, 0, "", 0);
            eventInfo.setMaxAffectedEndOffset(tokenStartOffset + token.length());
            if (!embedding.joinSections()) {
                etl.initAllTokens();
            }
            if (tll != null) {
                new TokenHierarchyUpdate(eventInfo).updateCreateOrRemoveEmbedding(etl, true);
            } else if (embedding.joinSections()) {
                tll = tokenHierarchyOperation.tokenListList(etl.languagePath());
            }
        }
        TokenChangeInfo<T> info = new TokenChangeInfo<T>(tokenList);
        info.setIndex(index);
        info.setOffset(tokenStartOffset);
        eventInfo.setTokenChangeInfo(info);
        TokenChangeInfo<ET> embeddedInfo = new TokenChangeInfo<ET>(etl);
        embeddedInfo.setIndex(0);
        embeddedInfo.setOffset(tokenStartOffset + embedding.startSkipLength());
        info.addEmbeddedChange(embeddedInfo);
        tokenHierarchyOperation.fireTokenHierarchyChanged(eventInfo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> boolean removeEmbedding(TokenList<T> tokenList, int index, Language<ET> embeddedLanguage) {
        TokenList<?> rootTokenList;
        TokenList<?> tokenList2 = rootTokenList = tokenList.rootTokenList();
        synchronized (tokenList2) {
            if (tokenList.isRemoved()) {
                return false;
            }
            TokenHierarchyOperation<?, ?> tokenHierarchyOperation = tokenList.tokenHierarchyOperation();
            tokenHierarchyOperation.ensureWriteLocked();
            TokenOrEmbedding<T> tokenOrEmbedding = tokenList.tokenOrEmbedding(index);
            EmbeddingContainer<T> ec = tokenOrEmbedding.embedding();
            if (ec != null) {
                ec.updateStatusUnsync();
                EmbeddedTokenList<?> prevEtl = null;
                for (EmbeddedTokenList<T> etl = ec.firstEmbeddedTokenList(); etl != null; etl = etl.nextEmbeddedTokenList()) {
                    if (embeddedLanguage != etl.languagePath().innerLanguage()) continue;
                    ec.removeEmbeddedTokenList(prevEtl, etl);
                    ec = new EmbeddingContainer<T>(ec);
                    ec.addEmbeddedTokenList(null, etl, false);
                    etl.setEmbeddingContainer(ec);
                    ec.markChildrenRemovedDeep();
                    int startOffset = ec.branchTokenStartOffset();
                    TokenHierarchyEventInfo eventInfo = new TokenHierarchyEventInfo(tokenHierarchyOperation, TokenHierarchyEventType.EMBEDDING_REMOVED, startOffset, 0, "", 0);
                    eventInfo.setMaxAffectedEndOffset(startOffset + ec.token().length());
                    TokenChangeInfo<T> info = new TokenChangeInfo<T>(tokenList);
                    info.setIndex(index);
                    info.setOffset(startOffset);
                    eventInfo.setTokenChangeInfo(info);
                    EmbeddedTokenList<T> etlET = etl;
                    TokenChangeInfo embeddedInfo = new TokenChangeInfo(etlET);
                    embeddedInfo.setIndex(0);
                    embeddedInfo.setOffset(startOffset + etl.embedding().startSkipLength());
                    info.addEmbeddedChange(embeddedInfo);
                    TokenListList tll = tokenHierarchyOperation.existingTokenListList(etl.languagePath());
                    if (tll != null) {
                        new TokenHierarchyUpdate(eventInfo).updateCreateOrRemoveEmbedding(etl, false);
                    }
                    tokenHierarchyOperation.fireTokenHierarchyChanged(eventInfo);
                    return true;
                }
            }
        }
        return false;
    }

    EmbeddingContainer(AbstractToken<T> branchToken, TokenList<?> rootTokenList) {
        if (branchToken == null) {
            throw new IllegalArgumentException("branchToken cannot be null");
        }
        if (rootTokenList == null) {
            throw new IllegalArgumentException("rootTokenList cannot be null");
        }
        this.branchToken = branchToken;
        this.rootTokenList = rootTokenList;
        this.cachedModCount = -3;
        this.updateStatusUnsync();
    }

    EmbeddingContainer(EmbeddingContainer<T> ec) {
        this(ec.token(), ec.rootTokenList());
    }

    private void markRemoved() {
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("EmbeddingContainer.markRemoved(): EC-");
            LexerUtilsConstants.appendIdentityHashCode(sb, this);
            sb.append('\n');
            LOG.fine(sb.toString());
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.INFO, "Embedding marked as removed:", new Exception());
            }
        }
        this.cachedModCount = -2;
        for (EmbeddedTokenList<?> etl = this.firstEmbeddedTokenList; etl != null && etl != EmbeddedTokenList.NO_DEFAULT_EMBEDDING; etl = etl.nextEmbeddedTokenList()) {
            etl.resetExtraModCount();
        }
    }

    public void markRemoved(int branchTokenStartOffset) {
        this.branchTokenStartOffset = branchTokenStartOffset;
        this.markRemoved();
    }

    void markChildrenRemovedDeep() {
        for (EmbeddedTokenList<?> etl = this.firstEmbeddedTokenList; etl != null && etl != EmbeddedTokenList.NO_DEFAULT_EMBEDDING; etl = etl.nextEmbeddedTokenList()) {
            for (int i = etl.tokenCountCurrent() - 1; i >= 0; --i) {
                EmbeddingContainer<?> ec = etl.tokenOrEmbeddingUnsync(i).embedding();
                if (ec == null) continue;
                ec.updateStatusUnsync();
                ec.markChildrenRemovedDeep();
                super.markRemoved();
            }
        }
    }

    public int cachedModCount() {
        return this.cachedModCount;
    }

    @Override
    public final AbstractToken<T> token() {
        return this.branchToken;
    }

    @Override
    public final EmbeddingContainer<T> embedding() {
        return this;
    }

    public void reinit(AbstractToken<T> token) {
        this.branchToken = token;
        this.cachedModCount = -3;
        this.updateStatusUnsync();
    }

    public TokenList<?> rootTokenList() {
        return this.rootTokenList;
    }

    public int branchTokenStartOffset() {
        return this.branchTokenStartOffset;
    }

    public EmbeddedTokenList<?> firstEmbeddedTokenList() {
        return this.firstEmbeddedTokenList;
    }

    public void addEmbeddedTokenList(EmbeddedTokenList<?> prevEtl, EmbeddedTokenList<?> etl, boolean defaultEmbedding) {
        if (prevEtl != null) {
            etl.setNextEmbeddedTokenList(prevEtl.nextEmbeddedTokenList());
            prevEtl.setNextEmbeddedTokenList(etl);
        } else {
            etl.setNextEmbeddedTokenList(this.firstEmbeddedTokenList);
            this.firstEmbeddedTokenList = etl;
        }
        if (defaultEmbedding) {
            this.defaultEmbeddedTokenList = etl;
        }
    }

    public EmbeddedTokenList<?> removeEmbeddedTokenList(EmbeddedTokenList<?> prevEtl, EmbeddedTokenList<?> etl) {
        EmbeddedTokenList<?> next = etl.nextEmbeddedTokenList();
        if (prevEtl != null) {
            prevEtl.setNextEmbeddedTokenList(next);
        } else {
            this.firstEmbeddedTokenList = next;
        }
        etl.setNextEmbeddedTokenList(null);
        if (this.defaultEmbeddedTokenList == etl) {
            this.defaultEmbeddedTokenList = null;
        }
        return next;
    }

    public EmbeddedTokenList<?> defaultEmbeddedTokenList() {
        return this.defaultEmbeddedTokenList;
    }

    public boolean isRemoved() {
        return this.cachedModCount == -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus() {
        TokenList<?> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            this.updateStatusUnsync();
        }
    }

    public void updateStatusUnsync() {
        this.updateStatusImpl(this.rootTokenList.modCount());
    }

    protected int updateStatusImpl(int rootModCount) {
        if (this.cachedModCount != -2 && this.cachedModCount != rootModCount) {
            TokenList<T> parentTokenList = this.branchToken.tokenList();
            if (parentTokenList == null) {
                this.markRemoved();
            } else if (parentTokenList.getClass() == EmbeddedTokenList.class) {
                EmbeddedTokenList parentEtl = (EmbeddedTokenList)parentTokenList;
                this.cachedModCount = parentEtl.embeddingContainer().updateStatusImpl(rootModCount);
                this.branchTokenStartOffset = parentEtl.tokenOffset(this.branchToken);
            } else {
                this.cachedModCount = rootModCount;
                this.branchTokenStartOffset = parentTokenList.tokenOffset(this.branchToken);
            }
        }
        return this.cachedModCount;
    }

    public boolean checkStatusUpdated() {
        if (this.cachedModCount != -2 && this.cachedModCount != this.rootTokenList.modCount() && !checkStatusUpdatedThrowingException) {
            checkStatusUpdatedThrowingException = true;
            String excMsg = "!!!INTERNAL ERROR!!! Status not updated on " + this + "\nin token hierarchy\n" + this.rootTokenList.tokenHierarchyOperation();
            checkStatusUpdatedThrowingException = false;
            throw new IllegalStateException(excMsg);
        }
        return true;
    }
}

