/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.util.Objects;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.jumpto.EntityComparator;
import org.netbeans.modules.jumpto.common.DescriptorAccessor;
import org.netbeans.modules.jumpto.common.StateFullComparator;
import org.netbeans.modules.jumpto.file.FileProviderAccessor;
import org.netbeans.modules.jumpto.settings.GoToSettings;
import org.netbeans.spi.jumpto.file.FileDescriptor;
import org.openide.util.ChangeSupport;

public abstract class FileComarator
extends EntityComparator<FileDescriptor>
implements StateFullComparator<FileDescriptor> {
    private final ChangeSupport support;
    protected final boolean caseSensitive;
    protected boolean preferOpPrjs;
    protected boolean usePreferred;

    private FileComarator(boolean usePreferred, boolean caseSensitive, boolean preferOpPrjs) {
        this.caseSensitive = caseSensitive;
        this.usePreferred = usePreferred;
        this.preferOpPrjs = preferOpPrjs;
        this.support = new ChangeSupport((Object)this);
    }

    boolean isUsePreferred() {
        return this.usePreferred;
    }

    void setUsePreferred(boolean usePreferred) {
        if (this.usePreferred != usePreferred) {
            this.usePreferred = usePreferred;
            this.support.fireChange();
        }
    }

    void setPrefereOpenProjects(boolean prefereOpenProjects) {
        if (this.preferOpPrjs != prefereOpenProjects) {
            this.preferOpPrjs = prefereOpenProjects;
            this.support.fireChange();
        }
    }

    abstract void setText(@NonNull String var1);

    @Override
    public abstract int compare(FileDescriptor var1, FileDescriptor var2);

    void fireChange() {
        this.support.fireChange();
    }

    @Override
    public void addChangeListener(@NonNull ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(@NonNull ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    @NonNull
    public static FileComarator create(@NonNull GoToSettings.SortingType kind, @NonNull String text, boolean usePreferred, boolean caseSensitive, boolean preferOpPrjs) {
        return switch (kind) {
            default -> throw new IncompatibleClassChangeError();
            case GoToSettings.SortingType.LEXICOGRAPHIC -> new Alphabet(usePreferred, caseSensitive, preferOpPrjs);
            case GoToSettings.SortingType.LEVENSHTEIN -> new Levenshtein(text, usePreferred, caseSensitive, preferOpPrjs);
        };
    }

    private static final class Alphabet
    extends FileComarator {
        Alphabet(boolean usePreferred, boolean caseSensitive, boolean preferOpPrjs) {
            super(usePreferred, caseSensitive, preferOpPrjs);
        }

        @Override
        void setText(@NonNull String text) {
        }

        @Override
        public int compare(FileDescriptor e1, FileDescriptor e2) {
            String e2projectName;
            String e1projectName;
            int result;
            if (this.usePreferred) {
                FileProviderAccessor fpa = FileProviderAccessor.getInstance();
                boolean isE1Curr = fpa.isFromCurrentProject(e1);
                boolean isE2Curr = fpa.isFromCurrentProject(e2);
                if (isE1Curr && !isE2Curr) {
                    return -1;
                }
                if (!isE1Curr && isE2Curr) {
                    return 1;
                }
            }
            if (this.preferOpPrjs && (result = this.compareProjects(e1projectName = e1.getProjectName(), e2projectName = e2.getProjectName())) != 0) {
                return result;
            }
            int result2 = this.compare(e1.getFileName(), e2.getFileName(), this.caseSensitive);
            if (result2 != 0) {
                return result2;
            }
            result2 = this.compare(e1.getProjectName(), e2.getProjectName(), this.caseSensitive);
            if (result2 != 0) {
                return result2;
            }
            result2 = this.compare(e1.getOwnerPath(), e2.getOwnerPath(), this.caseSensitive);
            return result2;
        }
    }

    private static final class Levenshtein
    extends FileComarator {
        private static final String ATTR_PATTERN = "Pattern";
        private static final String ATTR_LS_DIST = "LevenshteinDistance";
        private static final String ATTR_LS_TAIL = "LevenshteinTail";
        private String text;

        Levenshtein(String text, boolean usePreferred, boolean caseSensitive, boolean preferOpPrjs) {
            super(usePreferred, caseSensitive, preferOpPrjs);
            this.text = text;
        }

        @Override
        void setText(@NonNull String text) {
            boolean fire = !Objects.equals(this.text, text);
            this.text = text;
            if (fire) {
                this.fireChange();
            }
        }

        @Override
        public int compare(FileDescriptor e1, FileDescriptor e2) {
            int t2;
            int l2;
            String prefix;
            String fn;
            int t1;
            int l1;
            String e2projectName;
            String e1projectName;
            int result;
            if (this.usePreferred) {
                FileProviderAccessor fpa = FileProviderAccessor.getInstance();
                boolean isE1Curr = fpa.isFromCurrentProject(e1);
                boolean isE2Curr = fpa.isFromCurrentProject(e2);
                if (isE1Curr && !isE2Curr) {
                    return -1;
                }
                if (!isE1Curr && isE2Curr) {
                    return 1;
                }
            }
            if (this.preferOpPrjs && (result = this.compareProjects(e1projectName = e1.getProjectName(), e2projectName = e2.getProjectName())) != 0) {
                return result;
            }
            Object d = DescriptorAccessor.getInstance().getAttribute(e1, ATTR_LS_DIST);
            Object t = DescriptorAccessor.getInstance().getAttribute(e1, ATTR_LS_TAIL);
            Object p = DescriptorAccessor.getInstance().getAttribute(e1, ATTR_PATTERN);
            if (d instanceof Integer && t instanceof Integer && this.text.equals(p)) {
                l1 = (Integer)d;
                t1 = (Integer)t;
            } else {
                fn = e1.getFileName();
                prefix = this.levenshteinPrefix(fn, this.text, this.caseSensitive);
                l1 = this.levenshteinDistance(prefix, this.text, this.caseSensitive);
                t1 = fn.length() - prefix.length();
                DescriptorAccessor.getInstance().setAttribute(e1, ATTR_LS_DIST, l1);
                DescriptorAccessor.getInstance().setAttribute(e1, ATTR_LS_TAIL, t1);
                DescriptorAccessor.getInstance().setAttribute(e1, ATTR_PATTERN, this.text);
            }
            d = DescriptorAccessor.getInstance().getAttribute(e2, ATTR_LS_DIST);
            t = DescriptorAccessor.getInstance().getAttribute(e2, ATTR_LS_TAIL);
            p = DescriptorAccessor.getInstance().getAttribute(e2, ATTR_PATTERN);
            if (d instanceof Integer && t instanceof Integer && this.text.equals(p)) {
                l2 = (Integer)d;
                t2 = (Integer)t;
            } else {
                fn = e2.getFileName();
                prefix = this.levenshteinPrefix(fn, this.text, this.caseSensitive);
                l2 = this.levenshteinDistance(prefix, this.text, this.caseSensitive);
                t2 = fn.length() - prefix.length();
                DescriptorAccessor.getInstance().setAttribute(e2, ATTR_LS_DIST, l2);
                DescriptorAccessor.getInstance().setAttribute(e2, ATTR_LS_TAIL, t2);
                DescriptorAccessor.getInstance().setAttribute(e2, ATTR_PATTERN, this.text);
            }
            int result2 = l1 - l2;
            if (result2 != 0) {
                return result2;
            }
            result2 = t1 - t2;
            if (result2 != 0) {
                return result2;
            }
            result2 = this.compare(e1.getFileName(), e2.getFileName(), this.caseSensitive);
            if (result2 != 0) {
                return result2;
            }
            result2 = this.compare(e1.getProjectName(), e2.getProjectName(), this.caseSensitive);
            if (result2 != 0) {
                return result2;
            }
            result2 = this.compare(e1.getOwnerPath(), e2.getOwnerPath(), this.caseSensitive);
            return result2;
        }
    }
}

