/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;

class TranslateIdentifier
extends TreePathScanner<Void, Void> {
    private final Map<Tree, Tree> translateMap = new HashMap<Tree, Tree>();
    @NonNull
    private final CompilationInfo info;
    @NonNull
    private final TreeMaker make;

    public static <T extends Tree> T importFQNs(WorkingCopy copy, T tree) {
        if (tree == null) {
            return null;
        }
        TranslateIdentifier ti = new TranslateIdentifier(copy);
        ti.scan(tree.getKind() == Tree.Kind.COMPILATION_UNIT ? new TreePath((CompilationUnitTree)tree) : new TreePath(new TreePath(copy.getCompilationUnit()), tree), null);
        return (T)copy.getTreeUtilities().translate(tree, ti.translateMap);
    }

    private TranslateIdentifier(@NonNull WorkingCopy copy) {
        this.info = copy;
        this.make = copy.getTreeMaker();
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        TreePath path = this.getCurrentPath();
        Element element = this.info.getTrees().getElement(path);
        if (element != null && element.asType().getKind() != TypeKind.ERROR && (element.getKind().isClass() || element.getKind().isInterface() || element.getKind().isField() && ((Symbol)element).isStatic())) {
            Tree parent;
            Tree tree = parent = path.getParentPath() != null ? path.getParentPath().getLeaf() : null;
            if (parent != null && parent.getKind() == Tree.Kind.CASE && ((CaseTree)parent).getExpression() == node && element.getKind() == ElementKind.ENUM_CONSTANT || path.getCompilationUnit().getSourceFile() == ((Symbol)element).enclClass().sourcefile) {
                this.translateMap.put(node, this.make.Identifier(element.getSimpleName()));
            } else {
                this.translateMap.put(node, this.make.QualIdent(element));
            }
        }
        return null;
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void p) {
        TypeElement e = this.info.getElements().getTypeElement(node.toString());
        if (e != null) {
            this.translateMap.put(node, this.make.QualIdent(e));
            return null;
        }
        return (Void)super.visitMemberSelect(node, p);
    }

    @Override
    public Void visitMethod(MethodTree node, Void p) {
        if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath().getCompilationUnit(), node)) {
            return null;
        }
        return (Void)super.visitMethod(node, p);
    }
}

