/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Position;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.type.TypeKind;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.pretty.VeryPretty;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;
import org.netbeans.modules.java.source.save.DiffContext;
import org.netbeans.modules.java.source.save.DiffUtilities;
import org.netbeans.modules.java.source.save.EstimatorFactory;
import org.netbeans.modules.java.source.save.ListMatcher;
import org.netbeans.modules.java.source.save.Measure;
import org.netbeans.modules.java.source.save.PositionEstimator;
import org.netbeans.modules.java.source.transform.FieldGroupTree;
import org.netbeans.modules.java.source.transform.TreeHelpers;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public class CasualDiff {
    public static boolean OLD_TREES_VERBATIM = Boolean.parseBoolean(System.getProperty(WorkingCopy.class.getName() + ".keep-old-trees", "true"));
    protected final Collection<Diff> diffs;
    protected CommentHandler comments;
    protected JCTree.JCCompilationUnit oldTopLevel;
    protected TreeUtilities treeUtilities;
    protected final DiffContext diffContext;
    private TokenSequence<JavaTokenId> tokenSequence;
    private String origText;
    private VeryPretty printer;
    private final Context context;
    private final Names names;
    private final TreeMaker make;
    private static final Logger LOG = Logger.getLogger(CasualDiff.class.getName());
    public static final int GENERATED_MEMBER = 0x1000000;
    private Map<Integer, String> diffInfo = new HashMap<Integer, String>();
    private final Map<Tree, ?> tree2Tag;
    private final Map<Object, int[]> tag2Span;
    private final Set<Tree> oldTrees;
    private final Map<Tree, DocCommentTree> tree2Doc;
    private boolean parameterPrint = false;
    private boolean enumConstantPrint = false;
    private Map<Integer, Integer> blockSequenceMap = new LinkedHashMap<Integer, Integer>();
    private Iterator<Integer> boundaries;
    private int nextBlockBoundary = -1;
    private Name origClassName = null;
    private Name newClassName = null;
    boolean anonClass = false;
    private static final EnumSet<JavaTokenId> LAMBDA_PARAM_END_TOKENS = EnumSet.of(JavaTokenId.RPAREN, JavaTokenId.ARROW);
    private boolean suppressParameterTypes;
    @NullAllowed
    private TreePath currentPath;
    private boolean innerCommentsProcessed;
    private JCTree parent;
    private static final EnumSet<Tree.Kind> compAssign = EnumSet.of(Tree.Kind.MULTIPLY_ASSIGNMENT, new Tree.Kind[]{Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT});
    private static final EnumSet<Tree.Kind> binaries = EnumSet.of(Tree.Kind.MULTIPLY, new Tree.Kind[]{Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN_EQUAL, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.AND, Tree.Kind.XOR, Tree.Kind.OR, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR});
    private static final EnumSet<Tree.Kind> unaries = EnumSet.of(Tree.Kind.POSTFIX_INCREMENT, new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.LOGICAL_COMPLEMENT});
    public static boolean noInvalidCopyTos = false;

    protected CasualDiff(Context context, DiffContext diffContext, TreeUtilities treeUtilities, Map<Tree, ?> tree2Tag, Map<Tree, DocCommentTree> tree2Doc, Map<?, int[]> tag2Span, Set<Tree> oldTrees) {
        this.diffs = new LinkedHashSet<Diff>();
        this.comments = CommentHandlerService.instance(context);
        this.treeUtilities = treeUtilities;
        this.diffContext = diffContext;
        this.tokenSequence = diffContext.tokenSequence;
        this.origText = diffContext.origText;
        this.context = context;
        this.names = Names.instance(context);
        this.make = TreeMaker.instance(context);
        this.tree2Tag = tree2Tag;
        this.tree2Doc = tree2Doc;
        this.tag2Span = tag2Span;
        this.printer = new VeryPretty(diffContext, diffContext.style, tree2Tag, tree2Doc, tag2Span, this.origText);
        this.printer.oldTrees = oldTrees;
        this.oldTrees = oldTrees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Diff> diff(Context context, DiffContext diffContext, TreeUtilities treeUtilities, TreePath oldTreePath, JCTree newTree, Map<Integer, String> userInfo, Map<Tree, ?> tree2Tag, Map<Tree, DocCommentTree> tree2Doc, Map<?, int[]> tag2Span, Set<Tree> oldTrees) {
        int lineStart;
        final CasualDiff td = new CasualDiff(context, diffContext, treeUtilities, tree2Tag, tree2Doc, tag2Span, oldTrees);
        JCTree oldTree = (JCTree)oldTreePath.getLeaf();
        td.oldTopLevel = (JCTree.JCCompilationUnit)(oldTree.getKind() == Tree.Kind.COMPILATION_UNIT ? oldTree : diffContext.origUnit);
        for (Tree t : oldTreePath) {
            int indent;
            java.util.List<? extends Tree> embeddedElements;
            if (t == oldTree) continue;
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
                embeddedElements = ((ClassTree)t).getMembers();
            } else {
                if (t.getKind() != Tree.Kind.BLOCK) continue;
                embeddedElements = ((BlockTree)t).getStatements();
            }
            embeddedElements = td.filterHidden(NbCollections.checkedListByCopy(embeddedElements, JCTree.class, (boolean)false));
            if (embeddedElements.isEmpty()) {
                indent = CasualDiff.getOldIndent(diffContext, t);
                if (indent < 0) {
                    td.printer.indent();
                    continue;
                }
                td.printer.setIndent(indent);
                td.printer.indent();
                break;
            }
            indent = CasualDiff.getOldIndent(diffContext, embeddedElements.get(0));
            if (indent < 0) {
                td.printer.indent();
                continue;
            }
            td.printer.setIndent(indent);
            break;
        }
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)oldTree.getKind()) && oldTreePath.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
            td.anonClass = true;
        }
        int[] bounds = td.getCommentCorrectedBounds(oldTree);
        boolean isCUT = oldTree.getKind() == Tree.Kind.COMPILATION_UNIT;
        int start = isCUT ? 0 : bounds[0];
        String origText = td.origText;
        int end = isCUT ? origText.length() : bounds[1];
        for (lineStart = start; lineStart > 0 && origText.charAt(lineStart - 1) != '\n'; --lineStart) {
        }
        td.printer.setInitialOffset(lineStart);
        Tree current = oldTree;
        for (Tree t : oldTreePath) {
            if (t.getKind() == Tree.Kind.METHOD) {
                MethodTree mt = (MethodTree)t;
                for (Tree tree : mt.getParameters()) {
                    if (tree != current) continue;
                    td.parameterPrint = true;
                }
                break;
            }
            if (t.getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
                for (Tree tree : ((LambdaExpressionTree)t).getParameters()) {
                    if (tree != current) continue;
                    td.parameterPrint = true;
                }
                break;
            }
            if (t.getKind() == Tree.Kind.VARIABLE) {
                JCTree.JCVariableDecl vt = (JCTree.JCVariableDecl)t;
                if ((vt.mods.flags & 0x4000L) != 0L && vt.init == current) {
                    td.enumConstantPrint = true;
                }
            }
            current = t;
        }
        if (oldTree.getKind() == Tree.Kind.MODIFIERS || oldTree.getKind() == Tree.Kind.METHOD || !td.parameterPrint && oldTree.getKind() == Tree.Kind.VARIABLE) {
            td.tokenSequence.move(start);
            if (td.tokenSequence.movePrevious() && td.tokenSequence.token().id() == JavaTokenId.WHITESPACE) {
                String text = td.tokenSequence.token().text().toString();
                int index = text.lastIndexOf(10);
                start = td.tokenSequence.offset();
                if (index > -1) {
                    start += index + 1;
                }
            }
        }
        td.copyTo(lineStart, start, td.printer);
        td.diffTree(oldTreePath, newTree, new int[]{start, bounds[1]});
        String resultSrc = td.printer.toString().substring(start - lineStart);
        if (!td.printer.reindentRegions.isEmpty()) {
            ArrayList<SectKey> keys = new ArrayList<SectKey>(td.blockSequenceMap.size());
            for (Map.Entry entry : td.blockSequenceMap.entrySet()) {
                int n = (Integer)entry.getValue();
                SectKey k = new SectKey(n);
                keys.add(k);
                td.tag2Span.put(k, new int[]{n, n});
            }
            try {
                String toParse = origText.substring(0, start) + resultSrc + origText.substring(end);
                LineDocument lineDocument = LineDocumentUtils.createDocument((String)"text/x-java");
                lineDocument.insertString(0, toParse, null);
                lineDocument.putProperty(Language.class, JavaTokenId.language());
                lineDocument.putProperty("stream", diffContext.file);
                Position position = lineDocument.createPosition(start);
                Position endPos = lineDocument.createPosition(start + resultSrc.length());
                IdentityHashMap<Object, Position[]> spans = new IdentityHashMap<Object, Position[]>(td.tag2Span.size());
                for (Map.Entry<Object, int[]> e : td.tag2Span.entrySet()) {
                    spans.put(e.getKey(), new Position[]{lineDocument.createPosition(e.getValue()[0]), lineDocument.createPosition(e.getValue()[1])});
                }
                Indent i = Indent.get((Document)lineDocument);
                i.lock();
                AtomicLockDocument adoc = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)lineDocument, AtomicLockDocument.class);
                try {
                    Runnable r = new Runnable(){
                        final /* synthetic */ Document val$doc;
                        final /* synthetic */ Indent val$i;
                        {
                            this.val$doc = document;
                            this.val$i = indent;
                        }

                        @Override
                        public void run() {
                            try {
                                Position[] regions = new Position[((CasualDiff)td).printer.reindentRegions.size() * 2];
                                int idx = 0;
                                for (int[] region : ((CasualDiff)td).printer.reindentRegions) {
                                    regions[idx] = this.val$doc.createPosition(region[0]);
                                    regions[idx + 1] = this.val$doc.createPosition(region[1]);
                                    idx += 2;
                                }
                                for (int j = 0; j < regions.length; j += 2) {
                                    this.val$i.reindent(regions[j].getOffset(), regions[j + 1].getOffset());
                                }
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    };
                    adoc.runAtomic(r);
                }
                finally {
                    i.unlock();
                }
                resultSrc = lineDocument.getText(position.getOffset(), endPos.getOffset() - position.getOffset());
                for (Map.Entry entry : spans.entrySet()) {
                    int[] span = td.tag2Span.get(entry.getKey());
                    span[0] = ((Position[])entry.getValue())[0].getOffset();
                    span[1] = ((Position[])entry.getValue())[1].getOffset();
                }
                Iterator it = keys.iterator();
                for (Map.Entry<Integer, Integer> e : td.blockSequenceMap.entrySet()) {
                    SectKey k = (SectKey)it.next();
                    int[] span = td.tag2Span.get(k);
                    e.setValue(span[0]);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        String originalText = isCUT ? origText : origText.substring(start, end);
        userInfo.putAll(td.diffInfo);
        return td.checkDiffs(DiffUtilities.diff(originalText, resultSrc, start, td.readSections(originalText.length(), resultSrc.length(), lineStart, start), lineStart));
    }

    private int[] readSections(int l1, int l2, int printerStart, int diffStart) {
        Map<Integer, Integer> seqMap = this.blockSequenceMap;
        if (seqMap.isEmpty()) {
            int delta = diffStart - printerStart;
            return new int[]{l1 + delta, l2 + delta};
        }
        int[] res = new int[seqMap.size() * 2];
        int p = 0;
        for (Map.Entry<Integer, Integer> en : seqMap.entrySet()) {
            int point = en.getKey();
            if (point < printerStart || point > diffStart + l2) continue;
            res[p++] = en.getKey();
            res[p++] = en.getValue();
        }
        return res;
    }

    private java.util.List<Diff> checkDiffs(java.util.List<Diff> theDiffs) {
        if (theDiffs != null) {
            for (Diff d : theDiffs) {
                if (this.diffContext.positionConverter.getOriginalPosition(d.getPos()) <= this.diffContext.textLength && this.diffContext.positionConverter.getOriginalPosition(d.getEnd()) <= this.diffContext.textLength) continue;
                LOG.warning("Invalid diff: " + d);
            }
        }
        return theDiffs;
    }

    public static Collection<Diff> diff(Context context, DiffContext diffContext, TreeUtilities treeUtilities, java.util.List<? extends ImportTree> original, java.util.List<? extends ImportTree> nue, Map<Integer, String> userInfo, Map<Tree, ?> tree2Tag, Map<Tree, DocCommentTree> tree2Doc, Map<?, int[]> tag2Span, Set<Tree> oldTrees) {
        CasualDiff td = new CasualDiff(context, diffContext, treeUtilities, tree2Tag, tree2Doc, tag2Span, oldTrees);
        td.oldTopLevel = diffContext.origUnit;
        int start = td.oldTopLevel.getPackage() != null ? td.endPos(td.oldTopLevel.getPackage()) : 0;
        td.tokenSequence.move(start);
        while (td.tokenSequence.movePrevious()) {
            if (!td.isNoop((JavaTokenId)td.tokenSequence.token().id())) continue;
            start = td.tokenSequence.offset();
        }
        LinkedList<JCTree.JCImport> originalJC = new LinkedList<JCTree.JCImport>();
        LinkedList<JCTree.JCImport> nueJC = new LinkedList<JCTree.JCImport>();
        for (ImportTree importTree : original) {
            originalJC.add((JCTree.JCImport)importTree);
        }
        for (ImportTree importTree : nue) {
            nueJC.add((JCTree.JCImport)importTree);
        }
        PositionEstimator est = EstimatorFactory.imports(originalJC, nueJC, td.diffContext);
        int n = td.diffList(originalJC, nueJC, start, est, Measure.DEFAULT, td.printer);
        String resultSrc = td.printer.toString();
        if (start > n) {
            LOG.log(Level.INFO, "Illegal values: start = " + start + "; end = " + n + ".Please attach your messages.log to issue #200152 (https://netbeans.org/bugzilla/show_bug.cgi?id=200152)");
            LOG.log(Level.INFO, "-----\n" + td.diffContext.origText + "-----\n");
            LOG.log(Level.INFO, "Orig imports: " + original);
            LOG.log(Level.INFO, "New imports: " + nue);
        }
        String originalText = td.diffContext.origText.substring(start, n);
        userInfo.putAll(td.diffInfo);
        return td.checkDiffs(DiffUtilities.diff(originalText, resultSrc, start));
    }

    public int endPos(JCTree t) {
        if (t instanceof FieldGroupTree) {
            FieldGroupTree fgt = (FieldGroupTree)t;
            VariableTree vt = fgt.getVariables().get(fgt.getVariables().size() - 1);
            return TreeInfo.getEndPos((JCTree)((Object)vt), this.oldTopLevel.endPositions);
        }
        int endPos = this.diffContext.getEndPosition(this.oldTopLevel, t);
        if (endPos == -1) {
            endPos = t instanceof JCTree.JCAssign ? TreeInfo.getEndPos(((JCTree.JCAssign)t).rhs, this.oldTopLevel.endPositions) : CasualDiff.getOldPos(t);
        }
        return endPos;
    }

    private int endPos(List<? extends JCTree> trees) {
        int result = -1;
        if (trees.nonEmpty()) {
            result = this.endPos((JCTree)trees.head);
            List l = trees.tail;
            while (l.nonEmpty()) {
                result = this.endPos((JCTree)l.head);
                l = l.tail;
            }
        }
        return result;
    }

    private int endPos(java.util.List<? extends JCTree> trees) {
        if (trees.isEmpty()) {
            return -1;
        }
        return this.endPos(trees.get(trees.size() - 1));
    }

    private int checkLocalPointer(JCTree oldT, JCTree newT, int localPointer) {
        if (localPointer < 0 || localPointer > this.origText.length()) {
            LOG.warning("Invalid localPointer (" + localPointer + "), see defect #226498 and report the log to the issue");
            LOG.warning("OldT:" + oldT);
            LOG.warning("NewT:" + newT);
            LOG.warning("CodeStyle: " + CasualDiff.printCodeStyle(this.diffContext.style));
            LOG.warning("origText(" + this.origText.length() + "): " + this.origText);
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            LOG.warning("Stacktrace: " + sw.toString());
        }
        return localPointer;
    }

    protected void diffTopLevel(JCTree.JCCompilationUnit oldT, JCTree.JCCompilationUnit newT, int[] elementBounds) {
        this.oldTopLevel = oldT;
        int localPointer = this.diffPackage(oldT.getPackage(), newT.getPackage(), elementBounds[0]);
        PositionEstimator est = EstimatorFactory.imports(oldT.getImports(), newT.getImports(), this.diffContext);
        localPointer = this.diffList(oldT.getImports(), newT.getImports(), localPointer, est, Measure.DEFAULT, this.printer);
        java.util.List<? extends Tree> oldTopLevelDecls = TreeHelpers.getCombinedTopLevelDecls(oldT);
        java.util.List<? extends Tree> newTopLevelDecls = TreeHelpers.getCombinedTopLevelDecls(newT);
        est = EstimatorFactory.toplevel(oldTopLevelDecls, newTopLevelDecls, this.diffContext);
        localPointer = this.diffList(oldTopLevelDecls, newTopLevelDecls, localPointer, est, Measure.REAL_MEMBER, this.printer);
        this.checkLocalPointer(oldT, newT, localPointer);
        this.printer.print(this.origText.substring(localPointer));
    }

    private static int getOldIndent(DiffContext diffContext, Tree t) {
        int offset = (int)diffContext.trees.getSourcePositions().getStartPosition(diffContext.origUnit, t);
        if (offset < 0) {
            return -1;
        }
        while (offset > 0 && diffContext.origText.charAt(offset - 1) != '\n') {
            --offset;
        }
        int indent = 0;
        while (offset < diffContext.origText.length()) {
            char c;
            if ((c = diffContext.origText.charAt(offset++)) == '\t') {
                indent += diffContext.style.getTabSize();
                continue;
            }
            if (c == '\n' || !Character.isWhitespace(c)) break;
            ++indent;
        }
        return indent;
    }

    private boolean needStar(int localPointer) {
        if (localPointer <= 0) {
            return false;
        }
        while (localPointer > 0) {
            char c;
            if ((c = this.diffContext.origText.charAt(--localPointer)) == '\n') {
                return false;
            }
            if (Character.isWhitespace(c)) continue;
            return localPointer > 3 && this.diffContext.origText.substring(localPointer - 2, localPointer + 1).equals("/**");
        }
        return false;
    }

    private int adjustToPreviousNewLine(int oldPos, int localPointer) {
        char c;
        int offset = oldPos;
        if (offset < 0) {
            return localPointer;
        }
        while (offset > localPointer && (c = this.diffContext.origText.charAt(--offset)) != '\n') {
            if (c == '*' || Character.isWhitespace(c)) continue;
            return oldPos;
        }
        return offset;
    }

    private ChangeKind getChangeKind(Tree oldT, Tree newT) {
        if (oldT == newT) {
            return ChangeKind.NOCHANGE;
        }
        if (oldT != null && newT != null) {
            return ChangeKind.MODIFY;
        }
        if (oldT != null) {
            return ChangeKind.DELETE;
        }
        return ChangeKind.INSERT;
    }

    protected int diffModuleDef(JCTree.JCModuleDecl oldT, JCTree.JCModuleDecl newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] qualBounds = this.getBounds(oldT.qualId);
        if (oldT.getModuleType() == newT.getModuleType()) {
            this.copyTo(localPointer, qualBounds[0]);
        } else if (oldT.getModuleType() == ModuleTree.ModuleKind.OPEN) {
            PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.OPEN);
            this.copyTo(localPointer, this.tokenSequence.offset());
        } else {
            this.copyTo(localPointer, qualBounds[0]);
            this.printer.print("open ");
        }
        localPointer = this.diffTree(oldT.qualId, (JCTree)newT.qualId, qualBounds);
        int insertHint = oldT.directives.isEmpty() ? this.endPos(oldT) - 1 : oldT.directives.get(0).getStartPosition() - 1;
        this.tokenSequence.move(insertHint);
        this.tokenSequence.moveNext();
        insertHint = PositionEstimator.moveBackToToken(this.tokenSequence, insertHint, JavaTokenId.LBRACE) + 1;
        int old = this.printer.indent();
        PositionEstimator est = EstimatorFactory.members(oldT.directives, newT.directives, this.diffContext);
        localPointer = this.copyUpTo(localPointer, insertHint);
        insertHint = this.diffInnerComments(oldT, newT, insertHint);
        localPointer = this.diffList(oldT.directives, newT.directives, insertHint, est, Measure.REAL_MEMBER, this.printer);
        this.printer.undent(old);
        if (localPointer != -1 && localPointer < this.origText.length()) {
            if (this.origText.charAt(localPointer) == '}') {
                this.printer.toLeftMargin();
            }
            this.copyTo(localPointer, bounds[1]);
        }
        return bounds[1];
    }

    protected int diffRequires(JCTree.JCRequires oldT, JCTree.JCRequires newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] nameBounds = this.getBounds(oldT.moduleName);
        if (oldT.isStaticPhase || oldT.isTransitive) {
            JavaTokenId id = PositionEstimator.moveFwdToOneOfTokens(this.tokenSequence, localPointer, EnumSet.of(JavaTokenId.STATIC, JavaTokenId.TRANSITIVE));
            switch (id) {
                case STATIC: {
                    if (!newT.isStaticPhase) {
                        this.copyTo(localPointer, this.tokenSequence.offset());
                        this.tokenSequence.moveNext();
                        localPointer = this.tokenSequence.offset() + this.tokenSequence.token().length();
                    }
                    if (oldT.isTransitive == newT.isTransitive) {
                        this.copyTo(localPointer, nameBounds[0]);
                        break;
                    }
                    if (oldT.isTransitive) {
                        PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.TRANSITIVE);
                        this.copyTo(localPointer, this.tokenSequence.offset());
                        break;
                    }
                    this.copyTo(localPointer, nameBounds[0]);
                    this.printer.print("transitive ");
                    break;
                }
                case TRANSITIVE: {
                    if (!newT.isTransitive) {
                        this.copyTo(localPointer, this.tokenSequence.offset());
                        this.tokenSequence.moveNext();
                        localPointer = this.tokenSequence.offset() + this.tokenSequence.token().length();
                    }
                    if (oldT.isStaticPhase == newT.isStaticPhase) {
                        this.copyTo(localPointer, nameBounds[0]);
                        break;
                    }
                    if (oldT.isStaticPhase) {
                        PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.STATIC);
                        this.copyTo(localPointer, this.tokenSequence.offset());
                        break;
                    }
                    this.copyTo(localPointer, nameBounds[0]);
                    this.printer.print("static ");
                }
            }
        } else {
            this.copyTo(localPointer, nameBounds[0]);
            if (newT.isStaticPhase) {
                this.printer.print("static ");
            }
            if (newT.isTransitive) {
                this.printer.print("transitive ");
            }
        }
        localPointer = this.diffTree(oldT.moduleName, (JCTree)newT.moduleName, nameBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffExports(JCTree.JCExports oldT, JCTree.JCExports newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] expNameBounds = this.getBounds(oldT.qualid);
        this.copyTo(localPointer, expNameBounds[0]);
        localPointer = this.diffTree(oldT.qualid, (JCTree)newT.qualid, expNameBounds);
        int posHint = oldT.moduleNames == null || oldT.moduleNames.isEmpty() ? this.endPos(oldT) - 1 : oldT.moduleNames.iterator().next().getStartPosition();
        if (newT.moduleNames != null && !newT.moduleNames.isEmpty()) {
            int n = localPointer;
            localPointer = posHint;
            this.copyTo(n, localPointer);
        }
        PositionEstimator est = EstimatorFactory.exportsOpensTo(oldT.moduleNames, newT.moduleNames, this.diffContext);
        localPointer = this.diffList2(oldT.moduleNames, newT.moduleNames, posHint, est);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffOpens(JCTree.JCOpens oldT, JCTree.JCOpens newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] expNameBounds = this.getBounds(oldT.qualid);
        this.copyTo(localPointer, expNameBounds[0]);
        localPointer = this.diffTree(oldT.qualid, (JCTree)newT.qualid, expNameBounds);
        int posHint = oldT.moduleNames == null || oldT.moduleNames.isEmpty() ? this.endPos(oldT) - 1 : oldT.moduleNames.iterator().next().getStartPosition();
        if (newT.moduleNames != null && !newT.moduleNames.isEmpty()) {
            int n = localPointer;
            localPointer = posHint;
            this.copyTo(n, localPointer);
        }
        PositionEstimator est = EstimatorFactory.exportsOpensTo(oldT.moduleNames, newT.moduleNames, this.diffContext);
        localPointer = this.diffList2(oldT.moduleNames, newT.moduleNames, posHint, est);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffProvides(JCTree.JCProvides oldT, JCTree.JCProvides newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] servBounds = this.getBounds(oldT.serviceName);
        this.copyTo(localPointer, servBounds[0]);
        localPointer = this.diffTree(oldT.serviceName, (JCTree)newT.serviceName, servBounds);
        int posHint = oldT.implNames == null || oldT.implNames.isEmpty() ? this.endPos(oldT) - 1 : oldT.implNames.iterator().next().getStartPosition();
        if (newT.implNames != null && !newT.implNames.isEmpty()) {
            int n = localPointer;
            localPointer = posHint;
            this.copyTo(n, localPointer);
        }
        PositionEstimator est = EstimatorFactory.providesWith(oldT.implNames, newT.implNames, this.diffContext);
        localPointer = this.diffList2(oldT.implNames, newT.implNames, posHint, est);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffUses(JCTree.JCUses oldT, JCTree.JCUses newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] servBounds = this.getBounds(oldT.qualid);
        this.copyTo(localPointer, servBounds[0]);
        localPointer = this.diffTree(oldT.qualid, (JCTree)newT.qualid, servBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffPackage(JCTree.JCPackageDecl oldT, JCTree.JCPackageDecl newT, int start) {
        JCTree.JCExpression newTPid;
        int packageKeywordStart = start;
        JCTree.JCExpression oldTPid = oldT != null ? oldT.pid : null;
        JCTree.JCExpression jCExpression = newTPid = newT != null ? newT.pid : null;
        if (oldTPid != null) {
            this.tokenSequence.move(oldTPid.getStartPosition());
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
            packageKeywordStart = this.tokenSequence.offset();
        }
        List<Object> oldTAnnotations = oldT != null ? oldT.annotations : List.nil();
        List<Object> newTAnnotations = newT != null ? newT.annotations : List.nil();
        int localPointer = oldTAnnotations.isEmpty() && !newTAnnotations.isEmpty() ? packageKeywordStart : start;
        localPointer = this.diffAnnotationsLists(oldTAnnotations, newTAnnotations, localPointer, start);
        ChangeKind change = this.getChangeKind(oldTPid, newTPid);
        switch (change) {
            case NOCHANGE: {
                if (oldTPid == null) break;
                localPointer = this.copyUpTo(localPointer, this.endPos(oldTPid));
                break;
            }
            case INSERT: {
                this.printer.printPackage(newTPid);
                break;
            }
            case DELETE: {
                this.copyTo(localPointer, packageKeywordStart);
                this.tokenSequence.move(this.endPos(oldTPid));
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                localPointer = this.tokenSequence.offset() + 1;
                break;
            }
            case MODIFY: {
                this.copyTo(localPointer, CasualDiff.getOldPos(oldTPid));
                localPointer = this.endPos(oldTPid);
                this.printer.print(newTPid);
                this.diffInfo.put(CasualDiff.getOldPos(oldTPid), NbBundle.getMessage(CasualDiff.class, (String)"TXT_UpdatePackageStatement"));
            }
        }
        return localPointer;
    }

    protected int diffImport(JCTree.JCImport oldT, JCTree.JCImport newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] qualBounds = this.getBounds(oldT.getQualifiedIdentifier());
        if (oldT.staticImport == newT.staticImport) {
            this.copyTo(localPointer, qualBounds[0]);
        } else if (oldT.staticImport) {
            PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.STATIC);
            this.copyTo(localPointer, this.tokenSequence.offset());
        } else {
            this.copyTo(localPointer, qualBounds[0]);
            this.printer.print("static ");
        }
        localPointer = this.diffTree(oldT.getQualifiedIdentifier(), (JCTree)newT.getQualifiedIdentifier(), qualBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffClassDef(JCTree.JCClassDecl oldT, JCTree.JCClassDecl newT, int[] bounds) {
        boolean implicit;
        int localPointer = bounds[0];
        Name origOuterClassName = this.origClassName;
        Name newOuterClassName = this.newClassName;
        int insertHint = localPointer;
        java.util.List<JCTree> filteredOldTDefs = this.filterHidden(oldT.defs);
        java.util.List<JCTree> filteredNewTDefs = this.filterHidden(newT.defs);
        boolean bl = implicit = (oldT.mods.flags & 0x80000L) != 0L;
        if (!this.anonClass && !implicit) {
            PositionEstimator estimator;
            JavaTokenId[] javaTokenIdArray;
            this.tokenSequence.move(oldT.pos);
            this.tokenSequence.moveNext();
            this.tokenSequence.moveNext();
            int afterKindHint = this.tokenSequence.offset();
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
            insertHint = this.tokenSequence.offset();
            localPointer = this.diffModifiers(oldT.mods, newT.mods, oldT, localPointer);
            if (this.kindChanged(oldT.mods.flags, newT.mods.flags)) {
                int pos = oldT.pos;
                if ((oldT.mods.flags & 0x2000L) != 0L) {
                    this.tokenSequence.move(pos);
                    this.tokenSequence.moveNext();
                    PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                    pos = this.tokenSequence.offset();
                }
                if ((newT.mods.flags & 0x2000L) != 0L) {
                    this.copyTo(localPointer, pos);
                    this.printer.print("@interface");
                } else if ((newT.mods.flags & 0x4000L) != 0L) {
                    this.copyTo(localPointer, pos);
                    this.printer.print("enum");
                } else if ((newT.mods.flags & 0x200L) != 0L) {
                    this.copyTo(localPointer, pos);
                    this.printer.print("interface");
                } else {
                    this.copyTo(localPointer, pos);
                    this.printer.print("class");
                }
                localPointer = afterKindHint;
            }
            if (this.nameChanged(oldT.name, newT.name)) {
                this.copyTo(localPointer, insertHint);
                this.printer.print(newT.name);
                this.diffInfo.put(insertHint, NbBundle.getMessage(CasualDiff.class, (String)"TXT_ChangeClassName"));
                localPointer = insertHint += oldT.name.length();
            } else {
                int n = localPointer;
                localPointer = insertHint += oldT.name.length();
                this.copyTo(n, localPointer);
            }
            this.origClassName = oldT.name;
            this.newClassName = newT.name;
            if (oldT.typarams.nonEmpty() && newT.typarams.nonEmpty()) {
                int n = localPointer;
                localPointer = ((JCTree.JCTypeParameter)oldT.typarams.head).pos;
                this.copyTo(n, localPointer);
            }
            boolean parens = oldT.typarams.isEmpty() && newT.typarams.nonEmpty();
            List<JCTree.JCTypeParameter> list = oldT.typarams;
            List<JCTree.JCTypeParameter> list2 = newT.typarams;
            if (parens) {
                JavaTokenId[] javaTokenIdArray2 = new JavaTokenId[2];
                javaTokenIdArray2[0] = JavaTokenId.LT;
                javaTokenIdArray = javaTokenIdArray2;
                javaTokenIdArray2[1] = JavaTokenId.GT;
            } else {
                javaTokenIdArray = null;
            }
            localPointer = this.diffParameterList(list, list2, javaTokenIdArray, localPointer, Measure.ARGUMENT);
            if (oldT.typarams.nonEmpty()) {
                insertHint = this.endPos(oldT.typarams.last());
                this.tokenSequence.move(insertHint);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                insertHint = this.tokenSequence.offset() + this.tokenSequence.token().length();
            }
            switch (this.getChangeKind(oldT.extending, newT.extending)) {
                case NOCHANGE: {
                    insertHint = oldT.extending != null ? this.endPos(oldT.extending) : insertHint;
                    int n = localPointer;
                    localPointer = insertHint;
                    this.copyTo(n, localPointer);
                    break;
                }
                case MODIFY: {
                    this.copyTo(localPointer, CasualDiff.getOldPos(oldT.extending));
                    localPointer = this.diffTree(oldT.extending, (JCTree)newT.extending, this.getBounds(oldT.extending));
                    break;
                }
                case INSERT: {
                    this.copyTo(localPointer, insertHint);
                    this.printer.print(" extends ");
                    this.printer.print(newT.extending);
                    localPointer = insertHint;
                    break;
                }
                case DELETE: {
                    this.copyTo(localPointer, insertHint);
                    localPointer = this.endPos(oldT.extending);
                }
            }
            if (oldT.implementing.isEmpty()) {
                if (oldT.extending != null) {
                    insertHint = this.endPos(oldT.extending);
                }
            } else {
                insertHint = oldT.implementing.iterator().next().getStartPosition();
            }
            long flags = oldT.sym != null ? oldT.sym.flags() : oldT.mods.flags;
            PositionEstimator positionEstimator = estimator = (flags & 0x200L) == 0L ? EstimatorFactory.implementz(oldT.getImplementsClause(), newT.getImplementsClause(), this.diffContext) : EstimatorFactory.extendz(oldT.getImplementsClause(), newT.getImplementsClause(), this.diffContext);
            if (!newT.implementing.isEmpty()) {
                this.copyTo(localPointer, insertHint);
            }
            localPointer = this.diffList2(oldT.implementing, newT.implementing, insertHint, estimator);
            insertHint = this.endPos(oldT) - 1;
            insertHint = filteredOldTDefs.isEmpty() ? this.endPos(oldT) - 1 : filteredOldTDefs.get(0).getStartPosition() - 1;
            this.tokenSequence.move(insertHint);
            this.tokenSequence.moveNext();
            insertHint = PositionEstimator.moveBackToToken(this.tokenSequence, insertHint, JavaTokenId.LBRACE) + 1;
        } else if (!implicit) {
            insertHint = PositionEstimator.moveFwdToToken(this.tokenSequence, oldT.getKind() == Tree.Kind.ENUM ? localPointer : CasualDiff.getOldPos(oldT), JavaTokenId.LBRACE);
            this.tokenSequence.moveNext();
            insertHint = this.tokenSequence.offset();
        }
        int old = this.printer.indent();
        JCTree.JCClassDecl origClass = this.printer.enclClass;
        this.printer.enclClass = newT;
        PositionEstimator est = EstimatorFactory.members(filteredOldTDefs, filteredNewTDefs, this.diffContext);
        localPointer = this.copyUpTo(localPointer, insertHint);
        insertHint = this.diffInnerComments(oldT, newT, insertHint);
        if ((newT.mods.flags & 0x4000L) != 0L && !filteredNewTDefs.isEmpty()) {
            boolean xxx;
            boolean constMissing = filteredOldTDefs.isEmpty();
            boolean firstDiff = false;
            boolean oldEnum = constMissing;
            boolean bl2 = xxx = (newT.mods.flags & 0x4000L) != 0L && filteredOldTDefs.isEmpty() && !filteredNewTDefs.isEmpty() && !this.isEnum(filteredNewTDefs.get(0)) && !newT.getSimpleName().isEmpty();
            if (constMissing) {
                firstDiff = !this.isEnum(filteredNewTDefs.get(0));
            } else {
                oldEnum = this.isEnum(filteredOldTDefs.get(0));
                boolean bl3 = firstDiff = oldEnum != this.isEnum(filteredNewTDefs.get(0));
            }
            if (firstDiff && !newT.getSimpleName().isEmpty()) {
                if (oldEnum) {
                    this.printer.blankline();
                    this.printer.toLeftMargin();
                    this.printer.print(";");
                    this.printer.newline();
                } else {
                    insertHint = this.removeExtraEnumSemicolon(insertHint);
                }
            }
        }
        localPointer = this.diffList(filteredOldTDefs, filteredNewTDefs, insertHint, est, Measure.REAL_MEMBER, this.printer);
        this.printer.enclClass = origClass;
        this.origClassName = origOuterClassName;
        this.newClassName = newOuterClassName;
        this.printer.undent(old);
        if (localPointer != -1 && localPointer < this.origText.length()) {
            if (this.origText.charAt(localPointer) == '}') {
                this.printer.toLeftMargin();
            }
            this.copyTo(localPointer, bounds[1]);
        }
        return bounds[1];
    }

    private int removeExtraEnumSemicolon(int insertHint) {
        int startWS = -1;
        int rewind = this.tokenSequence.offset();
        this.tokenSequence.move(insertHint);
        this.tokenSequence.moveNext();
        boolean semi = false;
        block5: do {
            Token t = this.tokenSequence.token();
            switch ((JavaTokenId)t.id()) {
                case WHITESPACE: {
                    if (semi) {
                        int nl = t.text().toString().lastIndexOf(10);
                        if (nl == -1) {
                            startWS = this.tokenSequence.offset();
                            break;
                        }
                        startWS = this.tokenSequence.offset() + nl + 1;
                        break;
                    }
                    if (startWS != -1) continue block5;
                    startWS = t.text().toString().indexOf(10);
                    if (startWS == -1) {
                        startWS = this.tokenSequence.offset();
                        break;
                    }
                    startWS += this.tokenSequence.offset() + 1;
                    break;
                }
                case SEMICOLON: {
                    if (startWS >= 0) {
                        this.copyTo(insertHint, startWS);
                        insertHint = this.tokenSequence.offset() + t.length();
                    }
                    startWS = -1;
                    semi = true;
                    break;
                }
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case JAVADOC_COMMENT: {
                    if (semi) break block5;
                    startWS = -1;
                    break;
                }
                default: {
                    break block5;
                }
            }
        } while (this.tokenSequence.moveNext());
        if (semi && startWS > -1) {
            insertHint = startWS;
        }
        this.tokenSequence.move(rewind);
        this.tokenSequence.moveNext();
        return insertHint;
    }

    private boolean isEnum(Tree tree) {
        if (tree instanceof FieldGroupTree) {
            return ((FieldGroupTree)tree).isEnum();
        }
        if (tree instanceof VariableTree) {
            return (((JCTree.JCVariableDecl)tree).getModifiers().flags & 0x4000L) != 0L;
        }
        if (tree instanceof ClassTree) {
            return (((JCTree.JCClassDecl)tree).getModifiers().flags & 0x4000L) != 0L;
        }
        return false;
    }

    private boolean hasModifiers(JCTree.JCModifiers mods) {
        return mods != null && (!mods.getFlags().isEmpty() || !((List)mods.getAnnotations()).isEmpty());
    }

    protected int diffMethodDef(JCTree.JCMethodDecl oldT, JCTree.JCMethodDecl newT, int[] bounds) {
        int pos;
        JCTree.JCExpression oldRestype = oldT.name != this.names.init ? oldT.restype : null;
        JCTree.JCExpression newRestype = newT.name != this.names.init ? newT.restype : null;
        int localPointer = bounds[0];
        if (!this.matchModifiers(oldT.mods, newT.mods)) {
            if (this.hasModifiers(newT.mods)) {
                localPointer = this.diffModifiers(oldT.mods, newT.mods, oldT, localPointer);
            } else {
                int oldPos = CasualDiff.getOldPos(oldT.mods);
                this.copyTo(localPointer, oldPos);
                if (oldT.typarams.isEmpty()) {
                    localPointer = oldRestype != null ? CasualDiff.getOldPos(oldRestype) : oldT.pos;
                } else {
                    int firstTyParam = CasualDiff.getOldPos((JCTree)oldT.typarams.head);
                    this.tokenSequence.move(firstTyParam);
                    JavaTokenId id = PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                    localPointer = id == JavaTokenId.LT ? this.tokenSequence.offset() : firstTyParam;
                }
            }
        }
        int n = oldT.typarams.isEmpty() ? (oldRestype != null ? CasualDiff.getOldPos(oldRestype) : oldT.pos) : (pos = CasualDiff.getOldPos((JCTree)oldT.typarams.head));
        if (!this.listsMatch(oldT.typarams, newT.typarams)) {
            JavaTokenId[] javaTokenIdArray;
            if (newT.typarams.nonEmpty()) {
                this.copyTo(localPointer, pos);
            } else if (this.hasModifiers(oldT.mods)) {
                this.copyTo(localPointer, this.endPos(oldT.mods));
            }
            boolean parens = oldT.typarams.isEmpty() || newT.typarams.isEmpty();
            List<JCTree.JCTypeParameter> list = oldT.typarams;
            List<JCTree.JCTypeParameter> list2 = newT.typarams;
            if (parens) {
                JavaTokenId[] javaTokenIdArray2 = new JavaTokenId[2];
                javaTokenIdArray2[0] = JavaTokenId.LT;
                javaTokenIdArray = javaTokenIdArray2;
                javaTokenIdArray2[1] = JavaTokenId.GT;
            } else {
                javaTokenIdArray = null;
            }
            localPointer = this.diffParameterList(list, list2, javaTokenIdArray, pos, Measure.ARGUMENT);
            if (parens && oldT.typarams.isEmpty()) {
                this.printer.print(" ");
            }
        }
        if (oldRestype != null) {
            int[] restypeBounds = this.getBounds(oldRestype);
            this.copyTo(localPointer, restypeBounds[0]);
            localPointer = this.diffTree(oldRestype, (JCTree)newRestype, restypeBounds);
            if (restypeBounds[1] > localPointer) {
                int n2 = localPointer;
                localPointer = restypeBounds[1];
                this.copyTo(n2, localPointer);
            }
        } else if (oldRestype == null && newRestype != null) {
            int n3 = localPointer;
            localPointer = oldT.pos;
            this.copyTo(n3, localPointer);
            this.printer.print(newRestype);
            this.printer.print(" ");
        }
        int posHint = oldT.typarams.isEmpty() ? (oldRestype != null ? oldRestype.getStartPosition() : oldT.getStartPosition()) : oldT.typarams.iterator().next().getStartPosition();
        if (!(oldT.name == this.names.init && this.origClassName == null || newT.name == this.names.init && this.newClassName == null)) {
            int origLength;
            int n4 = origLength = oldT.name == this.names.init && this.origClassName != null ? this.origClassName.length() : oldT.name.length();
            if (this.nameChanged(oldT.name, newT.name)) {
                this.copyTo(localPointer, oldT.pos);
                if (newT.name == this.names.init && this.newClassName != null) {
                    this.printer.print(this.newClassName);
                    localPointer = oldT.pos + origLength;
                } else {
                    this.printer.print(newT.name);
                    this.diffInfo.put(oldT.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameMethod", (Object)oldT.name));
                    localPointer = oldT.pos + origLength;
                }
            } else {
                int n5 = localPointer;
                localPointer = oldT.pos + origLength;
                this.copyTo(n5, localPointer);
            }
        }
        if (oldT.params.isEmpty()) {
            int startOffset = oldT.pos;
            PositionEstimator.moveFwdToToken(this.tokenSequence, startOffset, JavaTokenId.RPAREN);
            posHint = this.tokenSequence.offset();
        } else {
            posHint = oldT.params.iterator().next().getStartPosition();
        }
        if (!this.listsMatch(oldT.params, newT.params)) {
            this.copyTo(localPointer, posHint);
            int old = this.printer.setPrec(0);
            this.parameterPrint = true;
            JCTree.JCClassDecl oldEnclClass = this.printer.enclClass;
            this.printer.enclClass = null;
            localPointer = this.diffParameterList(oldT.params, newT.params, null, posHint, Measure.MEMBER);
            this.printer.enclClass = oldEnclClass;
            this.parameterPrint = false;
            this.printer.setPrec(old);
        }
        PositionEstimator.moveFwdToToken(this.tokenSequence, oldT.params.isEmpty() ? posHint : this.endPos(oldT.params.last()), JavaTokenId.RPAREN);
        this.tokenSequence.moveNext();
        posHint = this.tokenSequence.offset();
        if (localPointer < posHint) {
            int n6 = localPointer;
            localPointer = posHint;
            this.copyTo(n6, localPointer);
        }
        if (oldT.thrown.isEmpty()) {
            if (oldT.body != null) {
                this.tokenSequence.move(oldT.body.pos);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                posHint = this.tokenSequence.offset();
            } else if (oldT.defaultValue != null) {
                this.tokenSequence.move(CasualDiff.getOldPos(oldT.defaultValue));
                while (this.tokenSequence.movePrevious() && this.tokenSequence.token().id() != JavaTokenId.DEFAULT) {
                }
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                posHint = this.tokenSequence.offset();
            } else {
                posHint = this.endPos(oldT) - 1;
            }
        } else {
            posHint = oldT.thrown.iterator().next().getStartPosition();
        }
        if (!newT.thrown.isEmpty()) {
            int n7 = localPointer;
            localPointer = posHint;
            this.copyTo(n7, localPointer);
        }
        PositionEstimator est = EstimatorFactory.throwz(oldT.getThrows(), newT.getThrows(), this.diffContext);
        localPointer = this.diffList2(oldT.thrown, newT.thrown, posHint, est);
        if (oldT.defaultValue != newT.defaultValue) {
            if (oldT.defaultValue == null) {
                this.printer.print(" default ");
                this.printer.print(newT.defaultValue);
            } else if (newT.defaultValue == null) {
                localPointer = this.endPos(oldT.defaultValue);
            } else {
                int[] restypeBounds = this.getBounds(oldT.defaultValue);
                this.copyTo(localPointer, restypeBounds[0]);
                int n8 = localPointer = this.diffTree(oldT.defaultValue, (JCTree)newT.defaultValue, restypeBounds);
                localPointer = restypeBounds[1];
                this.copyTo(n8, localPointer);
            }
        }
        if (newT.body == null && oldT.body != null) {
            localPointer = this.endPos(oldT.body);
            this.printer.print(";");
        } else if (oldT.body != null && newT.body != null) {
            int[] bodyBounds = this.getBounds(oldT.body);
            this.copyTo(localPointer, bodyBounds[0]);
            localPointer = this.diffTree(oldT.body, (JCTree)newT.body, bodyBounds);
        } else if (oldT.body == null && newT.body != null) {
            this.tokenSequence.move(localPointer);
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
            if (this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                localPointer = this.tokenSequence.offset() + this.tokenSequence.token().length();
            }
            if (this.diffContext.style.spaceBeforeMethodDeclLeftBrace()) {
                this.printer.print(" ");
            }
            this.printer.print(newT.body);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffVarDef(JCTree.JCVariableDecl oldT, JCTree.JCVariableDecl newT, int pos) {
        int localPointer = oldT.pos;
        this.copyTo(pos, localPointer);
        if (this.nameChanged(oldT.name, newT.name)) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(newT.name);
            this.diffInfo.put(oldT.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameVariable", (Object)oldT.name));
            localPointer = oldT.pos + oldT.name.length();
        }
        if (newT.init != null && oldT.init != null) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldT.init);
            this.copyTo(n, localPointer);
            localPointer = this.diffTree(oldT.init, (JCTree)newT.init, new int[]{localPointer, this.endPos(oldT.init)});
        } else {
            if (oldT.init != null && newT.init == null) {
                pos = CasualDiff.getOldPos(oldT.init);
                this.tokenSequence.move(pos);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                int to = this.tokenSequence.offset();
                this.copyTo(localPointer, to);
                localPointer = this.endPos(oldT.init);
            }
            if (oldT.init == null && newT.init != null) {
                int end = this.endPos(oldT);
                this.tokenSequence.move(end);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                int n = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n, localPointer);
                this.printer.printVarInit(newT);
            }
        }
        int n = localPointer;
        localPointer = this.endPos(oldT);
        this.copyTo(n, localPointer);
        return localPointer;
    }

    private int diffVarDef(JCTree.JCVariableDecl oldT, JCTree.JCVariableDecl newT, int[] bounds) {
        int localPointer = bounds[0];
        if ((oldT.mods.flags & 0x4000L) != 0L) {
            JCTree.JCModifiers mods = oldT.getModifiers();
            int startPos = mods.pos != -1 ? CasualDiff.getOldPos(mods) : CasualDiff.getOldPos(oldT);
            localPointer = this.diffAnnotationsLists((List<JCTree.JCAnnotation>)mods.getAnnotations(), (List<JCTree.JCAnnotation>)newT.getModifiers().getAnnotations(), startPos, localPointer);
            if (this.nameChanged(oldT.name, newT.name)) {
                int namePos = oldT.pos;
                if (!((List)mods.getAnnotations()).isEmpty()) {
                    int annotationsEnd = this.endPos((List<? extends JCTree>)mods.getAnnotations());
                    this.tokenSequence.move(annotationsEnd);
                    PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                    if (this.tokenSequence.token().id() == JavaTokenId.IDENTIFIER) {
                        namePos = this.tokenSequence.offset();
                    }
                }
                this.copyTo(localPointer, namePos);
                this.printer.print(newT.name);
                this.diffInfo.put(namePos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameEnumConstant", (Object)oldT.name));
                localPointer = namePos + oldT.name.length();
            }
            JCTree.JCNewClass oldInit = (JCTree.JCNewClass)oldT.init;
            JCTree.JCNewClass newInit = (JCTree.JCNewClass)newT.init;
            if (oldInit.args.nonEmpty() && newInit.args.nonEmpty()) {
                int n = localPointer;
                localPointer = CasualDiff.getOldPos((JCTree)oldInit.args.head);
                this.copyTo(n, localPointer);
                localPointer = this.diffParameterList(oldInit.args, newInit.args, null, localPointer, Measure.ARGUMENT);
            }
            if (oldInit.def != null && newInit.def != null) {
                this.anonClass = true;
                int[] defBounds = new int[]{localPointer, this.endPos(oldInit.def)};
                localPointer = this.diffTree(oldInit.def, (JCTree)newInit.def, defBounds);
                this.anonClass = false;
            }
            this.copyTo(localPointer, bounds[1]);
            return bounds[1];
        }
        if (!this.matchModifiers(oldT.mods, newT.mods)) {
            if (this.hasModifiers(newT.mods)) {
                localPointer = this.diffModifiers(oldT.mods, newT.mods, oldT, localPointer);
            } else if (this.hasModifiers(oldT.mods)) {
                int oldPos = CasualDiff.getOldPos(oldT.mods);
                this.copyTo(localPointer, oldPos);
                localPointer = CasualDiff.getOldPos(oldT.vartype);
            }
        }
        boolean cLikeArray = false;
        boolean cLikeArrayChange = false;
        int addDimensions = 0;
        if (this.diffContext.syntheticTrees.contains(oldT.vartype)) {
            if (!this.diffContext.syntheticTrees.contains(newT.vartype)) {
                int varOffset = this.findVar(localPointer, oldT.pos);
                if (varOffset != -1) {
                    int n = localPointer;
                    localPointer = varOffset;
                    this.copyTo(n, localPointer);
                    localPointer += 3;
                }
                if (!this.suppressParameterTypes) {
                    int l = this.printer.out.length();
                    this.printer.print(newT.vartype);
                    if (l < this.printer.out.length() && varOffset == -1) {
                        this.printer.print(" ");
                    }
                }
            }
        } else if (this.suppressParameterTypes) {
            int[] vartypeBounds = this.getBounds(oldT.vartype);
            localPointer = vartypeBounds[1];
        } else {
            if (newT.vartype == null) {
                throw new UnsupportedOperationException();
            }
            int[] vartypeBounds = this.getBounds(oldT.vartype);
            addDimensions = this.dimension(newT.vartype, -1);
            cLikeArray = vartypeBounds[1] > oldT.pos;
            boolean bl = cLikeArrayChange = cLikeArray && this.dimension(oldT.vartype, oldT.pos) > addDimensions;
            if (oldT.type.getKind() == TypeKind.ERROR && vartypeBounds[1] == -1) {
                int modsUpperBound = this.getCommentCorrectedEndPos(oldT.mods);
                if (modsUpperBound > -1) {
                    this.tokenSequence.move(modsUpperBound);
                    if (this.tokenSequence.moveNext()) {
                        int n = localPointer;
                        localPointer = modsUpperBound;
                        this.copyTo(n, localPointer);
                    }
                }
                int offset = localPointer;
                JavaTokenId tokenId = null;
                this.tokenSequence.move(localPointer);
                while (this.tokenSequence.moveNext()) {
                    offset = this.tokenSequence.offset();
                    tokenId = (JavaTokenId)this.tokenSequence.token().id();
                    if ((tokenId == JavaTokenId.WHITESPACE || tokenId == JavaTokenId.BLOCK_COMMENT || tokenId == JavaTokenId.JAVADOC_COMMENT) && offset < oldT.sym.pos) continue;
                }
                int n = localPointer;
                localPointer = offset;
                this.copyTo(n, localPointer);
                vartypeBounds[1] = oldT.sym.pos;
                vartypeBounds[0] = offset;
            } else {
                this.copyTo(localPointer, vartypeBounds[0]);
            }
            localPointer = this.diffTree(oldT.vartype, (JCTree)newT.vartype, vartypeBounds);
            if (oldT.type.getKind() == TypeKind.ERROR && localPointer == -1) {
                this.tokenSequence.move(vartypeBounds[0]);
                this.tokenSequence.moveNext();
                if (this.tokenSequence.moveNext()) {
                    int offset = this.tokenSequence.offset();
                    localPointer = vartypeBounds[1];
                    this.copyTo(offset, localPointer);
                }
            }
        }
        if (this.nameChanged(oldT.name, newT.name)) {
            boolean isOldError;
            boolean bl = isOldError = oldT.name == Names.instance((Context)this.context).error;
            if (!isOldError) {
                this.copyTo(localPointer, oldT.pos);
            } else {
                this.printer.print(" ");
            }
            if (cLikeArray) {
                this.printer.eatChars(1);
                for (int i = 0; i < addDimensions; ++i) {
                    this.printer.print("[]");
                }
                this.printer.print(" ");
            }
            this.printer.print(newT.name);
            this.diffInfo.put(oldT.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameVariable", (Object)oldT.name));
            if (!isOldError) {
                if (cLikeArray) {
                    int[] clab = this.getBounds(oldT.vartype);
                    localPointer = clab[1];
                } else {
                    localPointer = oldT.pos + oldT.name.length();
                }
            }
        } else if (cLikeArrayChange) {
            for (int i = 0; i < addDimensions; ++i) {
                this.printer.print("[]");
            }
            this.printer.print(" ");
            this.printer.print(newT.name);
        }
        if (newT.init != null && oldT.init != null) {
            int n = localPointer;
            localPointer = this.getCommentCorrectedOldPos(oldT.init);
            this.copyTo(n, localPointer);
            localPointer = this.diffTree(oldT.init, (JCTree)newT.init, new int[]{localPointer, this.endPos(oldT.init)});
        } else {
            if (oldT.init != null && newT.init == null) {
                int pos = CasualDiff.getOldPos(oldT.init);
                this.tokenSequence.move(pos);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                int to = this.tokenSequence.offset();
                this.copyTo(localPointer, to);
                localPointer = this.endPos(oldT.init);
            }
            if (oldT.init == null && newT.init != null) {
                int end = this.endPos(oldT);
                this.tokenSequence.move(end);
                this.tokenSequence.moveNext();
                if (!JavaTokenId.COMMA.equals((Object)this.tokenSequence.token().id()) && !JavaTokenId.SEMICOLON.equals((Object)this.tokenSequence.token().id())) {
                    this.tokenSequence.movePrevious();
                }
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                int n = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n, localPointer);
                this.printer.printVarInit(newT);
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffBlock(JCTree.JCBlock oldT, JCTree.JCBlock newT, int[] blockBounds) {
        boolean emptyToNonEmptySingleLine;
        int localPointer = blockBounds[0];
        int startPos = CasualDiff.getOldPos(oldT);
        int endPos = this.endPos(oldT);
        if (oldT.flags != newT.flags) {
            int n = localPointer;
            localPointer = startPos;
            this.copyTo(n, localPointer);
            if ((oldT.flags & 8L) == 0L && (newT.flags & 8L) != 0L) {
                this.printer.print("static");
                if (this.diffContext.style.spaceBeforeStaticInitLeftBrace()) {
                    this.printer.print(" ");
                }
            } else if ((oldT.flags & 8L) != 0L && (newT.flags & 8L) == 0L) {
                this.tokenSequence.move(startPos);
                if (this.tokenSequence.moveNext() && this.tokenSequence.token().id() == JavaTokenId.STATIC) {
                    localPointer = this.tokenSequence.offset() + this.tokenSequence.token().length();
                    if (this.tokenSequence.moveNext() && this.tokenSequence.token().id() == JavaTokenId.WHITESPACE) {
                        localPointer = this.tokenSequence.offset() + this.tokenSequence.token().length();
                    }
                }
            }
        } else {
            int n = localPointer;
            localPointer = oldT.pos + 1;
            this.copyTo(n, localPointer);
        }
        PositionEstimator est = EstimatorFactory.statements(this.filterHidden(oldT.stats), this.filterHidden(newT.stats), this.diffContext);
        int old = this.printer.indent();
        localPointer = this.diffInnerComments(oldT, newT, localPointer);
        JCTree.JCClassDecl oldEnclosing = this.printer.enclClass;
        this.printer.enclClass = null;
        java.util.List<JCTree> oldstats = this.filterHidden(oldT.stats);
        Position.LineMap lm = this.oldTopLevel.getLineMap();
        boolean bl = emptyToNonEmptySingleLine = oldT.stats.isEmpty() && !newT.stats.isEmpty() && lm.getLineNumber(startPos) == lm.getLineNumber(endPos);
        if (emptyToNonEmptySingleLine) {
            this.printer.newline();
            this.printer.toLeftMargin();
        }
        localPointer = this.diffList(oldstats, this.filterHidden(newT.stats), localPointer, est, Measure.MEMBER, this.printer);
        this.printer.enclClass = oldEnclosing;
        if (emptyToNonEmptySingleLine) {
            this.printer.undent(old);
            this.printer.toLeftMargin();
            this.tokenSequence.move(localPointer);
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
            int n = localPointer = this.tokenSequence.offset();
            localPointer = endPos;
            this.copyTo(n, localPointer);
        } else {
            if (localPointer < endPos) {
                int n = localPointer;
                localPointer = endPos;
                this.copyTo(n, localPointer);
            }
            this.printer.undent(old);
        }
        return localPointer;
    }

    private int adjustLocalPointer(int localPointer, CommentSet cs, CommentSet.RelativePosition position) {
        if (cs == null) {
            return localPointer;
        }
        java.util.List<Comment> cl = cs.getComments(position);
        if (!cl.isEmpty()) {
            for (Comment comment : cl) {
                localPointer = Math.max(comment.endPos(), localPointer);
            }
        }
        return localPointer;
    }

    private boolean isComment(JavaTokenId tid) {
        switch (tid) {
            case LINE_COMMENT: 
            case BLOCK_COMMENT: 
            case JAVADOC_COMMENT: {
                return true;
            }
        }
        return false;
    }

    private boolean isNoop(JavaTokenId tid) {
        switch (tid) {
            case WHITESPACE: 
            case LINE_COMMENT: 
            case BLOCK_COMMENT: 
            case JAVADOC_COMMENT: {
                return true;
            }
        }
        return false;
    }

    private int dimension(JCTree t, int afterPos) {
        int[] bounds;
        if (t.getKind() != Tree.Kind.ARRAY_TYPE) {
            return 0;
        }
        int add = afterPos >= 0 ? (afterPos < (bounds = this.getBounds(t))[1] ? 1 : 0) : 1;
        return add + this.dimension(((JCTree.JCArrayTypeTree)t).getType(), afterPos);
    }

    protected int diffDoLoop(JCTree.JCDoWhileLoop oldT, JCTree.JCDoWhileLoop newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] bodyBounds = new int[]{localPointer, this.endPos(oldT.body)};
        int oldIndent = newT.body.hasTag(JCTree.Tag.BLOCK) ? -1 : this.printer.indent();
        localPointer = this.diffTree((JCTree)oldT.body, (JCTree)newT.body, bodyBounds, oldT.getKind());
        if (!newT.body.hasTag(JCTree.Tag.BLOCK)) {
            this.printer.undent(oldIndent);
        }
        int[] condBounds = this.getBounds(oldT.cond);
        if (oldT.body.getKind() != Tree.Kind.BLOCK && newT.body.getKind() == Tree.Kind.BLOCK) {
            PositionEstimator.moveBackToToken(this.tokenSequence, condBounds[0], JavaTokenId.WHILE);
            localPointer = this.tokenSequence.offset();
        } else {
            this.copyTo(localPointer, condBounds[0]);
            localPointer = this.diffTree(oldT.cond, (JCTree)newT.cond, condBounds);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffWhileLoop(JCTree.JCWhileLoop oldT, JCTree.JCWhileLoop newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] condPos = this.getBounds(oldT.cond);
        this.copyTo(localPointer, condPos[0]);
        localPointer = this.diffTree(oldT.cond, (JCTree)newT.cond, condPos);
        int[] bodyPos = new int[]{localPointer, this.endPos(oldT.body)};
        int oldIndent = newT.body.hasTag(JCTree.Tag.BLOCK) ? -1 : this.printer.indent();
        localPointer = this.diffTree((JCTree)oldT.body, (JCTree)newT.body, bodyPos, oldT.getKind());
        if (!newT.body.hasTag(JCTree.Tag.BLOCK)) {
            this.printer.undent(oldIndent);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffForLoop(JCTree.JCForLoop oldT, JCTree.JCForLoop newT, int[] bounds) {
        int localPointer;
        if (oldT.init.nonEmpty()) {
            localPointer = CasualDiff.getOldPos((JCTree)oldT.init.head);
        } else {
            PositionEstimator.moveFwdToToken(this.tokenSequence, bounds[0], JavaTokenId.SEMICOLON);
            localPointer = this.tokenSequence.offset();
        }
        this.copyTo(bounds[0], localPointer);
        if (!this.listsMatch(oldT.init, newT.init)) {
            boolean newVariable;
            boolean oldVariable = CasualDiff.containsVariable(oldT.init);
            if (oldVariable ^ (newVariable = CasualDiff.containsVariable(newT.init))) {
                int oldPrec = this.printer.setPrec(0);
                localPointer = this.diffParameterList(oldT.init, newT.init, null, localPointer, Measure.ARGUMENT);
                this.printer.setPrec(oldPrec);
            } else if (oldVariable) {
                java.util.List oldInit = NbCollections.checkedListByCopy(oldT.init, JCTree.JCVariableDecl.class, (boolean)false);
                FieldGroupTree old = new FieldGroupTree(oldInit);
                java.util.List newInit = NbCollections.checkedListByCopy(newT.init, JCTree.JCVariableDecl.class, (boolean)false);
                FieldGroupTree nue = new FieldGroupTree(newInit);
                int[] initBounds = this.getBounds((JCTree)oldT.init.head);
                JCTree last = oldT.init.get(oldT.init.size() - 1);
                long endPos = this.diffContext.trees.getSourcePositions().getEndPosition(this.oldTopLevel, last);
                initBounds[1] = (int)endPos;
                localPointer = this.diffTree(old, (JCTree)nue, initBounds);
            } else {
                localPointer = this.diffParameterList(oldT.init, newT.init, null, localPointer, Measure.ARGUMENT);
            }
        }
        if (oldT.cond != null) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldT.cond);
            this.copyTo(n, localPointer);
            localPointer = this.diffTree(oldT.cond, (JCTree)newT.cond, this.getBounds(oldT.cond));
        } else {
            PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.SEMICOLON);
            int n = localPointer;
            localPointer = this.tokenSequence.offset();
            this.copyTo(n, localPointer);
        }
        if (oldT.step.nonEmpty()) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos((JCTree)oldT.step.head);
            this.copyTo(n, localPointer);
        } else {
            PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.SEMICOLON);
            this.tokenSequence.moveNext();
            int n = localPointer;
            localPointer = this.tokenSequence.offset();
            this.copyTo(n, localPointer);
        }
        localPointer = this.diffParameterList(oldT.step, newT.step, null, localPointer, Measure.ARGUMENT);
        int[] bodyBounds = new int[]{localPointer, this.endPos(oldT.body)};
        int oldIndent = newT.body.hasTag(JCTree.Tag.BLOCK) ? -1 : this.printer.indent();
        localPointer = this.diffTree((JCTree)oldT.body, (JCTree)newT.body, bodyBounds, oldT.getKind());
        if (!newT.body.hasTag(JCTree.Tag.BLOCK)) {
            this.printer.undent(oldIndent);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    private static boolean containsVariable(java.util.List<JCTree.JCStatement> statements) {
        for (JCTree.JCStatement s : statements) {
            if (s.getKind() != Tree.Kind.VARIABLE) continue;
            return true;
        }
        return false;
    }

    protected int diffForeachLoop(JCTree.JCEnhancedForLoop oldT, JCTree.JCEnhancedForLoop newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] varBounds = this.getBounds(oldT.var);
        this.copyTo(localPointer, varBounds[0]);
        localPointer = this.diffTree(oldT.var, (JCTree)newT.var, varBounds);
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, (JCTree)newT.expr, exprBounds);
        int[] bodyBounds = new int[]{localPointer, this.endPos(oldT.body)};
        int oldIndent = newT.body.hasTag(JCTree.Tag.BLOCK) ? -1 : this.printer.indent();
        localPointer = this.diffTree((JCTree)oldT.body, (JCTree)newT.body, bodyBounds, oldT.getKind());
        if (!newT.body.hasTag(JCTree.Tag.BLOCK)) {
            this.printer.undent(oldIndent);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffLabelled(JCTree.JCLabeledStatement oldT, JCTree.JCLabeledStatement newT, int[] bounds) {
        int localPointer = bounds[0];
        if (this.nameChanged(oldT.label, newT.label)) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldT);
            this.copyTo(n, localPointer);
            this.printer.print(newT.label);
            localPointer += oldT.label.length();
        }
        int[] bodyBounds = this.getBounds(oldT.body);
        this.copyTo(localPointer, bodyBounds[0]);
        localPointer = this.diffTree(oldT.body, (JCTree)newT.body, bodyBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffSwitch(JCTree.JCSwitch oldT, JCTree.JCSwitch newT, int[] bounds) {
        String caseKind;
        int localPointer = bounds[0];
        int[] selectorBounds = this.getBounds(oldT.selector);
        this.copyTo(localPointer, selectorBounds[0]);
        localPointer = this.diffTree(oldT.selector, (JCTree)newT.selector, selectorBounds);
        this.tokenSequence.move(selectorBounds[1]);
        while (this.tokenSequence.moveNext() && JavaTokenId.LBRACE != this.tokenSequence.token().id()) {
        }
        this.tokenSequence.moveNext();
        int n = localPointer;
        localPointer = this.tokenSequence.offset();
        this.copyTo(n, localPointer);
        PositionEstimator est = EstimatorFactory.cases(oldT.getCases(), newT.getCases(), this.diffContext);
        localPointer = this.diffList(oldT.cases, newT.cases, localPointer, est, Measure.MEMBER, this.printer);
        List<JCTree.JCCase> cases = newT.cases;
        if (cases.size() != 0 && (caseKind = String.valueOf((Object)((JCTree.JCCase)cases.get(0)).getCaseKind())).equals("RULE")) {
            this.printer.newline();
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffSwitchExpression(JCTree.JCSwitchExpression oldT, JCTree.JCSwitchExpression newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] selectorBounds = this.getBounds(oldT.selector);
        this.copyTo(localPointer, selectorBounds[0]);
        localPointer = this.diffTree(oldT.selector, (JCTree)newT.selector, selectorBounds);
        this.tokenSequence.move(selectorBounds[1]);
        while (this.tokenSequence.moveNext() && JavaTokenId.LBRACE != this.tokenSequence.token().id()) {
        }
        this.tokenSequence.moveNext();
        int n = localPointer;
        localPointer = this.tokenSequence.offset();
        this.copyTo(n, localPointer);
        PositionEstimator est = EstimatorFactory.cases(oldT.cases, newT.cases, this.diffContext);
        ListBuffer<JCTree.JCCase> oldTcases = new ListBuffer<JCTree.JCCase>();
        for (CaseTree t : oldT.getCases()) {
            oldTcases.append((JCTree.JCCase)t);
        }
        ListBuffer<JCTree.JCCase> newTcases = new ListBuffer<JCTree.JCCase>();
        for (CaseTree t : newT.getCases()) {
            newTcases.append((JCTree.JCCase)t);
        }
        localPointer = this.diffList(oldTcases.toList(), newTcases.toList(), localPointer, est, Measure.MEMBER, this.printer);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffBindingPattern(JCTree.JCBindingPattern oldT, JCTree.JCBindingPattern newT, int[] bounds) {
        return this.diffTree(oldT.var, (JCTree)newT.var, bounds);
    }

    protected int diffRecordPattern(JCTree.JCRecordPattern oldT, JCTree.JCRecordPattern newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] exprBounds = this.getBounds(oldT.deconstructor);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.deconstructor, (JCTree)newT.deconstructor, exprBounds);
        Iterator<JCTree.JCPattern> oldTIter = oldT.nested.iterator();
        Iterator<JCTree.JCPattern> newTIter = newT.nested.iterator();
        while (oldTIter.hasNext()) {
            JCTree oldP = oldTIter.next();
            JCTree newP = newTIter.next();
            int[] patternBounds = this.getBounds(oldP);
            this.copyTo(localPointer, patternBounds[0]);
            localPointer = this.diffTree(oldP, newP, patternBounds);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffConstantCaseLabel(JCTree.JCConstantCaseLabel oldT, JCTree.JCConstantCaseLabel newT, int[] bounds) {
        return this.diffTree(oldT.expr, (JCTree)newT.expr, bounds);
    }

    protected int diffCase(JCTree.JCCase oldT, JCTree.JCCase newT, int[] bounds) {
        int copyTo;
        int endpos;
        int posHint;
        int localPointer = bounds[0];
        java.util.List oldPatterns = oldT.getLabels();
        java.util.List newPatterns = newT.getLabels();
        PositionEstimator patternEst = EstimatorFactory.casePatterns(oldPatterns, newPatterns, this.diffContext);
        if (JavaTokenId.DEFAULT == PositionEstimator.moveFwdToOneOfTokens(this.tokenSequence, bounds[0], EnumSet.of(JavaTokenId.CASE, JavaTokenId.DEFAULT))) {
            endpos = posHint = this.tokenSequence.offset();
            copyTo = posHint;
        } else {
            copyTo = posHint = ((JCTree.JCCaseLabel)oldPatterns.iterator().next()).getStartPosition();
            endpos = this.endPos((JCTree)oldPatterns.get(oldPatterns.size() - 1));
            if (newPatterns.size() == 1 && ((JCTree.JCCaseLabel)newPatterns.get(0)).getKind() == Tree.Kind.DEFAULT_CASE_LABEL) {
                copyTo = this.tokenSequence.offset();
            }
        }
        this.copyTo(localPointer, copyTo);
        localPointer = this.diffList2(oldPatterns, newPatterns, posHint, patternEst);
        this.tokenSequence.move(endpos);
        if (oldT.guard != null && newT.guard != null) {
            int[] guardBounds = this.getBounds(oldT.guard);
            this.copyTo(localPointer, guardBounds[0]);
            this.diffTree(oldT.guard, (JCTree)newT.guard, guardBounds);
        } else if (oldT.guard != null && newT.guard == null || oldT.guard != null || newT.guard != null) {
            // empty if block
        }
        while (this.tokenSequence.moveNext() && JavaTokenId.COLON != this.tokenSequence.token().id() && JavaTokenId.ARROW != this.tokenSequence.token().id()) {
        }
        boolean reindentStatements = false;
        if (Objects.equals((Object)oldT.getCaseKind(), (Object)newT.getCaseKind())) {
            this.tokenSequence.moveNext();
            int n = localPointer;
            localPointer = this.tokenSequence.offset();
            this.copyTo(n, localPointer);
        } else if (JavaTokenId.COLON == this.tokenSequence.token().id()) {
            this.printer.out.needSpace();
            this.printer.print("-> ");
            PositionEstimator.moveToDifferentThan(this.tokenSequence, PositionEstimator.Direction.FORWARD, EnumSet.of(JavaTokenId.WHITESPACE));
            localPointer = this.tokenSequence.offset();
        } else if (JavaTokenId.ARROW == this.tokenSequence.token().id()) {
            this.printer.print(":");
            if (newT.stats.size() > 1) {
                this.printer.newline();
            } else {
                this.printer.out.needSpace();
            }
            this.tokenSequence.moveNext();
            PositionEstimator.moveToDifferentThan(this.tokenSequence, PositionEstimator.Direction.FORWARD, EnumSet.of(JavaTokenId.WHITESPACE));
            localPointer = this.tokenSequence.offset();
            reindentStatements = true;
        }
        PositionEstimator est = EstimatorFactory.statements(this.filterHidden(oldT.stats), this.filterHidden(newT.stats), this.diffContext);
        int old = this.printer.indent();
        SortedSet<int[]> oldReindentRegions = this.printer.reindentRegions;
        this.printer.reindentRegions = new TreeSet<int[]>(new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                return o1[0] - o2[0];
            }
        });
        int reindentStart = localPointer;
        localPointer = this.diffInnerComments(oldT, newT, localPointer);
        JCTree.JCClassDecl oldEnclosing = this.printer.enclClass;
        this.printer.enclClass = null;
        localPointer = this.diffList(this.filterHidden(oldT.stats), this.filterHidden(newT.stats), localPointer, est, Measure.MEMBER, this.printer);
        this.printer.enclClass = oldEnclosing;
        if (localPointer < this.endPos(oldT)) {
            int n = localPointer;
            localPointer = this.endPos(oldT);
            this.copyTo(n, localPointer);
        }
        if (reindentStatements) {
            this.printer.reindentRegions = oldReindentRegions;
            this.printer.reindentRegions.add(new int[]{reindentStart, localPointer});
        } else {
            oldReindentRegions.addAll(this.printer.reindentRegions);
            this.printer.reindentRegions = oldReindentRegions;
        }
        this.printer.undent(old);
        return localPointer;
    }

    protected int diffSynchronized(JCTree.JCSynchronized oldT, JCTree.JCSynchronized newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] lockBounds = this.getBounds(oldT.lock);
        this.copyTo(localPointer, lockBounds[0]);
        localPointer = this.diffTree(oldT.lock, (JCTree)newT.lock, lockBounds);
        int[] bodyBounds = this.getBounds(oldT.body);
        this.copyTo(localPointer, bodyBounds[0]);
        int oldIndent = newT.body.hasTag(JCTree.Tag.BLOCK) ? -1 : this.printer.indent();
        localPointer = this.diffTree(oldT.body, (JCTree)newT.body, bodyBounds);
        if (!newT.body.hasTag(JCTree.Tag.BLOCK)) {
            this.printer.undent(oldIndent);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTry(JCTree.JCTry oldT, JCTree.JCTry newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] bodyPos = this.getBounds(oldT.body);
        if (!this.listsMatch(oldT.resources, newT.resources)) {
            if (oldT.resources.nonEmpty() && newT.resources.isEmpty()) {
                this.tokenSequence.move(CasualDiff.getOldPos((JCTree)oldT.resources.head));
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                assert (this.tokenSequence.token().id() == JavaTokenId.LPAREN);
                this.copyTo(localPointer, this.tokenSequence.offset());
                localPointer = bodyPos[0];
            } else {
                JavaTokenId[] javaTokenIdArray;
                int pos;
                pos = oldT.resources.isEmpty() ? (pos = bodyPos[0]) : CasualDiff.getOldPos((JCTree)oldT.resources.head);
                this.copyTo(localPointer, pos);
                boolean parens = oldT.resources.isEmpty() || newT.resources.isEmpty();
                int oldPrec = this.printer.setPrec(0);
                if (newT.resources.nonEmpty()) {
                    List<JCTree> l = newT.resources;
                    Tree t = (Tree)l.head;
                    while (t != null) {
                        this.printer.oldTrees.remove(t);
                        l = l.tail;
                        t = (Tree)l.head;
                    }
                }
                List<JCTree> list = oldT.resources;
                List<JCTree> list2 = newT.resources;
                if (parens) {
                    JavaTokenId[] javaTokenIdArray2 = new JavaTokenId[2];
                    javaTokenIdArray2[0] = JavaTokenId.LPAREN;
                    javaTokenIdArray = javaTokenIdArray2;
                    javaTokenIdArray2[1] = JavaTokenId.RPAREN;
                } else {
                    javaTokenIdArray = null;
                }
                localPointer = this.diffParameterList(list, list2, null, javaTokenIdArray, pos, Measure.ARGUMENT, this.diffContext.style.spaceBeforeSemi(), this.diffContext.style.spaceAfterSemi(), ListType.RESOURCE, ";");
                this.printer.setPrec(oldPrec);
                if (parens && oldT.resources.isEmpty()) {
                    this.printer.print(" ");
                }
            }
        }
        this.copyTo(localPointer, bodyPos[0]);
        int n = localPointer = this.diffTree(oldT.body, (JCTree)newT.body, bodyPos);
        localPointer = bodyPos[1];
        this.copyTo(n, localPointer);
        PositionEstimator est = EstimatorFactory.catches(oldT.getCatches(), newT.getCatches(), oldT.finalizer != null, this.diffContext);
        localPointer = this.diffList(oldT.catchers, newT.catchers, localPointer, est, Measure.DEFAULT, this.printer);
        if (oldT.finalizer != null) {
            int[] finalBounds = this.getBounds(oldT.finalizer);
            if (newT.finalizer != null) {
                this.copyTo(localPointer, finalBounds[0]);
                localPointer = this.diffTree(oldT.finalizer, (JCTree)newT.finalizer, finalBounds);
            } else {
                int endetHier = oldT.catchers.isEmpty() ? Math.max(this.endPos(oldT.body), localPointer) : this.endPos(oldT.catchers);
                this.copyTo(localPointer, endetHier);
                localPointer = finalBounds[1];
            }
            this.copyTo(localPointer, bounds[1]);
        } else if (newT.finalizer != null) {
            int catchEnd = oldT.catchers.isEmpty() ? bounds[1] : this.endPos((JCTree)oldT.catchers.reverse().head);
            int n2 = localPointer;
            localPointer = catchEnd;
            this.copyTo(n2, localPointer);
            this.printer.printFinallyBlock(newT.finalizer);
            this.copyTo(localPointer, bounds[1]);
        } else {
            this.copyTo(localPointer, bounds[1]);
        }
        return bounds[1];
    }

    protected int diffCatch(JCTree.JCCatch oldT, JCTree.JCCatch newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] paramBounds = this.getBounds(oldT.param);
        this.copyTo(localPointer, paramBounds[0]);
        localPointer = this.diffTree(oldT.param, (JCTree)newT.param, paramBounds);
        int[] bodyBounds = this.getBounds(oldT.body);
        this.copyTo(localPointer, bodyBounds[0]);
        localPointer = this.diffTree(oldT.body, (JCTree)newT.body, bodyBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffConditional(JCTree.JCConditional oldT, JCTree.JCConditional newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] condBounds = this.getBounds(oldT.cond);
        this.copyTo(localPointer, condBounds[0]);
        localPointer = this.diffTree(oldT.cond, (JCTree)newT.cond, condBounds);
        int[] trueBounds = this.getBounds(oldT.truepart);
        this.copyTo(localPointer, trueBounds[0]);
        localPointer = this.diffTree(oldT.truepart, (JCTree)newT.truepart, trueBounds);
        int[] falseBounds = this.getBounds(oldT.falsepart);
        this.copyTo(localPointer, falseBounds[0]);
        localPointer = this.diffTree(oldT.falsepart, (JCTree)newT.falsepart, falseBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffIf(JCTree.JCIf oldT, JCTree.JCIf newT, int[] bounds) {
        int localPointer = bounds[0];
        int start = this.printer.toString().length();
        int[] condBounds = this.getCommentCorrectedBounds(oldT.cond);
        this.copyTo(localPointer, condBounds[0]);
        int n = localPointer = this.diffTree((JCTree)oldT.cond, (JCTree)newT.cond, null, condBounds);
        localPointer = condBounds[1];
        this.copyTo(n, localPointer);
        int[] partBounds = new int[]{localPointer, this.endPos(oldT.thenpart)};
        this.printer.conditionStartHack = start;
        localPointer = this.diffTree(oldT.thenpart, newT.thenpart, partBounds, oldT.getKind(), newT.elsepart == null);
        this.printer.conditionStartHack = -1;
        if (oldT.elsepart == null && newT.elsepart != null) {
            int n2 = localPointer;
            localPointer = partBounds[1];
            this.copyTo(n2, localPointer);
            this.printer.printElse(newT, newT.thenpart.getKind() == Tree.Kind.BLOCK);
        } else {
            if (oldT.elsepart != null && newT.elsepart == null) {
                this.copyTo(localPointer, partBounds[1]);
                this.copyTo(this.getBounds(oldT.elsepart)[1], bounds[1]);
                return bounds[1];
            }
            if (oldT.elsepart != null) {
                if (oldT.thenpart.getKind() != newT.thenpart.getKind() && newT.thenpart.getKind() == Tree.Kind.BLOCK) {
                    this.tokenSequence.move(localPointer);
                    PositionEstimator.moveToDifferentThan(this.tokenSequence, PositionEstimator.Direction.FORWARD, EnumSet.of(JavaTokenId.WHITESPACE));
                    if (localPointer != this.tokenSequence.offset() && this.diffContext.style.spaceBeforeElse()) {
                        this.printer.print(" ");
                    }
                    localPointer = this.tokenSequence.offset();
                }
                partBounds = new int[]{localPointer, this.endPos(oldT.elsepart)};
                localPointer = this.diffTree((JCTree)oldT.elsepart, (JCTree)newT.elsepart, partBounds, oldT.getKind());
                this.tokenSequence.move(localPointer);
                if (this.tokenSequence.movePrevious() && this.tokenSequence.token().id() == JavaTokenId.LINE_COMMENT) {
                    this.printer.newline();
                }
            }
        }
        if (localPointer < bounds[1]) {
            int n3 = localPointer;
            localPointer = bounds[1];
            this.copyTo(n3, localPointer);
        }
        return localPointer;
    }

    protected int diffExec(JCTree.JCExpressionStatement oldT, JCTree.JCExpressionStatement newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, (JCTree)newT.expr, exprBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffBreak(JCTree.JCBreak oldT, JCTree.JCBreak newT, int[] bounds) {
        Name oldTLabel = oldT.getLabel();
        Name newTlabel = newT.getLabel();
        return this.printBreakContinueTree(bounds, oldTLabel, newTlabel, oldT);
    }

    protected int diffContinue(JCTree.JCContinue oldT, JCTree.JCContinue newT, int[] bounds) {
        Name oldTLabel = oldT.label;
        Name newTlabel = newT.label;
        return this.printBreakContinueTree(bounds, oldTLabel, newTlabel, oldT);
    }

    protected int diffReturn(JCTree.JCReturn oldT, JCTree.JCReturn newT, int[] bounds) {
        int localPointer = bounds[0];
        if (oldT.expr != newT.expr) {
            if (oldT.expr == null) {
                this.tokenSequence.move(this.endPos(oldT));
                this.tokenSequence.movePrevious();
                int n = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n, localPointer);
                if (this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                    this.tokenSequence.movePrevious();
                }
                if (this.tokenSequence.token().id() != JavaTokenId.WHITESPACE) {
                    this.printer.print(" ");
                }
                this.printer.print(newT.expr);
            } else if (newT.expr == null) {
                int n = localPointer;
                localPointer = CasualDiff.getOldPos(oldT) + "return".length();
                this.copyTo(n, localPointer);
                localPointer = this.endPos(oldT.expr);
            } else {
                int[] exprBounds = this.getBounds(oldT.expr);
                this.copyTo(bounds[0], exprBounds[0]);
                localPointer = this.diffTree(oldT.expr, (JCTree)newT.expr, exprBounds);
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffThrow(JCTree.JCThrow oldT, JCTree.JCThrow newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, (JCTree)newT.expr, exprBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffAssert(JCTree.JCAssert oldT, JCTree.JCAssert newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] condBounds = this.getBounds(oldT.cond);
        this.copyTo(localPointer, condBounds[0]);
        localPointer = this.diffTree(oldT.cond, (JCTree)newT.cond, condBounds);
        if (oldT.detail != newT.detail) {
            if (oldT.detail == null) {
                this.copyTo(localPointer, condBounds[1]);
                localPointer = condBounds[1];
                this.printer.print(" : ");
                this.printer.print(newT.detail);
            } else {
                int[] detailBounds = this.getBounds(oldT.detail);
                if (newT.detail == null) {
                    this.copyTo(localPointer, condBounds[1]);
                    localPointer = detailBounds[1];
                } else {
                    this.copyTo(localPointer, detailBounds[0]);
                    localPointer = this.diffTree(oldT.detail, (JCTree)newT.detail, detailBounds);
                }
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffApply(JCTree.JCMethodInvocation oldT, JCTree.JCMethodInvocation newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] methBounds = this.getBounds(oldT.meth);
        if (Tree.Kind.MEMBER_SELECT == oldT.meth.getKind() && oldT.meth.getKind() == newT.meth.getKind()) {
            localPointer = this.diffSelect((JCTree.JCFieldAccess)oldT.meth, (JCTree.JCFieldAccess)newT.meth, methBounds, oldT.typeargs, newT.typeargs);
        } else if (oldT.typeargs.isEmpty() && newT.typeargs.isEmpty()) {
            localPointer = this.diffTree(oldT.meth, (JCTree)newT.meth, methBounds);
        } else {
            this.copyTo(localPointer, methBounds[0]);
            this.printer.printMethodSelect(newT);
            localPointer = methBounds[1];
        }
        if (!this.listsMatch(oldT.args, newT.args)) {
            if (oldT.args.nonEmpty()) {
                int startArg1 = this.getCommentCorrectedOldPos((JCTree)oldT.args.head);
                this.tokenSequence.move(startArg1);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                int n = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n, localPointer);
            } else {
                int n = localPointer;
                localPointer = methBounds[1];
                this.copyTo(n, localPointer);
                this.tokenSequence.move(localPointer);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                this.tokenSequence.moveNext();
                int n2 = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n2, localPointer);
            }
            localPointer = this.diffParameterList(oldT.args, newT.args, null, localPointer, Measure.ARGUMENT);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffNewClass(JCTree.JCNewClass oldT, JCTree.JCNewClass newT, int[] bounds) {
        java.util.List<JCTree> oldTFilteredArgs;
        int localPointer = bounds[0];
        if (oldT.encl != null) {
            int[] enclBounds = this.getBounds(oldT.encl);
            if (newT.encl == null) {
                PositionEstimator.moveFwdToToken(this.tokenSequence, enclBounds[1], JavaTokenId.DOT);
                this.tokenSequence.moveNext();
                localPointer = this.tokenSequence.offset();
            } else {
                localPointer = this.diffTree(oldT.encl, (JCTree)newT.encl, enclBounds);
            }
        }
        this.diffParameterList(oldT.typeargs, newT.typeargs, null, localPointer, Measure.ARGUMENT);
        if (!this.enumConstantPrint) {
            int[] clazzBounds = this.getBounds(oldT.clazz);
            this.copyTo(localPointer, clazzBounds[0]);
            localPointer = this.diffTree(oldT.clazz, (JCTree)newT.clazz, clazzBounds);
        }
        if (!(oldTFilteredArgs = this.filterHidden(oldT.args)).isEmpty()) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldTFilteredArgs.get(0));
            this.copyTo(n, localPointer);
        } else if (!this.enumConstantPrint) {
            PositionEstimator.moveFwdToToken(this.tokenSequence, oldT.pos, JavaTokenId.LPAREN);
            this.tokenSequence.moveNext();
            int n = localPointer;
            localPointer = this.tokenSequence.offset();
            this.copyTo(n, localPointer);
        }
        localPointer = this.diffParameterList(oldTFilteredArgs, newT.args, null, localPointer, Measure.ARGUMENT);
        if (oldT.def != newT.def) {
            if (oldT.def != null && newT.def != null) {
                int[] defBounds = this.getBounds(oldT.def);
                if (this.enumConstantPrint) {
                    if (!oldTFilteredArgs.isEmpty()) {
                        defBounds[0] = this.endPos(oldTFilteredArgs);
                    }
                    if (defBounds[0] != -1) {
                        PositionEstimator.moveFwdToToken(this.tokenSequence, defBounds[0], JavaTokenId.LBRACE);
                        defBounds[0] = this.tokenSequence.offset();
                    }
                }
                this.copyTo(localPointer, defBounds[0]);
                this.anonClass = true;
                localPointer = this.diffTree(oldT.def, (JCTree)newT.def, defBounds);
                this.anonClass = false;
            } else if (newT.def == null) {
                if (this.endPos(oldTFilteredArgs) > localPointer) {
                    this.copyTo(localPointer, this.endPos(oldTFilteredArgs));
                }
                this.printer.print(")");
                localPointer = this.endPos(oldT.def);
            } else {
                int n = localPointer;
                localPointer = this.endPos(oldT);
                this.copyTo(n, localPointer);
                this.printer.printNewClassBody(newT);
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffNewArray(JCTree.JCNewArray oldT, JCTree.JCNewArray newT, int[] bounds) {
        int localPointer = bounds[0];
        if (newT.elemtype != null) {
            if (oldT.elemtype != null) {
                int[] elemtypeBounds = this.getBounds(oldT.elemtype);
                this.copyTo(localPointer, elemtypeBounds[0]);
                localPointer = this.diffTree(oldT.elemtype, (JCTree)newT.elemtype, elemtypeBounds);
            }
            if (!this.listsMatch(oldT.dims, newT.dims) && !newT.dims.isEmpty()) {
                List<JCTree.JCExpression> l1 = oldT.dims;
                List<JCTree.JCExpression> l2 = newT.dims;
                while (l1.nonEmpty()) {
                    int[] span = this.getBounds((JCTree)l1.head);
                    this.copyTo(localPointer, span[0]);
                    localPointer = this.diffTree((JCTree)l1.head, (JCTree)l2.head, span);
                    l1 = l1.tail;
                    l2 = l2.tail;
                }
            }
        } else if (oldT.elemtype != null) {
            this.copyTo(localPointer, CasualDiff.getOldPos(oldT));
            if (oldT.elems != null) {
                localPointer = oldT.dims != null && !oldT.dims.isEmpty() ? this.endPos(oldT.dims) : this.endPos(oldT.elemtype);
                PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.LBRACE);
                localPointer = this.tokenSequence.offset();
            } else {
                localPointer = this.endPos(oldT);
            }
        }
        if (oldT.elems != null) {
            if (oldT.elems.head != null) {
                this.copyTo(localPointer, CasualDiff.getOldPos((JCTree)oldT.elems.head));
                localPointer = this.diffParameterList(oldT.elems, newT.elems, null, CasualDiff.getOldPos((JCTree)oldT.elems.head), Measure.ARGUMENT);
            } else if (newT.elems != null && !newT.elems.isEmpty()) {
                PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.LBRACE);
                this.tokenSequence.moveNext();
                int n = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n, localPointer);
                localPointer = this.diffParameterList(oldT.elems, newT.elems, null, localPointer, Measure.ARGUMENT);
            }
        } else if (newT.elems != null && !newT.elems.isEmpty()) {
            if (newT.elemtype != null) {
                this.printer.print("[]");
            }
            this.printer.print("{");
            localPointer = this.diffParameterList(Collections.emptyList(), newT.elems, null, localPointer, Measure.ARGUMENT);
            this.printer.print("}");
            PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.SEMICOLON);
            this.tokenSequence.moveNext();
            localPointer = bounds[1];
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffParens(JCTree.JCParens oldT, JCTree.JCParens newT, int[] bounds) {
        int localPointer = bounds[0];
        this.copyTo(localPointer, this.getCommentCorrectedOldPos(oldT.expr));
        localPointer = this.diffTree(oldT.expr, (JCTree)newT.expr, this.getBounds(oldT.expr));
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffAssign(JCTree.JCAssign oldT, JCTree.JCAssign newT, JCTree parent, int[] bounds) {
        int localPointer = bounds[0];
        int[] lhsBounds = this.getBounds(oldT.lhs);
        if (lhsBounds[0] < 0) {
            lhsBounds[0] = CasualDiff.getOldPos(oldT.rhs);
            lhsBounds[1] = -1;
        }
        this.copyTo(localPointer, lhsBounds[0]);
        localPointer = this.diffTree(oldT.lhs, (JCTree)newT.lhs, lhsBounds);
        int[] rhsBounds = this.getCommentCorrectedBounds(oldT.rhs);
        if (oldT.lhs.getKind() == Tree.Kind.IDENTIFIER && newT.lhs.getKind() == Tree.Kind.IDENTIFIER && !((JCTree.JCIdent)oldT.lhs).name.equals(((JCTree.JCIdent)newT.lhs).name)) {
            this.tokenSequence.move(rhsBounds[0]);
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
            if (this.tokenSequence.token().id() != JavaTokenId.EQ) {
                boolean spaceAroundAssignOps;
                boolean bl = spaceAroundAssignOps = parent.getKind() == Tree.Kind.ANNOTATION || parent.getKind() == Tree.Kind.TYPE_ANNOTATION ? this.diffContext.style.spaceAroundAnnotationValueAssignOps() : this.diffContext.style.spaceAroundAssignOps();
                if (spaceAroundAssignOps) {
                    this.printer.print(" = ");
                } else {
                    this.printer.print("=");
                }
                localPointer = lhsBounds[0];
            }
        }
        this.copyTo(localPointer, rhsBounds[0]);
        localPointer = this.diffTree(oldT.rhs, (JCTree)newT.rhs, rhsBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffAssignop(JCTree.JCAssignOp oldT, JCTree.JCAssignOp newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] lhsBounds = this.getBounds(oldT.lhs);
        this.copyTo(localPointer, lhsBounds[0]);
        localPointer = this.diffTree(oldT.lhs, (JCTree)newT.lhs, lhsBounds);
        if (oldT.getTag() != newT.getTag()) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(this.getAssignementOperator(newT));
            localPointer = oldT.pos + this.getAssignementOperator(oldT).length();
        }
        int[] rhsBounds = this.getBounds(oldT.rhs);
        this.copyTo(localPointer, rhsBounds[0]);
        localPointer = this.diffTree(oldT.rhs, (JCTree)newT.rhs, rhsBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    String getAssignementOperator(Tree t) {
        switch (t.getKind()) {
            case MULTIPLY_ASSIGNMENT: {
                return "*=";
            }
            case DIVIDE_ASSIGNMENT: {
                return "/=";
            }
            case REMAINDER_ASSIGNMENT: {
                return "%=";
            }
            case PLUS_ASSIGNMENT: {
                return "+=";
            }
            case MINUS_ASSIGNMENT: {
                return "-=";
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return "<<=";
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return ">>=";
            }
            case AND_ASSIGNMENT: {
                return "&=";
            }
            case XOR_ASSIGNMENT: {
                return "^=";
            }
            case OR_ASSIGNMENT: {
                return "|=";
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return ">>>=";
            }
        }
        throw new IllegalArgumentException("Illegal kind " + (Object)((Object)t.getKind()));
    }

    protected int diffUnary(JCTree.JCUnary oldT, JCTree.JCUnary newT, int[] bounds) {
        boolean newOpOnLeft;
        int[] argBounds = this.getBounds(oldT.arg);
        boolean bl = newOpOnLeft = newT.getKind() != Tree.Kind.POSTFIX_DECREMENT && newT.getKind() != Tree.Kind.POSTFIX_INCREMENT;
        if (newOpOnLeft) {
            if (oldT.getTag() != newT.getTag()) {
                this.printer.print(this.operatorName(newT.getTag()));
            } else {
                this.copyTo(bounds[0], argBounds[0]);
            }
        }
        int localPointer = this.diffTree(oldT.arg, (JCTree)newT.arg, argBounds);
        localPointer = this.copyUpTo(localPointer, argBounds[1]);
        if (!newOpOnLeft) {
            if (oldT.getTag() != newT.getTag()) {
                this.printer.print(this.operatorName(newT.getTag()));
            } else {
                this.copyUpTo(localPointer, bounds[1]);
            }
        }
        return bounds[1];
    }

    protected int diffBinary(JCTree.JCBinary oldT, JCTree.JCBinary newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] lhsBounds = this.getBounds(oldT.lhs);
        this.copyTo(localPointer, lhsBounds[0]);
        localPointer = this.diffTree(oldT.lhs, (JCTree)newT.lhs, lhsBounds);
        if (oldT.getTag() != newT.getTag()) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(this.operatorName(newT.getTag()));
            localPointer = oldT.pos + this.operatorName(oldT.getTag()).length();
        }
        int[] rhsBounds = this.getCommentCorrectedBounds(oldT.rhs);
        rhsBounds[0] = this.copyUpTo(localPointer, rhsBounds[0]);
        localPointer = this.diffTree(oldT.rhs, (JCTree)newT.rhs, rhsBounds);
        return this.copyUpTo(localPointer, bounds[1]);
    }

    private String operatorName(JCTree.Tag tag) {
        return new Pretty(null, false).operatorName(tag);
    }

    protected int diffTypeCast(JCTree.JCTypeCast oldT, JCTree.JCTypeCast newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] clazzBounds = this.getBounds(oldT.clazz);
        this.copyTo(localPointer, clazzBounds[0]);
        localPointer = this.diffTree(oldT.clazz, newT.clazz, clazzBounds);
        int[] exprBounds = this.getBounds(oldT.expr);
        exprBounds[0] = this.copyUpTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, (JCTree)newT.expr, exprBounds);
        localPointer = this.copyUpTo(localPointer, bounds[1]);
        return localPointer;
    }

    protected int diffTypeTest(JCTree.JCInstanceOf oldT, JCTree.JCInstanceOf newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, (JCTree)newT.expr, exprBounds);
        JCTree oldPattern = CasualDiff.getPattern(oldT);
        JCTree newPattern = CasualDiff.getPattern(newT);
        int[] clazzBounds = this.getBounds(oldPattern);
        clazzBounds[0] = this.copyUpTo(localPointer, clazzBounds[0]);
        localPointer = this.diffTree(oldPattern, newPattern, clazzBounds);
        localPointer = this.copyUpTo(localPointer, bounds[1]);
        return localPointer;
    }

    public static JCTree getPattern(JCTree.JCInstanceOf tree) {
        try {
            Field clazzField = JCTree.JCInstanceOf.class.getField("clazz");
            return (JCTree)clazzField.get(tree);
        }
        catch (Throwable t) {
            try {
                Field patternField = JCTree.JCInstanceOf.class.getField("pattern");
                return (JCTree)patternField.get(tree);
            }
            catch (Throwable t2) {
                return tree.getType();
            }
        }
    }

    protected int diffIndexed(JCTree.JCArrayAccess oldT, JCTree.JCArrayAccess newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] indexedBounds = this.getBounds(oldT.indexed);
        this.copyTo(localPointer, indexedBounds[0]);
        localPointer = this.diffTree(oldT.indexed, (JCTree)newT.indexed, indexedBounds);
        int[] indexBounds = this.getBounds(oldT.index);
        indexBounds[0] = this.copyUpTo(localPointer, indexBounds[0]);
        localPointer = this.diffTree(oldT.index, (JCTree)newT.index, indexBounds);
        localPointer = this.copyUpTo(localPointer, bounds[1]);
        return localPointer;
    }

    protected int diffSelect(JCTree.JCFieldAccess oldT, JCTree.JCFieldAccess newT, int[] bounds, List<JCTree.JCExpression> oldTypePar, List<JCTree.JCExpression> newTypePar) {
        int localPointer = bounds[0];
        int[] selectedBounds = this.getBounds(oldT.selected);
        this.copyTo(localPointer, selectedBounds[0]);
        localPointer = this.diffTree(oldT.selected, (JCTree)newT.selected, selectedBounds);
        if (oldTypePar != null && newTypePar != null) {
            JavaTokenId[] javaTokenIdArray;
            boolean parens;
            int insertHint;
            if (oldTypePar.nonEmpty() && newTypePar.nonEmpty()) {
                insertHint = ((JCTree.JCExpression)oldTypePar.head).pos;
            } else {
                this.tokenSequence.move(selectedBounds[1]);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                this.tokenSequence.moveNext();
                insertHint = this.tokenSequence.offset();
            }
            int n = localPointer;
            localPointer = insertHint;
            this.copyTo(n, localPointer);
            boolean bl = parens = oldTypePar.isEmpty() && newTypePar.nonEmpty();
            if (parens) {
                JavaTokenId[] javaTokenIdArray2 = new JavaTokenId[2];
                javaTokenIdArray2[0] = JavaTokenId.LT;
                javaTokenIdArray = javaTokenIdArray2;
                javaTokenIdArray2[1] = JavaTokenId.GT;
            } else {
                javaTokenIdArray = null;
            }
            localPointer = this.diffParameterList(oldTypePar, newTypePar, javaTokenIdArray, localPointer, Measure.ARGUMENT);
            if (oldTypePar.nonEmpty()) {
                this.tokenSequence.move(this.endPos(oldTypePar.last()));
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                int end = this.tokenSequence.offset();
                if (newTypePar.nonEmpty()) {
                    this.copyTo(localPointer, end);
                }
                localPointer = end;
            }
        } else {
            this.tokenSequence.move(selectedBounds[1]);
            if (oldT.name != Names.instance((Context)this.context).error) {
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                int n = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n, localPointer);
            }
        }
        if (this.nameChanged(oldT.name, newT.name)) {
            int[] nameSpan = this.treeUtilities.findNameSpan(oldT);
            this.printer.print(newT.name);
            this.diffInfo.put(localPointer, NbBundle.getMessage(CasualDiff.class, (String)"TXT_UpdateReferenceTo", (Object)oldT.name));
            localPointer = nameSpan != null ? nameSpan[1] : (localPointer += oldT.name.length());
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffMemberReference(JCTree.JCMemberReference oldT, JCTree.JCMemberReference newT, int[] bounds) {
        List<Object> newTypePar;
        int localPointer = bounds[0];
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, (JCTree)newT.expr, exprBounds);
        this.tokenSequence.move(exprBounds[1]);
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
        if (this.tokenSequence.token() != null && this.tokenSequence.token().id() == JavaTokenId.COLONCOLON) {
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
            int n = localPointer;
            localPointer = this.tokenSequence.offset();
            this.copyTo(n, localPointer);
        }
        List<Object> oldTypePar = oldT.typeargs != null ? oldT.typeargs : List.nil();
        List<Object> list = newTypePar = newT.typeargs != null ? newT.typeargs : List.nil();
        if (!this.listsMatch(oldTypePar, newTypePar)) {
            JavaTokenId[] javaTokenIdArray;
            boolean parens;
            int insertHint = oldTypePar.nonEmpty() && newTypePar.nonEmpty() ? ((JCTree.JCExpression)oldTypePar.head).pos : localPointer;
            int n = localPointer;
            localPointer = insertHint;
            this.copyTo(n, localPointer);
            boolean bl = parens = oldTypePar.isEmpty() && newTypePar.nonEmpty();
            if (parens) {
                JavaTokenId[] javaTokenIdArray2 = new JavaTokenId[2];
                javaTokenIdArray2[0] = JavaTokenId.LT;
                javaTokenIdArray = javaTokenIdArray2;
                javaTokenIdArray2[1] = JavaTokenId.GT;
            } else {
                javaTokenIdArray = null;
            }
            localPointer = this.diffParameterList(oldTypePar, newTypePar, javaTokenIdArray, localPointer, Measure.ARGUMENT);
            if (oldTypePar.nonEmpty()) {
                this.tokenSequence.move(this.endPos((JCTree)oldTypePar.last()));
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                int end = this.tokenSequence.offset();
                if (newTypePar.nonEmpty()) {
                    this.copyTo(localPointer, end);
                }
                localPointer = end;
            }
        }
        if (this.nameChanged(oldT.name, newT.name)) {
            this.printer.print(newT.name);
            this.diffInfo.put(localPointer, NbBundle.getMessage(CasualDiff.class, (String)"TXT_UpdateReferenceTo", (Object)oldT.name));
            localPointer += oldT.name.length();
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffSelect(JCTree.JCFieldAccess oldT, JCTree.JCFieldAccess newT, int[] bounds) {
        return this.diffSelect(oldT, newT, bounds, null, null);
    }

    protected int diffIdent(JCTree.JCIdent oldT, JCTree.JCIdent newT, int[] bounds) {
        if (this.nameChanged(oldT.name, newT.name)) {
            this.copyTo(bounds[0], oldT.pos);
            this.printer.print(newT.name);
            this.diffInfo.put(oldT.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_UpdateReferenceTo", (Object)oldT.name));
        } else {
            this.copyTo(bounds[0], bounds[1]);
        }
        return bounds[1];
    }

    protected int diffLiteral(JCTree.JCLiteral oldT, JCTree.JCLiteral newT, int[] bounds) {
        if (oldT.typetag != newT.typetag || oldT.value != null && !oldT.value.equals(newT.value) || this.possibleTextBlock(oldT, newT)) {
            int localPointer = bounds[0];
            int[] literalBounds = this.getBounds(oldT);
            this.copyTo(localPointer, literalBounds[0]);
            this.printer.print(newT);
            this.copyTo(literalBounds[1], bounds[1]);
        } else {
            this.copyTo(bounds[0], bounds[1]);
        }
        return bounds[1];
    }

    protected int diffTypeIdent(JCTree.JCPrimitiveTypeTree oldT, JCTree.JCPrimitiveTypeTree newT, int[] bounds) {
        if (oldT.typetag != newT.typetag) {
            this.printer.print(newT);
        } else {
            this.copyTo(bounds[0], bounds[1]);
        }
        return bounds[1];
    }

    protected int diffTypeArray(JCTree.JCArrayTypeTree oldT, JCTree.JCArrayTypeTree newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] elemtypeBounds = this.getBounds(oldT.elemtype);
        localPointer = this.diffTree(oldT.elemtype, (JCTree)newT.elemtype, elemtypeBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTypeApply(JCTree.JCTypeApply oldT, JCTree.JCTypeApply newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] clazzBounds = this.getBounds(oldT.clazz);
        this.copyTo(localPointer, clazzBounds[0]);
        localPointer = this.diffTree(oldT.clazz, (JCTree)newT.clazz, clazzBounds);
        if (!this.listsMatch(oldT.arguments, newT.arguments)) {
            JavaTokenId[] javaTokenIdArray;
            int pos = oldT.arguments.nonEmpty() ? CasualDiff.getOldPos((JCTree)oldT.arguments.head) : this.endPos(oldT.clazz);
            this.copyTo(localPointer, pos);
            boolean printBrace = false;
            List<JCTree.JCExpression> list = oldT.arguments;
            List<JCTree.JCExpression> list2 = newT.arguments;
            if (printBrace) {
                JavaTokenId[] javaTokenIdArray2 = new JavaTokenId[2];
                javaTokenIdArray2[0] = JavaTokenId.LT;
                javaTokenIdArray = javaTokenIdArray2;
                javaTokenIdArray2[1] = JavaTokenId.GT;
            } else {
                javaTokenIdArray = null;
            }
            localPointer = this.diffParameterList(list, list2, javaTokenIdArray, pos, Measure.ARGUMENT);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffAnnotatedType(JCTree.JCAnnotatedType oldT, JCTree.JCAnnotatedType newT, int[] bounds) {
        int localPointer = bounds[0];
        if (!this.listsMatch(oldT.annotations, newT.annotations)) {
            int pos = oldT.annotations.nonEmpty() ? CasualDiff.getOldPos((JCTree)oldT.annotations.head) : bounds[0];
            this.copyTo(localPointer, pos);
            localPointer = this.diffParameterList(oldT.annotations, newT.annotations, null, null, pos, Measure.ARGUMENT, true, false, ListType.NORMAL, "");
        }
        int[] underlyingBounds = this.getBounds(oldT.underlyingType);
        this.copyTo(localPointer, underlyingBounds[0]);
        localPointer = this.diffTree(oldT.underlyingType, (JCTree)newT.underlyingType, underlyingBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTypeParameter(JCTree.JCTypeParameter oldT, JCTree.JCTypeParameter newT, int[] bounds) {
        int localPointer = bounds[0];
        this.copyTo(localPointer, CasualDiff.getOldPos(oldT));
        if (this.nameChanged(oldT.name, newT.name)) {
            this.printer.print(newT.name);
            localPointer += oldT.name.length();
        }
        if (!this.listsMatch(oldT.bounds, newT.bounds)) {
            int pos;
            PositionEstimator est = EstimatorFactory.implementz(oldT.getBounds(), newT.getBounds(), this.diffContext);
            int n = pos = oldT.bounds.nonEmpty() ? CasualDiff.getOldPos((JCTree)oldT.bounds.head) : -1;
            if (pos > -1) {
                this.copyTo(localPointer, pos);
                localPointer = this.diffList2(oldT.bounds, newT.bounds, pos, est);
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffWildcard(JCTree.JCWildcard oldT, JCTree.JCWildcard newT, int[] bounds) {
        JCTree newBound;
        int localPointer = bounds[0];
        if (oldT.kind != newT.kind) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(newT.kind.toString());
            localPointer = oldT.pos + oldT.kind.toString().length();
        }
        JCTree oldBound = oldT.kind.kind != BoundKind.UNBOUND ? oldT.inner : null;
        JCTree jCTree = newBound = newT.kind.kind != BoundKind.UNBOUND ? newT.inner : null;
        if (oldBound == newBound && oldBound == null) {
            return localPointer;
        }
        int[] innerBounds = this.getBounds(oldBound);
        this.copyTo(localPointer, innerBounds[0]);
        localPointer = this.diffTree(oldBound, newBound, innerBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTypeBoundKind(JCTree.TypeBoundKind oldT, JCTree.TypeBoundKind newT, int[] bounds) {
        int localPointer = bounds[0];
        if (oldT.kind != newT.kind) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(newT.kind.toString());
            localPointer = oldT.pos + oldT.kind.toString().length();
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffAnnotation(JCTree.JCAnnotation oldT, JCTree.JCAnnotation newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] annotationBounds = this.getBounds(oldT.annotationType);
        this.copyTo(localPointer, annotationBounds[0]);
        localPointer = this.diffTree(oldT.annotationType, newT.annotationType, annotationBounds);
        JavaTokenId[] parens = null;
        if (oldT.args.nonEmpty()) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos((JCTree)oldT.args.head);
            this.copyTo(n, localPointer);
        } else {
            int endPos = this.endPos(oldT);
            this.tokenSequence.move(endPos);
            this.tokenSequence.movePrevious();
            if (JavaTokenId.RPAREN != this.tokenSequence.token().id()) {
                parens = new JavaTokenId[]{JavaTokenId.LPAREN, JavaTokenId.RPAREN};
            } else {
                --endPos;
            }
            int n = localPointer;
            localPointer = endPos;
            this.copyTo(n, localPointer);
        }
        localPointer = this.diffParameterList(oldT.args, newT.args, oldT, parens, localPointer, Measure.ARGUMENT);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffModifiers(JCTree.JCModifiers oldT, JCTree.JCModifiers newT, JCTree parent, int localPointer) {
        if (oldT == newT) {
            return localPointer;
        }
        int startPos = oldT.pos != -1 ? CasualDiff.getOldPos(oldT) : CasualDiff.getOldPos(parent);
        int firstAnnotationPos = !((List)oldT.getAnnotations()).isEmpty() ? CasualDiff.getOldPos((JCTree)((List)oldT.getAnnotations()).head) : -1;
        int endOffset = this.endPos(oldT);
        if (startPos < firstAnnotationPos && oldT.flags != newT.flags) {
            this.copyTo(localPointer, startPos);
            this.printer.printFlags(newT.flags & 0xFFFFFFFFFFFFFDFFL, oldT.getFlags().isEmpty());
            this.tokenSequence.move(firstAnnotationPos);
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
            this.tokenSequence.moveNext();
            localPointer = this.tokenSequence.offset();
        }
        localPointer = this.diffAnnotationsLists((List<JCTree.JCAnnotation>)oldT.getAnnotations(), (List<JCTree.JCAnnotation>)newT.getAnnotations(), startPos, localPointer);
        if ((oldT.flags & 0x2000L) != 0L) {
            this.tokenSequence.move(endOffset);
            this.tokenSequence.movePrevious();
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
            this.tokenSequence.moveNext();
            endOffset = this.tokenSequence.offset();
        }
        if (oldT.flags != newT.flags && startPos >= firstAnnotationPos) {
            if (localPointer == startPos) {
                if ((newT.flags & 0xFFFFFFFFFFFFFDFFL) != 0L) {
                    this.printer.printFlags(newT.flags & 0xFFFFFFFFFFFFFDFFL, oldT.getFlags().isEmpty());
                    localPointer = endOffset > 0 ? endOffset : localPointer;
                } else if (endOffset > 0) {
                    this.tokenSequence.move(endOffset);
                    while (this.tokenSequence.moveNext() && JavaTokenId.WHITESPACE == this.tokenSequence.token().id()) {
                    }
                    localPointer = this.tokenSequence.offset();
                }
            } else {
                this.tokenSequence.move(localPointer);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                int n = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n, localPointer);
                localPointer = this.tokenSequence.offset();
                if (!oldT.getFlags().isEmpty()) {
                    localPointer = endOffset;
                }
                this.printer.printFlags(newT.flags, oldT.getFlags().isEmpty());
            }
        } else if (endOffset > localPointer) {
            if (localPointer == startPos) {
                this.printer.toLeftMargin();
            }
            int n = localPointer;
            localPointer = endOffset;
            this.copyTo(n, localPointer);
        }
        return localPointer;
    }

    private int diffAnnotationsLists(List<JCTree.JCAnnotation> oldAnnotations, List<JCTree.JCAnnotation> newAnnotations, int startPos, int localPointer) {
        int annotationsEnd;
        int n = annotationsEnd = oldAnnotations.nonEmpty() ? this.endPos(oldAnnotations) : localPointer;
        if (this.listsMatch(oldAnnotations, newAnnotations)) {
            int n2 = localPointer;
            localPointer = annotationsEnd != localPointer ? annotationsEnd : startPos;
            this.copyTo(n2, localPointer);
        } else {
            this.tokenSequence.move(startPos);
            if (this.tokenSequence.movePrevious() && JavaTokenId.WHITESPACE == this.tokenSequence.token().id()) {
                String text = this.tokenSequence.token().text().toString();
                int index = text.lastIndexOf(10);
                startPos = this.tokenSequence.offset();
                if (index > -1) {
                    startPos += index + 1;
                }
                if (startPos < localPointer) {
                    startPos = localPointer;
                }
            }
            this.copyTo(localPointer, startPos);
            PositionEstimator est = EstimatorFactory.annotations(oldAnnotations, newAnnotations, this.diffContext, this.parameterPrint);
            localPointer = this.diffList(oldAnnotations, newAnnotations, startPos, est, Measure.ARGUMENT, this.printer);
        }
        return localPointer;
    }

    protected void diffLetExpr(JCTree.LetExpr oldT, JCTree.LetExpr newT) {
    }

    protected int diffErroneous(JCTree.JCErroneous oldT, JCTree.JCErroneous newT, int[] bounds) {
        JCTree oldTerr = (JCTree)((List)oldT.getErrorTrees()).get(0);
        JCTree newTerr = (JCTree)((List)newT.getErrorTrees()).get(0);
        int localPointer = bounds[0];
        int[] errBounds = this.getBounds(oldTerr);
        this.copyTo(localPointer, errBounds[0]);
        localPointer = this.diffTree(oldTerr, newTerr, errBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffLambda(JCTree.JCLambda oldT, JCTree.JCLambda newT, int[] bounds) {
        JavaTokenId id;
        int posHint;
        int localPointer = bounds[0];
        if (oldT.params.isEmpty()) {
            int startOffset = oldT.pos;
            PositionEstimator.moveFwdToToken(this.tokenSequence, startOffset, JavaTokenId.RPAREN);
            posHint = this.tokenSequence.offset();
        } else {
            posHint = oldT.params.iterator().next().getStartPosition();
        }
        if (!this.listsMatch(oldT.params, newT.params)) {
            JavaTokenId id2;
            this.copyTo(localPointer, posHint);
            int old = this.printer.setPrec(0);
            this.parameterPrint = true;
            JCTree.JCClassDecl oldEnclClass = this.printer.enclClass;
            this.printer.enclClass = null;
            this.suppressParameterTypes = newT.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT;
            JavaTokenId[] parens = null;
            if (newT.params.size() > 1 && (id2 = PositionEstimator.moveFwdToOneOfTokens(this.tokenSequence, oldT.params.isEmpty() ? posHint : this.endPos(oldT.params.last()), LAMBDA_PARAM_END_TOKENS)) != JavaTokenId.RPAREN) {
                parens = new JavaTokenId[]{JavaTokenId.LPAREN, JavaTokenId.RPAREN};
            }
            localPointer = this.diffParameterList(oldT.params, newT.params, parens, posHint, Measure.MEMBER);
            this.suppressParameterTypes = false;
            this.printer.enclClass = oldEnclClass;
            this.parameterPrint = false;
            this.printer.setPrec(old);
        }
        if ((id = PositionEstimator.moveFwdToOneOfTokens(this.tokenSequence, oldT.params.isEmpty() ? posHint : this.endPos(oldT.params.last()), LAMBDA_PARAM_END_TOKENS)) == JavaTokenId.RPAREN) {
            this.tokenSequence.moveNext();
        }
        if (localPointer < (posHint = this.tokenSequence.offset())) {
            int n = localPointer;
            localPointer = posHint;
            this.copyTo(n, localPointer);
        }
        if (oldT.body != null && newT.body != null) {
            int[] bodyBounds = this.getCommentCorrectedBounds(oldT.body);
            this.copyTo(localPointer, bodyBounds[0]);
            localPointer = this.diffTree(oldT.body, newT.body, bodyBounds);
        }
        localPointer = this.copyUpTo(localPointer, bounds[1]);
        return localPointer;
    }

    protected int diffFieldGroup(FieldGroupTree oldT, FieldGroupTree newT, int[] bounds) {
        if (!this.listsMatch(oldT.getVariables(), newT.getVariables())) {
            int localpointer = this.getCommentCorrectedOldPos(oldT.getVariables().get(0));
            if (bounds[0] < localpointer) {
                this.copyTo(bounds[0], localpointer);
            } else {
                localpointer = bounds[0];
            }
            if (oldT.isEnum()) {
                int pos = this.diffParameterList(oldT.getVariables(), newT.getVariables(), oldT, null, localpointer, Measure.ARGUMENT, this.diffContext.style.spaceBeforeComma(), this.diffContext.style.spaceAfterComma(), ListType.ENUM, ",");
                this.copyTo(pos, bounds[1]);
                return bounds[1];
            }
            int pos = this.diffVarGroup(oldT.getVariables(), newT.getVariables(), null, localpointer, Measure.GROUP_VAR_MEASURE);
            this.copyTo(pos, bounds[1]);
            return bounds[1];
        }
        this.tokenSequence.move(oldT.endPos());
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
        this.tokenSequence.moveNext();
        return this.tokenSequence.offset();
    }

    protected boolean listContains(java.util.List<? extends JCTree> list, JCTree tree) {
        for (JCTree jCTree : list) {
            if (!this.treesMatch(jCTree, tree)) continue;
            return true;
        }
        return false;
    }

    protected boolean treesMatch(JCTree t1, JCTree t2) {
        return this.treesMatch(t1, t2, true);
    }

    public boolean treesMatch(JCTree t1, JCTree t2, boolean deepMatch) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        if (t1.getTag() != t2.getTag()) {
            return false;
        }
        if (!deepMatch) {
            return true;
        }
        switch (t1.getTag()) {
            case TOPLEVEL: {
                return ((JCTree.JCCompilationUnit)t1).sourcefile.equals(((JCTree.JCCompilationUnit)t2).sourcefile);
            }
            case IMPORT: {
                return this.matchImport((JCTree.JCImport)t1, (JCTree.JCImport)t2);
            }
            case CLASSDEF: {
                return ((JCTree.JCClassDecl)t1).sym == ((JCTree.JCClassDecl)t2).sym;
            }
            case METHODDEF: {
                return ((JCTree.JCMethodDecl)t1).sym == ((JCTree.JCMethodDecl)t2).sym;
            }
            case VARDEF: {
                return ((JCTree.JCVariableDecl)t1).sym == ((JCTree.JCVariableDecl)t2).sym;
            }
            case SKIP: {
                return true;
            }
            case BLOCK: {
                return this.matchBlock((JCTree.JCBlock)t1, (JCTree.JCBlock)t2);
            }
            case DOLOOP: {
                return this.matchDoLoop((JCTree.JCDoWhileLoop)t1, (JCTree.JCDoWhileLoop)t2);
            }
            case WHILELOOP: {
                return this.matchWhileLoop((JCTree.JCWhileLoop)t1, (JCTree.JCWhileLoop)t2);
            }
            case FORLOOP: {
                return this.matchForLoop((JCTree.JCForLoop)t1, (JCTree.JCForLoop)t2);
            }
            case FOREACHLOOP: {
                return this.matchForeachLoop((JCTree.JCEnhancedForLoop)t1, (JCTree.JCEnhancedForLoop)t2);
            }
            case LABELLED: {
                return this.matchLabelled((JCTree.JCLabeledStatement)t1, (JCTree.JCLabeledStatement)t2);
            }
            case SWITCH: {
                return this.matchSwitch((JCTree.JCSwitch)t1, (JCTree.JCSwitch)t2);
            }
            case CASE: {
                return this.matchCase((JCTree.JCCase)t1, (JCTree.JCCase)t2);
            }
            case SYNCHRONIZED: {
                return this.matchSynchronized((JCTree.JCSynchronized)t1, (JCTree.JCSynchronized)t2);
            }
            case TRY: {
                return this.matchTry((JCTree.JCTry)t1, (JCTree.JCTry)t2);
            }
            case CATCH: {
                return this.matchCatch((JCTree.JCCatch)t1, (JCTree.JCCatch)t2);
            }
            case CONDEXPR: {
                return this.matchConditional((JCTree.JCConditional)t1, (JCTree.JCConditional)t2);
            }
            case IF: {
                return this.matchIf((JCTree.JCIf)t1, (JCTree.JCIf)t2);
            }
            case EXEC: {
                return this.treesMatch(((JCTree.JCExpressionStatement)t1).expr, ((JCTree.JCExpressionStatement)t2).expr);
            }
            case BREAK: {
                return this.matchBreak((JCTree.JCBreak)t1, (JCTree.JCBreak)t2);
            }
            case CONTINUE: {
                return this.matchContinue((JCTree.JCContinue)t1, (JCTree.JCContinue)t2);
            }
            case RETURN: {
                return this.treesMatch(((JCTree.JCReturn)t1).expr, ((JCTree.JCReturn)t2).expr);
            }
            case THROW: {
                return this.treesMatch(((JCTree.JCThrow)t1).expr, ((JCTree.JCThrow)t2).expr);
            }
            case ASSERT: {
                return this.matchAssert((JCTree.JCAssert)t1, (JCTree.JCAssert)t2);
            }
            case APPLY: {
                return this.matchApply((JCTree.JCMethodInvocation)t1, (JCTree.JCMethodInvocation)t2);
            }
            case NEWCLASS: {
                if (((JCTree.JCNewClass)t2).def != null) {
                    ((JCTree.JCNewClass)t2).def.sym = null;
                }
                return this.matchNewClass((JCTree.JCNewClass)t1, (JCTree.JCNewClass)t2);
            }
            case NEWARRAY: {
                return this.matchNewArray((JCTree.JCNewArray)t1, (JCTree.JCNewArray)t2);
            }
            case PARENS: {
                return this.treesMatch(((JCTree.JCParens)t1).expr, ((JCTree.JCParens)t2).expr);
            }
            case ASSIGN: {
                return this.matchAssign((JCTree.JCAssign)t1, (JCTree.JCAssign)t2);
            }
            case TYPECAST: {
                return this.matchTypeCast((JCTree.JCTypeCast)t1, (JCTree.JCTypeCast)t2);
            }
            case TYPETEST: {
                return this.matchTypeTest((JCTree.JCInstanceOf)t1, (JCTree.JCInstanceOf)t2);
            }
            case INDEXED: {
                return this.matchIndexed((JCTree.JCArrayAccess)t1, (JCTree.JCArrayAccess)t2);
            }
            case SELECT: {
                return this.matchSelect((JCTree.JCFieldAccess)t1, (JCTree.JCFieldAccess)t2);
            }
            case REFERENCE: {
                return this.matchReference((JCTree.JCMemberReference)t1, (JCTree.JCMemberReference)t2);
            }
            case IDENT: {
                return ((JCTree.JCIdent)t1).getName().contentEquals(((JCTree.JCIdent)t2).getName());
            }
            case LITERAL: {
                return this.matchLiteral((JCTree.JCLiteral)t1, (JCTree.JCLiteral)t2);
            }
            case TYPEIDENT: {
                return ((JCTree.JCPrimitiveTypeTree)t1).typetag == ((JCTree.JCPrimitiveTypeTree)t2).typetag;
            }
            case TYPEARRAY: {
                return this.treesMatch(((JCTree.JCArrayTypeTree)t1).elemtype, ((JCTree.JCArrayTypeTree)t2).elemtype);
            }
            case TYPEAPPLY: {
                return this.matchTypeApply((JCTree.JCTypeApply)t1, (JCTree.JCTypeApply)t2);
            }
            case TYPEPARAMETER: {
                return this.matchTypeParameter((JCTree.JCTypeParameter)t1, (JCTree.JCTypeParameter)t2);
            }
            case WILDCARD: {
                return this.matchWildcard((JCTree.JCWildcard)t1, (JCTree.JCWildcard)t2);
            }
            case TYPEBOUNDKIND: {
                return ((JCTree.TypeBoundKind)t1).kind == ((JCTree.TypeBoundKind)t2).kind;
            }
            case ANNOTATION: 
            case TYPE_ANNOTATION: {
                return this.matchAnnotation((JCTree.JCAnnotation)t1, (JCTree.JCAnnotation)t2);
            }
            case LETEXPR: {
                return this.matchLetExpr((JCTree.LetExpr)t1, (JCTree.LetExpr)t2);
            }
            case POS: 
            case NEG: 
            case NOT: 
            case COMPL: 
            case PREINC: 
            case PREDEC: 
            case POSTINC: 
            case POSTDEC: 
            case NULLCHK: {
                return this.matchUnary((JCTree.JCUnary)t1, (JCTree.JCUnary)t2);
            }
            case OR: 
            case AND: 
            case BITOR: 
            case BITXOR: 
            case BITAND: 
            case EQ: 
            case NE: 
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case SL: 
            case SR: 
            case USR: 
            case PLUS: 
            case MINUS: 
            case MUL: 
            case DIV: 
            case MOD: {
                return this.matchBinary((JCTree.JCBinary)t1, (JCTree.JCBinary)t2);
            }
            case BITOR_ASG: 
            case BITXOR_ASG: 
            case BITAND_ASG: 
            case SL_ASG: 
            case SR_ASG: 
            case USR_ASG: 
            case PLUS_ASG: 
            case MINUS_ASG: 
            case MUL_ASG: 
            case DIV_ASG: 
            case MOD_ASG: {
                return this.matchAssignop((JCTree.JCAssignOp)t1, (JCTree.JCAssignOp)t2);
            }
            case ANNOTATED_TYPE: {
                return this.matchAnnotatedType((JCTree.JCAnnotatedType)t1, (JCTree.JCAnnotatedType)t2);
            }
            case LAMBDA: {
                return this.matchLambda((JCTree.JCLambda)t1, (JCTree.JCLambda)t2);
            }
            case ERRONEOUS: {
                SourcePositions sps = this.diffContext.trees.getSourcePositions();
                int a1 = (int)sps.getStartPosition(this.diffContext.origUnit, t1);
                int a2 = (int)sps.getEndPosition(this.diffContext.origUnit, t1);
                int b1 = (int)sps.getStartPosition(this.diffContext.origUnit, t2);
                int b2 = (int)sps.getEndPosition(this.diffContext.origUnit, t2);
                if (a1 == b1 && a2 == b2) {
                    return true;
                }
                if (a1 == -2 || a2 == -2 || b1 == -2 || b2 == -2) {
                    return false;
                }
                if (a1 == -1 || a2 == -1 || b1 == -1 || b2 == -1) {
                    return false;
                }
                String sa = this.diffContext.origText.substring(a1, a2);
                String sb = this.diffContext.origText.substring(b1, b2);
                return sa.equals(sb);
            }
        }
        String msg = t1.getKind().toString() + " " + t1.getClass().getName();
        throw new AssertionError((Object)msg);
    }

    private boolean kindChanged(long oldFlags, long newFlags) {
        return (oldFlags & 0x6200L) != (newFlags & 0x6200L);
    }

    protected boolean nameChanged(Name oldName, Name newName) {
        byte[] arr2;
        if (oldName == newName) {
            return false;
        }
        if (oldName == null || newName == null) {
            return true;
        }
        byte[] arr1 = oldName.toUtf();
        int len = arr1.length;
        if (len != (arr2 = newName.toUtf()).length) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (arr1[i] == arr2[i]) continue;
            return true;
        }
        return false;
    }

    protected int diffList2(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, int initialPos, PositionEstimator estimator) {
        if (oldList == newList) {
            return initialPos;
        }
        assert (oldList != null && newList != null);
        int lastOldPos = initialPos;
        ListMatcher<? extends JCTree> matcher = ListMatcher.instance(oldList, newList, null);
        if (!matcher.match()) {
            return initialPos;
        }
        Iterator<? extends JCTree> oldIter = oldList.iterator();
        ListMatcher.ResultItem<? extends JCTree>[] result = matcher.getTransformedResult();
        ListMatcher.Separator s = matcher.separatorInstance();
        s.compute();
        int[][] matrix = estimator.getMatrix();
        int testPos = initialPos;
        int i = 0;
        int newIndex = 0;
        boolean firstNewItem = true;
        block6: for (int j = 0; j < result.length; ++j) {
            ListMatcher.ResultItem<? extends JCTree> item = result[j];
            switch (item.operation) {
                case MODIFY: {
                    this.tokenSequence.moveIndex(matrix[i][4]);
                    if (this.tokenSequence.moveNext()) {
                        testPos = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            testPos += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    JCTree oldT = oldIter.next();
                    ++i;
                    if (!firstNewItem) {
                        this.copyTo(lastOldPos, CasualDiff.getOldPos(oldT));
                    }
                    if (this.treesMatch(oldT, (JCTree)item.element, false)) {
                        lastOldPos = this.diffTree(oldT, (JCTree)item.element, this.getBounds(oldT));
                    } else {
                        this.printer.print((JCTree)item.element);
                        lastOldPos = Math.max(testPos, this.endPos(oldT));
                    }
                    firstNewItem = false;
                    ++newIndex;
                    continue block6;
                }
                case INSERT: {
                    String tail;
                    String prec = s.head(j) ? estimator.head() : (s.prev(j) ? estimator.sep() : null);
                    String string = tail = s.next(j) ? estimator.sep() : null;
                    if (estimator.getIndentString() != null && !estimator.getIndentString().equals(" ")) {
                        prec = prec + estimator.getIndentString();
                    }
                    this.copyTo(lastOldPos, testPos);
                    this.printer.print(prec);
                    this.printer.print((JCTree)item.element);
                    this.printer.print(tail);
                    firstNewItem = false;
                    ++newIndex;
                    continue block6;
                }
                case DELETE: {
                    int delta = 0;
                    if (i == 0 && matrix[i + 1][2] != -1 && matrix[i + 1][2] == matrix[i + 1][3]) {
                        ++delta;
                    }
                    int startOffset = this.toOff(s.head(j) || s.prev(j) ? matrix[i][1] : matrix[i][2 + delta]);
                    int endOffset = this.toOff(s.tail(j) || s.next(j) ? matrix[i + 1][2] : matrix[i][4]);
                    assert (startOffset != -1 && endOffset != -1) : "Invalid offset!";
                    this.tokenSequence.moveIndex(matrix[i][4]);
                    if (this.tokenSequence.moveNext()) {
                        testPos = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            PositionEstimator.moveToDifferentThan(this.tokenSequence, PositionEstimator.Direction.FORWARD, EnumSet.of(JavaTokenId.WHITESPACE));
                            testPos = this.tokenSequence.offset();
                        }
                    }
                    lastOldPos = i == 0 && !newList.isEmpty() ? endOffset : Math.max(testPos, this.endPos((JCTree)item.element));
                    JCTree oldT = oldIter.next();
                    ++i;
                    continue block6;
                }
                case NOCHANGE: {
                    this.tokenSequence.moveIndex(matrix[i][4]);
                    if (this.tokenSequence.moveNext()) {
                        testPos = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            PositionEstimator.moveToDifferentThan(this.tokenSequence, PositionEstimator.Direction.FORWARD, EnumSet.of(JavaTokenId.WHITESPACE));
                            testPos = this.tokenSequence.offset();
                        }
                    }
                    JCTree oldT = oldIter.next();
                    ++i;
                    int copyTo = ++newIndex < newList.size() ? Math.max(testPos, this.endPos(oldT)) : this.endPos(oldT);
                    int n = lastOldPos;
                    lastOldPos = copyTo;
                    this.copyTo(n, lastOldPos);
                    firstNewItem = false;
                    continue block6;
                }
            }
        }
        return lastOldPos;
    }

    private int printBreakContinueTree(int[] bounds, Name oldTLabel, Name newTlabel, JCTree.JCStatement oldT) {
        String stmt;
        int localPointer = bounds[0];
        String string = stmt = oldT.getKind() == Tree.Kind.BREAK ? "break" : "continue";
        if (this.nameChanged(oldTLabel, newTlabel)) {
            int labelPos = -1;
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldT);
            this.copyTo(n, localPointer);
            this.printer.print(stmt);
            localPointer += stmt.length();
            int commentStart = -1;
            int commentEnd = -1;
            if (oldTLabel != null && oldTLabel.length() > 0) {
                this.tokenSequence.move(localPointer);
                while (this.tokenSequence.moveNext()) {
                    Token tukac = this.tokenSequence.token();
                    if (this.isComment((JavaTokenId)tukac.id())) {
                        if (commentStart == -1) {
                            commentStart = this.tokenSequence.offset();
                        }
                        commentEnd = this.tokenSequence.offset() + tukac.length();
                        continue;
                    }
                    if (tukac.id() == JavaTokenId.WHITESPACE) continue;
                    break;
                }
                if (commentStart != -1) {
                    localPointer = this.copyUpTo(localPointer, commentEnd);
                }
                labelPos = this.tokenSequence.offset();
            }
            if (newTlabel != null && newTlabel.length() > 0) {
                if (oldTLabel != null) {
                    localPointer = this.copyUpTo(localPointer, labelPos);
                } else {
                    this.printer.print(" ");
                }
                this.printer.print(newTlabel);
            }
            if (oldTLabel != null) {
                localPointer = labelPos + oldTLabel.length();
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    private int toOff(int tokenIndex) {
        if (tokenIndex == -1) {
            return -1;
        }
        this.tokenSequence.moveIndex(tokenIndex);
        this.tokenSequence.moveNext();
        return this.tokenSequence.offset();
    }

    private int diffParameterList(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, JavaTokenId[] makeAround, int pos, Comparator<JCTree> measure) {
        return this.diffParameterList(oldList, newList, null, makeAround, pos, measure);
    }

    private int diffParameterList(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, JCTree parent, JavaTokenId[] makeAround, int pos, Comparator<JCTree> measure) {
        return this.diffParameterList(oldList, newList, parent, makeAround, pos, measure, this.diffContext.style.spaceBeforeComma(), this.diffContext.style.spaceAfterComma(), ListType.NORMAL, ",");
    }

    private int diffParameterList(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, JavaTokenId[] makeAround, int pos, Comparator<JCTree> measure, boolean spaceBefore, boolean spaceAfter, ListType listType, String separator) {
        return this.diffParameterList(oldList, newList, null, makeAround, pos, measure, spaceBefore, spaceAfter, listType, separator);
    }

    private int diffParameterList(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, JCTree parent, JavaTokenId[] makeAround, int pos, Comparator<JCTree> measure, boolean spaceBefore, boolean spaceAfter, ListType listType, String separator) {
        boolean printParens;
        assert (oldList != null && newList != null);
        if (oldList == newList || oldList.equals(newList)) {
            return pos;
        }
        boolean bl = printParens = makeAround != null && makeAround.length != 0;
        if (newList.isEmpty()) {
            int endPos = this.endPos(oldList);
            if (printParens) {
                this.tokenSequence.move(endPos);
                PositionEstimator.moveFwdToToken(this.tokenSequence, endPos, makeAround[1]);
                this.tokenSequence.moveNext();
                endPos = this.tokenSequence.offset();
                if (!PositionEstimator.nonRelevant.contains(this.tokenSequence.token().id())) {
                    this.printer.print(" ");
                }
            }
            return endPos;
        }
        ListMatcher<JCTree> matcher = ListMatcher.instance(oldList, newList, measure);
        if (!matcher.match()) {
            return pos;
        }
        ListMatcher.ResultItem[] result = matcher.getResult();
        if (printParens) {
            this.printer.print(makeAround[0].fixedText());
        }
        int oldIndex = 0;
        boolean wasLeadingDelete = false;
        boolean wasComma = false;
        for (int j = 0; j < result.length; ++j) {
            ListMatcher.ResultItem<JCTree> item = result[j];
            switch (item.operation) {
                case MODIFY: {
                    int end;
                    JCTree tree = oldList.get(oldIndex++);
                    int[] bounds = this.getCommentCorrectedBounds(tree);
                    this.tokenSequence.move(bounds[0]);
                    int start = -1;
                    if (oldIndex != 1 && !separator.isEmpty()) {
                        if (wasLeadingDelete) {
                            start = Math.max(PositionEstimator.offsetToSrcWiteOnLine(this.tokenSequence, PositionEstimator.Direction.BACKWARD), pos);
                        } else {
                            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                        }
                    }
                    if (start == -1) {
                        this.tokenSequence.moveNext();
                        start = Math.max(this.tokenSequence.offset(), pos);
                    }
                    if (start < bounds[0]) {
                        this.copyTo(start, bounds[0], this.printer);
                    } else {
                        bounds[0] = Math.max(start, bounds[0]);
                    }
                    this.diffTree(tree, (JCTree)item.element, parent, bounds);
                    switch (listType) {
                        case RESOURCE: {
                            this.tokenSequence.move(bounds[1]);
                            this.tokenSequence.movePrevious();
                            if (this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                                end = this.tokenSequence.offset();
                                break;
                            }
                        }
                        default: {
                            this.tokenSequence.move(bounds[1]);
                            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                            end = Math.max(this.tokenSequence.offset(), bounds[1]);
                        }
                    }
                    if (!this.commaNeeded(result, item) && listType == ListType.ENUM && this.tokenSequence.token().id() == JavaTokenId.RBRACKET) {
                        this.printer.print(";");
                    }
                    pos = end;
                    this.copyTo(bounds[1], pos, this.printer);
                    wasLeadingDelete = false;
                    break;
                }
                case INSERT: {
                    if (wasComma && spaceAfter) {
                        this.printer.print(" ");
                    }
                    this.printer.suppressVariableType = this.suppressParameterTypes;
                    this.printer.print((JCTree)item.element);
                    this.printer.suppressVariableType = false;
                    wasLeadingDelete = false;
                    break;
                }
                case DELETE: {
                    wasLeadingDelete |= oldIndex++ == 0;
                    int endPos = this.getBounds((JCTree)item.element)[1];
                    this.tokenSequence.move(endPos);
                    PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                    if (this.tokenSequence.token().id() != JavaTokenId.COMMA || this.tokenSequence.moveNext()) {
                        // empty if block
                    }
                    pos = Math.max(this.tokenSequence.offset(), endPos);
                    break;
                }
                case NOCHANGE: {
                    if (oldIndex++ == 0 && wasComma && spaceAfter) {
                        this.printer.print(" ");
                    }
                    int[] bounds = this.getCommentCorrectedBounds((JCTree)item.element);
                    this.tokenSequence.move(bounds[0]);
                    int start = -1;
                    if (oldIndex != 1 && !separator.isEmpty()) {
                        if (wasLeadingDelete) {
                            start = PositionEstimator.offsetToSrcWiteOnLine(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                        } else {
                            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                        }
                    }
                    if (start == -1) {
                        this.tokenSequence.moveNext();
                        start = this.tokenSequence.offset();
                    }
                    boolean forceUseOfTokenOffset = false;
                    switch (listType) {
                        case RESOURCE: {
                            this.tokenSequence.move(bounds[1]);
                            this.tokenSequence.movePrevious();
                            if (this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                                forceUseOfTokenOffset = true;
                                break;
                            }
                        }
                        default: {
                            this.tokenSequence.move(bounds[1]);
                            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                        }
                    }
                    int end = listType == ListType.ENUM ? (this.tokenSequence.token().id() == JavaTokenId.SEMICOLON || this.tokenSequence.token().id() == JavaTokenId.COMMA ? this.tokenSequence.offset() : bounds[1]) : (oldIndex < oldList.size() || forceUseOfTokenOffset ? this.tokenSequence.offset() : bounds[1]);
                    start = Math.max(start, pos);
                    pos = end;
                    this.copyTo(start, pos, this.printer);
                    wasLeadingDelete = false;
                    break;
                }
            }
            if (this.commaNeeded(result, item)) {
                if ((item.operation == ListMatcher.Operation.INSERT || oldIndex == oldList.size() && j + 1 < result.length && result[j + 1].operation == ListMatcher.Operation.INSERT) && spaceBefore) {
                    this.printer.print(" ");
                }
                this.printer.print(separator);
                wasComma = true;
                continue;
            }
            if (item.operation == ListMatcher.Operation.DELETE) continue;
            wasComma = false;
        }
        if (printParens) {
            this.printer.print(makeAround[1].fixedText());
        }
        if (oldList.isEmpty()) {
            return pos;
        }
        int endPos2 = this.endPos(oldList);
        this.tokenSequence.move(endPos2);
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
        if (listType == ListType.ENUM && (this.tokenSequence.token().id() == JavaTokenId.SEMICOLON || this.tokenSequence.token().id() == JavaTokenId.COMMA)) {
            return this.tokenSequence.offset();
        }
        return pos;
    }

    private int diffVarGroup(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, JavaTokenId[] makeAround, int pos, Comparator<JCTree> measure) {
        boolean printParens;
        assert (oldList != null && newList != null);
        if (oldList == newList || oldList.equals(newList)) {
            return pos;
        }
        boolean bl = printParens = makeAround != null && makeAround.length != 0;
        if (newList.isEmpty()) {
            int endPos = this.endPos(oldList);
            if (printParens) {
                this.tokenSequence.move(endPos);
                PositionEstimator.moveFwdToToken(this.tokenSequence, endPos, makeAround[1]);
                this.tokenSequence.moveNext();
                endPos = this.tokenSequence.offset();
                if (!PositionEstimator.nonRelevant.contains(this.tokenSequence.token().id())) {
                    this.printer.print(" ");
                }
            }
            return endPos;
        }
        ListMatcher<JCTree> matcher = ListMatcher.instance(oldList, newList, measure);
        if (!matcher.match()) {
            return pos;
        }
        ListMatcher.ResultItem[] result = matcher.getResult();
        if (printParens && oldList.isEmpty()) {
            this.printer.print(makeAround[0].fixedText());
        }
        int oldIndex = 0;
        boolean skipWhitespaces = false;
        for (int j = 0; j < result.length; ++j) {
            ListMatcher.ResultItem<JCTree> item = result[j];
            switch (item.operation) {
                case MODIFY: {
                    int start;
                    JCTree tree = oldList.get(oldIndex++);
                    int[] bounds = this.getBounds(tree);
                    if (oldIndex != 1) {
                        bounds[0] = tree.pos;
                    }
                    if (j == 0) {
                        int n = pos;
                        pos = bounds[0];
                        this.copyTo(n, pos);
                    }
                    this.tokenSequence.move(bounds[1]);
                    this.tokenSequence.movePrevious();
                    if (this.tokenSequence.token().id() == JavaTokenId.COMMA || this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                        bounds[1] = this.tokenSequence.offset();
                    }
                    this.tokenSequence.move(bounds[0]);
                    if (oldIndex != 1 && !skipWhitespaces) {
                        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                    }
                    this.tokenSequence.moveNext();
                    int n = start = this.tokenSequence.offset();
                    start = bounds[0];
                    this.copyTo(n, start, this.printer);
                    if (j > 0) {
                        CommentSet old = this.comments.getComments(tree);
                        CommentSet cs = this.comments.getComments((Tree)item.element);
                        java.util.List<Comment> oldPrecedingComments = old.getComments(CommentSet.RelativePosition.PRECEDING);
                        java.util.List<Comment> newPrecedingComments = cs.getComments(CommentSet.RelativePosition.PRECEDING);
                        int indentReset = -1;
                        if (oldPrecedingComments.isEmpty() && !newPrecedingComments.isEmpty()) {
                            if (this.printer.out.isWhitespaceLine()) {
                                indentReset = this.printer.getIndent();
                                this.printer.setIndent(this.printer.out.getCol());
                            } else {
                                this.printer.newline();
                                this.printer.toLeftMargin();
                            }
                        }
                        start = this.diffPrecedingComments(tree, (JCTree)item.element, bounds[0], start, false);
                        if (indentReset != -1) {
                            this.printer.setIndent(indentReset);
                        }
                    }
                    int localPointer = oldIndex != 1 ? this.diffVarDef((JCTree.JCVariableDecl)tree, (JCTree.JCVariableDecl)item.element, bounds[0]) : this.diffVarDef((JCTree.JCVariableDecl)tree, (JCTree.JCVariableDecl)item.element, bounds);
                    pos = bounds[1];
                    this.copyTo(localPointer, pos, this.printer);
                    skipWhitespaces = false;
                    break;
                }
                case INSERT: {
                    JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)item.element;
                    if (j == 0) {
                        JCTree tree = oldList.get(oldIndex);
                        int[] bounds = this.getBounds(tree);
                        int n = pos;
                        pos = bounds[0];
                        this.copyTo(n, pos);
                    }
                    if (oldIndex == 0) {
                        int oldPrec = this.printer.setPrec(0);
                        this.printer.visitVarDef(decl);
                        this.printer.setPrec(oldPrec);
                    } else {
                        if (this.diffContext.style.spaceAfterComma()) {
                            this.printer.print(" ");
                        }
                        this.printer.print(decl.name);
                        if (decl.init != null) {
                            this.printer.printVarInit(decl);
                        }
                    }
                    skipWhitespaces = false;
                    break;
                }
                case NOCHANGE: {
                    ++oldIndex;
                    int[] bounds = this.getBounds((JCTree)item.element);
                    if (j != 0) {
                        bounds[0] = ((JCTree)item.element).pos;
                    } else {
                        int n = pos;
                        pos = bounds[0];
                        this.copyTo(n, pos);
                    }
                    this.tokenSequence.move(bounds[0]);
                    if (j != 0 && !skipWhitespaces) {
                        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                    }
                    this.tokenSequence.moveNext();
                    int start = this.tokenSequence.offset();
                    int end = bounds[1];
                    this.tokenSequence.move(end);
                    this.tokenSequence.movePrevious();
                    if (this.tokenSequence.token().id() == JavaTokenId.COMMA || this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                        end = this.tokenSequence.offset();
                    }
                    pos = end;
                    this.copyTo(start, pos, this.printer);
                    skipWhitespaces = false;
                    break;
                }
                case DELETE: {
                    skipWhitespaces = false;
                    if (j == 0) {
                        JCTree.JCVariableDecl oldEl = (JCTree.JCVariableDecl)oldList.get(0);
                        JCTree.JCVariableDecl newEl = (JCTree.JCVariableDecl)newList.get(0);
                        int[] bounds = this.getBounds(oldEl.getModifiers());
                        this.copyTo(pos, bounds[0]);
                        pos = this.diffTree(oldEl.getModifiers(), (JCTree)newEl.getModifiers(), bounds);
                        bounds = this.getBounds(oldEl.getType());
                        int n = pos;
                        pos = bounds[0];
                        this.copyTo(n, pos);
                        pos = this.diffTree(oldEl.getType(), newEl.getType(), bounds);
                        this.copyTo(pos, ((JCTree)item.element).pos);
                        skipWhitespaces = true;
                    }
                    int[] bounds = this.getBounds((JCTree)item.element);
                    this.tokenSequence.move(bounds[1]);
                    this.tokenSequence.movePrevious();
                    if (this.tokenSequence.token().id() == JavaTokenId.COMMA || this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                        bounds[1] = this.tokenSequence.offset();
                    }
                    pos = bounds[1];
                    break;
                }
            }
            if (!this.commaNeeded(result, item)) continue;
            this.printer.print(",");
        }
        if (printParens && oldList.isEmpty()) {
            this.printer.print(makeAround[1].fixedText());
        }
        return pos;
    }

    protected int diffUnionType(JCTree.JCTypeUnion oldT, JCTree.JCTypeUnion newT, int[] bounds) {
        int localPointer = bounds[0];
        int pos = this.diffParameterList(oldT.alternatives, newT.alternatives, null, localPointer, Measure.MEMBER, this.diffContext.style.spaceAroundBinaryOps(), this.diffContext.style.spaceAroundBinaryOps(), ListType.NORMAL, "|");
        return Math.min(pos, bounds[1]);
    }

    private boolean commaNeeded(ListMatcher.ResultItem[] arr, ListMatcher.ResultItem item) {
        if (item.operation == ListMatcher.Operation.DELETE) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < arr.length; ++i) {
            if (item == arr[i]) {
                result = true;
                continue;
            }
            if (!result || arr[i].operation == ListMatcher.Operation.DELETE) continue;
            return true;
        }
        return false;
    }

    private java.util.List<JCTree> filterHidden(java.util.List<? extends JCTree> list) {
        return CasualDiff.filterHidden(this.diffContext, list);
    }

    public static java.util.List<JCTree> filterHidden(DiffContext diffContext, java.util.List<? extends JCTree> list) {
        LinkedList<JCTree> result = new LinkedList<JCTree>();
        ArrayList<JCTree.JCVariableDecl> fieldGroup = new ArrayList<JCTree.JCVariableDecl>();
        ArrayList<JCTree.JCVariableDecl> enumConstants = new ArrayList<JCTree.JCVariableDecl>();
        for (JCTree jCTree : list) {
            if (jCTree.pos == -1 || diffContext.syntheticTrees.contains(jCTree)) continue;
            if (Tree.Kind.VARIABLE == jCTree.getKind()) {
                JCTree.JCVariableDecl var = (JCTree.JCVariableDecl)jCTree;
                if ((var.mods.flags & 0x4000L) != 0L) {
                    enumConstants.add(var);
                    continue;
                }
                if ((var.mods.flags & 0x1000000L) != 0L) continue;
                if (!fieldGroup.isEmpty()) {
                    int oldPos = CasualDiff.getOldPos((JCTree)fieldGroup.get(0));
                    if (oldPos != -1 && oldPos != -2 && oldPos == CasualDiff.getOldPos(var) && ((JCTree.JCVariableDecl)fieldGroup.get(0)).getModifiers() == var.getModifiers() && !CasualDiff.isVarTypeVariable(var)) {
                        fieldGroup.add(var);
                        continue;
                    }
                    if (fieldGroup.size() > 1) {
                        result.add(new FieldGroupTree(fieldGroup));
                    } else {
                        result.add((JCTree)fieldGroup.get(0));
                    }
                    fieldGroup = new ArrayList();
                    fieldGroup.add(var);
                    continue;
                }
                fieldGroup.add(var);
                continue;
            }
            if (!fieldGroup.isEmpty()) {
                if (fieldGroup.size() > 1) {
                    result.add(new FieldGroupTree(fieldGroup));
                } else {
                    result.add((JCTree)fieldGroup.get(0));
                }
                fieldGroup = new ArrayList();
            }
            if (Tree.Kind.METHOD == jCTree.getKind()) {
                if (jCTree.pos == -1 || (((JCTree.JCMethodDecl)jCTree).mods.flags & 0x1000000000L) != 0L) {
                    continue;
                }
            } else if (Tree.Kind.BLOCK == jCTree.getKind()) {
                JCTree.JCBlock block = (JCTree.JCBlock)jCTree;
                if (block.stats.isEmpty() && block.pos == -1 && block.flags == 0L) continue;
            }
            result.add(jCTree);
        }
        if (!fieldGroup.isEmpty()) {
            if (fieldGroup.size() > 1) {
                result.add(new FieldGroupTree(fieldGroup));
            } else {
                result.add((JCTree)fieldGroup.get(0));
            }
        }
        if (!enumConstants.isEmpty()) {
            result.addFirst(new FieldGroupTree(enumConstants, !result.isEmpty()));
        }
        return result;
    }

    private int diffList(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, int localPointer, PositionEstimator estimator, Comparator<JCTree> measure, VeryPretty printer) {
        if (oldList == newList || oldList.equals(newList)) {
            return localPointer;
        }
        assert (oldList != null && newList != null);
        ListMatcher<JCTree> matcher = ListMatcher.instance(oldList, newList, measure);
        if (!matcher.match()) {
            return localPointer;
        }
        LinkedList<JCTree> deletedItems = new LinkedList<JCTree>();
        JCTree lastdel = null;
        ListMatcher.ResultItem<JCTree>[] result = matcher.getResult();
        if (oldList.isEmpty() && !newList.isEmpty()) {
            StringBuilder aHead = new StringBuilder();
            StringBuilder aTail = new StringBuilder();
            int pos = estimator.prepare(localPointer, aHead, aTail);
            this.copyUpTo(localPointer, pos, printer);
            if (newList.get(0).getKind() == Tree.Kind.IMPORT) {
                printer.printImportsBlock(newList, true);
            } else {
                printer.print(aHead.toString());
                for (JCTree jCTree : newList) {
                    if (LineInsertionType.BEFORE == estimator.lineInsertType()) {
                        printer.newline();
                    }
                    printer.print(jCTree);
                    if (LineInsertionType.AFTER != estimator.lineInsertType()) continue;
                    printer.newline();
                }
                printer.print(aTail.toString());
            }
            return pos;
        }
        if (newList.isEmpty() && !oldList.isEmpty()) {
            int[] removalBounds = estimator.sectionRemovalBounds(null);
            this.copyTo(localPointer, removalBounds[0]);
            return removalBounds[1];
        }
        CodeStyle.ImportGroups importGroups = newList.get(0).getKind() == Tree.Kind.IMPORT && this.diffContext.style.separateImportGroups() ? this.diffContext.style.getImportGroups() : null;
        int lastGroup = -1;
        int i = 0;
        int insertPos = Math.min(this.getCommentCorrectedOldPos(oldList.get(i)), estimator.getInsertPos(0));
        int n = localPointer;
        if (insertPos < localPointer) {
            insertPos = -1;
        }
        block7: for (int j = 0; j < result.length; ++j) {
            ListMatcher.ResultItem<JCTree> item = result[j];
            int group = -1;
            if (importGroups != null) {
                Name name = printer.fullName(((JCTree.JCImport)item.element).qualid);
                group = name != null ? importGroups.getGroupId(name.toString(), ((JCTree.JCImport)item.element).staticImport) : -1;
            }
            switch (item.operation) {
                case MODIFY: {
                    lastGroup = group;
                    int[] bounds = estimator.getPositions(i);
                    bounds[0] = Math.min(bounds.length > 4 ? bounds[4] : bounds[0], this.getCommentCorrectedOldPos(oldList.get(i)));
                    this.copyTo(localPointer, bounds[0], printer);
                    localPointer = this.diffTree(oldList.get(i), (JCTree)item.element, bounds);
                    lastdel = null;
                    ++i;
                    insertPos = -1;
                    continue block7;
                }
                case INSERT: {
                    int pos;
                    int n2;
                    boolean insetBlankLine = lastGroup >= 0 && lastGroup != group;
                    JCTree ld = null;
                    boolean match = false;
                    if (lastdel != null) {
                        boolean wasInFieldGroup = false;
                        if (lastdel instanceof FieldGroupTree) {
                            FieldGroupTree fieldGroupTree = (FieldGroupTree)lastdel;
                            for (JCTree.JCVariableDecl var : fieldGroupTree.getVariables()) {
                                if (!this.treesMatch((JCTree)item.element, var, false)) continue;
                                ld = lastdel;
                                wasInFieldGroup = true;
                                this.oldTrees.remove(item.element);
                                break;
                            }
                        }
                        match = wasInFieldGroup;
                        Iterator it = deletedItems.iterator();
                        while (!match && it.hasNext()) {
                            ld = (JCTree)it.next();
                            match = this.treesMatch((JCTree)item.element, ld, false);
                            if (!match) continue;
                            it.remove();
                        }
                    }
                    if (insertPos > -1 && i > 0) {
                        if (match) {
                            insertPos = Math.min(insertPos, i < oldList.size() ? estimator.getPositions(i)[0] : estimator.getPositions(i - 1)[2]);
                        }
                        if (insertPos > n2) {
                            this.copyTo(n2, insertPos);
                        }
                        localPointer = Math.max(localPointer, insertPos);
                    }
                    insertPos = -1;
                    lastGroup = group;
                    int n3 = importGroups != null ? (i == 0 || insetBlankLine && i < oldList.size() ? estimator.getPositions(i)[0] : estimator.getPositions(i - 1)[2]) : (pos = estimator.getInsertPos(i));
                    if (pos > localPointer) {
                        int n4 = localPointer;
                        localPointer = pos;
                        this.copyTo(n4, localPointer);
                    }
                    if (insetBlankLine) {
                        printer.blankline();
                    }
                    if (match) {
                        VeryPretty oldPrinter = this.printer;
                        int old = oldPrinter.indent();
                        this.printer = new VeryPretty(this.diffContext, this.diffContext.style, this.tree2Tag, this.tree2Doc, this.tag2Span, this.origText, oldPrinter.toString().length() + oldPrinter.getInitialOffset());
                        this.printer.reset(old, oldPrinter.out.getCol());
                        this.printer.oldTrees = this.oldTrees;
                        int index = oldList.indexOf(ld);
                        int[] poss = estimator.getPositions(index);
                        int diffTo = this.diffTree(ld, (JCTree)item.element, poss);
                        this.copyTo(diffTo, poss[1]);
                        localPointer = Math.max(localPointer, poss[1]);
                        if (j > 0 && LineInsertionType.BEFORE == estimator.lineInsertType()) {
                            printer.newline();
                        }
                        printer.print(this.printer.toString());
                        if (j < result.length - 1 && LineInsertionType.AFTER == estimator.lineInsertType()) {
                            printer.newline();
                        }
                        printer.reindentRegions.addAll(this.printer.reindentRegions);
                        this.printer = oldPrinter;
                        this.printer.undent(old);
                        if (!deletedItems.isEmpty()) continue block7;
                        lastdel = null;
                        continue block7;
                    }
                    if (LineInsertionType.BEFORE == estimator.lineInsertType()) {
                        printer.newline();
                    }
                    if (!oldList.contains(item.element) || !printer.handlePossibleOldTrees(Collections.singletonList((JCTree)item.element), true)) {
                        printer.print((JCTree)item.element);
                    }
                    if (LineInsertionType.AFTER != estimator.lineInsertType()) continue block7;
                    printer.newline();
                    continue block7;
                }
                case DELETE: {
                    int n2;
                    int[] pos = estimator.getPositions(i);
                    if (localPointer < pos[0] && lastdel == null) {
                        this.copyTo(localPointer, pos[0], printer);
                        if (insertPos > -1) {
                            assert (localPointer == n2);
                            n2 = pos[0];
                        }
                    }
                    if (lastdel == null) {
                        deletedItems.clear();
                    }
                    lastdel = oldList.get(i);
                    deletedItems.add(lastdel);
                    CommentSet ch = this.comments.getComments(oldList.get(i));
                    localPointer = Math.max(pos[1], Math.max(CasualDiff.commentEnd(ch, CommentSet.RelativePosition.INLINE), CasualDiff.commentEnd(ch, CommentSet.RelativePosition.TRAILING)));
                    ++i;
                    continue block7;
                }
                case NOCHANGE: {
                    boolean insetBlankLine = lastGroup >= 0 && lastGroup != group;
                    insertPos = -1;
                    lastGroup = group;
                    int[] pos = estimator.getPositions(i);
                    if (pos[0] > localPointer) {
                        this.copyTo(localPointer, pos[0], printer);
                        localPointer = pos[0];
                    }
                    if (insetBlankLine) {
                        printer.blankline();
                    }
                    JCTree oldItem = oldList.get(i);
                    CommentSet cs = this.comments.getComments(oldItem);
                    boolean reprintComments = cs.hasChanges();
                    int itemStart = pos[0];
                    int itemEnd = pos[1];
                    if (reprintComments) {
                        itemStart = pos.length > 6 ? pos[5] : CasualDiff.getOldPos(oldItem);
                        itemEnd = pos.length > 6 ? pos[6] : this.endPos(oldItem);
                        localPointer = this.diffPrecedingComments(oldItem, oldItem, itemStart, localPointer, false);
                    }
                    if (pos[0] >= localPointer) {
                        localPointer = itemStart;
                        if (pos.length > 3 && pos[3] != -1 && j + 1 < result.length) {
                            int n5 = localPointer;
                            localPointer = pos[3];
                            this.copyTo(n5, localPointer, printer);
                            printer.print(estimator.append(i));
                        }
                    }
                    int n6 = localPointer;
                    localPointer = itemEnd;
                    this.copyTo(n6, localPointer, printer);
                    if (reprintComments) {
                        localPointer = this.diffInnerComments(oldItem, oldItem, localPointer);
                        localPointer = this.diffTrailingComments(oldItem, oldItem, localPointer, pos[1]);
                    }
                    lastdel = null;
                    ++i;
                    continue block7;
                }
            }
        }
        return localPointer;
    }

    private static boolean isVarTypeVariable(JCTree.JCVariableDecl tree) {
        if (tree == null) {
            return false;
        }
        return tree.getType() instanceof JCTree.JCIdent && ((JCTree.JCIdent)tree.getType()).name.contentEquals("var");
    }

    private CommentSet getCommentsForTree(Tree t, boolean preceding) {
        if (t instanceof FieldGroupTree) {
            FieldGroupTree fgt = (FieldGroupTree)t;
            java.util.List<JCTree.JCVariableDecl> vars = fgt.getVariables();
            t = preceding ? (Tree)vars.get(0) : (Tree)vars.get(vars.size() - 1);
        }
        return this.comments.getComments(t);
    }

    protected int diffInnerComments(JCTree oldT, JCTree newT, int localPointer) {
        java.util.List<Comment> newPrecedingComments;
        CommentSet old;
        if (this.innerCommentsProcessed) {
            return localPointer;
        }
        this.innerCommentsProcessed = true;
        CommentSet cs = this.getCommentsForTree(newT, true);
        java.util.List<Comment> oldPrecedingComments = cs == (old = this.getCommentsForTree(oldT, true)) ? ((CommentSetImpl)cs).getOrigComments(CommentSet.RelativePosition.INNER) : old.getComments(CommentSet.RelativePosition.INNER);
        if (this.sameComments(oldPrecedingComments, newPrecedingComments = cs.getComments(CommentSet.RelativePosition.INNER))) {
            if (oldPrecedingComments.isEmpty()) {
                return localPointer;
            }
            Comment c = oldPrecedingComments.get(oldPrecedingComments.size() - 1);
            if (c.pos() == -1) {
                return localPointer;
            }
            int newP = c.endPos();
            this.copyTo(localPointer, newP);
            return newP;
        }
        return this.diffCommentLists(CasualDiff.getOldPos(oldT), oldPrecedingComments, newPrecedingComments, null, null, true, false, true, false, localPointer);
    }

    private DocCommentTree getDocComment(JCTree t, boolean old) {
        if (t instanceof FieldGroupTree) {
            FieldGroupTree fgt = (FieldGroupTree)t;
            java.util.List<JCTree.JCVariableDecl> vars = fgt.getVariables();
            t = vars.get(0);
        }
        return old ? this.oldTopLevel.docComments.getCommentTree(t) : this.tree2Doc.get(t);
    }

    protected int diffPrecedingComments(JCTree oldT, JCTree newT, int oldTreeStartPos, int localPointer, boolean doNotDelete) {
        CommentSet old;
        FieldGroupTree fgt;
        if (this.parent instanceof FieldGroupTree && !(fgt = (FieldGroupTree)this.parent).getVariables().isEmpty() && fgt.getVariables().get(0) == oldT) {
            return localPointer;
        }
        CommentSet cs = this.getCommentsForTree(newT, true);
        java.util.List<Comment> oldPrecedingComments = cs == (old = this.getCommentsForTree(oldT, true)) ? ((CommentSetImpl)cs).getOrigComments(CommentSet.RelativePosition.PRECEDING) : old.getComments(CommentSet.RelativePosition.PRECEDING);
        java.util.List<Comment> newPrecedingComments = cs.getComments(CommentSet.RelativePosition.PRECEDING);
        DocCommentTree newD = this.getDocComment(newT, false);
        if (this.sameComments(oldPrecedingComments, newPrecedingComments) && newD == null) {
            if (oldPrecedingComments.isEmpty()) {
                return localPointer;
            }
            int newP = oldPrecedingComments.get(oldPrecedingComments.size() - 1).endPos();
            if (newP > localPointer && newP < oldTreeStartPos) {
                this.copyTo(localPointer, newP);
                return newP;
            }
            return localPointer;
        }
        DocCommentTree oldD = this.getDocComment(oldT, true);
        return this.diffCommentLists(oldTreeStartPos, oldPrecedingComments, newPrecedingComments, oldD, newD, false, true, false, doNotDelete, localPointer);
    }

    protected int diffTrailingComments(JCTree oldT, JCTree newT, int localPointer, int elementEndWithComments) {
        boolean commentsCreated;
        CommentSet old;
        CommentSet cs = this.getCommentsForTree(newT, false);
        java.util.List<Comment> oldInlineComments = cs == (old = this.getCommentsForTree(oldT, false)) ? ((CommentSetImpl)cs).getOrigComments(CommentSet.RelativePosition.INLINE) : old.getComments(CommentSet.RelativePosition.INLINE);
        java.util.List<Comment> newInlineComments = cs.getComments(CommentSet.RelativePosition.INLINE);
        java.util.List<Comment> oldTrailingComments = cs == old ? ((CommentSetImpl)cs).getOrigComments(CommentSet.RelativePosition.TRAILING) : old.getComments(CommentSet.RelativePosition.TRAILING);
        java.util.List<Comment> newTrailingComments = cs.getComments(CommentSet.RelativePosition.TRAILING);
        boolean sameInline = this.sameComments(oldInlineComments, newInlineComments);
        if (sameInline && this.sameComments(oldTrailingComments, newTrailingComments)) {
            if (oldInlineComments.isEmpty() && oldTrailingComments.isEmpty()) {
                return localPointer;
            }
            int n = localPointer;
            localPointer = elementEndWithComments;
            this.copyTo(n, localPointer);
            return localPointer;
        }
        if (!sameInline) {
            while (this.printer.out.isWhitespaceLine()) {
                this.printer.eatChars(1);
            }
            localPointer = this.diffCommentLists(CasualDiff.getOldPos(oldT), oldInlineComments, newInlineComments, null, null, false, false, false, false, localPointer);
            boolean containedEmbeddedNewLine = false;
            boolean containsEmbeddedNewLine = false;
            for (Comment oldComment : oldInlineComments) {
                if (oldComment.style() != Comment.Style.LINE) continue;
                containedEmbeddedNewLine = true;
            }
            for (Comment nueComment : newInlineComments) {
                if (nueComment.style() != Comment.Style.LINE) continue;
                containsEmbeddedNewLine = true;
            }
            if (containedEmbeddedNewLine && !containsEmbeddedNewLine) {
                this.printer.print("\n");
            }
        }
        int lp = this.diffCommentLists(CasualDiff.getOldPos(oldT), oldTrailingComments, newTrailingComments, null, null, true, false, false, false, localPointer);
        boolean bl = commentsCreated = oldInlineComments.isEmpty() && oldTrailingComments.isEmpty();
        if (commentsCreated) {
            Comment c;
            Comment comment = c = newTrailingComments.isEmpty() ? newInlineComments.get(newInlineComments.size() - 1) : newTrailingComments.get(newTrailingComments.size() - 1);
            if (c.style() != Comment.Style.LINE) {
                while (this.printer.out.isWhitespaceLine()) {
                    this.printer.eatChars(1);
                }
            }
            if (lp > 0 && this.diffContext.origText.charAt(lp - 1) == '\n') {
                this.printer.out.toLineStart();
            }
        }
        return lp;
    }

    private boolean sameComments(java.util.List<Comment> oldList, java.util.List<Comment> newList) {
        Iterator<Comment> oldIter = oldList.iterator();
        Iterator<Comment> newIter = newList.iterator();
        Comment oldC = this.safeNext(oldIter);
        Comment newC = this.safeNext(newIter);
        while (oldC != null && newC != null) {
            if (!this.commentsMatch(oldC, newC)) {
                return false;
            }
            oldC = this.safeNext(oldIter);
            newC = this.safeNext(newIter);
        }
        return !(oldC == null ^ newC == null);
    }

    private int diffCommentLists(int oldTreeStartPos, java.util.List<Comment> oldList, java.util.List<Comment> newList, DocCommentTree oldDoc, DocCommentTree newDoc, boolean trailing, boolean preceding, boolean inner, boolean doNotDeleteIfMissing, int localPointer) {
        int cStart;
        Comment javadoc = null;
        for (Comment comment : oldList) {
            if (comment.style() != Comment.Style.JAVADOC) continue;
            javadoc = comment;
        }
        Iterator<Comment> oldIter = oldList.iterator();
        Iterator<Comment> newIter = newList.iterator();
        Comment oldC = this.safeNext(oldIter);
        Comment newC = this.safeNext(newIter);
        boolean first = true;
        boolean firstNewCommentPrinted = false;
        while (oldC != null && newC != null) {
            cStart = this.commentStartCorrect(oldC);
            if (first && trailing && localPointer < cStart) {
                this.copyTo(localPointer, cStart);
            }
            first = false;
            int nextTarget = Math.max(localPointer, oldC.endPos());
            if (this.commentsMatch(oldC, newC)) {
                if (preceding && oldC == javadoc && oldDoc != null) {
                    localPointer = this.diffDocTree((DCTree.DCDocComment)oldDoc, (DCTree)((Object)oldDoc), (DCTree)((Object)newDoc), new int[]{localPointer, oldC.endPos()});
                }
                if (nextTarget > localPointer) {
                    this.copyTo(localPointer, nextTarget);
                }
                oldC = this.safeNext(oldIter);
                newC = this.safeNext(newIter);
                firstNewCommentPrinted = true;
            } else if (!this.listContains(newList, oldC)) {
                if (!this.listContains(oldList, newC)) {
                    int n = localPointer;
                    localPointer = oldC.pos();
                    this.copyTo(n, localPointer);
                    this.printer.printComment(newC, !trailing, false, true);
                    oldC = this.safeNext(oldIter);
                    newC = this.safeNext(newIter);
                } else {
                    oldC = this.safeNext(oldIter);
                }
            } else {
                if (!firstNewCommentPrinted && preceding) {
                    int n = localPointer;
                    localPointer = oldTreeStartPos;
                    this.copyTo(n, localPointer);
                }
                this.printer.print(newC.getText());
                newC = this.safeNext(newIter);
                firstNewCommentPrinted = true;
            }
            localPointer = nextTarget;
        }
        while (oldC != null) {
            cStart = this.commentStartCorrect(oldC);
            if (first && trailing && localPointer < cStart) {
                this.copyTo(localPointer, cStart);
            }
            if (oldC.style() == Comment.Style.WHITESPACE) {
                localPointer = cStart;
            } else if (first && doNotDeleteIfMissing) {
                localPointer = cStart;
            } else {
                first = false;
                localPointer = Math.max(localPointer, oldC.endPos());
            }
            oldC = this.safeNext(oldIter);
        }
        while (newC != null) {
            if (Comment.Style.WHITESPACE != newC.style()) {
                if (!firstNewCommentPrinted && preceding) {
                    int n = localPointer;
                    localPointer = oldTreeStartPos;
                    this.copyTo(n, localPointer);
                }
                this.printer.printComment(newC, !trailing, false, !preceding && !trailing);
                firstNewCommentPrinted = true;
            }
            newC = this.safeNext(newIter);
        }
        if (preceding && javadoc == null && newDoc != null) {
            if (!firstNewCommentPrinted && preceding) {
                int n = localPointer;
                localPointer = oldTreeStartPos;
                this.copyTo(n, localPointer);
            }
            this.printer.print((DCTree)((Object)newDoc), firstNewCommentPrinted);
        }
        return localPointer;
    }

    private int diffDocTree(DCTree.DCDocComment doc, DCTree oldT, DCTree newT, int[] elementBounds) {
        if (oldT == null && newT != null) {
            throw new IllegalArgumentException("Null is not allowed in parameters.");
        }
        if (oldT == newT) {
            return elementBounds[0];
        }
        if (newT == null) {
            this.tokenSequence.move(elementBounds[1]);
            if (!this.tokenSequence.moveNext()) {
                return elementBounds[1];
            }
            while (this.tokenSequence.token().id() == JavaTokenId.WHITESPACE && this.tokenSequence.moveNext()) {
            }
            return this.tokenSequence.offset();
        }
        int localpointer = elementBounds[0];
        if (oldT.getKind() != newT.getKind()) {
            int[] oldBounds = this.getBounds(oldT, doc);
            if (oldBounds[0] > elementBounds[0]) {
                this.copyTo(elementBounds[0], oldBounds[0]);
            }
            this.printer.print(newT);
            return oldBounds[1];
        }
        switch (oldT.getKind()) {
            case ATTRIBUTE: {
                localpointer = this.diffAttribute(doc, (DCTree.DCAttribute)oldT, (DCTree.DCAttribute)newT, elementBounds);
                break;
            }
            case DOC_COMMENT: {
                localpointer = this.diffDocComment(doc, (DCTree.DCDocComment)oldT, (DCTree.DCDocComment)newT, elementBounds);
                break;
            }
            case PARAM: {
                localpointer = this.diffParam(doc, (DCTree.DCParam)oldT, (DCTree.DCParam)newT, elementBounds);
                break;
            }
            case RETURN: {
                localpointer = this.diffReturn(doc, (DCTree.DCReturn)oldT, (DCTree.DCReturn)newT, elementBounds);
                break;
            }
            case IDENTIFIER: {
                localpointer = this.diffIdentifier(doc, (DCTree.DCIdentifier)oldT, (DCTree.DCIdentifier)newT, elementBounds);
                break;
            }
            case SEE: {
                localpointer = this.diffSee(doc, (DCTree.DCSee)oldT, (DCTree.DCSee)newT, elementBounds);
                break;
            }
            case LINK_PLAIN: 
            case LINK: {
                localpointer = this.diffLink(doc, (DCTree.DCLink)oldT, (DCTree.DCLink)newT, elementBounds);
                break;
            }
            case TEXT: {
                localpointer = this.diffText(doc, (DCTree.DCText)oldT, (DCTree.DCText)newT, elementBounds);
                break;
            }
            case AUTHOR: {
                localpointer = this.diffAuthor(doc, (DCTree.DCAuthor)oldT, (DCTree.DCAuthor)newT, elementBounds);
                break;
            }
            case COMMENT: {
                localpointer = this.diffComment(doc, (DCTree.DCComment)oldT, (DCTree.DCComment)newT, elementBounds);
                break;
            }
            case DEPRECATED: {
                localpointer = this.diffDeprecated(doc, (DCTree.DCDeprecated)oldT, (DCTree.DCDeprecated)newT, elementBounds);
                break;
            }
            case DOC_ROOT: {
                localpointer = this.diffDocRoot(doc, (DCTree.DCDocRoot)oldT, (DCTree.DCDocRoot)newT, elementBounds);
                break;
            }
            case ENTITY: {
                localpointer = this.diffEntity(doc, (DCTree.DCEntity)oldT, (DCTree.DCEntity)newT, elementBounds);
                break;
            }
            case ERRONEOUS: {
                localpointer = this.diffErroneous(doc, (DCTree.DCErroneous)oldT, (DCTree.DCErroneous)newT, elementBounds);
                break;
            }
            case EXCEPTION: 
            case THROWS: {
                localpointer = this.diffThrows(doc, (DCTree.DCThrows)oldT, (DCTree.DCThrows)newT, elementBounds);
                break;
            }
            case INHERIT_DOC: {
                localpointer = this.diffInheritDoc(doc, (DCTree.DCInheritDoc)oldT, (DCTree.DCInheritDoc)newT, elementBounds);
                break;
            }
            case CODE: 
            case LITERAL: {
                localpointer = this.diffLiteral(doc, (DCTree.DCLiteral)oldT, (DCTree.DCLiteral)newT, elementBounds);
                break;
            }
            case REFERENCE: {
                localpointer = this.diffReference(doc, (DCTree.DCReference)oldT, (DCTree.DCReference)newT, elementBounds);
                break;
            }
            case SERIAL: {
                localpointer = this.diffSerial(doc, (DCTree.DCSerial)oldT, (DCTree.DCSerial)newT, elementBounds);
                break;
            }
            case SERIAL_DATA: {
                localpointer = this.diffSerialData(doc, (DCTree.DCSerialData)oldT, (DCTree.DCSerialData)newT, elementBounds);
                break;
            }
            case SERIAL_FIELD: {
                localpointer = this.diffSerialField(doc, (DCTree.DCSerialField)oldT, (DCTree.DCSerialField)newT, elementBounds);
                break;
            }
            case SINCE: {
                localpointer = this.diffSince(doc, (DCTree.DCSince)oldT, (DCTree.DCSince)newT, elementBounds);
                break;
            }
            case START_ELEMENT: {
                localpointer = this.diffStartElement(doc, (DCTree.DCStartElement)oldT, (DCTree.DCStartElement)newT, elementBounds);
                break;
            }
            case END_ELEMENT: {
                localpointer = this.diffEndElement(doc, (DCTree.DCEndElement)oldT, (DCTree.DCEndElement)newT, elementBounds);
                break;
            }
            case UNKNOWN_BLOCK_TAG: {
                localpointer = this.diffUnknownBlockTag(doc, (DCTree.DCUnknownBlockTag)oldT, (DCTree.DCUnknownBlockTag)newT, elementBounds);
                break;
            }
            case UNKNOWN_INLINE_TAG: {
                localpointer = this.diffUnknownInlineTag(doc, (DCTree.DCUnknownInlineTag)oldT, (DCTree.DCUnknownInlineTag)newT, elementBounds);
                break;
            }
            case VALUE: {
                localpointer = this.diffValue(doc, (DCTree.DCValue)oldT, (DCTree.DCValue)newT, elementBounds);
                break;
            }
            case VERSION: {
                localpointer = this.diffVersion(doc, (DCTree.DCVersion)oldT, (DCTree.DCVersion)newT, elementBounds);
                break;
            }
            default: {
                if (oldT.getKind() == DocTree.Kind.OTHER) break;
                String msg = "Diff not implemented: " + oldT.getKind().toString() + " " + oldT.getClass().getName();
                throw new AssertionError((Object)msg);
            }
        }
        return localpointer;
    }

    private int diffAttribute(DCTree.DCDocComment doc, DCTree.DCAttribute oldT, DCTree.DCAttribute newT, int[] elementBounds) {
        return elementBounds[1];
    }

    private int diffDocComment(DCTree.DCDocComment doc, DCTree.DCDocComment oldT, DCTree.DCDocComment newT, int[] elementBounds) {
        int commentEnd;
        this.tokenSequence.move(elementBounds[0]);
        if (!this.tokenSequence.moveNext()) {
            return elementBounds[1];
        }
        while (this.tokenSequence.token().id() == JavaTokenId.WHITESPACE && this.tokenSequence.moveNext()) {
        }
        int localpointer = this.tokenSequence.offset() + 3;
        this.copyTo(elementBounds[0], localpointer);
        if (oldT.firstSentence.isEmpty() && !newT.firstSentence.isEmpty()) {
            this.printer.newline();
            this.printer.toLeftMargin();
            this.printer.print(" * ");
        }
        localpointer = this.diffList(doc, oldT.firstSentence, newT.firstSentence, localpointer, Measure.TAGS);
        localpointer = this.diffList(doc, oldT.body, newT.body, localpointer, Measure.TAGS);
        if (oldT.tags.isEmpty() && localpointer < (commentEnd = CasualDiff.commentEnd(doc))) {
            int n = localpointer;
            localpointer = commentEnd;
            this.copyTo(n, localpointer);
        }
        if ((localpointer = this.diffList(doc, oldT.tags, newT.tags, localpointer, Measure.TAGS)) < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffParam(DCTree.DCDocComment doc, DCTree.DCParam oldT, DCTree.DCParam newT, int[] elementBounds) {
        int localpointer;
        if (oldT.isTypeParameter != newT.isTypeParameter) {
            if (oldT.isTypeParameter) {
                localpointer = this.getOldPos(oldT.name, doc);
                this.copyTo(elementBounds[0], localpointer - 1);
            } else {
                localpointer = this.getOldPos(oldT.name, doc);
                this.copyTo(elementBounds[0], localpointer);
                this.printer.print("<");
            }
        } else {
            localpointer = this.getOldPos(oldT.name, doc);
            this.copyTo(elementBounds[0], localpointer);
        }
        int nameEnd = this.endPos(oldT.name, doc);
        localpointer = this.diffDocTree(doc, oldT.name, newT.name, new int[]{localpointer, nameEnd});
        if (localpointer < nameEnd) {
            int n = localpointer;
            localpointer = nameEnd;
            this.copyTo(n, localpointer);
        }
        if (oldT.isTypeParameter) {
            ++localpointer;
        }
        if (newT.isTypeParameter) {
            this.printer.print(">");
        }
        if ((localpointer = this.diffList(doc, oldT.description, newT.description, localpointer, Measure.TAGS)) < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffReturn(DCTree.DCDocComment doc, DCTree.DCReturn oldT, DCTree.DCReturn newT, int[] elementBounds) {
        int localpointer = oldT.description.isEmpty() ? elementBounds[1] : this.getOldPos(oldT.description.get(0), doc);
        this.copyTo(elementBounds[0], localpointer);
        localpointer = this.diffList(doc, oldT.description, newT.description, localpointer, Measure.TAGS);
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffIdentifier(DCTree.DCDocComment doc, DCTree.DCIdentifier oldT, DCTree.DCIdentifier newT, int[] elementBounds) {
        if (oldT.name.equals(newT.name)) {
            this.copyTo(elementBounds[0], elementBounds[1]);
        } else {
            this.printer.print((Name)newT.name);
        }
        return elementBounds[1];
    }

    private int diffLink(DCTree.DCDocComment doc, DCTree.DCLink oldT, DCTree.DCLink newT, int[] elementBounds) {
        int localpointer = this.getOldPos(oldT.ref, doc);
        this.copyTo(elementBounds[0], localpointer);
        localpointer = this.diffDocTree(doc, oldT.ref, newT.ref, new int[]{localpointer, this.endPos(oldT.ref, doc)});
        localpointer = this.diffList(doc, oldT.label, newT.label, localpointer, Measure.TAGS);
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffSee(DCTree.DCDocComment doc, DCTree.DCSee oldT, DCTree.DCSee newT, int[] elementBounds) {
        int localpointer = this.getOldPos(oldT.reference.get(0), doc);
        this.copyTo(elementBounds[0], localpointer);
        localpointer = this.diffList(doc, oldT.reference, newT.reference, localpointer, Measure.DOCTREE);
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffText(DCTree.DCDocComment doc, DCTree.DCText oldT, DCTree.DCText newT, int[] elementBounds) {
        if (oldT.text.equals(newT.text)) {
            this.copyTo(elementBounds[0], elementBounds[1]);
        } else {
            this.printer.print(newT.text);
        }
        return elementBounds[1];
    }

    private int diffAuthor(DCTree.DCDocComment doc, DCTree.DCAuthor oldT, DCTree.DCAuthor newT, int[] elementBounds) {
        int localpointer = oldT.name.isEmpty() ? elementBounds[1] : this.getOldPos(oldT.name.get(0), doc);
        this.copyTo(elementBounds[0], localpointer);
        localpointer = this.diffList(doc, oldT.name, newT.name, localpointer, Measure.DOCTREE);
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffComment(DCTree.DCDocComment doc, DCTree.DCComment oldT, DCTree.DCComment newT, int[] elementBounds) {
        if (oldT.body.equals(newT.body)) {
            this.copyTo(elementBounds[0], elementBounds[1]);
        } else {
            this.printer.print(newT.body);
        }
        return elementBounds[1];
    }

    private int diffDeprecated(DCTree.DCDocComment doc, DCTree.DCDeprecated oldT, DCTree.DCDeprecated newT, int[] elementBounds) {
        int localpointer = oldT.body.isEmpty() ? elementBounds[1] : this.getOldPos(oldT.body.get(0), doc);
        this.copyTo(elementBounds[0], localpointer);
        localpointer = this.diffList(doc, oldT.body, newT.body, localpointer, Measure.DOCTREE);
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffDocRoot(DCTree.DCDocComment doc, DCTree.DCDocRoot oldT, DCTree.DCDocRoot newT, int[] elementBounds) {
        this.copyTo(elementBounds[0], elementBounds[1]);
        return elementBounds[1];
    }

    private int diffEntity(DCTree.DCDocComment doc, DCTree.DCEntity oldT, DCTree.DCEntity newT, int[] elementBounds) {
        if (oldT.name.equals(newT.name)) {
            this.copyTo(elementBounds[0], elementBounds[1]);
        } else {
            this.printer.print(newT);
        }
        return elementBounds[1];
    }

    private int diffErroneous(DCTree.DCDocComment doc, DCTree.DCErroneous oldT, DCTree.DCErroneous newT, int[] elementBounds) {
        if (oldT.body.equals(newT.body)) {
            this.copyTo(elementBounds[0], elementBounds[1]);
        } else {
            this.printer.print(newT.body);
        }
        return elementBounds[1];
    }

    private int diffThrows(DCTree.DCDocComment doc, DCTree.DCThrows oldT, DCTree.DCThrows newT, int[] elementBounds) {
        int localpointer = this.getOldPos(oldT.name, doc);
        this.copyTo(elementBounds[0], localpointer);
        int endPos = this.endPos(oldT.name, doc);
        localpointer = this.diffDocTree(doc, oldT.name, newT.name, new int[]{localpointer, endPos});
        if (localpointer < endPos) {
            int n = localpointer;
            localpointer = endPos;
            this.copyTo(n, localpointer);
        }
        if ((localpointer = this.diffList(doc, oldT.description, newT.description, localpointer, Measure.TAGS)) < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffInheritDoc(DCTree.DCDocComment doc, DCTree.DCInheritDoc oldT, DCTree.DCInheritDoc newT, int[] elementBounds) {
        this.copyTo(elementBounds[0], elementBounds[1]);
        return elementBounds[1];
    }

    private int diffLiteral(DCTree.DCDocComment doc, DCTree.DCLiteral oldT, DCTree.DCLiteral newT, int[] elementBounds) {
        int localpointer = this.getOldPos(oldT.body, doc);
        this.copyTo(elementBounds[0], localpointer);
        localpointer = this.diffDocTree(doc, oldT.body, newT.body, new int[]{localpointer, this.endPos(oldT.body, doc)});
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffReference(DCTree.DCDocComment doc, DCTree.DCReference oldT, DCTree.DCReference newT, int[] elementBounds) {
        this.printer.print(newT);
        return elementBounds[1];
    }

    private int diffSerial(DCTree.DCDocComment doc, DCTree.DCSerial oldT, DCTree.DCSerial newT, int[] elementBounds) {
        int localpointer = this.getOldPos(oldT.description.get(0), doc);
        this.copyTo(elementBounds[0], localpointer);
        localpointer = this.diffList(doc, oldT.description, newT.description, localpointer, Measure.TAGS);
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffSerialData(DCTree.DCDocComment doc, DCTree.DCSerialData oldT, DCTree.DCSerialData newT, int[] elementBounds) {
        int localpointer = this.getOldPos(oldT.description.get(0), doc);
        this.copyTo(elementBounds[0], localpointer);
        localpointer = this.diffList(doc, oldT.description, newT.description, localpointer, Measure.TAGS);
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffSerialField(DCTree.DCDocComment doc, DCTree.DCSerialField oldT, DCTree.DCSerialField newT, int[] elementBounds) {
        int localpointer = this.getOldPos(oldT.name, doc);
        this.copyTo(elementBounds[0], localpointer);
        localpointer = this.diffDocTree(doc, oldT.name, newT.name, new int[]{localpointer, this.endPos(oldT.name, doc)});
        localpointer = this.diffDocTree(doc, oldT.type, newT.type, new int[]{localpointer, this.endPos(oldT.type, doc)});
        localpointer = this.diffList(doc, oldT.description, newT.description, localpointer, Measure.TAGS);
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffSince(DCTree.DCDocComment doc, DCTree.DCSince oldT, DCTree.DCSince newT, int[] elementBounds) {
        int localpointer = oldT.body.isEmpty() ? elementBounds[1] : this.getOldPos(oldT.body.get(0), doc);
        this.copyTo(elementBounds[0], localpointer);
        localpointer = this.diffList(doc, oldT.body, newT.body, localpointer, Measure.DOCTREE);
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffStartElement(DCTree.DCDocComment doc, DCTree.DCStartElement oldT, DCTree.DCStartElement newT, int[] elementBounds) {
        int localpointer;
        int n = localpointer = oldT.attrs.isEmpty() ? elementBounds[1] - 1 : this.getOldPos(oldT.attrs.get(0), doc);
        if (oldT.name.equals(newT.name)) {
            this.copyTo(elementBounds[0], localpointer);
        } else {
            this.printer.print("<");
            this.printer.print((Name)newT.name);
        }
        localpointer = this.diffList(doc, oldT.attrs, newT.attrs, localpointer, Measure.DOCTREE);
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffEndElement(DCTree.DCDocComment doc, DCTree.DCEndElement oldT, DCTree.DCEndElement newT, int[] elementBounds) {
        if (oldT.name.equals(newT.name)) {
            this.copyTo(elementBounds[0], elementBounds[1]);
        } else {
            this.printer.print(newT);
        }
        return elementBounds[1];
    }

    private int diffUnknownBlockTag(DCTree.DCDocComment doc, DCTree.DCUnknownBlockTag oldT, DCTree.DCUnknownBlockTag newT, int[] elementBounds) {
        int localpointer;
        int n = localpointer = oldT.content.isEmpty() ? elementBounds[1] : this.getOldPos(oldT.content.get(0), doc);
        if (oldT.name.equals(newT.name)) {
            this.copyTo(elementBounds[0], localpointer);
        } else {
            this.printer.print("@");
            this.printer.print((Name)newT.name);
            this.printer.out.needSpace();
        }
        localpointer = this.diffList(doc, oldT.content, newT.content, localpointer, Measure.DOCTREE);
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffUnknownInlineTag(DCTree.DCDocComment doc, DCTree.DCUnknownInlineTag oldT, DCTree.DCUnknownInlineTag newT, int[] elementBounds) {
        int localpointer;
        int n = localpointer = oldT.content.isEmpty() ? elementBounds[1] : this.getOldPos(oldT.content.get(0), doc);
        if (oldT.name.equals(newT.name)) {
            this.copyTo(elementBounds[0], localpointer);
        } else {
            this.printer.print("{@");
            this.printer.print((Name)newT.name);
            this.printer.out.needSpace();
        }
        localpointer = this.diffList(doc, oldT.content, newT.content, localpointer, Measure.DOCTREE);
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffValue(DCTree.DCDocComment doc, DCTree.DCValue oldT, DCTree.DCValue newT, int[] elementBounds) {
        int localpointer = this.getOldPos(oldT.ref, doc);
        this.copyTo(elementBounds[0], localpointer);
        localpointer = this.diffDocTree(doc, oldT.ref, newT.ref, new int[]{localpointer, this.endPos(oldT.ref, doc)});
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffVersion(DCTree.DCDocComment doc, DCTree.DCVersion oldT, DCTree.DCVersion newT, int[] elementBounds) {
        int localpointer = oldT.body.isEmpty() ? elementBounds[1] : this.getOldPos(oldT.body.get(0), doc);
        this.copyTo(elementBounds[0], localpointer);
        localpointer = this.diffList(doc, oldT.body, newT.body, localpointer, Measure.DOCTREE);
        if (localpointer < elementBounds[1]) {
            this.copyTo(localpointer, elementBounds[1]);
        }
        return elementBounds[1];
    }

    private int diffList(DCTree.DCDocComment doc, java.util.List<? extends DCTree> oldList, java.util.List<? extends DCTree> newList, int localPointer, Comparator<DCTree> measure) {
        assert (oldList != null && newList != null);
        if (oldList == newList || oldList.equals(newList)) {
            return localPointer;
        }
        ListMatcher<DCTree> matcher = ListMatcher.instance(oldList, newList, measure);
        if (!matcher.match()) {
            return localPointer;
        }
        DCTree lastdel = null;
        ListMatcher.ResultItem<DCTree>[] result = matcher.getResult();
        if (oldList.isEmpty() && !newList.isEmpty()) {
            StringBuilder aHead = new StringBuilder();
            StringBuilder aTail = new StringBuilder();
            this.printer.out.needSpace();
            for (DCTree dCTree : newList) {
                this.printer.print(dCTree);
            }
            return localPointer;
        }
        if (newList.isEmpty() && !oldList.isEmpty()) {
            int oldPos = this.adjustToPreviousNewLine(this.getOldPos(oldList.get(0), doc), localPointer);
            this.copyTo(localPointer, oldPos);
            return this.endPos(oldList, doc);
        }
        int insertPos = this.adjustToPreviousNewLine(this.getOldPos(oldList.get(0), doc), localPointer);
        if (insertPos > localPointer) {
            int n = localPointer;
            localPointer = insertPos;
            this.copyTo(n, localPointer);
        }
        int i = 0;
        block7: for (int j = 0; j < result.length; ++j) {
            ListMatcher.ResultItem<DCTree> resultItem = result[j];
            switch (resultItem.operation) {
                case MODIFY: {
                    DCTree oldT = oldList.get(i);
                    int[] pos = this.getBounds(oldT, doc);
                    this.copyTo(localPointer, pos[0]);
                    localPointer = this.diffDocTree(doc, oldT, (DCTree)resultItem.element, pos);
                    ++i;
                    continue block7;
                }
                case INSERT: {
                    int oldPos = ((DCTree)resultItem.element).pos;
                    boolean found = false;
                    if (oldPos > 0) {
                        for (DCTree dCTree : oldList) {
                            int oldNodePos = dCTree.pos;
                            if (oldPos != oldNodePos) continue;
                            found = true;
                            VeryPretty oldPrinter = this.printer;
                            int old = oldPrinter.indent();
                            this.printer = new VeryPretty(this.diffContext, this.diffContext.style, this.tree2Tag, this.tree2Doc, this.tag2Span, this.origText, oldPrinter.toString().length() + oldPrinter.getInitialOffset());
                            this.printer.reset(old, oldPrinter.out.getCol());
                            this.printer.oldTrees = this.oldTrees;
                            int[] poss = this.getBounds(dCTree, doc);
                            int end = this.diffDocTree(doc, dCTree, (DCTree)resultItem.element, poss);
                            this.copyTo(end, poss[1]);
                            this.printer.print(this.printer.toString());
                            this.printer.reindentRegions.addAll(this.printer.reindentRegions);
                            this.printer = oldPrinter;
                            this.printer.undent(old);
                            break;
                        }
                    }
                    if (found) continue block7;
                    this.printer.print((DCTree)resultItem.element);
                    continue block7;
                }
                case DELETE: {
                    DCTree oldT;
                    lastdel = oldT = oldList.get(i);
                    int[] pos = this.getBounds(oldT, doc);
                    localPointer = pos[1];
                    ++i;
                    continue block7;
                }
                case NOCHANGE: {
                    DCTree oldT = oldList.get(i);
                    int[] pos = this.getBounds(oldT, doc);
                    if (this.needStar(pos[0])) {
                        this.printer.print(" * ");
                    }
                    int n = localPointer;
                    localPointer = pos[1];
                    this.copyTo(n, localPointer, this.printer);
                    lastdel = null;
                    ++i;
                    continue block7;
                }
            }
        }
        return localPointer;
    }

    private Comment safeNext(Iterator<Comment> iter) {
        return iter.hasNext() ? iter.next() : null;
    }

    private boolean commentsMatch(Comment oldC, Comment newC) {
        if (oldC == null && newC == null) {
            return true;
        }
        if (oldC == null || newC == null) {
            return false;
        }
        return oldC.equals(newC);
    }

    private boolean listContains(java.util.List<Comment> list, Comment comment) {
        for (Comment c : list) {
            if (!c.equals(comment)) continue;
            return true;
        }
        return false;
    }

    private int commentStartCorrect(Comment c) {
        this.tokenSequence.move(c.pos());
        boolean wasPrevious = false;
        while (this.tokenSequence.movePrevious()) {
            if (this.tokenSequence.token().id() != JavaTokenId.WHITESPACE) {
                return this.tokenSequence.offset() + this.tokenSequence.token().length();
            }
            int lastNewLine = this.tokenSequence.token().text().toString().lastIndexOf(10);
            if (lastNewLine != -1) {
                return this.tokenSequence.offset() + lastNewLine + 1;
            }
            wasPrevious = true;
        }
        if (wasPrevious) {
            return this.tokenSequence.offset();
        }
        return c.pos();
    }

    public static int commentStart(DiffContext diffContext, CommentSet comments, CommentSet.RelativePosition pos, int limit) {
        java.util.List<Comment> list = comments.getComments(pos);
        if (list.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        diffContext.tokenSequence.move(limit);
        PositionEstimator.moveToSrcRelevant(diffContext.tokenSequence, PositionEstimator.Direction.BACKWARD);
        limit = diffContext.tokenSequence.offset() + diffContext.tokenSequence.token().length();
        int start = Integer.MAX_VALUE;
        for (Comment c : list) {
            if (c.pos() < limit) continue;
            start = Math.min(start, c.pos());
        }
        return start;
    }

    public static int commentEnd(CommentSet comments, CommentSet.RelativePosition pos) {
        java.util.List<Comment> list = comments.getComments(pos);
        if (list.isEmpty()) {
            return -1;
        }
        return list.get(list.size() - 1).endPos();
    }

    private static int commentEnd(DCTree.DCDocComment doc) {
        int length = doc.comment.getText().length();
        return doc.comment.getSourcePos(length - 1);
    }

    private static int getOldPos(JCTree oldT) {
        return TreeInfo.getStartPos(oldT);
    }

    private int getOldPos(DCTree oldT, DCTree.DCDocComment doc) {
        return oldT.pos(doc).getStartPosition();
    }

    public int endPos(DCTree oldT, DCTree.DCDocComment doc) {
        DocSourcePositions sp = JavacTrees.instance(this.context).getSourcePositions();
        return (int)sp.getEndPosition(null, doc, oldT);
    }

    private int endPos(java.util.List<? extends DCTree> trees, DCTree.DCDocComment doc) {
        if (trees.isEmpty()) {
            return -1;
        }
        return this.endPos(trees.get(trees.size() - 1), doc);
    }

    protected int diffTree(JCTree oldT, JCTree newT, int[] elementBounds) {
        return this.checkLocalPointer(oldT, newT, this.diffTree(oldT, newT, null, elementBounds));
    }

    int diffTree(TreePath oldPath, JCTree newT, int[] elementBounds) {
        JCTree oldT = (JCTree)oldPath.getLeaf();
        this.currentPath = oldPath;
        JCTree parent = (JCTree)(oldPath.getParentPath() == null ? null : oldPath.getParentPath().getLeaf());
        return this.diffTree(oldT, newT, parent, elementBounds);
    }

    protected int diffTree(JCTree oldT, JCTree newT, JCTree parent, int[] elementBounds) {
        int result;
        TreePath savePath = this.currentPath;
        Object t = this.tree2Tag.get(newT);
        if (this.currentPath != null && this.currentPath.getLeaf() != oldT) {
            this.currentPath = new TreePath(this.currentPath, oldT);
        }
        if (t != null) {
            int start = this.printer.toString().length();
            result = this.diffTreeImpl(oldT, newT, parent, elementBounds);
            int end = this.printer.toString().length();
            this.tag2Span.put(t, new int[]{start + this.printer.getInitialOffset(), end + this.printer.getInitialOffset()});
        } else {
            result = this.diffTreeImpl(oldT, newT, parent, elementBounds);
        }
        this.currentPath = savePath;
        return result;
    }

    private int getPosAfterCommentEnd(Tree t, int minPos) {
        CommentSet cs = this.getCommentsForTree(t, false);
        java.util.List<Comment> cmm = cs.getComments(CommentSet.RelativePosition.TRAILING);
        if (cmm.isEmpty()) {
            cmm = cs.getComments(CommentSet.RelativePosition.INLINE);
        }
        if (cmm.isEmpty()) {
            return minPos;
        }
        Comment c = cmm.get(cmm.size() - 1);
        int pos = c.endPos();
        assert (pos >= 0);
        if ((c.style() == Comment.Style.LINE || c.style() == Comment.Style.WHITESPACE) && pos > 0 && this.diffContext.origText.charAt(pos - 1) == '\n') {
            --pos;
        }
        return Math.max(minPos, pos);
    }

    private int getPosAfterCommentStart(Tree t, int minPos) {
        CommentSet cs = this.getCommentsForTree(t, true);
        java.util.List<Comment> cmm = cs.getComments(CommentSet.RelativePosition.PRECEDING);
        if (cmm.isEmpty()) {
            cmm = cs.getComments(CommentSet.RelativePosition.INNER);
        }
        if (cmm.isEmpty()) {
            return minPos;
        }
        Comment c = cmm.get(cmm.size() - 1);
        int pos = c.endPos();
        assert (pos >= 0);
        return Math.max(minPos, pos);
    }

    private int getPosAfterTreeComments(JCTree t, int end) {
        class Scn
        extends ErrorAwareTreeScanner<Void, Void> {
            int max = -1;

            Scn() {
            }

            @Override
            public Void scan(Tree node, Void p) {
                this.max = Math.max(CasualDiff.this.getPosAfterCommentEnd((JCTree)node, -1), this.max);
                return (Void)super.scan(node, p);
            }
        }
        Scn scn = new Scn();
        scn.scan((Tree)t, null);
        return Math.max(scn.max, end);
    }

    protected int diffTreeImpl(JCTree oldT, JCTree newT, JCTree parent, int[] elementBounds) {
        boolean saveInnerComments = this.innerCommentsProcessed;
        JCTree saveParent = this.parent;
        this.parent = parent;
        int ret = this.diffTreeImpl0(oldT, newT, parent, elementBounds);
        this.innerCommentsProcessed = saveInnerComments;
        this.parent = saveParent;
        return ret;
    }

    private int diffTreeImpl0(JCTree oldT, JCTree newT, JCTree parent, int[] elementBounds) {
        boolean handleImplicitLambda;
        this.innerCommentsProcessed = false;
        if (oldT == null && newT != null) {
            throw new IllegalArgumentException("Null is not allowed in parameters.");
        }
        if (oldT == newT) {
            this.copyTo(elementBounds[0], elementBounds[1]);
            return elementBounds[1];
        }
        if (newT == null) {
            this.tokenSequence.move(elementBounds[1]);
            if (!this.tokenSequence.moveNext()) {
                return elementBounds[1];
            }
            while (this.tokenSequence.token().id() == JavaTokenId.WHITESPACE && this.tokenSequence.moveNext()) {
            }
            return this.tokenSequence.offset();
        }
        if (this.printer.handlePossibleOldTrees(Collections.singletonList(newT), true)) {
            return this.getCommentCorrectedEndPos(oldT);
        }
        boolean bl = handleImplicitLambda = parent != null && parent.hasTag(JCTree.Tag.LAMBDA) && ((JCTree.JCLambda)parent).params.size() == 1 && ((JCTree.JCLambda)parent).params.get(0) == oldT && ((JCTree.JCLambda)parent).paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT && newT.hasTag(JCTree.Tag.VARDEF) && ((JCTree.JCVariableDecl)newT).getType() != null;
        if (handleImplicitLambda) {
            this.tokenSequence.move(CasualDiff.getOldPos(parent));
            if (this.tokenSequence.moveNext() && this.tokenSequence.token().id() == JavaTokenId.LPAREN) {
                handleImplicitLambda = false;
            } else {
                this.printer.print("(");
            }
        }
        if (!(oldT.getTag() == newT.getTag() || compAssign.contains((Object)oldT.getKind()) && compAssign.contains((Object)newT.getKind()) || binaries.contains((Object)oldT.getKind()) && binaries.contains((Object)newT.getKind()) || unaries.contains((Object)oldT.getKind()) && unaries.contains((Object)newT.getKind()))) {
            int[] oldBounds = this.getBounds(oldT);
            elementBounds[0] = this.getPosAfterCommentStart(oldT, elementBounds[0]);
            if (oldBounds[0] > elementBounds[0]) {
                this.copyTo(elementBounds[0], oldBounds[0]);
            }
            this.printer.print(newT);
            return this.getPosAfterTreeComments(oldT, oldBounds[1]);
        }
        int predComments = this.diffPrecedingComments(oldT, newT, CasualDiff.getOldPos(oldT), elementBounds[0], oldT.getTag() == JCTree.Tag.TOPLEVEL && this.diffContext.forceInitialComment);
        int retVal = -1;
        elementBounds[0] = Math.abs(predComments);
        int elementEnd = elementBounds[1];
        int commentsStart = Math.min(CasualDiff.commentStart(this.diffContext, this.comments.getComments(oldT), CommentSet.RelativePosition.INLINE, this.endPos(oldT)), CasualDiff.commentStart(this.diffContext, this.comments.getComments(oldT), CommentSet.RelativePosition.TRAILING, this.endPos(oldT)));
        if (commentsStart < elementBounds[1]) {
            int lastIndex;
            this.tokenSequence.move(commentsStart);
            elementBounds = Arrays.copyOf(elementBounds, elementBounds.length);
            elementBounds[1] = this.tokenSequence.movePrevious() && this.tokenSequence.token().id() == JavaTokenId.WHITESPACE && (lastIndex = this.tokenSequence.token().text().toString().lastIndexOf(10)) > -1 ? this.tokenSequence.offset() + lastIndex + 1 : commentsStart;
        }
        switch (oldT.getTag()) {
            case TOPLEVEL: {
                this.diffTopLevel((JCTree.JCCompilationUnit)oldT, (JCTree.JCCompilationUnit)newT, elementBounds);
                break;
            }
            case MODULEDEF: {
                retVal = this.diffModuleDef((JCTree.JCModuleDecl)oldT, (JCTree.JCModuleDecl)newT, elementBounds);
                break;
            }
            case REQUIRES: {
                retVal = this.diffRequires((JCTree.JCRequires)oldT, (JCTree.JCRequires)newT, elementBounds);
                break;
            }
            case EXPORTS: {
                retVal = this.diffExports((JCTree.JCExports)oldT, (JCTree.JCExports)newT, elementBounds);
                break;
            }
            case OPENS: {
                retVal = this.diffOpens((JCTree.JCOpens)oldT, (JCTree.JCOpens)newT, elementBounds);
                break;
            }
            case PROVIDES: {
                retVal = this.diffProvides((JCTree.JCProvides)oldT, (JCTree.JCProvides)newT, elementBounds);
                break;
            }
            case USES: {
                retVal = this.diffUses((JCTree.JCUses)oldT, (JCTree.JCUses)newT, elementBounds);
                break;
            }
            case PACKAGEDEF: {
                retVal = this.diffPackage((JCTree.JCPackageDecl)oldT, (JCTree.JCPackageDecl)newT, CasualDiff.getOldPos(oldT));
                break;
            }
            case IMPORT: {
                retVal = this.diffImport((JCTree.JCImport)oldT, (JCTree.JCImport)newT, elementBounds);
                break;
            }
            case CLASSDEF: {
                retVal = this.diffClassDef((JCTree.JCClassDecl)oldT, (JCTree.JCClassDecl)newT, elementBounds);
                break;
            }
            case METHODDEF: {
                retVal = this.diffMethodDef((JCTree.JCMethodDecl)oldT, (JCTree.JCMethodDecl)newT, elementBounds);
                break;
            }
            case VARDEF: {
                retVal = this.diffVarDef((JCTree.JCVariableDecl)oldT, (JCTree.JCVariableDecl)newT, elementBounds);
                break;
            }
            case SKIP: {
                this.copyTo(elementBounds[0], elementBounds[1]);
                retVal = elementBounds[1];
                break;
            }
            case BLOCK: {
                retVal = this.diffBlock((JCTree.JCBlock)oldT, (JCTree.JCBlock)newT, elementBounds);
                break;
            }
            case DOLOOP: {
                retVal = this.diffDoLoop((JCTree.JCDoWhileLoop)oldT, (JCTree.JCDoWhileLoop)newT, elementBounds);
                break;
            }
            case WHILELOOP: {
                retVal = this.diffWhileLoop((JCTree.JCWhileLoop)oldT, (JCTree.JCWhileLoop)newT, elementBounds);
                break;
            }
            case FORLOOP: {
                retVal = this.diffForLoop((JCTree.JCForLoop)oldT, (JCTree.JCForLoop)newT, elementBounds);
                break;
            }
            case FOREACHLOOP: {
                retVal = this.diffForeachLoop((JCTree.JCEnhancedForLoop)oldT, (JCTree.JCEnhancedForLoop)newT, elementBounds);
                break;
            }
            case LABELLED: {
                retVal = this.diffLabelled((JCTree.JCLabeledStatement)oldT, (JCTree.JCLabeledStatement)newT, elementBounds);
                break;
            }
            case SWITCH: {
                retVal = this.diffSwitch((JCTree.JCSwitch)oldT, (JCTree.JCSwitch)newT, elementBounds);
                break;
            }
            case CASE: {
                retVal = this.diffCase((JCTree.JCCase)oldT, (JCTree.JCCase)newT, elementBounds);
                break;
            }
            case SYNCHRONIZED: {
                retVal = this.diffSynchronized((JCTree.JCSynchronized)oldT, (JCTree.JCSynchronized)newT, elementBounds);
                break;
            }
            case TRY: {
                retVal = this.diffTry((JCTree.JCTry)oldT, (JCTree.JCTry)newT, elementBounds);
                break;
            }
            case CATCH: {
                retVal = this.diffCatch((JCTree.JCCatch)oldT, (JCTree.JCCatch)newT, elementBounds);
                break;
            }
            case CONDEXPR: {
                retVal = this.diffConditional((JCTree.JCConditional)oldT, (JCTree.JCConditional)newT, elementBounds);
                break;
            }
            case IF: {
                retVal = this.diffIf((JCTree.JCIf)oldT, (JCTree.JCIf)newT, elementBounds);
                break;
            }
            case EXEC: {
                retVal = this.diffExec((JCTree.JCExpressionStatement)oldT, (JCTree.JCExpressionStatement)newT, elementBounds);
                break;
            }
            case BREAK: {
                retVal = this.diffBreak((JCTree.JCBreak)oldT, (JCTree.JCBreak)newT, elementBounds);
                break;
            }
            case CONTINUE: {
                retVal = this.diffContinue((JCTree.JCContinue)oldT, (JCTree.JCContinue)newT, elementBounds);
                break;
            }
            case RETURN: {
                retVal = this.diffReturn((JCTree.JCReturn)oldT, (JCTree.JCReturn)newT, elementBounds);
                break;
            }
            case THROW: {
                retVal = this.diffThrow((JCTree.JCThrow)oldT, (JCTree.JCThrow)newT, elementBounds);
                break;
            }
            case ASSERT: {
                retVal = this.diffAssert((JCTree.JCAssert)oldT, (JCTree.JCAssert)newT, elementBounds);
                break;
            }
            case APPLY: {
                retVal = this.diffApply((JCTree.JCMethodInvocation)oldT, (JCTree.JCMethodInvocation)newT, elementBounds);
                break;
            }
            case NEWCLASS: {
                retVal = this.diffNewClass((JCTree.JCNewClass)oldT, (JCTree.JCNewClass)newT, elementBounds);
                break;
            }
            case NEWARRAY: {
                retVal = this.diffNewArray((JCTree.JCNewArray)oldT, (JCTree.JCNewArray)newT, elementBounds);
                break;
            }
            case PARENS: {
                retVal = this.diffParens((JCTree.JCParens)oldT, (JCTree.JCParens)newT, elementBounds);
                break;
            }
            case ASSIGN: {
                retVal = this.diffAssign((JCTree.JCAssign)oldT, (JCTree.JCAssign)newT, parent, elementBounds);
                break;
            }
            case TYPECAST: {
                retVal = this.diffTypeCast((JCTree.JCTypeCast)oldT, (JCTree.JCTypeCast)newT, elementBounds);
                break;
            }
            case TYPETEST: {
                retVal = this.diffTypeTest((JCTree.JCInstanceOf)oldT, (JCTree.JCInstanceOf)newT, elementBounds);
                break;
            }
            case INDEXED: {
                retVal = this.diffIndexed((JCTree.JCArrayAccess)oldT, (JCTree.JCArrayAccess)newT, elementBounds);
                break;
            }
            case SELECT: {
                retVal = this.diffSelect((JCTree.JCFieldAccess)oldT, (JCTree.JCFieldAccess)newT, elementBounds);
                break;
            }
            case IDENT: {
                retVal = this.diffIdent((JCTree.JCIdent)oldT, (JCTree.JCIdent)newT, elementBounds);
                break;
            }
            case LITERAL: {
                retVal = this.diffLiteral((JCTree.JCLiteral)oldT, (JCTree.JCLiteral)newT, elementBounds);
                break;
            }
            case TYPEIDENT: {
                retVal = this.diffTypeIdent((JCTree.JCPrimitiveTypeTree)oldT, (JCTree.JCPrimitiveTypeTree)newT, elementBounds);
                break;
            }
            case TYPEARRAY: {
                retVal = this.diffTypeArray((JCTree.JCArrayTypeTree)oldT, (JCTree.JCArrayTypeTree)newT, elementBounds);
                break;
            }
            case TYPEAPPLY: {
                retVal = this.diffTypeApply((JCTree.JCTypeApply)oldT, (JCTree.JCTypeApply)newT, elementBounds);
                break;
            }
            case TYPEPARAMETER: {
                retVal = this.diffTypeParameter((JCTree.JCTypeParameter)oldT, (JCTree.JCTypeParameter)newT, elementBounds);
                break;
            }
            case WILDCARD: {
                retVal = this.diffWildcard((JCTree.JCWildcard)oldT, (JCTree.JCWildcard)newT, elementBounds);
                break;
            }
            case TYPEBOUNDKIND: {
                retVal = this.diffTypeBoundKind((JCTree.TypeBoundKind)oldT, (JCTree.TypeBoundKind)newT, elementBounds);
                break;
            }
            case ANNOTATION: 
            case TYPE_ANNOTATION: {
                retVal = this.diffAnnotation((JCTree.JCAnnotation)oldT, (JCTree.JCAnnotation)newT, elementBounds);
                break;
            }
            case LETEXPR: {
                this.diffLetExpr((JCTree.LetExpr)oldT, (JCTree.LetExpr)newT);
                break;
            }
            case POS: 
            case NEG: 
            case NOT: 
            case COMPL: 
            case PREINC: 
            case PREDEC: 
            case POSTINC: 
            case POSTDEC: 
            case NULLCHK: {
                retVal = this.diffUnary((JCTree.JCUnary)oldT, (JCTree.JCUnary)newT, elementBounds);
                break;
            }
            case OR: 
            case AND: 
            case BITOR: 
            case BITXOR: 
            case BITAND: 
            case EQ: 
            case NE: 
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case SL: 
            case SR: 
            case USR: 
            case PLUS: 
            case MINUS: 
            case MUL: 
            case DIV: 
            case MOD: {
                retVal = this.diffBinary((JCTree.JCBinary)oldT, (JCTree.JCBinary)newT, elementBounds);
                break;
            }
            case BITOR_ASG: 
            case BITXOR_ASG: 
            case BITAND_ASG: 
            case SL_ASG: 
            case SR_ASG: 
            case USR_ASG: 
            case PLUS_ASG: 
            case MINUS_ASG: 
            case MUL_ASG: 
            case DIV_ASG: 
            case MOD_ASG: {
                retVal = this.diffAssignop((JCTree.JCAssignOp)oldT, (JCTree.JCAssignOp)newT, elementBounds);
                break;
            }
            case ERRONEOUS: {
                retVal = this.diffErroneous((JCTree.JCErroneous)oldT, (JCTree.JCErroneous)newT, elementBounds);
                break;
            }
            case MODIFIERS: {
                retVal = this.diffModifiers((JCTree.JCModifiers)oldT, (JCTree.JCModifiers)newT, parent, elementBounds[0]);
                this.copyTo(retVal, elementBounds[1]);
                break;
            }
            case TYPEUNION: {
                retVal = this.diffUnionType((JCTree.JCTypeUnion)oldT, (JCTree.JCTypeUnion)newT, elementBounds);
                break;
            }
            case LAMBDA: {
                retVal = this.diffLambda((JCTree.JCLambda)oldT, (JCTree.JCLambda)newT, elementBounds);
                break;
            }
            case REFERENCE: {
                retVal = this.diffMemberReference((JCTree.JCMemberReference)oldT, (JCTree.JCMemberReference)newT, elementBounds);
                break;
            }
            case ANNOTATED_TYPE: {
                retVal = this.diffAnnotatedType((JCTree.JCAnnotatedType)oldT, (JCTree.JCAnnotatedType)newT, elementBounds);
                break;
            }
            case SWITCH_EXPRESSION: {
                retVal = this.diffSwitchExpression((JCTree.JCSwitchExpression)oldT, (JCTree.JCSwitchExpression)newT, elementBounds);
                break;
            }
            case BINDINGPATTERN: {
                retVal = this.diffBindingPattern((JCTree.JCBindingPattern)oldT, (JCTree.JCBindingPattern)newT, elementBounds);
                break;
            }
            case DEFAULTCASELABEL: {
                this.copyTo(elementBounds[0], elementBounds[1]);
                retVal = elementBounds[1];
                break;
            }
            case CONSTANTCASELABEL: {
                retVal = this.diffConstantCaseLabel((JCTree.JCConstantCaseLabel)oldT, (JCTree.JCConstantCaseLabel)newT, elementBounds);
                break;
            }
            case RECORDPATTERN: {
                retVal = this.diffRecordPattern((JCTree.JCRecordPattern)oldT, (JCTree.JCRecordPattern)newT, elementBounds);
                break;
            }
            default: {
                if (oldT.getKind() == Tree.Kind.OTHER) {
                    if (!(oldT instanceof FieldGroupTree)) break;
                    return this.diffFieldGroup((FieldGroupTree)oldT, (FieldGroupTree)newT, elementBounds);
                }
                String msg = "Diff not implemented: " + oldT.getKind().toString() + " " + oldT.getClass().getName();
                throw new AssertionError((Object)msg);
            }
        }
        if (handleImplicitLambda) {
            this.printer.print(")");
        }
        if (!this.innerCommentsProcessed) {
            retVal = this.diffInnerComments(oldT, newT, retVal);
        }
        int endComment = this.getCommentCorrectedEndPos(oldT);
        return this.diffTrailingComments(oldT, newT, retVal, endComment);
    }

    protected boolean listsMatch(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList) {
        if (oldList == newList) {
            return true;
        }
        int n = oldList.size();
        if (newList.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.treesMatch(oldList.get(i), newList.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matchImport(JCTree.JCImport t1, JCTree.JCImport t2) {
        return t1.staticImport == t2.staticImport && this.treesMatch(t1.qualid, t2.qualid);
    }

    private boolean matchBlock(JCTree.JCBlock t1, JCTree.JCBlock t2) {
        return t1.flags == t2.flags && this.listsMatch(t1.stats, t2.stats);
    }

    private boolean matchDoLoop(JCTree.JCDoWhileLoop t1, JCTree.JCDoWhileLoop t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchWhileLoop(JCTree.JCWhileLoop t1, JCTree.JCWhileLoop t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchForLoop(JCTree.JCForLoop t1, JCTree.JCForLoop t2) {
        return this.listsMatch(t1.init, t2.init) && this.treesMatch(t1.cond, t2.cond) && this.listsMatch(t1.step, t2.step) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchForeachLoop(JCTree.JCEnhancedForLoop t1, JCTree.JCEnhancedForLoop t2) {
        return this.treesMatch(t1.var, t2.var) && this.treesMatch(t1.expr, t2.expr) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchLabelled(JCTree.JCLabeledStatement t1, JCTree.JCLabeledStatement t2) {
        return t1.label == t2.label && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchSwitch(JCTree.JCSwitch t1, JCTree.JCSwitch t2) {
        return this.treesMatch(t1.selector, t2.selector) && this.listsMatch(t1.cases, t2.cases);
    }

    private boolean matchCase(JCTree.JCCase t1, JCTree.JCCase t2) {
        return this.listsMatch(t1.labels, t2.labels) && this.listsMatch(t1.stats, t2.stats);
    }

    private boolean matchSynchronized(JCTree.JCSynchronized t1, JCTree.JCSynchronized t2) {
        return this.treesMatch(t1.lock, t2.lock) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchTry(JCTree.JCTry t1, JCTree.JCTry t2) {
        return this.treesMatch(t1.finalizer, t2.finalizer) && this.listsMatch(t1.catchers, t2.catchers) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchCatch(JCTree.JCCatch t1, JCTree.JCCatch t2) {
        return this.treesMatch(t1.param, t2.param) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchConditional(JCTree.JCConditional t1, JCTree.JCConditional t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.truepart, t2.truepart) && this.treesMatch(t1.falsepart, t2.falsepart);
    }

    private boolean matchIf(JCTree.JCIf t1, JCTree.JCIf t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.thenpart, t2.thenpart) && this.treesMatch(t1.elsepart, t2.elsepart);
    }

    private boolean matchBreak(JCTree.JCBreak t1, JCTree.JCBreak t2) {
        return t1.label == t2.label && this.treesMatch(t1.target, t2.target);
    }

    private boolean matchContinue(JCTree.JCContinue t1, JCTree.JCContinue t2) {
        return t1.label == t2.label && this.treesMatch(t1.target, t2.target);
    }

    private boolean matchAssert(JCTree.JCAssert t1, JCTree.JCAssert t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.detail, t2.detail);
    }

    private boolean matchApply(JCTree.JCMethodInvocation t1, JCTree.JCMethodInvocation t2) {
        return t1.varargsElement == t2.varargsElement && this.listsMatch(t1.typeargs, t2.typeargs) && this.treesMatch(t1.meth, t2.meth) && this.listsMatch(t1.args, t2.args);
    }

    private boolean matchNewClass(JCTree.JCNewClass t1, JCTree.JCNewClass t2) {
        return t1.constructor == t2.constructor && this.treesMatch(t1.getIdentifier(), t2.getIdentifier()) && this.listsMatch(t1.typeargs, t2.typeargs) && this.listsMatch(t1.args, t2.args) && t1.varargsElement == t2.varargsElement && this.treesMatch(t1.def, t2.def);
    }

    private boolean matchNewArray(JCTree.JCNewArray t1, JCTree.JCNewArray t2) {
        return this.treesMatch(t1.elemtype, t2.elemtype) && this.listsMatch(t1.dims, t2.dims) && this.listsMatch(t1.elems, t2.elems);
    }

    private boolean matchAssign(JCTree.JCAssign t1, JCTree.JCAssign t2) {
        return this.treesMatch(t1.lhs, t2.lhs) && this.treesMatch(t1.rhs, t2.rhs);
    }

    private boolean matchAssignop(JCTree.JCAssignOp t1, JCTree.JCAssignOp t2) {
        return t1.operator == t2.operator && this.treesMatch(t1.lhs, t2.lhs) && this.treesMatch(t1.rhs, t2.rhs);
    }

    private boolean matchUnary(JCTree.JCUnary t1, JCTree.JCUnary t2) {
        return t1.operator == t2.operator && this.treesMatch(t1.arg, t2.arg);
    }

    private boolean matchBinary(JCTree.JCBinary t1, JCTree.JCBinary t2) {
        return t1.operator == t2.operator && this.treesMatch(t1.lhs, t2.lhs) && this.treesMatch(t1.rhs, t2.rhs);
    }

    private boolean matchTypeCast(JCTree.JCTypeCast t1, JCTree.JCTypeCast t2) {
        return this.treesMatch(t1.clazz, t2.clazz) && this.treesMatch(t1.expr, t2.expr);
    }

    private boolean matchTypeTest(JCTree.JCInstanceOf t1, JCTree.JCInstanceOf t2) {
        return this.treesMatch(CasualDiff.getPattern(t1), CasualDiff.getPattern(t2)) && this.treesMatch(t1.expr, t2.expr);
    }

    private boolean matchIndexed(JCTree.JCArrayAccess t1, JCTree.JCArrayAccess t2) {
        return this.treesMatch(t1.indexed, t2.indexed) && this.treesMatch(t1.index, t2.index);
    }

    private boolean matchSelect(JCTree.JCFieldAccess t1, JCTree.JCFieldAccess t2) {
        return this.treesMatch(t1.selected, t2.selected) && t1.name == t2.name;
    }

    private boolean matchReference(JCTree.JCMemberReference t1, JCTree.JCMemberReference t2) {
        return this.treesMatch(t1.expr, t2.expr) && t1.name == t2.name;
    }

    private boolean matchLiteral(JCTree.JCLiteral t1, JCTree.JCLiteral t2) {
        return t1.typetag == t2.typetag && (t1.value == t2.value || t1.value != null && t1.value.equals(t2.value)) && !this.possibleTextBlock(t1, t2);
    }

    private boolean possibleTextBlock(JCTree.JCLiteral t1, JCTree.JCLiteral t2) {
        return t1.getKind() == Tree.Kind.STRING_LITERAL && t2.getKind() == Tree.Kind.STRING_LITERAL;
    }

    private boolean matchTypeApply(JCTree.JCTypeApply t1, JCTree.JCTypeApply t2) {
        return this.treesMatch(t1.clazz, t2.clazz) && this.listsMatch(t1.arguments, t2.arguments);
    }

    private boolean matchAnnotatedType(JCTree.JCAnnotatedType t1, JCTree.JCAnnotatedType t2) {
        return this.treesMatch(t1.underlyingType, t2.underlyingType) && this.listsMatch(t1.annotations, t2.annotations);
    }

    private boolean matchTypeParameter(JCTree.JCTypeParameter t1, JCTree.JCTypeParameter t2) {
        return t1.name == t2.name && this.listsMatch(t1.bounds, t2.bounds);
    }

    private boolean matchWildcard(JCTree.JCWildcard t1, JCTree.JCWildcard t2) {
        return t1.kind == t2.kind && this.treesMatch(t1.inner, t2.inner);
    }

    private boolean matchAnnotation(JCTree.JCAnnotation t1, JCTree.JCAnnotation t2) {
        return this.treesMatch(t1.annotationType, t2.annotationType) && this.listsMatch(t1.args, t2.args);
    }

    private boolean matchModifiers(JCTree.JCModifiers t1, JCTree.JCModifiers t2) {
        return t1.flags == t2.flags && this.listsMatch(t1.annotations, t2.annotations);
    }

    private boolean matchLetExpr(JCTree.LetExpr t1, JCTree.LetExpr t2) {
        return this.listsMatch(t1.defs, t2.defs) && this.treesMatch(t1.expr, t2.expr);
    }

    private boolean matchLambda(JCTree.JCLambda t1, JCTree.JCLambda t2) {
        return this.listsMatch(t1.params, t2.params) && this.treesMatch(t1.body, t2.body);
    }

    private boolean isCommaSeparated(JCTree.JCVariableDecl oldT) {
        if (CasualDiff.getOldPos(oldT) <= 0 || oldT.pos <= 0) {
            return false;
        }
        this.tokenSequence.move(oldT.pos);
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
        if (this.tokenSequence.token() == null) {
            return false;
        }
        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
            return true;
        }
        if (oldT.getInitializer() != null && (oldT.mods.flags & 0x4000L) == 0L) {
            this.tokenSequence.move(this.endPos(oldT.getInitializer()));
        } else {
            this.tokenSequence.move(oldT.pos);
            this.tokenSequence.moveNext();
        }
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
        if (this.tokenSequence.token() == null) {
            return false;
        }
        return JavaTokenId.COMMA == this.tokenSequence.token().id();
    }

    private int getCommentCorrectedOldPos(JCTree tree) {
        CommentSet ch = this.comments.getComments(tree);
        return Math.min(CasualDiff.getOldPos(tree), CasualDiff.commentStart(this.diffContext, ch, CommentSet.RelativePosition.PRECEDING, CasualDiff.getOldPos(tree)));
    }

    private int getCommentCorrectedEndPos(JCTree tree) {
        final int[] res = new int[]{this.endPos(tree)};
        new ErrorAwareTreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree node, Void p) {
                if (node != null) {
                    CommentSet ch = CasualDiff.this.comments.getComments(node);
                    res[0] = Math.max(res[0], Math.max(CasualDiff.commentEnd(ch, CommentSet.RelativePosition.INLINE), CasualDiff.commentEnd(ch, CommentSet.RelativePosition.TRAILING)));
                }
                return (Void)super.scan(node, p);
            }
        }.scan((Tree)tree, (Void)null);
        return res[0];
    }

    private int[] getCommentCorrectedBounds(JCTree tree) {
        return new int[]{this.getCommentCorrectedOldPos(tree), this.getCommentCorrectedEndPos(tree)};
    }

    private int[] getBounds(JCTree tree) {
        return new int[]{CasualDiff.getOldPos(tree), this.endPos(tree)};
    }

    private int[] getBounds(DCTree tree, DCTree.DCDocComment doc) {
        return new int[]{this.getOldPos(tree, doc), this.endPos(tree, doc)};
    }

    private int copyUpTo(int from, int to, VeryPretty printer) {
        if (from < to) {
            this.copyTo(from, to, printer);
            return to;
        }
        return from;
    }

    private int copyUpTo(int from, int to) {
        return this.copyUpTo(from, to, this.printer);
    }

    private void copyTo(int from, int to) {
        this.copyTo(from, to, this.printer);
    }

    public void copyTo(int from, int to, VeryPretty loc) {
        if (from == to) {
            return;
        }
        if (from > to || from < 0 || to < 0) {
            LOG.log(Level.INFO, "-----\n" + this.origText + "-----\n");
            LOG.log(Level.INFO, "Illegal values: from = " + from + "; to = " + to + ".Please, attach your messages.log to new issue!");
            if (noInvalidCopyTos) {
                throw new IllegalStateException("Illegal values: from = " + from + "; to = " + to + ".");
            }
            if (to >= 0) {
                this.printer.eatChars(from - to);
            }
            return;
        }
        if (to > this.origText.length()) {
            LOG.severe("-----\n" + this.origText + "-----\n");
            throw new IllegalArgumentException("Copying to " + to + " is greater then its size (" + this.origText.length() + ").");
        }
        if (this.boundaries == null) {
            this.boundaries = this.diffContext.blockSequences.getBoundaries();
        }
        if (this.nextBlockBoundary == -1 && this.boundaries.hasNext()) {
            this.nextBlockBoundary = this.boundaries.next();
        }
        while (this.nextBlockBoundary != -1 && this.nextBlockBoundary < from) {
            if (this.boundaries.hasNext()) {
                this.nextBlockBoundary = this.boundaries.next();
                continue;
            }
            this.nextBlockBoundary = -1;
            break;
        }
        while (from <= this.nextBlockBoundary && to >= this.nextBlockBoundary) {
            int off = this.nextBlockBoundary - from;
            int mapped = loc.out.length() + (from < this.nextBlockBoundary ? off : 0);
            Integer prev = this.blockSequenceMap.put(this.nextBlockBoundary, mapped);
            if (prev != null) {
                this.blockSequenceMap.put(this.nextBlockBoundary, prev);
            }
            this.nextBlockBoundary = this.boundaries.hasNext() ? this.boundaries.next() : -1;
        }
        loc.print(this.origText.substring(from, to));
    }

    private int diffTree(JCTree oldT, JCTree newT, int[] elementBounds, Tree.Kind parentKind) {
        return this.diffTree(oldT, newT, elementBounds, parentKind, true);
    }

    private int diffTree(JCTree oldT, JCTree newT, int[] elementBounds, Tree.Kind parentKind, boolean retainNewline) {
        if (oldT.getKind() != newT.getKind() && newT.getKind() == Tree.Kind.BLOCK) {
            this.tokenSequence.move(CasualDiff.getOldPos(oldT));
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
            this.tokenSequence.moveNext();
            if (elementBounds[0] < this.tokenSequence.offset()) {
                this.copyTo(elementBounds[0], this.tokenSequence.offset());
            }
            this.printer.printBlock(oldT, newT, parentKind);
            int localpointer = this.getCommentCorrectedEndPos(oldT);
            if (retainNewline && localpointer > 0 && this.origText.charAt(localpointer - 1) == '\n') {
                this.printer.newline();
            }
            return localpointer;
        }
        elementBounds[0] = this.getCommentCorrectedBounds(oldT)[0];
        this.copyTo(elementBounds[0], elementBounds[0]);
        return this.diffTree(oldT, newT, elementBounds);
    }

    private static String printCodeStyle(CodeStyle style) {
        if (style == null) {
            return "<none>";
        }
        StringBuilder sb = new StringBuilder();
        try {
            Method[] arr;
            for (Method m : arr = style.getClass().getMethods()) {
                if (!Modifier.isPublic(m.getModifiers()) || m.getParameterTypes().length != 0) continue;
                String s = m.getName();
                if (s.startsWith("get")) {
                    s = s.substring(3);
                } else if (s.startsWith("is")) {
                    s = s.substring(2);
                }
                java.util.List<Object> val = m.invoke((Object)style, new Object[0]);
                if (val instanceof Object[]) {
                    val = Arrays.asList((Object[])val);
                }
                sb.append(s).append(":").append(val).append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private int findVar(int start, int end) {
        this.tokenSequence.move(end);
        while (this.tokenSequence.movePrevious() && this.tokenSequence.offset() >= start) {
            JavaTokenId token = (JavaTokenId)this.tokenSequence.token().id();
            if (token != JavaTokenId.VAR) continue;
            return this.tokenSequence.offset();
        }
        return -1;
    }

    private static class SectKey {
        private int off;

        SectKey(int off) {
            this.off = off;
        }
    }

    public static class Diff {
        public DiffTypes type;
        int pos;
        int endOffset;
        protected JCTree oldTree;
        protected JCTree newTree;
        protected Comment oldComment;
        protected Comment newComment;
        private String text;
        boolean trailing;

        public static Diff insert(int pos, String text) {
            return new Diff(DiffTypes.INSERT, pos, -1, text);
        }

        public static Diff delete(int startOffset, int endOffset) {
            return new Diff(DiffTypes.DELETE, startOffset, endOffset, null);
        }

        Diff(DiffTypes type, int pos, int endOffset, String text) {
            this.type = type;
            this.pos = pos;
            this.endOffset = endOffset;
            this.text = text;
        }

        Diff(DiffTypes type, int pos, JCTree oldTree, JCTree newTree, Comment oldComment, Comment newComment, boolean trailing) {
            this(type, pos, -1, null);
            assert (pos >= 0) : "invalid source offset";
            this.oldTree = oldTree;
            this.newTree = newTree;
            this.oldComment = oldComment;
            this.newComment = newComment;
            this.trailing = trailing;
        }

        public JCTree getOld() {
            return this.oldTree;
        }

        public JCTree getNew() {
            return this.newTree;
        }

        public int getPos() {
            return this.pos;
        }

        public int getEnd() {
            return this.endOffset;
        }

        public String getText() {
            return this.text;
        }

        public Comment getOldComment() {
            return this.oldComment;
        }

        public Comment getNewComment() {
            return this.newComment;
        }

        public boolean isTrailingComment() {
            return this.trailing;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Diff)) {
                return false;
            }
            Diff d2 = (Diff)obj;
            return this.type != d2.type && this.pos != d2.pos && this.oldTree != d2.oldTree && this.newTree != d2.newTree && this.oldComment != d2.oldComment && this.newComment != d2.newComment && this.trailing != d2.trailing;
        }

        public int hashCode() {
            return this.type.hashCode() + this.pos + (this.oldTree != null ? this.oldTree.hashCode() : 0) + (this.newTree != null ? this.newTree.hashCode() : 0) + (this.oldComment != null ? this.oldComment.hashCode() : 0) + (this.newComment != null ? this.newComment.hashCode() : 0) + Boolean.valueOf(this.trailing).hashCode();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("tree (");
            sb.append(this.type.toString());
            sb.append(") pos=");
            sb.append(this.pos);
            sb.append(", end=").append(this.endOffset);
            if (this.trailing) {
                sb.append(" trailing comment");
            }
            sb.append("\n");
            if (this.type == DiffTypes.DELETE || this.type == DiffTypes.INSERT || this.type == DiffTypes.MODIFY) {
                this.addDiffString(sb, this.oldTree, this.newTree);
            } else {
                this.addDiffString(sb, this.oldComment, this.newComment);
            }
            return sb.toString();
        }

        private void addDiffString(StringBuffer sb, Object o1, Object o2) {
            if (o1 != null) {
                sb.append("< ");
                sb.append(o1.toString());
                sb.append(o2 != null ? "\n---\n> " : "\n");
            } else {
                sb.append("> ");
            }
            if (o2 != null) {
                sb.append(o2.toString());
                sb.append('\n');
            }
        }
    }

    private static enum ChangeKind {
        INSERT,
        DELETE,
        MODIFY,
        NOCHANGE;

    }

    static enum ListType {
        NORMAL,
        ENUM,
        RESOURCE;

    }

    public static enum LineInsertionType {
        BEFORE,
        AFTER,
        NONE;

    }

    public static enum DiffTypes {
        MODIFY("modify"),
        INSERT("insert"),
        DELETE("delete");

        public final String name;

        private DiffTypes(String name) {
            this.name = name;
        }
    }
}

