/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.pretty;

import com.sun.tools.javac.comp.Operators;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import org.netbeans.modules.java.source.pretty.VeryPretty;

public class WidthEstimator
extends JCTree.Visitor {
    private int width;
    private int prec;
    private int maxwidth;
    private final Operators operators;

    public WidthEstimator(Context context) {
        this.operators = Operators.instance(context);
    }

    public int estimateWidth(JCTree t, int maxwidth) {
        this.width = 0;
        this.maxwidth = maxwidth;
        t.accept(this);
        return this.width;
    }

    public int estimateWidth(JCTree t) {
        return this.estimateWidth(t, 100);
    }

    public int estimateWidth(List<? extends JCTree> t, int maxwidth) {
        this.width = 0;
        this.maxwidth = maxwidth;
        while (t.nonEmpty() && this.width < this.maxwidth) {
            ((JCTree)t.head).accept(this);
            t = t.tail;
        }
        return this.width;
    }

    private void open(int contextPrec, int ownPrec) {
        if (ownPrec < contextPrec) {
            this.width += 2;
        }
    }

    private void width(Name n) {
        this.width += n.getByteLength();
    }

    private void width(String n) {
        this.width += n.length();
    }

    private void width(JCTree n) {
        if (this.width < this.maxwidth) {
            n.accept(this);
        }
    }

    private void width(List<? extends JCTree> n, int pad) {
        int nadd = 0;
        while (!n.isEmpty() && this.width < this.maxwidth) {
            this.width((JCTree)n.head);
            n = n.tail;
            ++nadd;
        }
        if (nadd > 1) {
            this.width += pad * nadd;
        }
    }

    private void width(List<? extends JCTree> n) {
        this.width(n, 2);
    }

    private void width(JCTree tree, int prec) {
        if (tree != null) {
            int prevPrec = this.prec;
            this.prec = prec;
            tree.accept(this);
            this.prec = prevPrec;
        }
    }

    @Override
    public void visitTree(JCTree tree) {
        System.err.println("Need width calc for " + tree);
        this.width = this.maxwidth;
    }

    @Override
    public void visitParens(JCTree.JCParens tree) {
        this.width += 2;
        this.width(tree.expr);
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        this.width += 2;
        this.width(tree.meth, 15);
        this.width(tree.args);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        if (tree.encl != null) {
            this.width(tree.encl);
            ++this.width;
        }
        this.width += 4;
        this.width(tree.clazz);
        this.width += 2;
        this.width(tree.args, 2);
        if (tree.def != null) {
            this.width += 4;
            this.width(tree.def.defs, 2);
        }
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        if (tree.elemtype != null) {
            this.width += 4;
            JCTree.JCExpression elemtype = tree.elemtype;
            while (elemtype.getTag() == JCTree.Tag.TYPEARRAY) {
                this.width += 2;
                elemtype = ((JCTree.JCArrayTypeTree)elemtype).elemtype;
            }
            this.width(elemtype);
            List<JCTree.JCExpression> l = tree.dims;
            while (l.nonEmpty()) {
                this.width += 2;
                this.width((JCTree)l.head);
                l = l.tail;
            }
        }
        if (tree.elems != null) {
            this.width += 4;
            this.width(tree.elems);
        }
    }

    private void widthAnnotations(List<JCTree.JCAnnotation> anns) {
        int nadd = 0;
        while (!anns.isEmpty() && this.width < this.maxwidth) {
            ++this.width;
            this.width((JCTree)anns.head);
            anns = anns.tail;
            ++nadd;
        }
        if (nadd > 1) {
            this.width += nadd;
        }
    }

    private void widthFlags(long flags) {
        if ((flags & 0x1000L) != 0L) {
            this.width += 14;
        }
        this.width += VeryPretty.flagNames(flags).length();
        if ((flags & 0xFFFL) != 0L) {
            ++this.width;
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        this.widthAnnotations(tree.mods.annotations);
        if ((tree.mods.flags & 0x4000L) == 0L) {
            this.widthFlags(tree.mods.flags);
            if (tree.vartype != null) {
                this.width(tree.vartype);
            }
            ++this.width;
        }
        this.width(tree.name);
        if (tree.init != null && (tree.mods.flags & 0x4000L) == 0L) {
            this.width += 3;
            this.width(tree.init);
        }
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        this.open(this.prec, 3);
        this.width += 6;
        this.width(tree.cond, 2);
        this.width(tree.truepart, 3);
        this.width(tree.falsepart, 3);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        this.open(this.prec, 2);
        this.width += 3;
        this.width(this.operators.operatorName(tree.getTag()));
        this.width(tree.lhs, 3);
        this.width(tree.rhs, 2);
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        this.open(this.prec, 1);
        this.width += 3;
        this.width(tree.lhs, 2);
        this.width(tree.rhs, 1);
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        int ownprec = TreeInfo.opPrec(tree.getTag());
        Name opname = this.operators.operatorName(tree.getTag());
        this.open(this.prec, ownprec);
        this.width(opname);
        this.width(tree.arg, ownprec);
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        int ownprec = TreeInfo.opPrec(tree.getTag());
        Name opname = this.operators.operatorName(tree.getTag());
        this.open(this.prec, ownprec);
        this.width(opname);
        this.width += 2;
        this.width(tree.lhs, ownprec);
        this.width(tree.rhs, ownprec + 1);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        this.width += 2;
        this.open(this.prec, 14);
        this.width(tree.clazz);
        this.width(tree.expr, 14);
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        this.open(this.prec, 10);
        this.width += 12;
        this.width(tree.expr, 10);
        this.width(tree.clazz);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        this.width += 2;
        this.width(tree.indexed, 15);
        this.width(tree.index);
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        ++this.width;
        this.width(tree.selected, 15);
        this.width(tree.name);
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        this.width(tree.name);
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        switch (tree.typetag) {
            case LONG: 
            case FLOAT: {
                ++this.width;
                this.width(tree.value.toString());
                break;
            }
            case CHAR: {
                this.width += 3;
                break;
            }
            case CLASS: {
                this.width += 2;
                this.width(tree.value.toString());
                break;
            }
            case BOOLEAN: {
                this.width(((Number)tree.value).intValue() == 1 ? "true" : "false");
                break;
            }
            case BOT: {
                this.width("null");
                break;
            }
            default: {
                this.width(tree.value.toString());
            }
        }
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
        this.width(tree.typetag.name());
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
        this.width(tree.elemtype);
        this.width += 2;
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply that) {
        this.width(that.clazz);
        this.width(that.arguments);
        this.width += 2 * that.arguments.size();
    }
}

